# Generated by default/object.tt
package Paws::Connect::KinesisVideoStreamConfig;
  use Moose;
  has EncryptionConfig => (is => 'ro', isa => 'Paws::Connect::EncryptionConfig', required => 1);
  has Prefix => (is => 'ro', isa => 'Str', required => 1);
  has RetentionPeriodHours => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::KinesisVideoStreamConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::KinesisVideoStreamConfig object:

  $service_obj->Method(Att1 => { EncryptionConfig => $value, ..., RetentionPeriodHours => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::KinesisVideoStreamConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->EncryptionConfig

=head1 DESCRIPTION

Configuration information of a Kinesis video stream.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EncryptionConfig => L<Paws::Connect::EncryptionConfig>

The encryption configuration.


=head2 B<REQUIRED> Prefix => Str

The prefix of the video stream.


=head2 B<REQUIRED> RetentionPeriodHours => Int

The number of hours data is retained in the stream. Kinesis Video
Streams retains the data in a data store that is associated with the
stream.

The default value is 0, indicating that the stream does not persist
data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

