## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Es v1.1.7;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Es::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=for stopwords CTAN Ipenburg Es

=head1 NAME

TeX::Hyphen::Pattern::Es - class for hyphenation in locale Es

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 COPYRIGHT

=begin text

copyright: Copyright (C) 1993, 1997 Javier Bezos, 2001-2019 Javier Bezos, CervanTeX
title: Hyphenation patterns for Spanish
notice: This file is part of the hyph-utf8 package.
    See http://www.hyphenation.org/tex for more information.
language:
    name: Spanish
    tag: es
version: 5.0 2019-09-24
authors:
  -
    name: Javier Bezos
licence:
    name: MIT/X11
    url: https://opensource.org/licenses/MIT
    text: >
        Permission is hereby granted, free of charge, to any person obtaining a copy
        of this software and associated documentation files (the "Software"), to deal
        in the Software without restriction, including without limitation the rights
        to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        copies of the Software, and to permit persons to whom the Software is
        furnished to do so, subject to the following conditions:

        The above copyright notice and this permission notice shall be included in
        all copies or substantial portions of the Software.

        THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
        SOFTWARE.
hyphenmins:
    typesetting:
        left: 2
        right: 2
texlive:
    synonyms:
        - espanol
    encoding: ec
    babelname: spanish
    legacy_patterns: eshyph.tex
    message: Spanish hyphenation patterns
    description: Hyphenation patterns for Spanish in T1/EC and UTF-8 encodings.
==========================================

For further info, bug reports and comments:

      https://github.com/jbezos/tex-hyphen-spanish

I would like to thanks Francesc Carmona for his permission
to steal parts of his work without restrictions. For his
patterns, (c) by Francesc Carmona



_____________________________________________________________
Javier Bezos                | http://www.cervantex.es/
.............................................................
TeX y tipografia            | http://www.texnia.com/

=end text

=cut

__DATA__
\patterns{
1b 4b. .b2 2bb 2bc 2bd 2bf 2bg 2bh 2bj 2bk     2bm 2bn 2bp 2bq     2bs 2bt 2bv 2bw 2bx 2by 2bz
1c 4c. .c2 2cb 2cc 2cd 2cf 2cg     2cj 2ck     2cm 2cn 2cp 2cq     2cs 2ct 2cv 2cw 2cx 2cy 2cz
1d 4d. .d2 2db 2dc 2dd 2df 2dg 2dh 2dj 2dk 2dl 2dm 2dn 2dp 2dq     2ds 2dt 2dv 2dw 2dx 2dy 2dz
1f 4f. .f2 2fb 2fc 2fd 2ff 2fg 2fh 2fj 2fk     2fm 2fn 2fp 2fq     2fs 2ft 2fv 2fw 2fx 2fy 2fz
1g 4g. .g2 2gb 2gc 2gd 2gf 2gg 2gh 2gj 2gk     2gm 2gn 2gp 2gq     2gs 2gt 2gv 2gw 2gx 2gy 2gz
   4h. 2hb 2hc 2hd 2hf 2hg 2hh 2hj 2hk 2hl 2hm 2hn 2hp 2hq 2hr 2hs 2ht 2hv 2hw 2hx 2hy 2hz
1j 4j. .j2 2jb 2jc 2jd 2jf 2jg 2jh 2jj 2jk 2jl 2jm 2jn 2jp 2jq 2jr 2js 2jt 2jv 2jw 2jx 2jy 2jz
1k 4k. .k2 2kb 2kc 2kd 2kf 2kg 2kh 2kj 2kk     2km 2kn 2kp 2kq     2ks 2kt 2kv 2kw 2kx 2ky 2kz
1l 4l. .l2 2lb 2lc 2ld 2lf 2lg 2lh 2lj 2lk     2lm 2ln 2lp 2lq 2lr 2ls 2lt 2lv 2lw 2lx 2ly 2lz
1m 4m. .m2 2mb 2mc 2md 2mf 2mg 2mh 2mj 2mk 2ml 2mm 2mn 2mp 2mq 2mr 2ms 2mt 2mv 2mw 2mx 2my 2mz
1n 4n. .n2 2nb 2nc 2nd 2nf 2ng 2nh 2nj 2nk 2nl 2nm 2nn 2np 2nq 2nr 2ns 2nt 2nv 2nw 2nx 2ny 2nz
1p 4p. .p2 2pb 2pc 2pd 2pf 2pg 2ph 2pj 2pk     2pm 2pn 2pp 2pq     2ps 2pt 2pv 2pw 2px 2py 2pz
1q 4q. .q2 2qb 2qc 2qd 2qf 2qg 2qh 2qj 2qk 2ql 2qm 2qn 2qp 2qq 2qr 2qs 2qt 2qv 2qw 2qx 2qy 2qz
1r 4r. .r2 2rb 2rc 2rd 2rf 2rg 2rh 2rj 2rk 2rl 2rm 2rn 2rp 2rq     2rs 2rt 2rv 2rw 2rx 2ry 2rz
1s 4s. .s2 2sb 2sc 2sd 2sf 2sg 2sh 2sj 2sk 2sl 2sm 2sn 2sp 2sq 2sr 2ss 2st 2sv 2sw 2sx 2sy 2sz
1t 4t. .t2 2tb 2tc 2td 2tf 2tg 2th 2tj 2tk     2tm 2tn 2tp 2tq         2tt 2tv 2tw     2ty    
1v 4v. .v2 2vb 2vc 2vd 2vf 2vg 2vh 2vj 2vk     2vm 2vn 2vp 2vq     2vs 2vt 2vv 2vw 2vx 2vy 2vz
1w 4w. .w2 2wb 2wc 2wd 2wf 2wg 2wh 2wj 2wk 2wl 2wm 2wn 2wp 2wq 2wr 2ws 2wt 2wv 2ww 2wx 2wy 2wz
1x 4x. .x2 2xb 2xc 2xd 2xf 2xg 2xh 2xj 2xk 2xl 2xm 2xn 2xp 2xq 2xr 2xs 2xt 2xv 2xw 2xx 2xy 2xz
1y 4y. .y2 2yb 2yc 2yd 2yf 2yg 2yh 2yj 2yk 2yl 2ym 2yn 2yp 2yq 2yr 2ys 2yt 2yv 2yw 2yx 2yy 2yz
1z 4z. .z2 2zb 2zc 2zd 2zf 2zg 2zh 2zj 2zk 2zl 2zm 2zn 2zp 2zq 2zr 2zs 2zt 2zv 2zw 2zx 2zy 2zz
1ñ 4ñ.
c4h 4ch. 2chb 2chc 2chd 2chf 2chg 2chh 2chj 2chk ch2l 2chm 2chn 2chp 2chq ch2r 2chs 2cht 2chv 2chw 2chx 2chy 2chz
l4l 4ll. 2llb 2llc 2lld 2llf 2llg 2llh 2llj 2llk 2lll 2llm 2lln 2llp 2llq 2llr 2lls 2llt 2llv 2llw 2llx 2lly 2llz
b2l 4bl. 2bl2b 2bl2c 2bl2d 2bl2f 2bl2g 2bl2h 2bl2j 2bl2k 2bl2l 2bl2m 2bl2n 2bl2p 2bl2q 2bl2r 2bl2s 2bl2t 2bl2v 2bl2w 2bl2x 2bl2y 2bl2z
c2l 4cl. 2cl2b 2cl2c 2cl2d 2cl2f 2cl2g 2cl2h 2cl2j 2cl2k 2cl2l 2cl2m 2cl2n 2cl2p 2cl2q 2cl2r 2cl2s 2cl2t 2cl2v 2cl2w 2cl2x 2cl2y 2cl2z
f2l 4fl. 2fl2b 2fl2c 2fl2d 2fl2f 2fl2g 2fl2h 2fl2j 2fl2k 2fl2l 2fl2m 2fl2n 2fl2p 2fl2q 2fl2r 2fl2s 2fl2t 2fl2v 2fl2w 2fl2x 2fl2y 2fl2z
g2l 4gl. 2gl2b 2gl2c 2gl2d 2gl2f 2gl2g 2gl2h 2gl2j 2gl2k 2gl2l 2gl2m 2gl2n 2gl2p 2gl2q 2gl2r 2gl2s 2gl2t 2gl2v 2gl2w 2gl2x 2gl2y 2gl2z
k2l 4kl. 2kl2b 2kl2c 2kl2d 2kl2f 2kl2g 2kl2h 2kl2j 2kl2k 2kl2l 2kl2m 2kl2n 2kl2p 2kl2q 2kl2r 2kl2s 2kl2t 2kl2v 2kl2w 2kl2x 2kl2y 2kl2z
p2l 4pl. 2pl2b 2pl2c 2pl2d 2pl2f 2pl2g 2pl2h 2pl2j 2pl2k 2pl2l 2pl2m 2pl2n 2pl2p 2pl2q 2pl2r 2pl2s 2pl2t 2pl2v 2pl2w 2pl2x 2pl2y 2pl2z
v2l 4vl. 2vl2b 2vl2c 2vl2d 2vl2f 2vl2g 2vl2h 2vl2j 2vl2k 2vl2l 2vl2m 2vl2n 2vl2p 2vl2q 2vl2r 2vl2s 2vl2t 2vl2v 2vl2w 2vl2x 2vl2y 2vl2z
b2r 4br. 2br2b 2br2c 2br2d 2br2f 2br2g 2br2h 2br2j 2br2k 2br2l 2br2m 2br2n 2br2p 2br2q 2br2r 2br2s 2br2t 2br2v 2br2w 2br2x 2br2y 2br2z
c2r 4cr. 2cr2b 2cr2c 2cr2d 2cr2f 2cr2g 2cr2h 2cr2j 2cr2k 2cr2l 2cr2m 2cr2n 2cr2p 2cr2q 2cr2r 2cr2s 2cr2t 2cr2v 2cr2w 2cr2x 2cr2y 2cr2z
d2r 4dr. 2dr2b 2dr2c 2dr2d 2dr2f 2dr2g 2dr2h 2dr2j 2dr2k 2dr2l 2dr2m 2dr2n 2dr2p 2dr2q 2dr2r 2dr2s 2dr2t 2dr2v 2dr2w 2dr2x 2dr2y 2dr2z
f2r 4fr. 2fr2b 2fr2c 2fr2d 2fr2f 2fr2g 2fr2h 2fr2j 2fr2k 2fr2l 2fr2m 2fr2n 2fr2p 2fr2q 2fr2r 2fr2s 2fr2t 2fr2v 2fr2w 2fr2x 2fr2y 2fr2z
g2r 4gr. 2gr2b 2gr2c 2gr2d 2gr2f 2gr2g 2gr2h 2gr2j 2gr2k 2gr2l 2gr2m 2gr2n 2gr2p 2gr2q 2gr2r 2gr2s 2gr2t 2gr2v 2gr2w 2gr2x 2gr2y 2gr2z
k2r 4kr. 2kr2b 2kr2c 2kr2d 2kr2f 2kr2g 2kr2h 2kr2j 2kr2k 2kr2l 2kr2m 2kr2n 2kr2p 2kr2q 2kr2r 2kr2s 2kr2t 2kr2v 2kr2w 2kr2x 2kr2y 2kr2z
p2r 4pr. 2pr2b 2pr2c 2pr2d 2pr2f 2pr2g 2pr2h 2pr2j 2pr2k 2pr2l 2pr2m 2pr2n 2pr2p 2pr2q 2pr2r 2pr2s 2pr2t 2pr2v 2pr2w 2pr2x 2pr2y 2pr2z
r2r 4rr. 2rr2b 2rr2c 2rr2d 2rr2f 2rr2g 2rr2h 2rr2j 2rr2k 2rr2l 2rr2m 2rr2n 2rr2p 2rr2q 2rr2r 2rr2s 2rr2t 2rr2v 2rr2w 2rr2x 2rr2y 2rr2z
t2r 4tr. 2tr2b 2tr2c 2tr2d 2tr2f 2tr2g 2tr2h 2tr2j 2tr2k 2tr2l 2tr2m 2tr2n 2tr2p 2tr2q 2tr2r 2tr2s 2tr2t 2tr2v 2tr2w 2tr2x 2tr2y 2tr2z
v2r 4vr. 2vr2b 2vr2c 2vr2d 2vr2f 2vr2g 2vr2h 2vr2j 2vr2k 2vr2l 2vr2m 2vr2n 2vr2p 2vr2q 2vr2r 2vr2s 2vr2t 2vr2v 2vr2w 2vr2x 2vr2y 2vr2z
2b3p2t 2c3p2t 2d3p2t 2l3p2t 2m3p2t 2n3p2t 2r3p2t 2s3p2t 2t3p2t 2x3p2t 2y3p2t 4pt.
2b3c2t 2c3c2t 2d3c2t 2l3c2t 2m3c2t 2n3c2t 2r3c2t 2s3c2t 2t3c2t 2x3c2t 2y3c2t 4ct.
2b3c2n 2c3c2n 2d3c2n 2l3c2n 2m3c2n 2n3c2n 2r3c2n 2s3c2n 2t3c2n 2x3c2n 2y3c2n 4cn.
2b3p2s 2c3p2s 2d3p2s 2l3p2s 2m3p2s 2n3p2s 2r3p2s 2s3p2s 2t3p2s 2x3p2s 2y3p2s 4ps.
2b3m2n 2c3m2n 2d3m2n 2l3m2n 2m3m2n 2n3m2n 2r3m2n 2s3m2n 2t3m2n 2x3m2n 2y3m2n 4mn.
2b3g2n 2c3g2n 2d3g2n 2l3g2n 2m3g2n 2n3g2n 2r3g2n 2s3g2n 2t3g2n 2x3g2n 2y3g2n 4gn.
2b3f2t 2c3f2t 2d3f2t 2l3f2t 2m3f2t 2n3f2t 2r3f2t 2s3f2t 2t3f2t 2x3f2t 2y3f2t 4ft.
2b3p2n 2c3p2n 2d3p2n 2l3p2n 2m3p2n 2n3p2n 2r3p2n 2s3p2n 2t3p2n 2x3p2n 2y3p2n 4pn.
2b3c2z 2c3c2z 2d3c2z 2l3c2z 2m3c2z 2n3c2z 2r3c2z 2s3c2z 2t3c2z 2x3c2z 2y3c2z 4cz.
2b3t2z 2c3t2z 2d3t2z 2l3t2z 2m3t2z 2n3t2z 2r3t2z 2s3t2z 2t3t2z 2x3t2z 2y3t2z 4tz.
2b3t2s 2c3t2s 2d3t2s 2l3t2s 2m3t2s 2n3t2s 2r3t2s 2s3t2s 2t3t2s 2x3t2s 2y3t2s 4ts.
san4c5t
plan4c5t
com4p3t
prom4p3t
o1eu2
a1ae2
a1aó2
eo1á2
eo1e2
o1ae2
o1eó2
2no.
2t2l
2t2s
2t2x
2t2z
tz3s4ch
4caca4
4cago4
4caga4
4cagas.
4teta.
4tetas.
4puta4
4puto4
.hu4mea
.hu4meo
.he4mee
4meo.
4meable.
4meables.
4pedo4
4culo4
5mente.
4i3go.
4es.
4és
4e.
4e3mos.
4éis.
4en.
4ía.
4ías.
4ía3mos.
4íais.
4ían.
4í.
4í4s3te.
4í4s3tes.
4í3tes.
4í3mos.
4ís3teis.
4e3ré.
4e3rás.
4e3rés.
4e3rís.
4e3rá.
4e3re3mos.
4e3réis.
4e3rán.
4i3ga.
4i3gas.
4i3gás.
4i3gamos.
4i3gáis.
4a4i3gan.
4e3ría.
4e3rías.
4e3ríamos.
4e3ríais.
4e3rían.
4i3gá3mosme.
4i3gá3mosmele.
4i3gá3mosmelo.
4i3gá3mos3mela.
4i3gá3mosmeles.
4i3gá3mosmelos.
4i3gá3mos3melas.
4i3gá3moste.
4i3gá3mostele.
4i3gá3mostelo.
4i3gá3mos3tela.
4i3gá3mosteles.
4i3gá3mostelos.
4i3gá3mos3telas.
4i3gá3mosle.
4i3gá3mosla.
4i3gá3moslo.
4i3gá3mosele.
4i3gá3moselo.
4i3gá3mosela.
4i3gá3moseles.
4i3gá3moselos.
4i3gá3moselas.
4i3gá3monos.
4i3gá3monosle.
4i3gá3monoslo.
4i3gá3monosla.
4i3gá3monosles.
4i3gá3monoslos.
4i3gá3monoslas.
4i3gá3moos.
4i3gá3moosle.
4i3gá3mooslo.
4i3gá3moosla.
4i3gá3moosles.
4i3gá3mooslos.
4i3gá3mooslas.
4i3gá3mosles.
4i3gá3moslas.
4i3gá3moslos.
4ed.
4é.
4edme.
4édmele.
4édmelo.
4éd3mela.
4édmeles.
4édmelos.
4éd3melas.
4edte.
4édtele.
4édtelo.
4éd3tela.
4édteles.
4édtelos.
4éd3telas.
4edle.
4eedla.
4edlo.
4édsele.
4édselo.
4édsela.
4édseles.
4édselos.
4édselas.
4ednos.
4édnosle.
4édnoslo.
4édnosla.
4édnosles.
4édnoslos.
4édnoslas.
4eos.
4éosle.
4éoslo.
4éosla.
4éosles.
4éoslos.
4éoslas.
4edles.
4edlas.
4edlos.
4er.
4erme.
4érmele.
4érmelo.
4ér3mela.
4érmeles.
4érmelos.
4ér3melas.
4erte.
4értele.
4értelo.
4ér3tela.
4érteles.
4értelos.
4ér3telas.
4erle.
4erla.
4erlo.
4erse.
4érsele.
4érselo.
4érsela.
4érseles.
4érselos.
4érselas.
4ernos.
4érnosle.
4érnoslo.
4érnosla.
4érnosles.
4érnoslos.
4érnoslas.
4e3ros.
4é3rosle.
4é3roslo.
4é3rosla.
4é3rosles.
4é3roslos.
4é3roslas.
4erles.
4erlas.
4erlos.
4í3do.
4í3da.
4í3dos.
4í3das.
4o.
4as.
4a.
4ás.
4a3mos.
4áis.
4an.
4aste.
4astes.
4ó.
4ates.
4asteis.
4a3ron.
4a3ba.
4a3bas.
4á3bamos.
4a3bais.
4a3ban.
4a3ría.
4a3rías.
4a3ríamos.
4a3ríais
4a3rían.
4a3ré.
4a3rás.
4a3rés.
4a3rís.
4a3rá.
4a3remos.
4a3réis.
4a3rán.
4a3ra.
4a3ras.
4á3ramos.
4a3rais.
4a3ran.
4a3re.
4a3res.
4á3remos.
4a3reis.
4a3ren.
4a3se.
4a3ses.
4á3semos.
4a3seis.
4a3sen.
4ad.
e5r4as.
e5r4a3mos.
e5r4áis.
e5r4an.
e5r4aste.
e5r4astes.
e5r4ates.
e5r4asteis.
e5r4a3ron.
e5r4a3ba.
e5r4a3bas.
e5r4á3bamos.
e5r4a3bais.
e5r4a3ban.
e5r4a3ría.
e5r4a3rías.
e5r4a3ríamos.
e5r4a3ríais
e5r4a3rían.
e5r4a3ré.
e5r4a3rás.
e5r4a3rés.
e5r4a3rís.
e5r4a3rá.
e5r4a3remos.
e5r4a3réis.
e5r4a3rán.
e5r4a3ra.
e5r4a3ras.
e5r4á3ramos.
e5r4a3rais.
e5r4a3ran.
e5r4a3re.
e5r4a3res.
e5r4á3remos.
e5r4a3reis.
e5r4a3ren.
e5r4a3se.
e5r4a3ses.
e5r4á3semos.
e5r4a3seis.
e5r4a3sen.
e5r4ad.
4adme.
4ádmele.
4ádmelo.
4ád3mela.
4ádmeles.
4ádmelos.
4ád3melas.
4adte.
4ádtele.
4ádtelo.
4ád3tela.
4ádteles.
4ádtelos.
4ád3telas.
4adle.
4eadla.
4adlo.
4ádsele.
4ádselo.
4ádsela.
4ádseles.
4ádselos.
4ádselas.
4adnos.
4ádnosle.
4ádnoslo.
4ádnosla.
4ádnosles.
4ádnoslos.
4ádnoslas.
4aos.
4áosle.
4áoslo.
4áosla.
4áosles.
4áoslos.
4áoslas.
4adles.
4adlas.
4adlos.
4ar.
4a4rme.
4á4rmele.
4á4rmelo.
4á4r3mela.
4á4r3meles.
4á4r3melos.
4á4r3melas.
4a4r3te.
4á4r3tele.
4á4r3telo.
4á4r3tela.
4á4r3teles.
4á4r3telos.
4á4r3telas.
4a4r3le.
4a4r3la.
4a4r3lo.
4a4r3se.
4á4r3sele.
4á4r3selo.
4á4r3sela.
4á4r3seles.
4á4r3selos.
4á4r3selas.
4a4r3nos.
4á4r3nosle.
4á4r3noslo.
4á4r3nosla.
4á4r3nosles.
4á4r3noslos.
4á4r3noslas.
4a3ros.
4árosle.
4ároslo.
4árosla.
4árosles.
4ároslos.
4ároslas.
4a4r3les.
4a4r3las.
4a4r3los.
4a3do.
4a3da.
4a3dos.
4a3das.
e5r4a3do.
e5r4a3da.
e5r4a3dos.
e5r4a3das.
4ando
4ándole.
4ándolo.
4ándola.
4ándoles.
4ándolos.
4ándolas.
4ándonos.
4ándoos.
4ándome.
4ándomelo.
4ándomela.
4ándomele.
4ándomelos.
4ándomelas.
4ándomeles.
4ándote.
4ándoteme.
4ándotelo.
4ándotela.
4ándotele.
4ándotelos.
4ándotelas.
4ándoteles.
4ándotenos.
4ándose.
4ándoseme.
4ándoselo.
4ándosela.
4ándosele.
4ándoselos.
4ándoselas.
4ándoseles.
4ándosenos.
4a3dor.
4a3dora.
4a3dores.
4a3doras.
e5r4a3dor.
e5r4a3dora.
e5r4a3dores.
e5r4a3doras.
.a4
.abre1h
.abre1a2 .abre1e2 .abre1i2 .abre1o2 .abre1u2
.abre1á2 .abre1é2 .abre1í2 .abre1ó2 .abre1ú2
.acro1h
.acro1a2 .acro1e2 .acro1i2 .acro1o2 .acro1u2
.acro1á2 .acro1é2 .acro1í2 .acro1ó2 .acro1ú2
acto1h
acto1a2 acto1e2 acto1i2 acto1o2 acto1u2
acto1á2 acto1é2 acto1í2 acto1ó2 acto1ú2
adeno1h
adeno1a2 adeno1e2 adeno1i2 adeno1o2 adeno1u2
adeno1á2 adeno1é2 adeno1í2 adeno1ó2 adeno1ú2
4i3ditis.
aero1h
aero1a2 aero1e2 aero1i2 aero1o2 aero1u2
aero1á2 aero1é2 aero1í2 aero1ó2 aero1ú2
afro1h
afro1a2 afro1e2 afro1i2 afro1o2 afro1u2
afro1á2 afro1é2 afro1í2 afro1ó2 afro1ú2
agro1h
agro1a2 agro1e2 agro1i2 agro1o2 agro1u2
agro1á2 agro1é2 agro1í2 agro1ó2 agro1ú2
.an3e2pigr
.an3a2lcoh
.an3amnio
.an3i4so
.an3i4só
.an3aero
andro1h
andro1a2 andro1e2 andro1i2 andro1o2 andro1u2
andro1á2 andro1é2 andro1í2 andro1ó2 andro1ú2
anfi1h
anfi1a2 anfi1e2 anfi1i2 anfi1o2 anfi1u2
anfi1á2 anfi1é2 anfi1í2 anfi1ó2 anfi1ú2
4o3xo.
4o3xos.
anglo1h
anglo1a2 anglo1e2 anglo1i2 anglo1o2 anglo1u2
anglo1á2 anglo1é2 anglo1í2 anglo1ó2 anglo1ú2
ante1h
ante1a2 ante1e2 ante1i2 ante1o2 ante1u2
ante1á2 ante1é2 ante1í2 ante1ó2 ante1ú2
.ante2o3je
acante2
4ísmo.
4ísmos.
4ísta.
4ístas.
4ismo.
4ismos.
4ista.
4istas.
4ístico.
4ísticos.
4ística.
4ísticas.
pante4o3n
.anteo3nes
mante4a
e4a3miento
e4ándo
tras3antea
2huelo.
2huela.
2huelos.
2huelas.
.anti1h
.anti1a2 .anti1e2 .anti1i2 .anti1o2 .anti1u2
.anti1á2 .anti1é2 .anti1í2 .anti1ó2 .anti1ú2
ti2o3qu
ti2o3co
apico1h
apico1a2 apico1e2 apico1i2 apico1o2 apico1u2
apico1á2 apico1é2 apico1í2 apico1ó2 apico1ú2
archi1h
archi1a2 archi1e2 archi1i2 archi1o2 archi1u2
archi1á2 archi1é2 archi1í2 archi1ó2 archi1ú2
.atto1h
.atto1a2 .atto1e2 .atto1i2 .atto1o2 .atto1u2
.atto1á2 .atto1é2 .atto1í2 .atto1ó2 .atto1ú2
audio1h
audio1a2 audio1e2 audio1i2 audio1o2 audio1u2
audio1á2 audio1é2 audio1í2 audio1ó2 audio1ú2
austro1h
austro1a2 austro1e2 austro1i2 austro1o2 austro1u2
austro1á2 austro1é2 austro1í2 austro1ó2 austro1ú2
auto1h
auto1a2 auto1e2 auto1i2 auto1o2 auto1u2
auto1á2 auto1é2 auto1í2 auto1ó2 auto1ú2
.bi1anual
.bi1aur
.bi1ox
.bi1ó2x
.bi1un
bi1u2ní
biblio1h
biblio1a2 biblio1e2 biblio1i2 biblio1o2 biblio1u2
biblio1á2 biblio1é2 biblio1í2 biblio1ó2 biblio1ú2
bien2
bien3b
bien3c
bien3d
bien3f
bien3g
bien3h
bien3l
bien3m
bien3p
bien3q
bien3s
bien3t
bien3v
bien3z
.bie4n3and
.bie4n3a4pa
.bie4n3a4ve
.bie4n3est
.bie4n3int
.bie4n3o4lie
b4ien3do.
.su3b4ien
b4ien3das.
bio1h
bio1a2 bio1e2 bio1i2 bio1o2 bio1u2
bio1á2 bio1é2 bio1í2 bio1ó2 bio1ú2
busca1h
busca1a2 busca1e2 busca1i2 busca1o2 busca1u2
busca1á2 busca1é2 busca1í2 busca1ó2 busca1ú2
cardio1h
cardio1a2 cardio1e2 cardio1i2 cardio1o2 cardio1u2
cardio1á2 cardio1é2 cardio1í2 cardio1ó2 cardio1ú2
cefalo1h
cefalo1a2 cefalo1e2 cefalo1i2 cefalo1o2 cefalo1u2
cefalo1á2 cefalo1é2 cefalo1í2 cefalo1ó2 cefalo1ú2
centi1h
centi1a2 centi1e2 centi1i2 centi1o2 centi1u2
centi1á2 centi1é2 centi1í2 centi1ó2 centi1ú2
cian1h
ciano1h
ciano1a2 ciano1e2 ciano1i2 ciano1o2 ciano1u2
ciano1á2 ciano1é2 ciano1í2 ciano1ó2 ciano1ú2
cibe2r3r
cibe2r1h
cibe2r1a2 cibe2r1e2 cibe2r1i2 cibe2r1o2 cibe2r1u2
cibe2r1á2 cibe2r1é2 cibe2r1í2 cibe2r1ó2 cibe2r1ú2
centi5área
ciclo1h
ciclo1a2 ciclo1e2 ciclo1i2 ciclo1o2 ciclo1u2
ciclo1á2 ciclo1é2 ciclo1í2 ciclo1ó2 ciclo1ú2
cito1h
cito1a2 cito1e2 cito1i2 cito1o2 cito1u2
cito1á2 cito1é2 cito1í2 cito1ó2 cito1ú2
clepto1h
clepto1a2 clepto1e2 clepto1i2 clepto1o2 clepto1u2
clepto1á2 clepto1é2 clepto1í2 clepto1ó2 clepto1ú2
cnico1h
cnico1a2 cnico1e2 cnico1i2 cnico1o2 cnico1u2
cnico1á2 cnico1é2 cnico1í2 cnico1ó2 cnico1ú2
.co1h
.co2a2
.co2e2
.co2i2
.co3o4
.co2u2
.co2á2
.co2é2
.co2í2
.co2ó2
.co2ú2
.co3acer
.co3acree
.coá3gul
.co3agen
.coa3gul
.co3apóst
.coa3lesc
.coa3lic
.co3arrend
.coa3xial
.co3auto
.co3edic
.co3edit
.co3educ
.co3efici
.coe3tá
.co3exis
.co6hib
.co4hech
.co4hesi
.co4heso
.co4herent
.co4het
.co3imput
.coi3to
.co4o5ki
.co4o3per
.co4o3pér
.co4orden
.co4ordin
.co4ordín
.co4opt
.co4ópt
.co2nurb
cou3lomb
corta1h
corta1a2 corta1e2 corta1i2 corta1o2 corta1u2
corta1á2 corta1é2 corta1í2 corta1ó2 corta1ú2
cosmo1h
cosmo1a2 cosmo1e2 cosmo1i2 cosmo1o2 cosmo1u2
cosmo1á2 cosmo1é2 cosmo1í2 cosmo1ó2 cosmo1ú2
crio1h
crio1a2 crio1e2 crio1i2 crio1o2 crio1u2
crio1á2 crio1é2 crio1í2 crio1ó2 crio1ú2
cripto1h
cripto1a2 cripto1e2 cripto1i2 cripto1o2 cripto1u2
cripto1á2 cripto1é2 cripto1í2 cripto1ó2 cripto1ú2
crono1h
crono1a2 crono1e2 crono1i2 crono1o2 crono1u2
crono1á2 crono1é2 crono1í2 crono1ó2 crono1ú2
contra1h
contra1a2 contra1e2 contra1i2 contra1o2 contra1u2
contra1á2 contra1é2 contra1í2 contra1ó2 contra1ú2
cuadru1h
cuadru1a2 cuadru1e2 cuadru1i2 cuadru1o2 cuadru1u2
cuadru1á2 cuadru1é2 cuadru1í2 cuadru1ó2 cuadru1ú2
cuasi1h
cuasi1a2 cuasi1e2 cuasi1i2 cuasi1o2 cuasi1u2
cuasi1á2 cuasi1é2 cuasi1í2 cuasi1ó2 cuasi1ú2
deca1h
deca1a2 deca1e2 deca1i2 deca1o2 deca1u2
deca1á2 deca1é2 deca1í2 deca1ó2 deca1ú2
dento1h
dento1a2 dento1e2 dento1i2 dento1o2 dento1u2
dento1á2 dento1é2 dento1í2 dento1ó2 dento1ú2
dermato1h
dermato1a2 dermato1e2 dermato1i2 dermato1o2 dermato1u2
dermato1á2 dermato1é2 dermato1í2 dermato1ó2 dermato1ú2
dermo1h
dermo1a2 dermo1e2 dermo1i2 dermo1o2 dermo1u2
dermo1á2 dermo1é2 dermo1í2 dermo1ó2 dermo1ú2
.de2s1h
.de2s3a2
.de2se2
.de2si2
.de2so2
.de2su2
.de2s3á2
.de2sé2
.de2sí2
.de2só2
.de2sú2
deca2i3mient
3sa.
3sas.
de2s3órde
de2s3orde
de3s4a3brid
de3s4a3bor
de3s4a3craliz
de3s4a3cralic
de3s4a3fia
de3s4a3fía
de3s4a3fiá
de3s4a3fíe
de3s4a3fié
de3s4a3fío
de3s4a3fió
des5a4gua
de3s4ahuci
de3s4áhuci
de3s4a3guis
des4ala
des4ála
de3s4a3liv
de3s4a3liniz
de3s4a3liníz
de3s4a3linic
de3s4a3liníc
de3s4angr
de3s4angel
de3s4a3prensiv
de3s4a3rroll
desa4sa
desa4se
des5a4tes
de3s4astr
de3s4a3yun
de3s4a3zón
de3s4a3zon
.des3em
de3s4e3meja
de3s4e3méja
de3s4e3mejá
de3s4e3meje
de3s4e3méje
de3s4e3mejé
de3s4e3mejo
de3s4e3méjo
de3s4e3mejó
de3s4empeñ
de3s4empéñ
.des3en
de3s4enfren
de3s4enfrén
de3seo
de3sea
de3sean
de3seán
de3sear
de3seár
de3seab
de3seáb
de3sead
de3seád
de3seam
de3seám
de3seas
de3seás
de3se3co
de3se3ca
de3se3cá
de3se3có
de3s4e3que
de3s4e3qué
de3se3can
de3se3cán
de3se3car
de3se3cár
de3se3cab
de3se3cáb
de3se3cad
de3se3cád
de3se3cam
de3se3cám
de3se3cas
de3se3cás
de3se3cha
de3sé3cha
de3se3chá
de3se3ché
de3se3che
de3sé3che
de3se3chó
de3se3cho
de2s3edif
de2s3educ
de2s3eduq
de2s3escombr
de2s3eq
de3s4erci
de3s4ert
de3s4ért
de2s3espa
de3sesperac
de2s3esperanz
de2s3espin
de2s3espum
de2s3estabil
de2s3estaci
de2s3estalin
de2s3estim
de2s3estres
de2s3estruc
de3sider
de3sidia
de2s3ideol
de3sidio
de3siert
de3sign
de2s3igual
de2s3iguál
de2s3ilusion
de2s3ilusión
de2s3imagin
de2s3iman
de2s3impon
de2s3impres
de2s3incent
de2s3inclin
de2s3incorp
de2s3incrust
de3si3nenc
de3si3nent
de3sinfec
de3su3dar
de3su3das
de3su3dan
de2s3infart
de2s3inflam
de2s3infl
de2s3inform
de2s3inhib
de2s3insect
de2s3instal
ini3ci
iní3ci
de3s4integr
de3s4inter
de2s3intox
de2s3intub
de2s3inver
de3sisten
de3isti
de2s3obedec
de2s3obedez
de2s3obedien
de2s3oblig
de2s3obstr
de3so3cas
de2s3ocup
de2s3ocúp
de2s3odor
de3so3la
de3só3la
de3so3lá
de3so3le
de3so3lé
de3so3lo
de3so3ló
de3solac
de3solad
de3soll
de2s3oprim
de2s3orej
de2s3orill
de2s3orient
de3sortij
de2s3organi
de2s3ornam
de3suell
de3sonce
de2s3ova
de2s3ová
de2s3ové
de2s3ovi
de2s3oxi
de2s3oye
de2s3oyé
de3s4ubstan
de3s4ustan
de3s4oseg
de2s3ub4ic
de2s3ub4iq
de2s3unir
de2s3unan
de2s3unas
de2s3une
de2s3unid
de2s3unien
de2s3uniera
de2s3unies
de2s3unién
de2s3uniér
de2s3uniés
de2s3unió
de2s3uno
de2s3uná
de2s3uní
de2s3unía
de2s3unier
de2s3unim
de2s3uña
de2s3uñá
de2s3urbani
.diecio2
.diecio3ch
ecano1h
ecano1a2 ecano1e2 ecano1i2 ecano1o2 ecano1u2
ecano1á2 ecano1é2 ecano1í2 ecano1ó2 ecano1ú2
eco1h
eco1a2 eco1e2 eco1i2 eco1o2 eco1u2
eco1á2 eco1é2 eco1í2 eco1ó2 eco1ú2
ecto1h
ecto1a2 ecto1e2 ecto1i2 ecto1o2 ecto1u2
ecto1á2 ecto1é2 ecto1í2 ecto1ó2 ecto1ú2
ectro1h
ectro1a2 ectro1e2 ectro1i2 ectro1o2 ectro1u2
ectro1á2 ectro1é2 ectro1í2 ectro1ó2 ectro1ú2
.e2n1h
.e2n2a2 .e2n2e2 .e2n2i2 .e2n2o2 .e2n2u2
.e2n2á2 .e2n2é2 .e2n2í2 .e2n2ó2 .e2n2ú2
.ena3mor
.en3amór
.ene3mist
.ene3míst
.eno3jar
.enu3mera
.enu3merá
.enu3mere
.en3aceit
.ena3jen
.ena3jén
.eno3ja
.eno3já
.eno3je
.eno3jé
.eno3jo
.eno3jó
.enó3j
.en3arb
en1hebr
.en2hest
4emboca
4o3lógico.
4o3lógica.
4o3lógicos.
4o3lógicas.
4o3lógicamente.
4o3logía.
4o3logías.
4ó3logo.
4ó3loga.
4ó3logos.
4ó3logas.
endo1h
endo1a2 endo1e2 endo1i2 endo1o2 endo1u2
endo1á2 endo1é2 endo1í2 endo1ó2 endo1ú2
enea1h
enea1a2 enea1e2 enea1i2 enea1o2 enea1u2
enea1á2 enea1é2 enea1í2 enea1ó2 enea1ú2
entero1h
entero1a2 entero1e2 entero1i2 entero1o2 entero1u2
entero1á2 entero1é2 entero1í2 entero1ó2 entero1ú2
ento1h
ento1a2 ento1e2 ento1i2 ento1o2 ento1u2
ento1á2 ento1é2 ento1í2 ento1ó2 ento1ú2
entre1h
entre1a2 entre1e2 entre1i2 entre1o2 entre1u2
entre1á2 entre1é2 entre1í2 entre1ó2 entre1ú2
esclero1h
esclero1a2 esclero1e2 esclero1i2 esclero1o2 esclero1u2
esclero1á2 esclero1é2 esclero1í2 esclero1ó2 esclero1ú2
estereo1h
estereo1a2 estereo1e2 estereo1i2 estereo1o2 estereo1u2
estereo1á2 estereo1é2 estereo1í2 estereo1ó2 estereo1ú2
etno1h
etno1a2 etno1e2 etno1i2 etno1o2 etno1u2
etno1á2 etno1é2 etno1í2 etno1ó2 etno1ú2
euco1h
euco1a2 euco1e2 euco1i2 euco1o2 euco1u2
euco1á2 euco1é2 euco1í2 euco1ó2 euco1ú2
euro1h
euro1a2 euro1e2 euro1i2 euro1o2 euro1u2
euro1á2 euro1é2 euro1í2 euro1ó2 euro1ú2
.e2x1h
.e2x2a2 .e2x2e2 .e2x2i2 .e2x2o2 .e2x2u2
.e2x2á2 .e2x2é2 .e2x2í2 .e2x2ó2 .e2x2ú2
.ex2hal
.ex2hál
.ex2haus
.ex2hib
.ex2híb
.ex2hort
.ex2hórt
.ex2hum
.ex2húm
3gono.
3gonos.
3gonal.
3gonales.
exá3men
exá3ri
exé3ge
exó3ti
exa3cerb
exa3ger
ex3alum
exa3min
exe3cr
exe3géti
exe3quia
exi3ja
exi3já
exí3ja
exi3ge
exí3ge
exi3gi
exi3gí
exi3jo
exí3jo
exi3lia
exi3liá
exí3lia
exi3lie
exi3lié
exí3lie
exi3lio
exi3lió
exí3lio
exi3ma
exi3má
exí3ma
exi3mi
exi3mí
exí3mi
exi3me
exi3mé
exí3me
exi3mo
exi3mó
exí3mo
exi3tos
exi3lar
exo3bió
exo3ner
exo3crin
exo3tér
exo3tic
exo3tiq
exo3tism
exo3gami
exo3esq
exo3plan
exo3gámi
exu3ber
exu3dar
exu3dat
exu3dac
extra1h
extra1a2 extra1e2 extra1i2 extra1o2 extra1u2
extra1á2 extra1é2 extra1í2 extra1ó2 extra1ú2
u4teri
.cau5t
.deu5t
femto1h
femto1a2 femto1e2 femto1i2 femto1o2 femto1u2
femto1á2 femto1é2 femto1í2 femto1ó2 femto1ú2
ferro1h
ferro1a2 ferro1e2 ferro1i2 ferro1o2 ferro1u2
ferro1á2 ferro1é2 ferro1í2 ferro1ó2 ferro1ú2
filo1h
filo1a2 filo1e2 filo1i2 filo1o2 filo1u2
filo1á2 filo1é2 filo1í2 filo1ó2 filo1ú2
fisio1h
fisio1a2 fisio1e2 fisio1i2 fisio1o2 fisio1u2
fisio1á2 fisio1é2 fisio1í2 fisio1ó2 fisio1ú2
fito1h
fito1a2 fito1e2 fito1i2 fito1o2 fito1u2
fito1á2 fito1é2 fito1í2 fito1ó2 fito1ú2
fono1h
fono1a2 fono1e2 fono1i2 fono1o2 fono1u2
fono1á2 fono1é2 fono1í2 fono1ó2 fono1ú2
foto1h
foto1a2 foto1e2 foto1i2 foto1o2 foto1u2
foto1á2 foto1é2 foto1í2 foto1ó2 foto1ú2
galo1h
galo1a2 galo1e2 galo1i2 galo1o2 galo1u2
galo1á2 galo1é2 galo1í2 galo1ó2 galo1ú2
gastero1h
gastero1a2 gastero1e2 gastero1i2 gastero1o2 gastero1u2
gastero1á2 gastero1é2 gastero1í2 gastero1ó2 gastero1ú2
gastro1h
gastro1a2 gastro1e2 gastro1i2 gastro1o2 gastro1u2
gastro1á2 gastro1é2 gastro1í2 gastro1ó2 gastro1ú2
geo1h
geo1a2 geo1e2 geo1i2 geo1o2 geo1u2
geo1á2 geo1é2 geo1í2 geo1ó2 geo1ú2
geronto1h
geronto1a2 geronto1e2 geronto1i2 geronto1o2 geronto1u2
geronto1á2 geronto1é2 geronto1í2 geronto1ó2 geronto1ú2
gineco1h
gineco1a2 gineco1e2 gineco1i2 gineco1o2 gineco1u2
gineco1á2 gineco1é2 gineco1í2 gineco1ó2 gineco1ú2
giga1h
giga1a2 giga1e2 giga1i2 giga1o2 giga1u2
giga1á2 giga1é2 giga1í2 giga1ó2 giga1ú2
gluco1h
gluco1a2 gluco1e2 gluco1i2 gluco1o2 gluco1u2
gluco1á2 gluco1é2 gluco1í2 gluco1ó2 gluco1ú2
grafo1h
grafo1a2 grafo1e2 grafo1i2 grafo1o2 grafo1u2
grafo1á2 grafo1é2 grafo1í2 grafo1ó2 grafo1ú2
guarda1h
guarda1a2 guarda1e2 guarda1i2 guarda1o2 guarda1u2
guarda1á2 guarda1é2 guarda1í2 guarda1ó2 guarda1ú2
halo1h
halo1a2 halo1e2 halo1i2 halo1o2 halo1u2
halo1á2 halo1é2 halo1í2 halo1ó2 halo1ú2
hecto1h
hecto1a2 hecto1e2 hecto1i2 hecto1o2 hecto1u2
hecto1á2 hecto1é2 hecto1í2 hecto1ó2 hecto1ú2
helico1h
helico1a2 helico1e2 helico1i2 helico1o2 helico1u2
helico1á2 helico1é2 helico1í2 helico1ó2 helico1ú2
helio1h
helio1a2 helio1e2 helio1i2 helio1o2 helio1u2
helio1á2 helio1é2 helio1í2 helio1ó2 helio1ú2
hemato1h
hemato1a2 hemato1e2 hemato1i2 hemato1o2 hemato1u2
hemato1á2 hemato1é2 hemato1í2 hemato1ó2 hemato1ú2
hemi1h
hemi1a2 hemi1e2 hemi1i2 hemi1o2 hemi1u2
hemi1á2 hemi1é2 hemi1í2 hemi1ó2 hemi1ú2
hemio3la.
hemio3las.
hemo1h
hemo1a2 hemo1e2 hemo1i2 hemo1o2 hemo1u2
hemo1á2 hemo1é2 hemo1í2 hemo1ó2 hemo1ú2
hepato1h
hepato1a2 hepato1e2 hepato1i2 hepato1o2 hepato1u2
hepato1á2 hepato1é2 hepato1í2 hepato1ó2 hepato1ú2
hepta1h
hepta1a2 hepta1e2 hepta1i2 hepta1o2 hepta1u2
hepta1á2 hepta1é2 hepta1í2 hepta1ó2 hepta1ú2
hetero1h
hetero1a2 hetero1e2 hetero1i2 hetero1o2 hetero1u2
hetero1á2 hetero1é2 hetero1í2 hetero1ó2 hetero1ú2
2al.
2ales.
hexa1h
hexa1a2 hexa1e2 hexa1i2 hexa1o2 hexa1u2
hexa1á2 hexa1é2 hexa1í2 hexa1ó2 hexa1ú2
hidro1h
hidro1a2 hidro1e2 hidro1i2 hidro1o2 hidro1u2
hidro1á2 hidro1é2 hidro1í2 hidro1ó2 hidro1ú2
holo1h
holo1a2 holo1e2 holo1i2 holo1o2 holo1u2
holo1á2 holo1é2 holo1í2 holo1ó2 holo1ú2
hipe2r3r
hipe2r1h
hipe2r1a2 hipe2r1e2 hipe2r1i2 hipe2r1o2 hipe2r1u2
hipe2r1á2 hipe2r1é2 hipe2r1í2 hipe2r1ó2 hipe2r1ú2
pe3r4e3mia
hipe3r4i3cíne
hipe3r4o3nimi
hipe3r4o3ními
hipe3r4ó3nimo
hipe3r4o3xia
hipo1h
hipo1a2 hipo1e2 hipo1i2 hipo1o2 hipo1u2
hipo1á2 hipo1é2 hipo1í2 hipo1ó2 hipo1ú2
spano1h
spano1a2 spano1e2 spano1i2 spano1o2 spano1u2
spano1á2 spano1é2 spano1í2 spano1ó2 spano1ú2
histo1h
histo1a2 histo1e2 histo1i2 histo1o2 histo1u2
histo1á2 histo1é2 histo1í2 histo1ó2 histo1ú2
homo1h
homo1a2 homo1e2 homo1i2 homo1o2 homo1u2
homo1á2 homo1é2 homo1í2 homo1ó2 homo1ú2
homeo1h
homeo1a2 homeo1e2 homeo1i2 homeo1o2 homeo1u2
homeo1á2 homeo1é2 homeo1í2 homeo1ó2 homeo1ú2
ibero1h
ibero1a2 ibero1e2 ibero1i2 ibero1o2 ibero1u2
ibero1á2 ibero1é2 ibero1í2 ibero1ó2 ibero1ú2
icono1h
icono1a2 icono1e2 icono1i2 icono1o2 icono1u2
icono1á2 icono1é2 icono1í2 icono1ó2 icono1ú2
.i2n1h
.i2n2a2 .i2n2e2 .i2n2i2 .i2n2o2 .i2n2u2
.i2n2á2 .i2n2é2 .i2n2í2 .i2n2ó2 .i2n2ú2
in4hib
in4híb
in4hal
in4hál
in4hest
in4hést
in4hum
in4húm
in4hiest
in4hiést
in4herent
in4hóspit
in4hesi
.in3abarc
.in3abord
.in3acent
.in3acept
.in3adapt
.in3adopt
.in3aguant
.in3alámb
.in3alien
.in3analiz
.in3anim
.in3apagab
.in3afect
.in3apel
.in3aplaz
.in3aplic
.in3apreci
.in3aprehen
.in3aprens
.in3armón
.in3arrug
.in3asist
.in3atent
.in3efic
.in3efici
.in3eludi
.in3encont
.in3equid
.in3exact
.in3evit
.ina3movib
.ina3nic
.ine3narr
.ine3quív
.iná3nim
.iné3dit
.in3eleg
.in3exha
.in3ex
ini3cia
iní3cia
ini3ciá
ini3cie
re3ini3cia
re3iní3cia
re3ini3ciá
re3ini3cie
.ini3cuo
.ini3cua
.in3igualab
.in3in
.in3obser
.ino3cuo
.ino3cua
.ino3cenc
.ino3cent
.in3ocult
.ino3fens
.ino3cula
.ino3culá
.ino3cule
.in3oport
.inú3til
.inu3tiliz
infra1h
infra1a2 infra1e2 infra1i2 infra1o2 infra1u2
infra1á2 infra1é2 infra1í2 infra1ó2 infra1ú2
inmuno1h
inmuno1a2 inmuno1e2 inmuno1i2 inmuno1o2 inmuno1u2
inmuno1á2 inmuno1é2 inmuno1í2 inmuno1ó2 inmuno1ú2
.inte2r3r
.inte2r1h
.inte2r1a2 .inte2r1e2 .inte2r1i2 .inte2r1o2 .inte2r1u2
.inte2r1á2 .inte2r1é2 .inte2r1í2 .inte2r1ó2 .inte2r1ú2
.in3ter2e3sa
.in3ter2e3se
.in3ter2e3so
.in3ter2e3sá
.in3ter2e3sé
.in3ter2e3só
.de3s4in3ter2e3sa
.de3s4in3ter2e3se
.de3s4in3ter2e3so
.de3s4in3ter2e3sá
.de3s4in3ter2e3sé
.de3s4in3ter2e3só
4n5te5r2i3n
inte6r5i4nsu
inte6r5i4nst
inte6r5i4nd
4ino.
4inos.
4ina.
4inas.
.in3te3r4rog
.in3te3r4rupc
.in3te3r4rupt
.in3te3r4rump
inter4és
inte3r4esar
inte5r4regno
inte3r4ior4
in3te3r4im.
4i4ano.
4i4ana.
4i4anos.
4i4anas.
intra1h
intra1a2 intra1e2 intra1i2 intra1o2 intra1u2
intra1á2 intra1é2 intra1í2 intra1ó2 intra1ú2
islamo1h
islamo1a2 islamo1e2 islamo1i2 islamo1o2 islamo1u2
islamo1á2 islamo1é2 islamo1í2 islamo1ó2 islamo1ú2
italo1h
italo1a2 italo1e2 italo1i2 italo1o2 italo1u2
italo1á2 italo1é2 italo1í2 italo1ó2 italo1ú2
iso1h
iso1a2 iso1e2 iso1i2 iso1o2 iso1u2
iso1á2 iso1é2 iso1í2 iso1ó2 iso1ú2
kilo1h
kilo1a2 kilo1e2 kilo1i2 kilo1o2 kilo1u2
kilo1á2 kilo1é2 kilo1í2 kilo1ó2 kilo1ú2
leuco1h
leuco1a2 leuco1e2 leuco1i2 leuco1o2 leuco1u2
leuco1á2 leuco1é2 leuco1í2 leuco1ó2 leuco1ú2
linfo1h
linfo1a2 linfo1e2 linfo1i2 linfo1o2 linfo1u2
linfo1á2 linfo1é2 linfo1í2 linfo1ó2 linfo1ú2
lipo1h
lipo1a2 lipo1e2 lipo1i2 lipo1o2 lipo1u2
lipo1á2 lipo1é2 lipo1í2 lipo1ó2 lipo1ú2
lito1h
lito1a2 lito1e2 lito1i2 lito1o2 lito1u2
lito1á2 lito1é2 lito1í2 lito1ó2 lito1ú2
macro1h
macro1a2 macro1e2 macro1i2 macro1o2 macro1u2
macro1á2 macro1é2 macro1í2 macro1ó2 macro1ú2
mal2
ma4l3h
.ma4l3e4du
mal3b
mal3c
mal3d
mal3f
mal3g
mal3m
mal3p
mal3q
mal3s
mal3t
mal3v
.mal1acon
.mal1acos
.mala1e
.mal1andant
.mal1andanz
.mal1est
.mal1int
maxi1h
maxi1a2 maxi1e2 maxi1i2 maxi1o2 maxi1u2
maxi1á2 maxi1é2 maxi1í2 maxi1ó2 maxi1ú2
megalo1h
megalo1a2 megalo1e2 megalo1i2 megalo1o2 megalo1u2
megalo1á2 megalo1é2 megalo1í2 megalo1ó2 megalo1ú2
mega1h
mega1a2 mega1e2 mega1i2 mega1o2 mega1u2
mega1á2 mega1é2 mega1í2 mega1ó2 mega1ú2
melano1h
melano1a2 melano1e2 melano1i2 melano1o2 melano1u2
melano1á2 melano1é2 melano1í2 melano1ó2 melano1ú2
meso1h
meso1a2 meso1e2 meso1i2 meso1o2 meso1u2
meso1á2 meso1é2 meso1í2 meso1ó2 meso1ú2
meta1h
meta1a2 meta1e2 meta1i2 meta1o2 meta1u2
meta1á2 meta1é2 meta1í2 meta1ó2 meta1ú2
micro1h
micro1a2 micro1e2 micro1i2 micro1o2 micro1u2
micro1á2 micro1é2 micro1í2 micro1ó2 micro1ú2
.mili1h
.mili1a2 .mili1e2 .mili1i2 .mili1o2 .mili1u2
.mili1á2 .mili1é2 .mili1í2 .mili1ó2 .mili1ú2
familia3ri
ia5res.
amili6a
a3rio
a3ria
li5á4rea
mili4ar
mini1h
mini1a2 mini1e2 mini1i2 mini1o2 mini1u2
mini1á2 mini1é2 mini1í2 mini1ó2 mini1ú2
2os.
2o3so.
2o3sos.
2o3sa.
2o3sas.
2o3samente.
mini4a5tur
.mio1h
.mio1a2 .mio1e2 .mio1i2 .mio1o2 .mio1u2
.mio1á2 .mio1é2 .mio1í2 .mio1ó2 .mio1ú2
multi1h
multi1a2 multi1e2 multi1i2 multi1o2 multi1u2
multi1á2 multi1é2 multi1í2 multi1ó2 multi1ú2
miria1h
miria1a2 miria1e2 miria1i2 miria1o2 miria1u2
miria1á2 miria1é2 miria1í2 miria1ó2 miria1ú2
mono1h
mono1a2 mono1e2 mono1i2 mono1o2 mono1u2
mono1á2 mono1é2 mono1í2 mono1ó2 mono1ú2
morfo1h
morfo1a2 morfo1e2 morfo1i2 morfo1o2 morfo1u2
morfo1á2 morfo1é2 morfo1í2 morfo1ó2 morfo1ú2
moto1h
moto1a2 moto1e2 moto1i2 moto1o2 moto1u2
moto1á2 moto1é2 moto1í2 moto1ó2 moto1ú2
namo1h
namo1a2 namo1e2 namo1i2 namo1o2 namo1u2
namo1á2 namo1é2 namo1í2 namo1ó2 namo1ú2
nano1h
nano1a2 nano1e2 nano1i2 nano1o2 nano1u2
nano1á2 nano1é2 nano1í2 nano1ó2 nano1ú2
narco1h
narco1a2 narco1e2 narco1i2 narco1o2 narco1u2
narco1á2 narco1é2 narco1í2 narco1ó2 narco1ú2
necro1h
necro1a2 necro1e2 necro1i2 necro1o2 necro1u2
necro1á2 necro1é2 necro1í2 necro1ó2 necro1ú2
nefro1h
nefro1a2 nefro1e2 nefro1i2 nefro1o2 nefro1u2
nefro1á2 nefro1é2 nefro1í2 nefro1ó2 nefro1ú2
neo1h
neo1a2 neo1e2 neo1i2 neo1o2 neo1u2
neo1á2 neo1é2 neo1í2 neo1ó2 neo1ú2
3c2neor
neto1h
neto1a2 neto1e2 neto1i2 neto1o2 neto1u2
neto1á2 neto1é2 neto1í2 neto1ó2 neto1ú2
neumo1h
neumo1a2 neumo1e2 neumo1i2 neumo1o2 neumo1u2
neumo1á2 neumo1é2 neumo1í2 neumo1ó2 neumo1ú2
norte1h
norte1a2 norte1e2 norte1i2 norte1o2 norte1u2
norte1á2 norte1é2 norte1í2 norte1ó2 norte1ú2
octo1h
octo1a2 octo1e2 octo1i2 octo1o2 octo1u2
octo1á2 octo1é2 octo1í2 octo1ó2 octo1ú2
octa1h
octa1a2 octa1e2 octa1i2 octa1o2 octa1u2
octa1á2 octa1é2 octa1í2 octa1ó2 octa1ú2
oligo1h
oligo1a2 oligo1e2 oligo1i2 oligo1o2 oligo1u2
oligo1á2 oligo1é2 oligo1í2 oligo1ó2 oligo1ú2
omni1h
omni1a2 omni1e2 omni1i2 omni1o2 omni1u2
omni1á2 omni1é2 omni1í2 omni1ó2 omni1ú2
onco1h
onco1a2 onco1e2 onco1i2 onco1o2 onco1u2
onco1á2 onco1é2 onco1í2 onco1ó2 onco1ú2
onto1h
onto1a2 onto1e2 onto1i2 onto1o2 onto1u2
onto1á2 onto1é2 onto1í2 onto1ó2 onto1ú2
opto1h
opto1a2 opto1e2 opto1i2 opto1o2 opto1u2
opto1á2 opto1é2 opto1í2 opto1ó2 opto1ú2
ornito1h
ornito1a2 ornito1e2 ornito1i2 ornito1o2 ornito1u2
ornito1á2 ornito1é2 ornito1í2 ornito1ó2 ornito1ú2
orto1h
orto1a2 orto1e2 orto1i2 orto1o2 orto1u2
orto1á2 orto1é2 orto1í2 orto1ó2 orto1ú2
orto4e3pía
osteo1h
osteo1a2 osteo1e2 osteo1i2 osteo1o2 osteo1u2
osteo1á2 osteo1é2 osteo1í2 osteo1ó2 osteo1ú2
paleo1h
paleo1a2 paleo1e2 paleo1i2 paleo1o2 paleo1u2
paleo1á2 paleo1é2 paleo1í2 paleo1ó2 paleo1ú2
.pa4n1a4fri
.pa4n1a4meri
.pa4n1á4rab
.pa4n1a4ráb
.pa4n1a4rab
.pa4n1europ
.pa4n1islam
.pa4n1islám
.pa4n5hisp
.pa4n1hel
.pa4n1ópti
para1h
para1a2 para1e2 para1i2 para1o2 para1u2
para1á2 para1é2 para1í2 para1ó2 para1ú2
para2is.
aí5so.
aí5sos.
para4íso
para4i3señ
para4ulata
penta1h
penta1a2 penta1e2 penta1i2 penta1o2 penta1u2
penta1á2 penta1é2 penta1í2 penta1ó2 penta1ú2
peta1h
peta1a2 peta1e2 peta1i2 peta1o2 peta1u2
peta1á2 peta1é2 peta1í2 peta1ó2 peta1ú2
pico1h
pico1a2 pico1e2 pico1i2 pico1o2 pico1u2
pico1á2 pico1é2 pico1í2 pico1ó2 pico1ú2
piezo1h
piezo1a2 piezo1e2 piezo1i2 piezo1o2 piezo1u2
piezo1á2 piezo1é2 piezo1í2 piezo1ó2 piezo1ú2
piro1h
piro1a2 piro1e2 piro1i2 piro1o2 piro1u2
piro1á2 piro1é2 piro1í2 piro1ó2 piro1ú2
pluri1h
pluri1a2 pluri1e2 pluri1i2 pluri1o2 pluri1u2
pluri1á2 pluri1é2 pluri1í2 pluri1ó2 pluri1ú2
poli1h
poli1a2 poli1e2 poli1i2 poli1o2 poli1u2
poli1á2 poli1é2 poli1í2 poli1ó2 poli1ú2
poli4u3r
poli4o5mie
poli4arq
poli4árq
poli4éste
poli4andr
poli4antea
poli4arca
expoli4
porta1h
porta1a2 porta1e2 porta1i2 porta1o2 porta1u2
porta1á2 porta1é2 porta1í2 porta1ó2 porta1ú2
porta4e3ro
.pos2t1h
.pos2t2a2 .pos2t2e2 .pos2t2i2 .pos2t2o2 .pos2t2u2
.pos2t2á2 .pos2t2é2 .pos2t2í2 .pos2t2ó2 .pos2t2ú2
po4s3impr
po4s3o2per
po4s3ind
po4s3e4lect
po4s3estr
.pos3tin
.pos3tín
.pos4t3ind
pos3ta.
pos3tas.
pos4t5s
s3te.
s3tes.
s3tal.
s3ta3les.
s3ti3lla.
s3ti3llas.
s3ti3llón.
s3ti3llones.
s3tor.
s3tora.
s3toras.
s3tores.
.pos3tó3ni
.pos3terg
.pos3te3ri
.pos3ti3go
.pos3ti3la
.pos3ti3ne
.pos3ti3za
.pos3ti3zo
.pos3tu3ra
.pos3tu3la
.pos3tu3lá
.pos3tu3le
.pos3tu3lé
.pos2t3elec
.pos2t3impr
.pos2t3ope
.pos2t3rev
.pos2t3rom
.pos3taci
.pos3tar
.pos3tear
.pos3te3me
.pos3ta3je
.pos3te3ler
.pos3te3ma
.pos3te3mi
.pos3te3río
.pos3te3ta
.pos3ti3le
.pos3ti3llo
.pos3ti3lo
.pos3ti3lá
.pos3ti3lé
.pos3ti3ló
.posti3nudo
.posto3res
.pos3tu3lo
.pos3tu3ló
.pos3tón
.pos3te3mas
.pos3ti3cer
.pos3tism
.pos3tu3reo
.pos3te3lera
.pos3teo
.pos3ti3ll
.pos3tista
.pre1h
.pre1a2 .pre1e2 .pre1i2 .pre1o2 .pre1u2
.pre1á2 .pre1é2 .pre1í2 .pre1ó2 .pre1ú2
.pre4ámbul
.pre4o3cup
.pre4o3cúp
.pre4ordin
.pre4ordín
.pro1h
.pro2a2 .pro2e2 .pro2i2 .pro2o2 .pro2u2
.pro2á2 .pro2é2 .pro2í2 .pro2ó2 .pro2ú2
.pro3abort
.pro3etarr
.pro4hiba
.pro4híba
.pro4hibá
.pro4hibe
.pro4híb
.pro4híbo
.pro4hibi
.pro4hibí
proto1h
proto1a2 proto1e2 proto1i2 proto1o2 proto1u2
proto1á2 proto1é2 proto1í2 proto1ó2 proto1ú2
psico1h
psico1a2 psico1e2 psico1i2 psico1o2 psico1u2
psico1á2 psico1é2 psico1í2 psico1ó2 psico1ú2
3p2sic
3p2siq
ptero1h
ptero1a2 ptero1e2 ptero1i2 ptero1o2 ptero1u2
ptero1á2 ptero1é2 ptero1í2 ptero1ó2 ptero1ú2
quete1h
quete1a2 quete1e2 quete1i2 quete1o2 quete1u2
quete1á2 quete1é2 quete1í2 quete1ó2 quete1ú2
quimio1h
quimio1a2 quimio1e2 quimio1i2 quimio1o2 quimio1u2
quimio1á2 quimio1é2 quimio1í2 quimio1ó2 quimio1ú2
quiro1h
quiro1a2 quiro1e2 quiro1i2 quiro1o2 quiro1u2
quiro1á2 quiro1é2 quiro1í2 quiro1ó2 quiro1ú2
radio1h
radio1a2 radio1e2 radio1i2 radio1o2 radio1u2
radio1á2 radio1é2 radio1í2 radio1ó2 radio1ú2
ranco1h
ranco1a2 ranco1e2 ranco1i2 ranco1o2 ranco1u2
ranco1á2 ranco1é2 ranco1í2 ranco1ó2 ranco1ú2
.re2a2
.re3e4
.re2i2
.re2o2
.re2u2
.re2á2
.re2é2
.re2í2
.re2ó2
.re2ú2
ea3cio.
ea3cios.
ea3cia.
ea3cias.
.re3abr
.re3ábr
.re3abiert
.re3absor
.re3absór
.re3admis
.re3admit
.re3admít
.re3afirm
.re3afírm
.re3agrav
.re3agráv
.re3acondic
.re3acuñ
.re3acúñ
.re3ajust
.rea3júst
.re3alegr
.re3alégr
.rea3liza
.rea3lizá
.rea3líza
.re3alim
.rea3lism
.rea3list
.re3aloj
.re3alój
.re3alq
.re3anim
.re3aním
.re3ama
.re3áma
.re3amá
.re3ame
.re3áme
.re3amé
.re3amo
.re3ámo
.re3amó
.re3aparec
.re3aprend
.re3aprénd
.re3apret
.reapríet
.rei3no
.re3ubica
.re3ubíca
.re3ubicá
.re3ubico
.re3ubicó
.re3ubiq
.re3ubíq
.reu3mati
.reu3máti
.reu3nir
.reu3nír
.reu3nia
.reu3ní
.reu3nis
.reunim
.reu3ná
.reu3nie
.reu3nié
.reu3nid
.reu3nió
.re3unif
.re3usar
.re3usár
.re3utiliz
.re3utilíz
.re3a2eg
.re3a2q
.re3a2z
.re3asum
.re3asúm
.re3a2grup
.re3i2m
.re3inc
.re3inic
.re3inf
.re3ing
.re3inv
.rei3na
.re3ins
.re3int
.re3o2b
.re3orient
.rei3vind
.re3oc
.re4o3j
.re3orga
.re3unt
.reu3ma
rete1h
rete1a2 rete1e2 rete1i2 rete1o2 rete1u2
rete1á2 rete1é2 rete1í2 rete1ó2 rete1ú2
rmano1h
rmano1a2 rmano1e2 rmano1i2 rmano1o2 rmano1u2
rmano1á2 rmano1é2 rmano1í2 rmano1ó2 rmano1ú2
retro1h
retro1a2 retro1e2 retro1i2 retro1o2 retro1u2
retro1á2 retro1é2 retro1í2 retro1ó2 retro1ú2
romo1h
romo1a2 romo1e2 romo1i2 romo1o2 romo1u2
romo1á2 romo1é2 romo1í2 romo1ó2 romo1ú2
salva1h
salva1a2 salva1e2 salva1i2 salva1o2 salva1u2
salva1á2 salva1é2 salva1í2 salva1ó2 salva1ú2
seleno1h
seleno1a2 seleno1e2 seleno1i2 seleno1o2 seleno1u2
seleno1á2 seleno1é2 seleno1í2 seleno1ó2 seleno1ú2
semi1h
semi1a2 semi1e2 semi1i2 semi1o2 semi1u2
semi1á2 semi1é2 semi1í2 semi1ó2 semi1ú2
i2a.
i2as.
2ótic
emi2o2
servo1h
servo1a2 servo1e2 servo1i2 servo1o2 servo1u2
servo1á2 servo1é2 servo1í2 servo1ó2 servo1ú2
2seudo1h
2seudo1a2 2seudo1e2 2seudo1i2 2seudo1o2 2seudo1u2
2seudo1á2 2seudo1é2 2seudo1í2 2seudo1ó2 2seudo1ú2
o2os.
.so3a4s
sobre1h
sobre1a2 sobre1e2 sobre1i2 sobre1o2 sobre1u2
sobre1á2 sobre1é2 sobre1í2 sobre1ó2 sobre1ú2
sobre3a4sa
sobre3a4sas
socio1h
socio1a2 socio1e2 socio1i2 socio1o2 socio1u2
socio1á2 socio1é2 socio1í2 socio1ó2 socio1ú2
4a3rio.
4a3rios.
4a3ria.
4a3rias.
3logía
4ón.
4ones.
4i4er.
4o2ico.
4o2icos.
4o2ica.
4o2icas.
.su2b1h
.su2b2a2 .su2b2e2 .su2b2i2 .su2b2o2 .su2b2u2
.su2b2á2 .su2b2é2 .su2b2í2 .su2b2ó2 .su2b2ú2
.sub3acuát
.subi3ll
.su3bi3da
.su3bi3dor
.su3bi3do
.su3bi3dón
.su3basta
.su3básta
.su3bastá
.su3baste
.su3básté
.su3basto
.su3bástó
.sub3índ
.sub3ími
.su4b3ray
.sub3acepc
.sub3acet
.sub3aflue
.sub3alcai
.sub3arr
.sub3ártic
.sub3atómic
.sub3ejecut
.sub3elemen
.sub3emple
.sub3enten
.seb3entrad
.sub3espec
.sub3estac
.sub3estim
.sub3estím
.sub3estruc
.sub3occipit
.sub3ofici
.su3bordin
.su3bordín
.sub3urba
.sub3aliment
.su3balter
.sub3insp
.sub3intenden
.su3bir
.su3bír
.su3bién
.su3bi3mien
.su3bier
.su3bies
.su2r1est
.su2r1oes
supe2r3r
supe2r1h
supe2r1a2 supe2r1e2 supe2r1i2 supe2r1o2 supe2r1u2
supe2r1á2 supe2r1é2 supe2r1í2 supe2r1ó2 supe2r1ú2
ra5ra
ra5rá
ra5re
ra5ré
ra5rí
ra5ro
supe3r4a4r
supe3r4á4r
supe3r4á3vit.
supe3r4á3vits.
super4ior
4a3ción.
4a3ciones.
4e3rior.
4e3riores.
4e3riora.
4e3rioras.
4e3riormente.
4e3rioridad.
4e3rioridades.
4e3r4a3ble.
4e3r4a3bles.
4e3r4a3blemente.
pe5r4ante
perpon5d6r
supra1h
supra1a2 supra1e2 supra1i2 supra1o2 supra1u2
supra1á2 supra1é2 supra1í2 supra1ó2 supra1ú2
sup6ra
talmo1h
talmo1a2 talmo1e2 talmo1i2 talmo1o2 talmo1u2
talmo1á2 talmo1é2 talmo1í2 talmo1ó2 talmo1ú2
tele1h
tele1a2 tele1e2 tele1i2 tele1o2 tele1u2
tele1á2 tele1é2 tele1í2 tele1ó2 tele1ú2
4ósteo.
4ósteos.
tecno1h
tecno1a2 tecno1e2 tecno1i2 tecno1o2 tecno1u2
tecno1á2 tecno1é2 tecno1í2 tecno1ó2 tecno1ú2
.tele1imp
.tele1obj
.tele4o3lót
tera1h
tera1a2 tera1e2 tera1i2 tera1o2 tera1u2
tera1á2 tera1é2 tera1í2 tera1ó2 tera1ú2
termo1h
termo1a2 termo1e2 termo1i2 termo1o2 termo1u2
termo1á2 termo1é2 termo1í2 termo1ó2 termo1ú2
tetra1h
tetra1a2 tetra1e2 tetra1i2 tetra1o2 tetra1u2
tetra1á2 tetra1é2 tetra1í2 tetra1ó2 tetra1ú2
topo1h
topo1a2 topo1e2 topo1i2 topo1o2 topo1u2
topo1á2 topo1é2 topo1í2 topo1ó2 topo1ú2
.tra2s1h
.tra2sa2 .tra2se2 .tra2si2 .tra2so2 .tra2su2
.tra2sá2 .tra2sé2 .tra2sí2 .tra2só2 .tra2sú2
tras1abuel
tras1alcob
tras1alp
tras1altar
tras1andin
tras1atlánt
tras1oceán
tra3se3ro.
tra3se3ros.
tra3se3ra.
tra3se3ras.
.tra3su3da
.tra3su3dá
.tra3su3de
.tra3su3dé
.tra3su3do
.tra3su3dó
.tra3sunta
.tra3suntá
.tra3sunte
.tra3sunté
.tra3sunto
.tra3suntó
.tra3so3ñ
.tra3se3g
.tra3sieg
tran2s1h
tran2sa2 tran2se2 tran2si2 tran2so2 tran2su2
tran2sá2 tran2sé2 tran2sí2 tran2só2 tran2sú2
trans3aminas
tran2s1and
tran2s1atl
tran2s1oce
tran2s1ur
tran3sacci
tran3sactiv
tran3seún
tran3se3xu
tran3si3berian
tran3si3cion
tran3si3ción
tran3sido.
tran3sidos.
tran3sida.
tran3sidas.
tran3si3gi
tran3si3gí
tran3si3ge
tran3si3ja
tran3si3já
tran3si3jo
tran3silvan
tran3sisto
tran3si3ta
tran3si3tá
tran3si3te
tran3si3té
tran3si3to
tran3si3tó
tran3si3tiv
tran3si3tori
trans3oraci
tran3subst
tran3sust
.tri1ó2x
tropo1h
tropo1a2 tropo1e2 tropo1i2 tropo1o2 tropo1u2
tropo1á2 tropo1é2 tropo1í2 tropo1ó2 tropo1ú2
turbo1h
turbo1a2 turbo1e2 turbo1i2 turbo1o2 turbo1u2
turbo1á2 turbo1é2 turbo1í2 turbo1ó2 turbo1ú2
ultra1h
ultra1a2 ultra1e2 ultra1i2 ultra1o2 ultra1u2
ultra1á2 ultra1é2 ultra1í2 ultra1ó2 ultra1ú2
vice1h
vice1a2 vice1e2 vice1i2 vice1o2 vice1u2
vice1á2 vice1é2 vice1í2 vice1ó2 vice1ú2
video1h
video1a2 video1e2 video1i2 video1o2 video1u2
video1á2 video1é2 video1í2 video1ó2 video1ú2
xeno1h
xeno1a2 xeno1e2 xeno1i2 xeno1o2 xeno1u2
xeno1á2 xeno1é2 xeno1í2 xeno1ó2 xeno1ú2
xero1h
xero1a2 xero1e2 xero1i2 xero1o2 xero1u2
xero1á2 xero1é2 xero1í2 xero1ó2 xero1ú2
xilo1h
xilo1a2 xilo1e2 xilo1i2 xilo1o2 xilo1u2
xilo1á2 xilo1é2 xilo1í2 xilo1ó2 xilo1ú2
zoo1h
zoo1a2 zoo1e2 zoo1i2 zoo1o2 zoo1u2
zoo1á2 zoo1é2 zoo1í2 zoo1ó2 zoo1ú2
wa3s4h
3grafo.
3grafa.
3grafos.
3grafas.
3grafía.
3grafías.
o4i3dea.
o4i3deas.
o4i3dal.
o4i3dales.
4o2i3de.
4o2i3des.
4i2dal.
4i2dales.
4i3deo.
4i3deos.
i2o.
i2os.
2i3co.
2i3cos.
2i3ca.
2i3cas.
4e3dro.
4e3dros.
4é3drico.
4é3dricos.
4é3drica.
4é3dricas.
4í3ble.
4í3bles.
3hablante
3habiente
5humano
5humana
3a4ficionad
3a4merican
su2d3a4merican
su2r3a4merican
3e4lectr
3e4léctr
di4e5lec
di4e5léc
5i4ndustr
5islámi
5islami
5ingenier
5técnic
5biología
5céntrico
5e4cuatorial
7u4niversid
5u4niversit
}

