/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.document;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.IBlankSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CompositeSegment<T extends GenericSegment>
extends TextSegment
implements Cloneable {
    protected List<T> items;

    public CompositeSegment(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize) {
        super(x1, x2, y1, y2, text, fontName, fontSize);
        this.items = new ArrayList<T>();
    }

    public CompositeSegment(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
        this.items = new ArrayList<T>();
    }

    public CompositeSegment(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize, List<T> items) {
        super(x1, x2, y1, y2, text, fontName, fontSize);
        this.items = items;
    }

    public CompositeSegment(float x1, float x2, float y1, float y2, List<T> items) {
        super(x1, x2, y1, y2);
        this.items = items;
    }

    public CompositeSegment(List<T> items) {
        this.items = items;
    }

    public CompositeSegment() {
        this.items = new ArrayList<T>();
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    @Override
    public Object clone() {
        CompositeSegment retVal = (CompositeSegment)super.clone();
        ArrayList<T> cloneList = new ArrayList<T>();
        cloneList.addAll(this.items);
        retVal.items = cloneList;
        return retVal;
    }

    @Override
    public String toString() {
        return String.valueOf(this.tagName()) + " no. items: " + this.items.size() + " - " + this.getAttributes();
    }

    public void printSubItems() {
        System.out.println(this);
        this.printSubItems(0);
    }

    public void printSubItems(int indent) {
        for (GenericSegment gs : this.items) {
            int n = 0;
            while (n < indent) {
                System.out.print("    ");
                ++n;
            }
            System.out.println(gs);
            if (!(gs instanceof CompositeSegment)) continue;
            CompositeSegment cs = (CompositeSegment)gs;
            cs.printSubItems(indent + 1);
        }
    }

    public String toExtendedString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.toString()) + "\nSub-items:\n");
        for (GenericSegment gs : this.items) {
            sb.append(String.valueOf(gs.toString()) + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public void setCalculatedFields() {
        this.findBoundingBox();
        this.findText();
        this.findFontName();
        this.findFontSize();
    }

    public void setCalculatedFields(TextSegment ts) {
        this.setBoundingBox(ts.getBoundingBox());
        this.setText(ts.getText());
        this.setFontName(ts.getFontName());
        this.setFontSize(ts.getFontSize());
    }

    public void findFontName() {
        HashMap<String, Integer> fontHash = new HashMap<String, Integer>();
        ArrayList<String> numList = new ArrayList<String>(this.items.size() + 1);
        int n = 0;
        while (n < this.items.size() + 1) {
            numList.add(null);
            ++n;
        }
        for (GenericSegment thisSegment : this.items) {
            if (!(thisSegment instanceof TextSegment) || thisSegment instanceof IBlankSegment) continue;
            TextSegment thisTextSegment = (TextSegment)thisSegment;
            if (fontHash.containsKey(thisTextSegment.getFontName())) {
                int count = (Integer)fontHash.get(thisTextSegment.getFontName());
                fontHash.put(thisTextSegment.getFontName(), new Integer(++count));
                if (numList.get(count) != null) continue;
                numList.set(count, thisTextSegment.getFontName());
                continue;
            }
            fontHash.put(thisTextSegment.getFontName(), new Integer(1));
            if (numList.get(1) != null) continue;
            numList.set(1, thisTextSegment.getFontName());
        }
        Collection counts = fontHash.values();
        int maxCount = 0;
        for (Integer countObj : counts) {
            int count = countObj;
            if (count <= maxCount) continue;
            maxCount = count;
        }
        if (maxCount > 0) {
            this.fontName = (String)numList.get(maxCount);
        }
    }

    public void findBoundingBox() {
        boolean first = true;
        int noItems = 0;
        double fontSizeTotal = 0.0;
        for (GenericSegment thisSegment : this.items) {
            if (thisSegment instanceof IBlankSegment) continue;
            if (thisSegment instanceof TextSegment) {
                ++noItems;
                fontSizeTotal += (double)((TextSegment)thisSegment).getFontSize();
            }
            if (first) {
                this.x1 = thisSegment.getX1();
                this.x2 = thisSegment.getX2();
                this.y1 = thisSegment.getY1();
                this.y2 = thisSegment.getY2();
                first = false;
                continue;
            }
            this.growBoundingBox(thisSegment);
        }
        this.fontSize = noItems >= 0 ? (float)(fontSizeTotal / (double)noItems) : -1.0f;
    }

    public void findText() {
        this.text = "";
        for (GenericSegment gs : this.items) {
            if (!(gs instanceof TextSegment)) continue;
            TextSegment ts = (TextSegment)gs;
            this.text = ts.getText() == "" ? String.valueOf(this.text) + " " : String.valueOf(this.text) + ts.getText();
        }
    }

    public void findFontSize() {
        int size = this.getItems().size();
        float sum = 0.0f;
        for (GenericSegment gs : this.items) {
            if (!(gs instanceof TextSegment)) continue;
            TextSegment ts = (TextSegment)gs;
            sum += ts.getFontSize();
        }
        this.setFontSize(sum / (float)size);
    }
}

