# Games::Checkers, Copyright (C) 1996-2012 Mikhael Goikhman, migo@cpan.org
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Games::Checkers::Board::_10x8;

use strict;
use warnings;

use base 'Games::Checkers::Board';
use Games::Checkers::Constants;

use constant size_x => 10;
use constant size_y => 8;
use constant locs => 40;
use constant default_rows => 3;

use constant loc_directions => [
	[ NL,  5, NL, NL ], [  5,  6, NL, NL ], [  6,  7, NL, NL ], [  7,  8, NL, NL ], [  8,  9, NL, NL ],
	[ 10, 11,  0,  1 ], [ 11, 12,  1,  2 ], [ 12, 13,  2,  3 ], [ 13, 14,  3,  4 ], [ 14, NL,  4, NL ],
	[ NL, 15, NL,  5 ], [ 15, 16,  5,  6 ], [ 16, 17,  6,  7 ], [ 17, 18,  7,  8 ], [ 18, 19,  8,  9 ],
	[ 20, 21, 10, 11 ], [ 21, 22, 11, 12 ], [ 22, 23, 12, 13 ], [ 23, 24, 13, 14 ], [ 24, NL, 14, NL ],
	[ NL, 25, NL, 15 ], [ 25, 26, 15, 16 ], [ 26, 27, 16, 17 ], [ 27, 28, 17, 18 ], [ 28, 29, 18, 19 ],
	[ 30, 31, 20, 21 ], [ 31, 32, 21, 22 ], [ 32, 33, 22, 23 ], [ 33, 34, 23, 24 ], [ 34, NL, 24, NL ],
	[ NL, 35, NL, 25 ], [ 35, 36, 25, 26 ], [ 36, 37, 26, 27 ], [ 37, 38, 27, 28 ], [ 38, 39, 28, 29 ],
	[ NL, NL, 30, 31 ], [ NL, NL, 31, 32 ], [ NL, NL, 32, 33 ], [ NL, NL, 33, 34 ], [ NL, NL, 34, NL ],
];

use constant is_crowning => [
[
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	1, 1, 1, 1, 1,
], [
	1, 1, 1, 1, 1,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0, 0,
]
];

use constant pawn_step => [
[
	[      5 ], [  5,  6 ], [  6,  7 ], [  7,  8 ], [  8,  9 ],
	[ 10, 11 ], [ 11, 12 ], [ 12, 13 ], [ 13, 14 ], [ 14     ],
	[     15 ], [ 15, 16 ], [ 16, 17 ], [ 17, 18 ], [ 18, 19 ],
	[ 20, 21 ], [ 21, 22 ], [ 22, 23 ], [ 23, 24 ], [ 24     ],
	[     25 ], [ 25, 26 ], [ 26, 27 ], [ 27, 28 ], [ 28, 29 ],
	[ 30, 31 ], [ 31, 32 ], [ 32, 33 ], [ 33, 34 ], [ 34     ],
	[     35 ], [ 35, 36 ], [ 36, 37 ], [ 37, 38 ], [ 38, 39 ],
	[        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ],
	[  0,  1 ], [  1,  2 ], [  2,  3 ], [  3,  4 ], [  4     ],
	[      5 ], [  5,  6 ], [  6,  7 ], [  7,  8 ], [  8,  9 ],
	[ 10, 11 ], [ 11, 12 ], [ 12, 13 ], [ 13, 14 ], [ 14     ],
	[     15 ], [ 15, 16 ], [ 16, 17 ], [ 17, 18 ], [ 18, 19 ],
	[ 20, 21 ], [ 21, 22 ], [ 22, 23 ], [ 23, 24 ], [ 24     ],
	[     25 ], [ 25, 26 ], [ 26, 27 ], [ 27, 28 ], [ 28, 29 ],
	[ 30, 31 ], [ 31, 32 ], [ 32, 33 ], [ 33, 34 ], [ 34     ],
]
];

use constant pawn_beat => [
	[     11         ], [ 10, 12         ], [ 11, 13         ], [ 12, 14         ], [ 13             ],
	[     16         ], [ 15, 17         ], [ 16, 18         ], [ 17, 19         ], [ 18             ],
	[     21,      1 ], [ 20, 22,  0,  2 ], [ 21, 23,  1,  3 ], [ 22, 24,  2,  4 ], [ 23,      3     ],
	[     26,      6 ], [ 25, 27,  5,  7 ], [ 26, 28,  6,  8 ], [ 27, 29,  7,  9 ], [ 28,      8     ],
	[     31,     11 ], [ 30, 32, 10, 12 ], [ 31, 33, 11, 13 ], [ 32, 34, 12, 14 ], [ 33,     13     ],
	[     36,     16 ], [ 35, 37, 15, 17 ], [ 36, 38, 16, 18 ], [ 37, 39, 17, 19 ], [ 38,     18     ],
	[             21 ], [         20, 22 ], [         21, 23 ], [         22, 24 ], [         23     ],
	[             26 ], [         25, 27 ], [         26, 28 ], [         27, 29 ], [         28     ],
];

use constant pawn_beat_forward => [
[
	[     11 ], [ 10, 12 ], [ 11, 13 ], [ 12, 14 ], [ 13     ],
	[     16 ], [ 15, 17 ], [ 16, 18 ], [ 17, 19 ], [ 18     ],
	[     21 ], [ 20, 22 ], [ 21, 23 ], [ 22, 24 ], [ 23     ],
	[     26 ], [ 25, 27 ], [ 26, 28 ], [ 27, 29 ], [ 28     ],
	[     31 ], [ 30, 32 ], [ 31, 33 ], [ 32, 34 ], [ 33     ],
	[     36 ], [ 35, 37 ], [ 36, 38 ], [ 37, 39 ], [ 38     ],
	[        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ],
	[      1 ], [  0,  2 ], [  1,  3 ], [  2,  4 ], [  3     ],
	[      6 ], [  5,  7 ], [  6,  8 ], [  7,  9 ], [  8     ],
	[     11 ], [ 10, 12 ], [ 11, 13 ], [ 12, 14 ], [ 13     ],
	[     16 ], [ 15, 17 ], [ 16, 18 ], [ 17, 19 ], [ 18     ],
	[     21 ], [ 20, 22 ], [ 21, 23 ], [ 22, 24 ], [ 23     ],
	[     26 ], [ 25, 27 ], [ 26, 28 ], [ 27, 29 ], [ 28     ],
]
];

use constant pawn_beat_8dirs => [
	[     11,                 20,  2 ], [ 10, 12,                 21,  3 ], [ 11, 13,              0, 22,  4 ], [ 12, 14,              1, 23     ], [ 13,                  2, 24     ],
	[     16,                 25,  7 ], [ 15, 17,                 26,  8 ], [ 16, 18,              5, 27,  9 ], [ 17, 19,              6, 28     ], [ 18,                  7, 29     ],
	[     21,      1,         30, 12 ], [ 20, 22,  0,  2,         31, 13 ], [ 21, 23,  1,  3,     10, 32, 14 ], [ 22, 24,  2,  4,     11, 33     ], [ 23,      3,         12, 34     ],
	[     26,      6,         35, 17 ], [ 25, 27,  5,  7,         36, 18 ], [ 26, 28,  6,  8,     15, 37, 19 ], [ 27, 29,  7,  9,     16, 38     ], [ 28,      8,         17, 39     ],
	[     31,     11,  0,         22 ], [ 30, 32, 10, 12,  1,         23 ], [ 31, 33, 11, 13,  2, 20,     24 ], [ 32, 34, 12, 14,  3, 21         ], [ 33,     13,      4, 22         ],
	[     36,     16,  5,         27 ], [ 35, 37, 15, 17,  6,         28 ], [ 36, 38, 16, 18,  7, 25,     29 ], [ 37, 39, 17, 19,  8, 26         ], [ 38,     18,      9, 27         ],
	[             21, 10,         32 ], [         20, 22, 11,         33 ], [         21, 23, 12, 30,     34 ], [         22, 24, 13, 31         ], [         23,     14, 32         ],
	[             26, 15,         37 ], [         25, 27, 16,         38 ], [         26, 28, 17, 35,     39 ], [         27, 29, 18, 36         ], [         28,     19, 37         ],
];

use constant king_step => [
	[      5,             11,             16,             22,             27,             33,             38         ],
	[  5,  6,         10, 12,             17,             23,             28,             34,             39         ],
	[  6,  7,         11, 13,         15, 18,         20, 24,             29                                         ],
	[  7,  8,         12, 14,         16, 19,         21,             25,             30                             ],
	[  8,  9,         13,             17,             22,             26,             31,             35             ],
	[ 10, 11,  0,  1,     16,             22,             27,             33,             38                         ],
	[ 11, 12,  1,  2, 15, 17,         20, 23,             28,             34,             39                         ],
	[ 12, 13,  2,  3, 16, 18,         21, 24,         25, 29,         30                                             ],
	[ 13, 14,  3,  4, 17, 19,         22,             26,             31,             35                             ],
	[ 14,      4,     18,             23,             27,             32,             36                             ],
	[     15,      5,     21,      1,     26,             32,             37                                         ],
	[ 15, 16,  5,  6, 20, 22,  0,  2,     27,             33,             38                                         ],
	[ 16, 17,  6,  7, 21, 23,  1,  3, 25, 28,         30, 34,             39                                         ],
	[ 17, 18,  7,  8, 22, 24,  2,  4, 26, 29,         31,             35                                             ],
	[ 18, 19,  8,  9, 23,      3,     27,             32,             36                                             ],
	[ 20, 21, 10, 11,     26,      6,     32,      2,     37                                                         ],
	[ 21, 22, 11, 12, 25, 27,  5,  7, 30, 33,  0,  3,     38                                                         ],
	[ 22, 23, 12, 13, 26, 28,  6,  8, 31, 34,  1,  4, 35, 39                                                         ],
	[ 23, 24, 13, 14, 27, 29,  7,  9, 32,      2,     36                                                             ],
	[ 24,     14,     28,      8,     33,      3,     37                                                             ],
	[     25,     15,     31,     11,     36,      6,              2                                                 ],
	[ 25, 26, 15, 16, 30, 32, 10, 12,     37,      7,              3                                                 ],
	[ 26, 27, 16, 17, 31, 33, 11, 13, 35, 38,  5,  8,          0,  4                                                 ],
	[ 27, 28, 17, 18, 32, 34, 12, 14, 36, 39,  6,  9,          1                                                     ],
	[ 28, 29, 18, 19, 33,     13,     37,      7,              2                                                     ],
	[ 30, 31, 20, 21,     36,     16,             12,              7,              3                                 ],
	[ 31, 32, 21, 22, 35, 37, 15, 17,         10, 13,              8,              4                                 ],
	[ 32, 33, 22, 23, 36, 38, 16, 18,         11, 14,          5,  9,          0                                     ],
	[ 33, 34, 23, 24, 37, 39, 17, 19,         12,              6,              1                                     ],
	[ 34,     24,     38,     18,             13,              7,              2                                     ],
	[     35,     25,             21,             16,             12,              7,              3                 ],
	[ 35, 36, 25, 26,         20, 22,             17,             13,              8,              4                 ],
	[ 36, 37, 26, 27,         21, 23,         15, 18,         10, 14,              9                                 ],
	[ 37, 38, 27, 28,         22, 24,         16, 19,         11,              5,              0                     ],
	[ 38, 39, 28, 29,         23,             17,             12,              6,              1                     ],
	[         30, 31,             26,             22,             17,             13,              8,              4 ],
	[         31, 32,         25, 27,         20, 23,             18,             14,              9                 ],
	[         32, 33,         26, 28,         21, 24,         15, 19,         10                                     ],
	[         33, 34,         27, 29,         22,             16,             11,              5,              0     ],
	[         34,             28,             23,             17,             12,              6,              1     ],
];

use constant king_beat => [
	[     11,             16,             22,             27,             33,             38         ],
	[ 10, 12,             17,             23,             28,             34,             39         ],
	[ 11, 13,         15, 18,         20, 24,             29                                         ],
	[ 12, 14,         16, 19,         21,             25,             30                             ],
	[ 13,             17,             22,             26,             31,             35             ],
	[     16,             22,             27,             33,             38                         ],
	[ 15, 17,         20, 23,             28,             34,             39                         ],
	[ 16, 18,         21, 24,         25, 29,         30                                             ],
	[ 17, 19,         22,             26,             31,             35                             ],
	[ 18,             23,             27,             32,             36                             ],
	[     21,      1,     26,             32,             37                                         ],
	[ 20, 22,  0,  2,     27,             33,             38                                         ],
	[ 21, 23,  1,  3, 25, 28,         30, 34,             39                                         ],
	[ 22, 24,  2,  4, 26, 29,         31,             35                                             ],
	[ 23,      3,     27,             32,             36                                             ],
	[     26,      6,     32,      2,     37                                                         ],
	[ 25, 27,  5,  7, 30, 33,  0,  3,     38                                                         ],
	[ 26, 28,  6,  8, 31, 34,  1,  4, 35, 39                                                         ],
	[ 27, 29,  7,  9, 32,      2,     36                                                             ],
	[ 28,      8,     33,      3,     37                                                             ],
	[     31,     11,     36,      6,              2                                                 ],
	[ 30, 32, 10, 12,     37,      7,              3                                                 ],
	[ 31, 33, 11, 13, 35, 38,  5,  8,          0,  4                                                 ],
	[ 32, 34, 12, 14, 36, 39,  6,  9,          1                                                     ],
	[ 33,     13,     37,      7,              2                                                     ],
	[     36,     16,             12,              7,              3                                 ],
	[ 35, 37, 15, 17,         10, 13,              8,              4                                 ],
	[ 36, 38, 16, 18,         11, 14,          5,  9,          0                                     ],
	[ 37, 39, 17, 19,         12,              6,              1                                     ],
	[ 38,     18,             13,              7,              2                                     ],
	[             21,             16,             12,              7,              3                 ],
	[         20, 22,             17,             13,              8,              4                 ],
	[         21, 23,         15, 18,         10, 14,              9                                 ],
	[         22, 24,         16, 19,         11,              5,              0                     ],
	[         23,             17,             12,              6,              1                     ],
	[             26,             22,             17,             13,              8,              4 ],
	[         25, 27,         20, 23,             18,             14,              9                 ],
	[         26, 28,         21, 24,         15, 19,         10                                     ],
	[         27, 29,         22,             16,             11,              5,              0     ],
	[         28,             23,             17,             12,              6,              1     ],
];

use constant king_step_short => [
	[      5         ], [  5,  6         ], [  6,  7         ], [  7,  8         ], [  8,  9         ],
	[ 10, 11,  0,  1 ], [ 11, 12,  1,  2 ], [ 12, 13,  2,  3 ], [ 13, 14,  3,  4 ], [ 14,      4     ],
	[     15,      5 ], [ 15, 16,  5,  6 ], [ 16, 17,  6,  7 ], [ 17, 18,  7,  8 ], [ 18, 19,  8,  9 ],
	[ 20, 21, 10, 11 ], [ 21, 22, 11, 12 ], [ 22, 23, 12, 13 ], [ 23, 24, 13, 14 ], [ 24,     14     ],
	[     25,     15 ], [ 25, 26, 15, 16 ], [ 26, 27, 16, 17 ], [ 27, 28, 17, 18 ], [ 28, 29, 18, 19 ],
	[ 30, 31, 20, 21 ], [ 31, 32, 21, 22 ], [ 32, 33, 22, 23 ], [ 33, 34, 23, 24 ], [ 34,     24     ],
	[     35,     25 ], [ 35, 36, 25, 26 ], [ 36, 37, 26, 27 ], [ 37, 38, 27, 28 ], [ 38, 39, 28, 29 ],
	[         30, 31 ], [         31, 32 ], [         32, 33 ], [         33, 34 ], [         34     ],
];

use constant king_beat_short => [
	[     11         ], [ 10, 12         ], [ 11, 13         ], [ 12, 14         ], [ 13             ],
	[     16         ], [ 15, 17         ], [ 16, 18         ], [ 17, 19         ], [ 18             ],
	[     21,      1 ], [ 20, 22,  0,  2 ], [ 21, 23,  1,  3 ], [ 22, 24,  2,  4 ], [ 23,      3     ],
	[     26,      6 ], [ 25, 27,  5,  7 ], [ 26, 28,  6,  8 ], [ 27, 29,  7,  9 ], [ 28,      8     ],
	[     31,     11 ], [ 30, 32, 10, 12 ], [ 31, 33, 11, 13 ], [ 32, 34, 12, 14 ], [ 33,     13     ],
	[     36,     16 ], [ 35, 37, 15, 17 ], [ 36, 38, 16, 18 ], [ 37, 39, 17, 19 ], [ 38,     18     ],
	[             21 ], [         20, 22 ], [         21, 23 ], [         22, 24 ], [         23     ],
	[             26 ], [         25, 27 ], [         26, 28 ], [         27, 29 ], [         28     ],
];

use constant king_beat_8dirs => [
	[     11,                 20,  2,     16,                 30,  3,     22,                      4,     27,                             33,                             38                         ],
	[ 10, 12,                 21,  3,     17,                 31,  4,     23,                             28,                             34,                             39                         ],
	[ 11, 13,              0, 22,  4, 15, 18,                 32,     20, 24,                             29                                                                                         ],
	[ 12, 14,              1, 23,     16, 19,              0, 33,     21,                             25,                             30                                                             ],
	[ 13,                  2, 24,     17,                  1, 34,     22,                  0,         26,                             31,                             35                             ],
	[     16,                 25,  7,     22,                 35,  8,     27,                      9,     33,                             38                                                         ],
	[ 15, 17,                 26,  8, 20, 23,                 36,  9,     28,                             34,                             39                                                         ],
	[ 16, 18,              5, 27,  9, 21, 24,                 37,     25, 29,                         30                                                                                             ],
	[ 17, 19,              6, 28,     22,                  5, 38,     26,                             31,                             35                                                             ],
	[ 18,                  7, 29,     23,                  6, 39,     27,                  5,         32,                             36                                                             ],
	[     21,      1,         30, 12,     26,                     13,     32,                     14,     37                                                                                         ],
	[ 20, 22,  0,  2,         31, 13,     27,                     14,     33,                             38                                                                                         ],
	[ 21, 23,  1,  3,     10, 32, 14, 25, 28,                         30, 34,                             39                                                                                         ],
	[ 22, 24,  2,  4,     11, 33,     26, 29,             10,         31,                             35                                                                                             ],
	[ 23,      3,         12, 34,     27,                 11,         32,                 10,         36                                                                                             ],
	[     26,      6,         35, 17,     32,      2,             18,     37,                     19                                                                                                 ],
	[ 25, 27,  5,  7,         36, 18, 30, 33,  0,  3,             19,     38                                                                                                                         ],
	[ 26, 28,  6,  8,     15, 37, 19, 31, 34,  1,  4,                 35, 39                                                                                                                         ],
	[ 27, 29,  7,  9,     16, 38,     32,      2,         15,         36                                                                                                                             ],
	[ 28,      8,         17, 39,     33,      3,         16,         37,                 15                                                                                                         ],
	[     31,     11,  0,         22,     36,      6,             23,              2,             24                                                                                                 ],
	[ 30, 32, 10, 12,  1,         23,     37,      7,             24,              3                                                                                                                 ],
	[ 31, 33, 11, 13,  2, 20,     24, 35, 38,  5,  8,                          0,  4                                                                                                                 ],
	[ 32, 34, 12, 14,  3, 21,         36, 39,  6,  9,     20,                  1                                                                                                                     ],
	[ 33,     13,      4, 22,         37,      7,         21,                  2,         20                                                                                                         ],
	[     36,     16,  5,         27,             12,             28,              7,             29,              3                                                                                 ],
	[ 35, 37, 15, 17,  6,         28,         10, 13,             29,              8,                              4                                                                                 ],
	[ 36, 38, 16, 18,  7, 25,     29,         11, 14,                          5,  9,                          0                                                                                     ],
	[ 37, 39, 17, 19,  8, 26,                 12,         25,                  6,                              1                                                                                     ],
	[ 38,     18,      9, 27,                 13,         26,                  7,         25,                  2                                                                                     ],
	[             21, 10,         32,             16,  0,         33,             12,             34,              7,                              3                                                 ],
	[         20, 22, 11,         33,             17,  1,         34,             13,                              8,                              4                                                 ],
	[         21, 23, 12, 30,     34,         15, 18,  2,                     10, 14,                              9                                                                                 ],
	[         22, 24, 13, 31,                 16, 19,  3, 30,                 11,                              5,                              0                                                     ],
	[         23,     14, 32,                 17,      4, 31,                 12,         30,                  6,                              1                                                     ],
	[             26, 15,         37,             22,  5,         38,             17,             39,             13,                              8,                              4                 ],
	[         25, 27, 16,         38,         20, 23,  6,         39,             18,                             14,                              9                                                 ],
	[         26, 28, 17, 35,     39,         21, 24,  7,                     15, 19,                         10                                                                                     ],
	[         27, 29, 18, 36,                 22,      8, 35,                 16,                             11,                              5,                              0                     ],
	[         28,     19, 37,                 23,      9, 36,                 17,         35,                 12,                              6,                              1                     ],
];

use constant enclosed_locs => [
	{ 11 => [  5 ], 16 => [  5, 11 ], 22 => [  5, 11, 16 ], 27 => [  5, 11, 16, 22 ], 33 => [  5, 11, 16, 22, 27 ], 38 => [  5, 11, 16, 22, 27, 33 ] },
	{ 10 => [  5 ], 12 => [  6 ], 17 => [  6, 12 ], 23 => [  6, 12, 17 ], 28 => [  6, 12, 17, 23 ], 34 => [  6, 12, 17, 23, 28 ], 39 => [  6, 12, 17, 23, 28, 34 ] },
	{ 11 => [  6 ], 13 => [  7 ], 15 => [  6, 11 ], 18 => [  7, 13 ], 20 => [  6, 11, 15 ], 24 => [  7, 13, 18 ], 29 => [  7, 13, 18, 24 ] },
	{ 12 => [  7 ], 14 => [  8 ], 16 => [  7, 12 ], 19 => [  8, 14 ], 21 => [  7, 12, 16 ], 25 => [  7, 12, 16, 21 ], 30 => [  7, 12, 16, 21, 25 ] },
	{ 13 => [  8 ], 17 => [  8, 13 ], 22 => [  8, 13, 17 ], 26 => [  8, 13, 17, 22 ], 31 => [  8, 13, 17, 22, 26 ], 35 => [  8, 13, 17, 22, 26, 31 ] },
	{ 16 => [ 11 ], 22 => [ 11, 16 ], 27 => [ 11, 16, 22 ], 33 => [ 11, 16, 22, 27 ], 38 => [ 11, 16, 22, 27, 33 ] },
	{ 15 => [ 11 ], 17 => [ 12 ], 20 => [ 11, 15 ], 23 => [ 12, 17 ], 28 => [ 12, 17, 23 ], 34 => [ 12, 17, 23, 28 ], 39 => [ 12, 17, 23, 28, 34 ] },
	{ 16 => [ 12 ], 18 => [ 13 ], 21 => [ 12, 16 ], 24 => [ 13, 18 ], 25 => [ 12, 16, 21 ], 29 => [ 13, 18, 24 ], 30 => [ 12, 16, 21, 25 ] },
	{ 17 => [ 13 ], 19 => [ 14 ], 22 => [ 13, 17 ], 26 => [ 13, 17, 22 ], 31 => [ 13, 17, 22, 26 ], 35 => [ 13, 17, 22, 26, 31 ] },
	{ 18 => [ 14 ], 23 => [ 14, 18 ], 27 => [ 14, 18, 23 ], 32 => [ 14, 18, 23, 27 ], 36 => [ 14, 18, 23, 27, 32 ] },
	{  1 => [  5 ], 21 => [ 15 ], 26 => [ 15, 21 ], 32 => [ 15, 21, 26 ], 37 => [ 15, 21, 26, 32 ] },
	{  0 => [  5 ],  2 => [  6 ], 20 => [ 15 ], 22 => [ 16 ], 27 => [ 16, 22 ], 33 => [ 16, 22, 27 ], 38 => [ 16, 22, 27, 33 ] },
	{  1 => [  6 ],  3 => [  7 ], 21 => [ 16 ], 23 => [ 17 ], 25 => [ 16, 21 ], 28 => [ 17, 23 ], 30 => [ 16, 21, 25 ], 34 => [ 17, 23, 28 ], 39 => [ 17, 23, 28, 34 ] },
	{  2 => [  7 ],  4 => [  8 ], 22 => [ 17 ], 24 => [ 18 ], 26 => [ 17, 22 ], 29 => [ 18, 24 ], 31 => [ 17, 22, 26 ], 35 => [ 17, 22, 26, 31 ] },
	{  3 => [  8 ], 23 => [ 18 ], 27 => [ 18, 23 ], 32 => [ 18, 23, 27 ], 36 => [ 18, 23, 27, 32 ] },
	{  2 => [ 11,  6 ],  6 => [ 11 ], 26 => [ 21 ], 32 => [ 21, 26 ], 37 => [ 21, 26, 32 ] },
	{  0 => [ 11,  5 ],  3 => [ 12,  7 ],  5 => [ 11 ],  7 => [ 12 ], 25 => [ 21 ], 27 => [ 22 ], 30 => [ 21, 25 ], 33 => [ 22, 27 ], 38 => [ 22, 27, 33 ] },
	{  1 => [ 12,  6 ],  4 => [ 13,  8 ],  6 => [ 12 ],  8 => [ 13 ], 26 => [ 22 ], 28 => [ 23 ], 31 => [ 22, 26 ], 34 => [ 23, 28 ], 35 => [ 22, 26, 31 ], 39 => [ 23, 28, 34 ] },
	{  2 => [ 13,  7 ],  7 => [ 13 ],  9 => [ 14 ], 27 => [ 23 ], 29 => [ 24 ], 32 => [ 23, 27 ], 36 => [ 23, 27, 32 ] },
	{  3 => [ 14,  8 ],  8 => [ 14 ], 28 => [ 24 ], 33 => [ 24, 28 ], 37 => [ 24, 28, 33 ] },
	{  2 => [ 15, 11,  6 ],  6 => [ 15, 11 ], 11 => [ 15 ], 31 => [ 25 ], 36 => [ 25, 31 ] },
	{  3 => [ 16, 12,  7 ],  7 => [ 16, 12 ], 10 => [ 15 ], 12 => [ 16 ], 30 => [ 25 ], 32 => [ 26 ], 37 => [ 26, 32 ] },
	{  0 => [ 16, 11,  5 ],  4 => [ 17, 13,  8 ],  5 => [ 16, 11 ],  8 => [ 17, 13 ], 11 => [ 16 ], 13 => [ 17 ], 31 => [ 26 ], 33 => [ 27 ], 35 => [ 26, 31 ], 38 => [ 27, 33 ] },
	{  1 => [ 17, 12,  6 ],  6 => [ 17, 12 ],  9 => [ 18, 14 ], 12 => [ 17 ], 14 => [ 18 ], 32 => [ 27 ], 34 => [ 28 ], 36 => [ 27, 32 ], 39 => [ 28, 34 ] },
	{  2 => [ 18, 13,  7 ],  7 => [ 18, 13 ], 13 => [ 18 ], 33 => [ 28 ], 37 => [ 28, 33 ] },
	{  3 => [ 21, 16, 12,  7 ],  7 => [ 21, 16, 12 ], 12 => [ 21, 16 ], 16 => [ 21 ], 36 => [ 31 ] },
	{  4 => [ 22, 17, 13,  8 ],  8 => [ 22, 17, 13 ], 10 => [ 21, 15 ], 13 => [ 22, 17 ], 15 => [ 21 ], 17 => [ 22 ], 35 => [ 31 ], 37 => [ 32 ] },
	{  0 => [ 22, 16, 11,  5 ],  5 => [ 22, 16, 11 ],  9 => [ 23, 18, 14 ], 11 => [ 22, 16 ], 14 => [ 23, 18 ], 16 => [ 22 ], 18 => [ 23 ], 36 => [ 32 ], 38 => [ 33 ] },
	{  1 => [ 23, 17, 12,  6 ],  6 => [ 23, 17, 12 ], 12 => [ 23, 17 ], 17 => [ 23 ], 19 => [ 24 ], 37 => [ 33 ], 39 => [ 34 ] },
	{  2 => [ 24, 18, 13,  7 ],  7 => [ 24, 18, 13 ], 13 => [ 24, 18 ], 18 => [ 24 ], 38 => [ 34 ] },
	{  3 => [ 25, 21, 16, 12,  7 ],  7 => [ 25, 21, 16, 12 ], 12 => [ 25, 21, 16 ], 16 => [ 25, 21 ], 21 => [ 25 ] },
	{  4 => [ 26, 22, 17, 13,  8 ],  8 => [ 26, 22, 17, 13 ], 13 => [ 26, 22, 17 ], 17 => [ 26, 22 ], 20 => [ 25 ], 22 => [ 26 ] },
	{  9 => [ 27, 23, 18, 14 ], 10 => [ 26, 21, 15 ], 14 => [ 27, 23, 18 ], 15 => [ 26, 21 ], 18 => [ 27, 23 ], 21 => [ 26 ], 23 => [ 27 ] },
	{  0 => [ 27, 22, 16, 11,  5 ],  5 => [ 27, 22, 16, 11 ], 11 => [ 27, 22, 16 ], 16 => [ 27, 22 ], 19 => [ 28, 24 ], 22 => [ 27 ], 24 => [ 28 ] },
	{  1 => [ 28, 23, 17, 12,  6 ],  6 => [ 28, 23, 17, 12 ], 12 => [ 28, 23, 17 ], 17 => [ 28, 23 ], 23 => [ 28 ] },
	{  4 => [ 31, 26, 22, 17, 13,  8 ],  8 => [ 31, 26, 22, 17, 13 ], 13 => [ 31, 26, 22, 17 ], 17 => [ 31, 26, 22 ], 22 => [ 31, 26 ], 26 => [ 31 ] },
	{  9 => [ 32, 27, 23, 18, 14 ], 14 => [ 32, 27, 23, 18 ], 18 => [ 32, 27, 23 ], 20 => [ 31, 25 ], 23 => [ 32, 27 ], 25 => [ 31 ], 27 => [ 32 ] },
	{ 10 => [ 32, 26, 21, 15 ], 15 => [ 32, 26, 21 ], 19 => [ 33, 28, 24 ], 21 => [ 32, 26 ], 24 => [ 33, 28 ], 26 => [ 32 ], 28 => [ 33 ] },
	{  0 => [ 33, 27, 22, 16, 11,  5 ],  5 => [ 33, 27, 22, 16, 11 ], 11 => [ 33, 27, 22, 16 ], 16 => [ 33, 27, 22 ], 22 => [ 33, 27 ], 27 => [ 33 ], 29 => [ 34 ] },
	{  1 => [ 34, 28, 23, 17, 12,  6 ],  6 => [ 34, 28, 23, 17, 12 ], 12 => [ 34, 28, 23, 17 ], 17 => [ 34, 28, 23 ], 23 => [ 34, 28 ], 28 => [ 34 ] },
];

use constant enclosed_8dirs_locs => [
	{  2 => [  1 ],  3 => [  1,  2 ],  4 => [  1,  2,  3 ], 11 => [  5 ], 16 => [  5, 11 ], 20 => [ 10 ], 22 => [  5, 11, 16 ], 27 => [  5, 11, 16, 22 ], 30 => [ 10, 20 ], 33 => [  5, 11, 16, 22, 27 ], 38 => [  5, 11, 16, 22, 27, 33 ] },
	{  3 => [  2 ],  4 => [  2,  3 ], 10 => [  5 ], 12 => [  6 ], 17 => [  6, 12 ], 21 => [ 11 ], 23 => [  6, 12, 17 ], 28 => [  6, 12, 17, 23 ], 31 => [ 11, 21 ], 34 => [  6, 12, 17, 23, 28 ], 39 => [  6, 12, 17, 23, 28, 34 ] },
	{  0 => [  1 ],  4 => [  3 ], 11 => [  6 ], 13 => [  7 ], 15 => [  6, 11 ], 18 => [  7, 13 ], 20 => [  6, 11, 15 ], 22 => [ 12 ], 24 => [  7, 13, 18 ], 29 => [  7, 13, 18, 24 ], 32 => [ 12, 22 ] },
	{  0 => [  2,  1 ],  1 => [  2 ], 12 => [  7 ], 14 => [  8 ], 16 => [  7, 12 ], 19 => [  8, 14 ], 21 => [  7, 12, 16 ], 23 => [ 13 ], 25 => [  7, 12, 16, 21 ], 30 => [  7, 12, 16, 21, 25 ], 33 => [ 13, 23 ] },
	{  0 => [  3,  2,  1 ],  1 => [  3,  2 ],  2 => [  3 ], 13 => [  8 ], 17 => [  8, 13 ], 22 => [  8, 13, 17 ], 24 => [ 14 ], 26 => [  8, 13, 17, 22 ], 31 => [  8, 13, 17, 22, 26 ], 34 => [ 14, 24 ], 35 => [  8, 13, 17, 22, 26, 31 ] },
	{  7 => [  6 ],  8 => [  6,  7 ],  9 => [  6,  7,  8 ], 16 => [ 11 ], 22 => [ 11, 16 ], 25 => [ 15 ], 27 => [ 11, 16, 22 ], 33 => [ 11, 16, 22, 27 ], 35 => [ 15, 25 ], 38 => [ 11, 16, 22, 27, 33 ] },
	{  8 => [  7 ],  9 => [  7,  8 ], 15 => [ 11 ], 17 => [ 12 ], 20 => [ 11, 15 ], 23 => [ 12, 17 ], 26 => [ 16 ], 28 => [ 12, 17, 23 ], 34 => [ 12, 17, 23, 28 ], 36 => [ 16, 26 ], 39 => [ 12, 17, 23, 28, 34 ] },
	{  5 => [  6 ],  9 => [  8 ], 16 => [ 12 ], 18 => [ 13 ], 21 => [ 12, 16 ], 24 => [ 13, 18 ], 25 => [ 12, 16, 21 ], 27 => [ 17 ], 29 => [ 13, 18, 24 ], 30 => [ 12, 16, 21, 25 ], 37 => [ 17, 27 ] },
	{  5 => [  7,  6 ],  6 => [  7 ], 17 => [ 13 ], 19 => [ 14 ], 22 => [ 13, 17 ], 26 => [ 13, 17, 22 ], 28 => [ 18 ], 31 => [ 13, 17, 22, 26 ], 35 => [ 13, 17, 22, 26, 31 ], 38 => [ 18, 28 ] },
	{  5 => [  8,  7,  6 ],  6 => [  8,  7 ],  7 => [  8 ], 18 => [ 14 ], 23 => [ 14, 18 ], 27 => [ 14, 18, 23 ], 29 => [ 19 ], 32 => [ 14, 18, 23, 27 ], 36 => [ 14, 18, 23, 27, 32 ], 39 => [ 19, 29 ] },
	{  1 => [  5 ], 12 => [ 11 ], 13 => [ 11, 12 ], 14 => [ 11, 12, 13 ], 21 => [ 15 ], 26 => [ 15, 21 ], 30 => [ 20 ], 32 => [ 15, 21, 26 ], 37 => [ 15, 21, 26, 32 ] },
	{  0 => [  5 ],  2 => [  6 ], 13 => [ 12 ], 14 => [ 12, 13 ], 20 => [ 15 ], 22 => [ 16 ], 27 => [ 16, 22 ], 31 => [ 21 ], 33 => [ 16, 22, 27 ], 38 => [ 16, 22, 27, 33 ] },
	{  1 => [  6 ],  3 => [  7 ], 10 => [ 11 ], 14 => [ 13 ], 21 => [ 16 ], 23 => [ 17 ], 25 => [ 16, 21 ], 28 => [ 17, 23 ], 30 => [ 16, 21, 25 ], 32 => [ 22 ], 34 => [ 17, 23, 28 ], 39 => [ 17, 23, 28, 34 ] },
	{  2 => [  7 ],  4 => [  8 ], 10 => [ 12, 11 ], 11 => [ 12 ], 22 => [ 17 ], 24 => [ 18 ], 26 => [ 17, 22 ], 29 => [ 18, 24 ], 31 => [ 17, 22, 26 ], 33 => [ 23 ], 35 => [ 17, 22, 26, 31 ] },
	{  3 => [  8 ], 10 => [ 13, 12, 11 ], 11 => [ 13, 12 ], 12 => [ 13 ], 23 => [ 18 ], 27 => [ 18, 23 ], 32 => [ 18, 23, 27 ], 34 => [ 24 ], 36 => [ 18, 23, 27, 32 ] },
	{  2 => [ 11,  6 ],  6 => [ 11 ], 17 => [ 16 ], 18 => [ 16, 17 ], 19 => [ 16, 17, 18 ], 26 => [ 21 ], 32 => [ 21, 26 ], 35 => [ 25 ], 37 => [ 21, 26, 32 ] },
	{  0 => [ 11,  5 ],  3 => [ 12,  7 ],  5 => [ 11 ],  7 => [ 12 ], 18 => [ 17 ], 19 => [ 17, 18 ], 25 => [ 21 ], 27 => [ 22 ], 30 => [ 21, 25 ], 33 => [ 22, 27 ], 36 => [ 26 ], 38 => [ 22, 27, 33 ] },
	{  1 => [ 12,  6 ],  4 => [ 13,  8 ],  6 => [ 12 ],  8 => [ 13 ], 15 => [ 16 ], 19 => [ 18 ], 26 => [ 22 ], 28 => [ 23 ], 31 => [ 22, 26 ], 34 => [ 23, 28 ], 35 => [ 22, 26, 31 ], 37 => [ 27 ], 39 => [ 23, 28, 34 ] },
	{  2 => [ 13,  7 ],  7 => [ 13 ],  9 => [ 14 ], 15 => [ 17, 16 ], 16 => [ 17 ], 27 => [ 23 ], 29 => [ 24 ], 32 => [ 23, 27 ], 36 => [ 23, 27, 32 ], 38 => [ 28 ] },
	{  3 => [ 14,  8 ],  8 => [ 14 ], 15 => [ 18, 17, 16 ], 16 => [ 18, 17 ], 17 => [ 18 ], 28 => [ 24 ], 33 => [ 24, 28 ], 37 => [ 24, 28, 33 ], 39 => [ 29 ] },
	{  0 => [ 10 ],  2 => [ 15, 11,  6 ],  6 => [ 15, 11 ], 11 => [ 15 ], 22 => [ 21 ], 23 => [ 21, 22 ], 24 => [ 21, 22, 23 ], 31 => [ 25 ], 36 => [ 25, 31 ] },
	{  1 => [ 11 ],  3 => [ 16, 12,  7 ],  7 => [ 16, 12 ], 10 => [ 15 ], 12 => [ 16 ], 23 => [ 22 ], 24 => [ 22, 23 ], 30 => [ 25 ], 32 => [ 26 ], 37 => [ 26, 32 ] },
	{  0 => [ 16, 11,  5 ],  2 => [ 12 ],  4 => [ 17, 13,  8 ],  5 => [ 16, 11 ],  8 => [ 17, 13 ], 11 => [ 16 ], 13 => [ 17 ], 20 => [ 21 ], 24 => [ 23 ], 31 => [ 26 ], 33 => [ 27 ], 35 => [ 26, 31 ], 38 => [ 27, 33 ] },
	{  1 => [ 17, 12,  6 ],  3 => [ 13 ],  6 => [ 17, 12 ],  9 => [ 18, 14 ], 12 => [ 17 ], 14 => [ 18 ], 20 => [ 22, 21 ], 21 => [ 22 ], 32 => [ 27 ], 34 => [ 28 ], 36 => [ 27, 32 ], 39 => [ 28, 34 ] },
	{  2 => [ 18, 13,  7 ],  4 => [ 14 ],  7 => [ 18, 13 ], 13 => [ 18 ], 20 => [ 23, 22, 21 ], 21 => [ 23, 22 ], 22 => [ 23 ], 33 => [ 28 ], 37 => [ 28, 33 ] },
	{  3 => [ 21, 16, 12,  7 ],  5 => [ 15 ],  7 => [ 21, 16, 12 ], 12 => [ 21, 16 ], 16 => [ 21 ], 27 => [ 26 ], 28 => [ 26, 27 ], 29 => [ 26, 27, 28 ], 36 => [ 31 ] },
	{  4 => [ 22, 17, 13,  8 ],  6 => [ 16 ],  8 => [ 22, 17, 13 ], 10 => [ 21, 15 ], 13 => [ 22, 17 ], 15 => [ 21 ], 17 => [ 22 ], 28 => [ 27 ], 29 => [ 27, 28 ], 35 => [ 31 ], 37 => [ 32 ] },
	{  0 => [ 22, 16, 11,  5 ],  5 => [ 22, 16, 11 ],  7 => [ 17 ],  9 => [ 23, 18, 14 ], 11 => [ 22, 16 ], 14 => [ 23, 18 ], 16 => [ 22 ], 18 => [ 23 ], 25 => [ 26 ], 29 => [ 28 ], 36 => [ 32 ], 38 => [ 33 ] },
	{  1 => [ 23, 17, 12,  6 ],  6 => [ 23, 17, 12 ],  8 => [ 18 ], 12 => [ 23, 17 ], 17 => [ 23 ], 19 => [ 24 ], 25 => [ 27, 26 ], 26 => [ 27 ], 37 => [ 33 ], 39 => [ 34 ] },
	{  2 => [ 24, 18, 13,  7 ],  7 => [ 24, 18, 13 ],  9 => [ 19 ], 13 => [ 24, 18 ], 18 => [ 24 ], 25 => [ 28, 27, 26 ], 26 => [ 28, 27 ], 27 => [ 28 ], 38 => [ 34 ] },
	{  0 => [ 20, 10 ],  3 => [ 25, 21, 16, 12,  7 ],  7 => [ 25, 21, 16, 12 ], 10 => [ 20 ], 12 => [ 25, 21, 16 ], 16 => [ 25, 21 ], 21 => [ 25 ], 32 => [ 31 ], 33 => [ 31, 32 ], 34 => [ 31, 32, 33 ] },
	{  1 => [ 21, 11 ],  4 => [ 26, 22, 17, 13,  8 ],  8 => [ 26, 22, 17, 13 ], 11 => [ 21 ], 13 => [ 26, 22, 17 ], 17 => [ 26, 22 ], 20 => [ 25 ], 22 => [ 26 ], 33 => [ 32 ], 34 => [ 32, 33 ] },
	{  2 => [ 22, 12 ],  9 => [ 27, 23, 18, 14 ], 10 => [ 26, 21, 15 ], 12 => [ 22 ], 14 => [ 27, 23, 18 ], 15 => [ 26, 21 ], 18 => [ 27, 23 ], 21 => [ 26 ], 23 => [ 27 ], 30 => [ 31 ], 34 => [ 33 ] },
	{  0 => [ 27, 22, 16, 11,  5 ],  3 => [ 23, 13 ],  5 => [ 27, 22, 16, 11 ], 11 => [ 27, 22, 16 ], 13 => [ 23 ], 16 => [ 27, 22 ], 19 => [ 28, 24 ], 22 => [ 27 ], 24 => [ 28 ], 30 => [ 32, 31 ], 31 => [ 32 ] },
	{  1 => [ 28, 23, 17, 12,  6 ],  4 => [ 24, 14 ],  6 => [ 28, 23, 17, 12 ], 12 => [ 28, 23, 17 ], 14 => [ 24 ], 17 => [ 28, 23 ], 23 => [ 28 ], 30 => [ 33, 32, 31 ], 31 => [ 33, 32 ], 32 => [ 33 ] },
	{  4 => [ 31, 26, 22, 17, 13,  8 ],  5 => [ 25, 15 ],  8 => [ 31, 26, 22, 17, 13 ], 13 => [ 31, 26, 22, 17 ], 15 => [ 25 ], 17 => [ 31, 26, 22 ], 22 => [ 31, 26 ], 26 => [ 31 ], 37 => [ 36 ], 38 => [ 36, 37 ], 39 => [ 36, 37, 38 ] },
	{  6 => [ 26, 16 ],  9 => [ 32, 27, 23, 18, 14 ], 14 => [ 32, 27, 23, 18 ], 16 => [ 26 ], 18 => [ 32, 27, 23 ], 20 => [ 31, 25 ], 23 => [ 32, 27 ], 25 => [ 31 ], 27 => [ 32 ], 38 => [ 37 ], 39 => [ 37, 38 ] },
	{  7 => [ 27, 17 ], 10 => [ 32, 26, 21, 15 ], 15 => [ 32, 26, 21 ], 17 => [ 27 ], 19 => [ 33, 28, 24 ], 21 => [ 32, 26 ], 24 => [ 33, 28 ], 26 => [ 32 ], 28 => [ 33 ], 35 => [ 36 ], 39 => [ 38 ] },
	{  0 => [ 33, 27, 22, 16, 11,  5 ],  5 => [ 33, 27, 22, 16, 11 ],  8 => [ 28, 18 ], 11 => [ 33, 27, 22, 16 ], 16 => [ 33, 27, 22 ], 18 => [ 28 ], 22 => [ 33, 27 ], 27 => [ 33 ], 29 => [ 34 ], 35 => [ 37, 36 ], 36 => [ 37 ] },
	{  1 => [ 34, 28, 23, 17, 12,  6 ],  6 => [ 34, 28, 23, 17, 12 ],  9 => [ 29, 19 ], 12 => [ 34, 28, 23, 17 ], 17 => [ 34, 28, 23 ], 19 => [ 29 ], 23 => [ 34, 28 ], 28 => [ 34 ], 35 => [ 38, 37, 36 ], 36 => [ 38, 37 ], 37 => [ 38 ] },
];

1;
