use Test::More tests => 1714;
use Basset::DB::Table;
package Basset::DB::Table;
{		Test::More::ok(1, "uses strict");
		Test::More::ok(1, "uses warnings");
};
{
#line 79  name
$| = 1;
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
Test::More::ok($o->name('test name'), "Set name");
Test::More::is($o->name, 'test name', "retrieved name");
Test::More::is($o->name('test name 2'), 'test name 2', 're-set name');
Test::More::is($o->name, 'test name 2', 'retrieved reset name');

Test::More::is(scalar(Basset::DB::Table->name('invalid name')), undef, 'Could not set name for class attribute');
};
{
#line 119  primary_column

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
Test::More::ok($o->primary_column('id'), "Set primary column");
Test::More::is($o->primary_column, 'id', "retrieved primary column");
Test::More::is($o->primary_column('id2'), 'id2', 're-set primary column');
Test::More::is($o->primary_column, 'id2', 'retrieved reset primary column');

my $a = [qw(id id2)];
Test::More::ok($a, "created arrayref");
Test::More::is($a->[0], 'id', 'proper array element 0');
Test::More::is($a->[1], 'id2', 'proper array element 1');
Test::More::is($o->primary_column($a), $a, 'set primary column to arrayref');

Test::More::is(scalar(Basset::DB::Table->primary_column('invalid name')), undef, 'Could not set primary column for class attribute');
};
{
#line 165  autogenerated

my $o = Basset::DB::Table->new();

Test::More::ok($o, "created object");
Test::More::is($o->autogenerated(1), 1, "set autogenerated");
Test::More::is($o->autogenerated(), 1, "accessed autogenerated");
Test::More::is($o->autogenerated(0), 0, "shut off autogenerated");
Test::More::is($o->autogenerated, 0, "accessed autogenerated");

Test::More::is(scalar(Basset::DB::Table->autogenerated(1)), undef, "Could not set autogenerated for class");
};
{
#line 242  definition

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->definition($h), $h, "Set definition");
Test::More::is($o->definition(), $h, 'reset definition');
Test::More::is(scalar(Basset::DB::Table->definition(1)), undef, 'Could not set definition for class');
};
{
#line 285  references

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->references($h), $h, "Set references");
Test::More::is($o->references(), $h, 'reset references');
Test::More::is(scalar(Basset::DB::Table->references(1)), undef, 'Could not set references for class');
};
{
#line 356  extra_select

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->extra_select($h), $h, "Set extra_select");
Test::More::is($o->extra_select(), $h, 'reset extra_select');
Test::More::is(scalar(Basset::DB::Table->extra_select(1)), undef, 'Could not set extra_select for class');
};
{
#line 404  db_read_translation

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->db_read_translation($h), $h, "Set db_read_translation");
Test::More::is($o->db_read_translation(), $h, 'reset db_read_translation');
Test::More::is(scalar(Basset::DB::Table->db_read_translation(1)), undef, 'Could not set db_read_translation for class');
};
{
#line 535  db_write_translation

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $h = {'foo' => 'bar', 'baz' => 'yee'};
Test::More::ok($h, 'got hashref');
Test::More::is($h->{'foo'}, 'bar', 'foo is bar');
Test::More::is($h->{'baz'}, 'yee', 'baz is yee');
Test::More::is($o->db_write_translation($h), $h, "Set db_write_translation");
Test::More::is($o->db_write_translation(), $h, 'reset db_write_translation');
Test::More::is(scalar(Basset::DB::Table->db_write_translation(1)), undef, 'Could not set db_write_translation for class');
};
{
#line 580  column_aliases

my $aliases = {
	'able' => 'aliased_able',
	'baker' => 'aliased_baker',
	'charlie' => 'aliased_charlie',
	'delta' => 'aliased_delta'
};

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

Test::More::is($o->column_aliases($aliases), $aliases, "Set column aliases");
Test::More::is($o->column_aliases(), $aliases, "Got column aliases");
};
{
#line 607  _cached_queries

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is(scalar(Basset::DB::Table->_cached_queries), undef, "could not call object method as class method");
Test::More::is(Basset::DB::Table->errcode, "BO-08", "proper error code");
Test::More::is(ref($o->_cached_queries), 'HASH', '_cached_queries is hashref');
Test::More::is($o->_cached_queries('abc'), 'abc', 'set _cached_queries to abc');
Test::More::is($o->_cached_queries(), 'abc', 'read value of _cached_queries - abc');
my $h = {};
Test::More::ok($h, 'got hashref');
Test::More::is($o->_cached_queries($h), $h, 'set _cached_queries to hashref');
Test::More::is($o->_cached_queries(), $h, 'read value of _cached_queries  - hashref');
my $a = [];
Test::More::ok($a, 'got arrayref');
Test::More::is($o->_cached_queries($a), $a, 'set _cached_queries to arrayref');
Test::More::is($o->_cached_queries(), $a, 'read value of _cached_queries  - arrayref');
};
{
#line 635  _cached_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is(scalar(Basset::DB::Table->_cached_bindables), undef, "could not call object method as class method");
Test::More::is(Basset::DB::Table->errcode, "BO-08", "proper error code");
Test::More::is(ref($o->_cached_bindables), 'HASH', '_cached_bindables is hashref');
Test::More::is($o->_cached_bindables('abc'), 'abc', 'set _cached_bindables to abc');
Test::More::is($o->_cached_bindables(), 'abc', 'read value of _cached_bindables - abc');
my $h = {};
Test::More::ok($h, 'got hashref');
Test::More::is($o->_cached_bindables($h), $h, 'set _cached_bindables to hashref');
Test::More::is($o->_cached_bindables(), $h, 'read value of _cached_bindables  - hashref');
my $a = [];
Test::More::ok($a, 'got arrayref');
Test::More::is($o->_cached_bindables($a), $a, 'set _cached_bindables to arrayref');
Test::More::is($o->_cached_bindables(), $a, 'read value of _cached_bindables  - arrayref');
};
{
#line 710  last_insert_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "got object");

Test::More::ok(! scalar(Basset::DB::Table->last_insert_query), "Cannot call object method as class method");

Test::More::is($o->last_insert_query('foo'), 'foo', "set query to foo");
Test::More::is($o->last_insert_query(), 'foo', 'got insert query');
};
{
#line 726  insert_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, 1, 'baker is an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, 1, 'delta is an insert col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 insert columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->insert_columns($icols)), join(',',@$icols), "set new insert columns");
	Test::More::is(join(',',$o->insert_columns), join(',',@$icols), "got new insert columns");


	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an insert col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 insert columns');
}

{
	my $icols = [qw()];

	$o->insert_columns($icols);

	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, 1, 'baker is an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, 1, 'delta is an insert col');	
	Test::More::is(scalar(keys %icols), 4, '4 insert columns');
}

{
	$o->insert_columns(undef);
	my %icols = map {$_, 1} $o->insert_columns();

	Test::More::is($icols{'able'}, 1, 'able is an insert col');
	Test::More::is($icols{'baker'}, 1, 'baker is an insert col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an insert col');
	Test::More::is($icols{'delta'}, 1, 'delta is an insert col');	
	Test::More::is(scalar(keys %icols), 4, '4 insert columns');
}

Test::More::is(scalar($o->insert_columns(['junk'])), undef, 'could not insert unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 800  update_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, 1, 'baker is an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, 1, 'delta is an update col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 update columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->update_columns($icols)), join(',',@$icols), "set new update columns");
	Test::More::is(join(',',$o->update_columns), join(',',@$icols), "got new update columns");


	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an update col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 update columns');
}

{
	my $icols = [qw()];

	$o->update_columns($icols);

	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, 1, 'baker is an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, 1, 'delta is an update col');	
	Test::More::is(scalar(keys %icols), 4, '4 update columns');
}

{
	$o->update_columns(undef);
	my %icols = map {$_, 1} $o->update_columns();

	Test::More::is($icols{'able'}, 1, 'able is an update col');
	Test::More::is($icols{'baker'}, 1, 'baker is an update col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an update col');
	Test::More::is($icols{'delta'}, 1, 'delta is an update col');	
	Test::More::is(scalar(keys %icols), 4, '4 update columns');
}

Test::More::is(scalar($o->update_columns(['junk'])), undef, 'could not update unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 874  delete_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, 1, 'baker is an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, 1, 'delta is an delete col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 delete columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->delete_columns($icols)), join(',',@$icols), "set new delete columns");
	Test::More::is(join(',',$o->delete_columns), join(',',@$icols), "got new delete columns");


	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an delete col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 delete columns');
}

{
	my $icols = [qw()];

	$o->delete_columns($icols);

	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, 1, 'baker is an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, 1, 'delta is an delete col');	
	Test::More::is(scalar(keys %icols), 4, '4 delete columns');
}

{
	$o->delete_columns(undef);
	my %icols = map {$_, 1} $o->delete_columns();

	Test::More::is($icols{'able'}, 1, 'able is an delete col');
	Test::More::is($icols{'baker'}, 1, 'baker is an delete col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an delete col');
	Test::More::is($icols{'delta'}, 1, 'delta is an delete col');	
	Test::More::is(scalar(keys %icols), 4, '4 delete columns');
}

Test::More::is(scalar($o->delete_columns(['junk'])), undef, 'could not delete unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 948  replace_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, 1, 'baker is an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, 1, 'delta is an replace col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 replace columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->replace_columns($icols)), join(',',@$icols), "set new replace columns");
	Test::More::is(join(',',$o->replace_columns), join(',',@$icols), "got new replace columns");


	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an replace col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 replace columns');
}

{
	my $icols = [qw()];

	$o->replace_columns($icols);

	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, 1, 'baker is an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, 1, 'delta is an replace col');	
	Test::More::is(scalar(keys %icols), 4, '4 replace columns');
}

{
	$o->replace_columns(undef);
	my %icols = map {$_, 1} $o->replace_columns();

	Test::More::is($icols{'able'}, 1, 'able is an replace col');
	Test::More::is($icols{'baker'}, 1, 'baker is an replace col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an replace col');
	Test::More::is($icols{'delta'}, 1, 'delta is an replace col');	
	Test::More::is(scalar(keys %icols), 4, '4 replace columns');
}

Test::More::is(scalar($o->replace_columns(['junk'])), undef, 'could not replace unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 1022  select_columns

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

{
	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, 1, 'baker is an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, 1, 'delta is an select col');	
	Test::More::is(scalar(keys %icols), 4, 'only 4 select columns');
}

{
	my $icols = [qw(able charlie)];

	Test::More::is(join(',',$o->select_columns($icols)), join(',',@$icols), "set new select columns");
	Test::More::is(join(',',$o->select_columns), join(',',@$icols), "got new select columns");


	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an select col');	
	Test::More::is(scalar(keys %icols), 2, 'only 2 select columns');
}

{
	my $icols = [qw(able charlie)];
	my $nicols = [qw(able)];

	Test::More::is(join(',',$o->select_columns($icols)), join(',',@$icols), "set new select columns");
	Test::More::is(join(',',$o->select_columns), join(',',@$icols), "got new select columns");

	Test::More::is(join(',',$o->nonselect_columns($nicols)), join(',',@$nicols), "set new non-select columns");
	Test::More::is(join(',',$o->nonselect_columns), join(',',@$nicols), "got new non-select columns");


	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, undef, 'able is a select col');
	Test::More::is($icols{'baker'}, undef, 'baker is not an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, undef, 'delta is not an select col');	
	Test::More::is(scalar(keys %icols), 1, 'only 1 select column');
}



{
	my $icols = [qw()];

	$o->select_columns($icols);
	$o->nonselect_columns([]);

	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, 1, 'baker is an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, 1, 'delta is an select col');	
	Test::More::is(scalar(keys %icols), 4, '4 select columns');
}

{
	$o->select_columns(undef);
	my %icols = map {$_, 1} $o->select_columns();

	Test::More::is($icols{'able'}, 1, 'able is an select col');
	Test::More::is($icols{'baker'}, 1, 'baker is an select col');
	Test::More::is($icols{'charlie'}, 1, 'charlie is an select col');
	Test::More::is($icols{'delta'}, 1, 'delta is an select col');	
	Test::More::is(scalar(keys %icols), 4, '4 select columns');
}

Test::More::is(scalar($o->select_columns(['junk'])), undef, 'could not select unknown column');
Test::More::is($o->errcode, 'BDT-13', 'proper error code');
};
{
#line 1131  _column_list_accessor

Test::More::ok("testing is implied", "testing is implied");
};
{
#line 1185  init

my $o = Basset::DB::Table->new();
Test::More::ok($o, "got object");
Test::More::is(ref $o->definition, 'HASH', 'definition initialized to hash');
Test::More::is(ref $o->extra_select, 'HASH', 'extra_select initialized to hash');
Test::More::is(ref $o->db_write_translation, 'HASH', 'db_write_translation initialized to hash');
Test::More::is(ref $o->db_read_translation, 'HASH', 'db_read_translation initialized to hash');
Test::More::is(ref $o->column_aliases, 'HASH', 'column_aliases initialized to hash');
Test::More::is(ref $o->references, 'HASH', 'references initialized to hash');
};
{
#line 1269  cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_VARCHAR',
	'charlie' => 'SQL_DATE',
	'delta' => 'SQL_UNKNOWN_TYPE'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %cols = map {$_, 1} $o->cols();

Test::More::is(scalar(keys %cols), scalar(keys %$def), "proper number of columns");
Test::More::is($cols{'able'}, 1, 'able is column');
Test::More::is($cols{'baker'}, 1, 'baker is column');
Test::More::is($cols{'charlie'}, 1, 'charlie is column');
Test::More::is($cols{'delta'}, 1, 'delta is column');
Test::More::is($cols{'edgar'}, undef, 'edgar is not column');
Test::More::is($cols{'foxtrot'}, undef, 'foxtrot is not column');
Test::More::is($cols{'goat'}, undef, 'goat is not column');
};
{
#line 1314  defs

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_VARCHAR',
	'charlie' => 'SQL_DATE',
	'delta' => 'SQL_UNKNOWN_TYPE'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my @cols = $o->cols();
my @defs = $o->defs();

Test::More::is(scalar(@defs), scalar(keys %$def), "proper number of definitions");
Test::More::is($defs[0], $o->definition->{$cols[0]}, "Definition matches column 0");
Test::More::is($defs[1], $o->definition->{$cols[1]}, "Definition matches column 1");
Test::More::is($defs[2], $o->definition->{$cols[2]}, "Definition matches column 2");
Test::More::is($defs[3], $o->definition->{$cols[3]}, "Definition matches column 3");
};
{
#line 1360  is_bindable

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is(scalar($o->is_bindable()), undef, 'Cannot bind w/o type');
Test::More::is($o->errcode, 'BDT-31', 'proper error code for is_bindable (type)');
Test::More::is(scalar($o->is_bindable('able')), undef, 'Cannot bind w/o col');
Test::More::is($o->errcode, 'BDT-30', 'proper error code for is_bindable (col)');

Test::More::is($o->is_bindable('I', 'able'), 1, 'able binds on insert');
Test::More::is($o->is_bindable('I', 'baker'), 1, 'baker binds on insert');
Test::More::is($o->is_bindable('I', 'charlie'), 1, 'charlie binds on insert');
Test::More::is($o->is_bindable('I', 'delta'), 1, 'delta binds on insert');

Test::More::is($o->is_bindable('U', 'able'), 1, 'able binds on update');
Test::More::is($o->is_bindable('U', 'baker'), 1, 'baker binds on update');
Test::More::is($o->is_bindable('U', 'charlie'), 1, 'charlie binds on update');
Test::More::is($o->is_bindable('U', 'delta'), 1, 'delta binds on update');

Test::More::is($o->is_bindable('R', 'able'), 1, 'able binds on replace');
Test::More::is($o->is_bindable('R', 'baker'), 1, 'baker binds on replace');
Test::More::is($o->is_bindable('R', 'charlie'), 1, 'charlie binds on replace');
Test::More::is($o->is_bindable('R', 'delta'), 1, 'delta binds on replace');

Test::More::is($o->is_bindable('D', 'able'), 1, 'able binds on delete');
Test::More::is($o->is_bindable('D', 'baker'), 1, 'baker binds on delete');
Test::More::is($o->is_bindable('D', 'charlie'), 1, 'charlie binds on delete');
Test::More::is($o->is_bindable('D', 'delta'), 1, 'delta binds on delete');

Test::More::is($o->is_bindable('S', 'able'), 1, 'able binds on select');
Test::More::is($o->is_bindable('S', 'baker'), 1, 'baker binds on select');
Test::More::is($o->is_bindable('S', 'charlie'), 1, 'charlie binds on select');
Test::More::is($o->is_bindable('S', 'delta'), 1, 'delta binds on select');

Test::More::is($o->is_bindable('A', 'able'), 1, 'able binds on all');
Test::More::is($o->is_bindable('A', 'baker'), 1, 'baker binds on all');
Test::More::is($o->is_bindable('A', 'charlie'), 1, 'charlie binds on all');
Test::More::is($o->is_bindable('A', 'delta'), 1, 'delta binds on all');

my $translator = 	{
		'able' => {
			'I' => {
				'val' => 'NOW()',
				'binds' => 0
			},
		},
		'baker' => {
			'U' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'charlie' => {
			'R' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'delta' => {
			'D' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
	};

Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

Test::More::is($o->is_bindable('I', 'able'), 0, 'able does not bind on insert');
Test::More::is($o->is_bindable('I', 'baker'), 1, 'baker binds on insert');
Test::More::is($o->is_bindable('I', 'charlie'), 1, 'charlie binds on insert');
Test::More::is($o->is_bindable('I', 'delta'), 1, 'delta binds on insert');

Test::More::is($o->is_bindable('U', 'able'), 1, 'able binds on update');
Test::More::is($o->is_bindable('U', 'baker'), 0, 'baker does not bind on update');
Test::More::is($o->is_bindable('U', 'charlie'), 1, 'charlie binds on update');
Test::More::is($o->is_bindable('U', 'delta'), 1, 'delta binds on update');

Test::More::is($o->is_bindable('R', 'able'), 1, 'able binds on replace');
Test::More::is($o->is_bindable('R', 'baker'), 1, 'baker binds on replace');
Test::More::is($o->is_bindable('R', 'charlie'), 0, 'charlie does not bind on replace');
Test::More::is($o->is_bindable('R', 'delta'), 1, 'delta binds on replace');

Test::More::is($o->is_bindable('D', 'able'), 1, 'able binds on delete');
Test::More::is($o->is_bindable('D', 'baker'), 1, 'baker binds on delete');
Test::More::is($o->is_bindable('D', 'charlie'), 1, 'charlie binds on delete');
Test::More::is($o->is_bindable('D', 'delta'), 0, 'delta does not bind on delete');

Test::More::is($o->is_bindable('S', 'able'), 1, 'able binds on select');
Test::More::is($o->is_bindable('S', 'baker'), 1, 'baker binds on select');
Test::More::is($o->is_bindable('S', 'charlie'), 1, 'charlie binds on select');
Test::More::is($o->is_bindable('S', 'delta'), 1, 'delta binds on select');

Test::More::is($o->is_bindable('A', 'able'), 1, 'able binds on all');
Test::More::is($o->is_bindable('A', 'baker'), 1, 'baker binds on all');
Test::More::is($o->is_bindable('A', 'charlie'), 1, 'charlie binds on all');
Test::More::is($o->is_bindable('A', 'delta'), 1, 'delta binds on all');

my $translator2 = 	{
		'able' => {
			'S' => {
				'val' => 'NOW()',
				'binds' => 0
			},
		},
		'baker' => {
			'A' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'charlie' => {
			'I' => {
				'val' => 'NOW()',
				'binds' => 1,
			},
			'A' => {
				'val' => 'NOW()',
				'binds' => 0,
			},
		},
		'delta' => {
			'A' => {
				'val' => '?',
				'binds' => 1,
			}
		},
	};

Test::More::is($o->db_write_translation($translator2), $translator2, "Set translator again");

Test::More::is($o->is_bindable('I', 'able'), 1, 'able binds on insert');
Test::More::is($o->is_bindable('I', 'baker'), 0, 'baker does not bind on insert');
Test::More::is($o->is_bindable('I', 'charlie'), 1, 'charlie binds on insert');
Test::More::is($o->is_bindable('I', 'delta'), 1, 'delta binds on insert');

Test::More::is($o->is_bindable('U', 'able'), 1, 'able binds on update');
Test::More::is($o->is_bindable('U', 'baker'), 0, 'baker does not bind on update');
Test::More::is($o->is_bindable('U', 'charlie'), 0, 'charlie does not bind on update');
Test::More::is($o->is_bindable('U', 'delta'), 1, 'delta binds on update');

Test::More::is($o->is_bindable('R', 'able'), 1, 'able binds on replace');
Test::More::is($o->is_bindable('R', 'baker'), 0, 'baker does not bind replace');
Test::More::is($o->is_bindable('R', 'charlie'), 0, 'charlie does not bind on replace');
Test::More::is($o->is_bindable('R', 'delta'), 1, 'delta binds on replace');

Test::More::is($o->is_bindable('D', 'able'), 1, 'able binds on delete');
Test::More::is($o->is_bindable('D', 'baker'), 0, 'baker does not bind delete');
Test::More::is($o->is_bindable('D', 'charlie'), 0, 'charlie does not bind on delete');
Test::More::is($o->is_bindable('D', 'delta'), 1, 'delta binds on delete');

Test::More::is($o->is_bindable('S', 'able'), 0, 'able does not bind on select');
Test::More::is($o->is_bindable('S', 'baker'), 0, 'baker does not bind on select');
Test::More::is($o->is_bindable('S', 'charlie'), 0, 'charlie does not bind on select');
Test::More::is($o->is_bindable('S', 'delta'), 1, 'delta binds on select');

Test::More::is($o->is_bindable('A', 'able'), 1, 'able binds on all');
Test::More::is($o->is_bindable('A', 'baker'), 0, 'baker does not bind on all');
Test::More::is($o->is_bindable('A', 'charlie'), 0, 'charlie does not bind on all');
Test::More::is($o->is_bindable('A', 'delta'), 1, 'delta binds on all');
};
{
#line 1561  is_selectable

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is(scalar($o->is_selectable), undef, 'Could not determine selectableness w/o value');
Test::More::is($o->errcode, 'BDT-44', 'proper error code');

Test::More::is($o->is_selectable('able'), 1, 'selects column');
Test::More::is($o->is_selectable('7'), 1, 'selects integer');
Test::More::is($o->is_selectable('7 as seven'), 1, 'selects aliased integer');
Test::More::is($o->is_selectable('98.6'), 1, 'selects float');
Test::More::is($o->is_selectable('98.6 as temp'), 1, 'selects aliased float');
Test::More::is($o->is_selectable('.778'), 1, 'selects decimal started float');
Test::More::is($o->is_selectable('.778 as small'), 1, 'selects decimal started float');
Test::More::is($o->is_selectable("'string'"), 1, 'selects single quoted string');
Test::More::is($o->is_selectable("'string' as alias"), 1, 'selects aliased single quoted string');
Test::More::is($o->is_selectable('"string"'), 1, 'selects double quoted string');
Test::More::is($o->is_selectable('"string" as alias'), 1, 'selects aliased double quoted string');
Test::More::is($o->is_selectable('NOW()'), 1, 'selects empty function');
Test::More::is($o->is_selectable('NOW() as "now"'), 1, 'selects aliased empty function');
Test::More::is($o->is_selectable('lc("able")'), 1, 'selects single arg function');
Test::More::is($o->is_selectable('lc("able") as "lc able"'), 1, 'selects aliased single arg function');
Test::More::is($o->is_selectable('lc("able")'), 1, 'selects double arg function');
Test::More::is($o->is_selectable('lc("able") as "lc able"'), 1, 'selects aliased double arg function');
};
{
#line 1624  db_translate_write

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is(scalar($o->db_translate_write()), undef, 'Cannot db_translate_write w/o type');
Test::More::is($o->errcode, 'BDT-33', 'proper error code for db_translate_write (col)');
Test::More::is(scalar($o->db_translate_write('I')), undef, 'Cannot db_translate_write w/o cols');
Test::More::is($o->errcode, 'BDT-32', 'proper error code for db_translate_write (type)');

Test::More::is($o->db_translate_write('I', 'able'), '?', 'db_translate_write for able on insert');
Test::More::is($o->db_translate_write('I', 'baker'), '?', 'db_translate_write for baker on insert');
Test::More::is($o->db_translate_write('I', 'charlie'), '?', 'db_translate_write for charlie on insert');
Test::More::is($o->db_translate_write('I', 'delta'), '?', 'db_translate_write for delta on insert');

Test::More::is($o->db_translate_write('U', 'able'), '?', 'db_translate_write for able on update');
Test::More::is($o->db_translate_write('U', 'baker'), '?', 'db_translate_write for baker on update');
Test::More::is($o->db_translate_write('U', 'charlie'), '?', 'db_translate_write for charlie on update');
Test::More::is($o->db_translate_write('U', 'delta'), '?', 'db_translate_write for delta on update');

Test::More::is($o->db_translate_write('R', 'able'), '?', 'db_translate_write for able on replace');
Test::More::is($o->db_translate_write('R', 'baker'), '?', 'db_translate_write for baker on replace');
Test::More::is($o->db_translate_write('R', 'charlie'), '?', 'db_translate_write for charlie on replace');
Test::More::is($o->db_translate_write('R', 'delta'), '?', 'db_translate_write for delta on replace');

Test::More::is($o->db_translate_write('D', 'able'), '?', 'db_translate_write for able on delete');
Test::More::is($o->db_translate_write('D', 'baker'), '?', 'db_translate_write for baker on delete');
Test::More::is($o->db_translate_write('D', 'charlie'), '?', 'db_translate_write for charlie on delete');
Test::More::is($o->db_translate_write('D', 'delta'), '?', 'db_translate_write for delta on delete');

Test::More::is($o->db_translate_write('S', 'able'), '?', 'db_translate_write for able on select');
Test::More::is($o->db_translate_write('S', 'baker'), '?', 'db_translate_write for baker on select');
Test::More::is($o->db_translate_write('S', 'charlie'), '?', 'db_translate_write for charlie on select');
Test::More::is($o->db_translate_write('S', 'delta'), '?', 'db_translate_write for delta on select');

Test::More::is($o->db_translate_write('A', 'able'), '?', 'db_translate_write for able on all');
Test::More::is($o->db_translate_write('A', 'baker'), '?', 'db_translate_write for baker on all');
Test::More::is($o->db_translate_write('A', 'charlie'), '?', 'db_translate_write for charlie on all');
Test::More::is($o->db_translate_write('A', 'delta'), '?', 'db_translate_write for delta on all');

{
	my @insert_all = $o->db_translate_write('I', sort $o->cols);
	Test::More::is($insert_all[0], '?', 'able is ? on insert in multi pass');
	Test::More::is($insert_all[1], '?', 'baker is ? on insert in multi pass');
	Test::More::is($insert_all[2], '?', 'charlie is ? on insert in multi pass');
	Test::More::is($insert_all[3], '?', 'delta is ? on insert in multi pass');
	
	my @update_all = $o->db_translate_write('U', sort $o->cols);
	Test::More::is($update_all[0], '?', 'able is ? on update in multi pass');
	Test::More::is($update_all[1], '?', 'baker is ? on update in multi pass');
	Test::More::is($update_all[2], '?', 'charlie is ? on update in multi pass');
	Test::More::is($update_all[3], '?', 'delta is ? on update in multi pass');
	
	my @replace_all = $o->db_translate_write('R', sort $o->cols);
	Test::More::is($replace_all[0], '?', 'able is ? on replace in multi pass');
	Test::More::is($replace_all[1], '?', 'baker is ? on replace in multi pass');
	Test::More::is($replace_all[2], '?', 'charlie is ? on replace in multi pass');
	Test::More::is($replace_all[3], '?', 'delta is ? on replace in multi pass');
	
	my @delete_all = $o->db_translate_write('D', sort $o->cols);
	Test::More::is($delete_all[0], '?', 'able is ? on delete in multi pass');
	Test::More::is($delete_all[1], '?', 'baker is ? on delete in multi pass');
	Test::More::is($delete_all[2], '?', 'charlie is ? on delete in multi pass');
	Test::More::is($delete_all[3], '?', 'delta is ? on delete in multi pass');
	
	my @all_all = $o->db_translate_write('A', sort $o->cols);
	Test::More::is($all_all[0], '?', 'able is ? on all in multi pass');
	Test::More::is($all_all[1], '?', 'baker is ? on all in multi pass');
	Test::More::is($all_all[2], '?', 'charlie is ? on all in multi pass');
	Test::More::is($all_all[3], '?', 'delta is ? on all in multi pass');
}

my $translator = 	{
		'able' => {
			'I' => {
				'val' => 'ableprime',
				'binds' => 0
			},
		},
		'baker' => {
			'U' => {
				'val' => 'bakerprime',
				'binds' => 0,
			},
		},
		'charlie' => {
			'R' => {
				'val' => 'charlieprime',
				'binds' => 1,
			},
		},
		'delta' => {
			'D' => {
				'val' => 'deltaprime',
				'binds' => 0,
			},
		},
	};

Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

Test::More::is($o->db_translate_write('I', 'able'), 'ableprime', 'db_translate_write for able on insert');
Test::More::is($o->db_translate_write('I', 'baker'), '?', 'db_translate_write for baker on insert');
Test::More::is($o->db_translate_write('I', 'charlie'), '?', 'db_translate_write for charlie on insert');
Test::More::is($o->db_translate_write('I', 'delta'), '?', 'db_translate_write for delta on insert');

Test::More::is($o->db_translate_write('U', 'able'), '?', 'db_translate_write for able on update');
Test::More::is($o->db_translate_write('U', 'baker'), 'bakerprime', 'db_translate_write for baker on update');
Test::More::is($o->db_translate_write('U', 'charlie'), '?', 'db_translate_write for charlie on update');
Test::More::is($o->db_translate_write('U', 'delta'), '?', 'db_translate_write for delta on update');

Test::More::is($o->db_translate_write('R', 'able'), '?', 'db_translate_write for able on replace');
Test::More::is($o->db_translate_write('R', 'baker'), '?', 'db_translate_write for baker on replace');
Test::More::is($o->db_translate_write('R', 'charlie'), 'charlieprime', 'db_translate_write for charlie on replace');
Test::More::is($o->db_translate_write('R', 'delta'), '?', 'db_translate_write for delta on replace');

Test::More::is($o->db_translate_write('D', 'able'), '?', 'db_translate_write for able on delete');
Test::More::is($o->db_translate_write('D', 'baker'), '?', 'db_translate_write for baker on delete');
Test::More::is($o->db_translate_write('D', 'charlie'), '?', 'db_translate_write for charlie on delete');
Test::More::is($o->db_translate_write('D', 'delta'), 'deltaprime', 'db_translate_write for delta on delete');

Test::More::is($o->db_translate_write('S', 'able'), '?', 'db_translate_write for able on select');
Test::More::is($o->db_translate_write('S', 'baker'), '?', 'db_translate_write for baker on select');
Test::More::is($o->db_translate_write('S', 'charlie'), '?', 'db_translate_write for charlie on select');
Test::More::is($o->db_translate_write('S', 'delta'), '?', 'db_translate_write for delta on select');

Test::More::is($o->db_translate_write('A', 'able'), '?', 'db_translate_write for able on all');
Test::More::is($o->db_translate_write('A', 'baker'), '?', 'db_translate_write for baker on all');
Test::More::is($o->db_translate_write('A', 'charlie'), '?', 'db_translate_write for charlie on all');
Test::More::is($o->db_translate_write('A', 'delta'), '?', 'db_translate_write for delta on all');

{
	my @insert_all = $o->db_translate_write('I', sort $o->cols);
	Test::More::is($insert_all[0], 'ableprime', 'able is ableprime on insert in multi pass');
	Test::More::is($insert_all[1], '?', 'baker is ? on insert in multi pass');
	Test::More::is($insert_all[2], '?', 'charlie is ? on insert in multi pass');
	Test::More::is($insert_all[3], '?', 'delta is ? on insert in multi pass');
	
	my @update_all = $o->db_translate_write('U', sort $o->cols);

	Test::More::is($update_all[0], '?', 'able is ? on update in multi pass');
	Test::More::is($update_all[1], 'bakerprime', 'baker is bakerprime on update in multi pass');
	Test::More::is($update_all[2], '?', 'charlie is ? on update in multi pass');
	Test::More::is($update_all[3], '?', 'delta is ? on update in multi pass');
	
	my @replace_all = $o->db_translate_write('R', sort $o->cols);
	Test::More::is($replace_all[0], '?', 'able is ? on replace in multi pass');
	Test::More::is($replace_all[1], '?', 'baker is ? on replace in multi pass');
	Test::More::is($replace_all[2], 'charlieprime', 'charlie is charlieprime on replace in multi pass');
	Test::More::is($replace_all[3], '?', 'delta is ? on replace in multi pass');
	
	my @delete_all = $o->db_translate_write('D', sort $o->cols);
	Test::More::is($delete_all[0], '?', 'able is ? on delete in multi pass');
	Test::More::is($delete_all[1], '?', 'baker is ? on delete in multi pass');
	Test::More::is($delete_all[2], '?', 'charlie is ? on delete in multi pass');
	Test::More::is($delete_all[3], 'deltaprime', 'delta is deltaprime on delete in multi pass');
	
	my @all_all = $o->db_translate_write('A', sort $o->cols);
	Test::More::is($all_all[0], '?', 'able is ? on all in multi pass');
	Test::More::is($all_all[1], '?', 'baker is ? on all in multi pass');
	Test::More::is($all_all[2], '?', 'charlie is ? on all in multi pass');
	Test::More::is($all_all[3], '?', 'delta is ? on all in multi pass');
}

my $translator2 = 	{
		'able' => {
			'S' => {
				'val' => 'ableselectorprime',
				'binds' => 0
			},
		},
		'baker' => {
			'A' => {
				'val' => 'bakerallprime',
				'binds' => 0,
			},
		},
		'charlie' => {
			'I' => {
				'val' => 'charlieinsertprime',
				'binds' => 1,
			},
			'A' => {
				'val' => 'charlieallprime',
				'binds' => 0,
			},
		},
	};

Test::More::is($o->db_write_translation($translator2), $translator2, "Set translator again");

Test::More::is($o->db_translate_write('I', 'able'), '?', 'db_translate_write for able on insert');
Test::More::is($o->db_translate_write('I', 'baker'), 'bakerallprime', 'db_translate_write for baker on insert');
Test::More::is($o->db_translate_write('I', 'charlie'), 'charlieinsertprime', 'db_translate_write for charlie on insert');
Test::More::is($o->db_translate_write('I', 'delta'), '?', 'db_translate_write for delta on insert');

Test::More::is($o->db_translate_write('U', 'able'), '?', 'db_translate_write for able on update');
Test::More::is($o->db_translate_write('U', 'baker'), 'bakerallprime', 'db_translate_write for baker on update');
Test::More::is($o->db_translate_write('U', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on update');
Test::More::is($o->db_translate_write('U', 'delta'), '?', 'db_translate_write for delta on update');

Test::More::is($o->db_translate_write('R', 'able'), '?', 'db_translate_write for able on replace');
Test::More::is($o->db_translate_write('R', 'baker'), 'bakerallprime', 'db_translate_write for baker on replace');
Test::More::is($o->db_translate_write('R', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on replace');
Test::More::is($o->db_translate_write('R', 'delta'), '?', 'db_translate_write for delta on replace');

Test::More::is($o->db_translate_write('D', 'able'), '?', 'db_translate_write for able on delete');
Test::More::is($o->db_translate_write('D', 'baker'), 'bakerallprime', 'db_translate_write for baker on delete');
Test::More::is($o->db_translate_write('D', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on delete');
Test::More::is($o->db_translate_write('D', 'delta'), '?', 'db_translate_write for delta on delete');

Test::More::is($o->db_translate_write('S', 'able'), 'ableselectorprime', 'db_translate_write for able on select');
Test::More::is($o->db_translate_write('S', 'baker'), 'bakerallprime', 'db_translate_write for baker on select');
Test::More::is($o->db_translate_write('S', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on select');
Test::More::is($o->db_translate_write('S', 'delta'), '?', 'db_translate_write for delta on select');

Test::More::is($o->db_translate_write('A', 'able'), '?', 'db_translate_write for able on all');
Test::More::is($o->db_translate_write('A', 'baker'), 'bakerallprime', 'db_translate_write for baker on all');
Test::More::is($o->db_translate_write('A', 'charlie'), 'charlieallprime', 'db_translate_write for charlie on all');
Test::More::is($o->db_translate_write('A', 'delta'), '?', 'db_translate_write for delta on all');

{
	my @insert_all = $o->db_translate_write('I', sort $o->cols);
	Test::More::is($insert_all[0], '?', 'able is ? on insert in multi pass');
	Test::More::is($insert_all[1], 'bakerallprime', 'baker is bakerallprime on insert in multi pass');
	Test::More::is($insert_all[2], 'charlieinsertprime', 'charlie is charlieinsertprime on insert in multi pass');
	Test::More::is($insert_all[3], '?', 'delta is ? on insert in multi pass');
	
	my @update_all = $o->db_translate_write('U', sort $o->cols);
	Test::More::is($update_all[0], '?', 'able is ? on update in multi pass');
	Test::More::is($update_all[1], 'bakerallprime', 'baker is bakerallprime on update in multi pass');
	Test::More::is($update_all[2], 'charlieallprime', 'charlie is charlieallprime on update in multi pass');
	Test::More::is($update_all[3], '?', 'delta is ? on update in multi pass');
	
	my @replace_all = $o->db_translate_write('R', sort $o->cols);
	Test::More::is($replace_all[0], '?', 'able is ? on replace in multi pass');
	Test::More::is($replace_all[1], 'bakerallprime', 'baker is bakerallprime on replace in multi pass');
	Test::More::is($replace_all[2], 'charlieallprime', 'charlie is charlieallprime on replace in multi pass');
	Test::More::is($replace_all[3], '?', 'delta is ? on replace in multi pass');
	
	my @delete_all = $o->db_translate_write('D', sort $o->cols);
	Test::More::is($delete_all[0], '?', 'able is ? on delete in multi pass');
	Test::More::is($delete_all[1], 'bakerallprime', 'baker is bakerallprime on delete in multi pass');
	Test::More::is($delete_all[2], 'charlieallprime', 'charlie is charlieallprime on delete in multi pass');
	Test::More::is($delete_all[3], '?', 'delta is ? on delete in multi pass');
	
	my @all_all = $o->db_translate_write('A', sort $o->cols);
	Test::More::is($all_all[0], '?', 'able is ? on all in multi pass');
	Test::More::is($all_all[1], 'bakerallprime', 'baker is bakerallprime on all in multi pass');
	Test::More::is($all_all[2], 'charlieallprime', 'charlie is charlieallprime on all in multi pass');
	Test::More::is($all_all[3], '?', 'delta is ? on all in multi pass');
}
};
{
#line 1924  db_translate_read

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");
Test::More::is($o->name('table'), 'table', 'Set table name');

Test::More::is(scalar($o->db_translate_read()), undef, 'Cannot db_translate_read w/o col');
Test::More::is($o->errcode, 'BDT-34', 'proper error code for db_translate_read (col)');

Test::More::is($o->db_translate_read('able'), 'table.able', 'db_translate_read for able on select');
Test::More::is($o->db_translate_read('baker'), 'table.baker', 'db_translate_read for baker on select');
Test::More::is($o->db_translate_read('charlie'), 'table.charlie', 'db_translate_read for charlie on select');
Test::More::is($o->db_translate_read('delta'), 'table.delta', 'db_translate_read for delta on select');

my $translator = 	{
		'able' => 'ableselectorprime',
		'baker' => 'bakerallprime',
		'charlie' => 'charlieselectprime',
	};

Test::More::is($o->db_read_translation($translator), $translator, "Set translator again");

Test::More::is($o->db_translate_read('able'), 'ableselectorprime', 'db_translate_read for able on select');
Test::More::is($o->db_translate_read('baker'), 'bakerallprime', 'db_translate_read for baker on select');
Test::More::is($o->db_translate_read('charlie'), 'charlieselectprime', 'db_translate_read for charlie on select');
Test::More::is($o->db_translate_read('delta'), 'table.delta', 'db_translate_read for delta on select');
};
{
#line 2000  alias_column

my $o = Basset::DB::Table->new('name' => 'testtable1');
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $aliases = {
	'able' => 'aliased_able',
	'baker' => 'aliased_baker',
	'charlie' => 'aliased_charlie',
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->column_aliases($aliases), $aliases, "Set column aliases");
Test::More::is($o->column_aliases(), $aliases, "Got column aliases");

Test::More::is(scalar($o->alias_column()), undef, "Could not alias_column w/o column");
Test::More::is($o->errcode, 'BDT-36', 'proper error code for alias_column (col)');

Test::More::is($o->alias_column('able'), 'aliased_able', 'properly aliased able');
Test::More::is($o->alias_column('baker'), 'aliased_baker', 'properly aliased baker');
Test::More::is($o->alias_column('charlie'), 'aliased_charlie', 'properly aliased charlie');
Test::More::is($o->alias_column('delta'), 'delta', 'properly aliased able (no alias)');

Test::More::is($o->alias_column('testtable1.able'), 'aliased_able', 'properly aliased able');
Test::More::is($o->alias_column('testtable1.baker'), 'aliased_baker', 'properly aliased baker');
Test::More::is($o->alias_column('testtable1.charlie'), 'aliased_charlie', 'properly aliased charlie');
Test::More::is($o->alias_column('testtable1.delta'), 'delta', 'properly aliased able (no alias)');
};
{
#line 2075  column_for_alias

my $o = Basset::DB::Table->new('name' => 'testtable2');
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $aliases = {
	'able' => 'aliased_able',
	'baker' => 'aliased_baker',
	'charlie' => 'aliased_charlie',
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->column_aliases($aliases), $aliases, "Set column aliases");
Test::More::is($o->column_aliases(), $aliases, "Got column aliases");

Test::More::is(scalar($o->column_for_alias()), undef, "Could not get column_for_alias w/o alias");
Test::More::is($o->errcode, 'BDT-35', 'proper error code for column_for_alias (alias)');

Test::More::is($o->column_for_alias('aliased_able'), 'able', 'properly unaliased able');
Test::More::is($o->column_for_alias('aliased_baker'), 'baker', 'properly unaliased baker');
Test::More::is($o->column_for_alias('aliased_charlie'), 'charlie', 'unproperly aliased charlie');
Test::More::is($o->column_for_alias('delta'), 'delta', 'properly aliased able (no alias)');

Test::More::is($o->column_for_alias('testtable2.aliased_able'), 'able', 'properly unaliased able');
Test::More::is($o->column_for_alias('testtable2.aliased_baker'), 'baker', 'properly unaliased baker');
Test::More::is($o->column_for_alias('testtable2.aliased_charlie'), 'charlie', 'unproperly aliased charlie');
Test::More::is($o->column_for_alias('testtable2.delta'), 'delta', 'properly aliased able (no alias)');
};
{
#line 2142  insert_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} $o->insert_bindables();

Test::More::is($bindable{'able'}, 1, 'able is insert bindable');
Test::More::is($bindable{'baker'}, 1, 'baker is insert bindable');
Test::More::is($bindable{'charlie'}, 1, 'charlie is insert bindable');
Test::More::is($bindable{'delta'}, 1, 'delta is insert bindable');

my $translator = {
	'able' => {
		'I' => {
			'val' => 'lc(?)',
			'binds' => 1
		},
		'A' => {
			'val' => 'NOW()',
			'binds' => 0,
		},
	},
	'baker' => {
		'I' => {
			'val' => 'NOW()',
			'binds' => 0
		},
		'A' => {
			'val' => '?',
			'binds' => 1,
		},
	},
	'charlie' => {
		'I' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
	'delta' => {
		'A' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
};

Test::More::is($o->db_write_translation($translator), $translator, 'set db_write_translation');

my %bindable2 = map {$_, 1} $o->insert_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is insert bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not insert bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not insert bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not insert bindable');
};
{
#line 2235  replace_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} $o->replace_bindables();

Test::More::is($bindable{'able'}, 1, 'able is replace bindable');
Test::More::is($bindable{'baker'}, 1, 'baker is replace bindable');
Test::More::is($bindable{'charlie'}, 1, 'charlie is replace bindable');
Test::More::is($bindable{'delta'}, 1, 'delta is replace bindable');

my $translator = {
	'able' => {
		'R' => {
			'val' => 'lc(?)',
			'binds' => 1
		},
		'A' => {
			'val' => 'NOW()',
			'binds' => 0,
		},
	},
	'baker' => {
		'R' => {
			'val' => 'NOW()',
			'binds' => 0
		},
		'A' => {
			'val' => '?',
			'binds' => 1,
		},
	},
	'charlie' => {
		'R' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
	'delta' => {
		'A' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
};

Test::More::is($o->db_write_translation($translator), $translator, 'set db_write_translation');

my %bindable2 = map {$_, 1} $o->replace_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is replace bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not replace bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not replace bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not replace bindable');
};
{
#line 2322  update_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} $o->update_bindables();

Test::More::is($bindable{'able'}, 1, 'able is update bindable');
Test::More::is($bindable{'baker'}, 1, 'baker is update bindable');
Test::More::is($bindable{'charlie'}, 1, 'charlie is update bindable');
Test::More::is($bindable{'delta'}, 1, 'delta is update bindable');

my $translator = {
	'able' => {
		'U' => {
			'val' => 'lc(?)',
			'binds' => 1
		},
		'A' => {
			'val' => 'NOW()',
			'binds' => 0,
		},
	},
	'baker' => {
		'U' => {
			'val' => 'NOW()',
			'binds' => 0
		},
		'A' => {
			'val' => '?',
			'binds' => 1,
		},
	},
	'charlie' => {
		'U' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
	'delta' => {
		'A' => {
			'val' => 'NOW()',
			'binds' => 0
		},
	},
};

Test::More::is($o->db_write_translation($translator), $translator, 'set db_write_translation');

my %bindable2 = map {$_, 1} $o->update_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is update bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not update bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not update bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not update bindable');
};
{
#line 2418  delete_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} grep {defined} $o->delete_bindables();

Test::More::is($bindable{'able'}, undef, 'able is not delete bindable');
Test::More::is($bindable{'baker'}, undef, 'baker is not delete bindable');
Test::More::is($bindable{'charlie'}, undef, 'charlie is not delete bindable');
Test::More::is($bindable{'delta'}, undef, 'delta is not delete bindable');

$o->primary_column('able');

my %bindable2 = map {$_, 1} $o->delete_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is delete bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not delete bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not delete bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not delete bindable');

$o->primary_column(['charlie', 'delta']);

my %bindable3 = map {$_, 1} $o->delete_bindables();

Test::More::is($bindable3{'able'}, undef, 'able is not delete bindable');
Test::More::is($bindable3{'baker'}, undef, 'baker is not delete bindable');
Test::More::is($bindable3{'charlie'}, 1, 'charlie is delete bindable');
Test::More::is($bindable3{'delta'}, 1, 'delta is delete bindable');
};
{
#line 2470  select_bindables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

my %bindable = map {$_, 1} grep {defined} $o->select_bindables;

Test::More::is($bindable{'able'}, undef, 'able is not select bindable');
Test::More::is($bindable{'baker'}, undef, 'baker is not select bindable');
Test::More::is($bindable{'charlie'}, undef, 'charlie is not select bindable');
Test::More::is($bindable{'delta'}, undef, 'delta is not select bindable');

$o->primary_column('able');

my %bindable2 = map {$_, 1} $o->select_bindables();

Test::More::is($bindable2{'able'}, 1, 'able is select bindable');
Test::More::is($bindable2{'baker'}, undef, 'baker is not select bindable');
Test::More::is($bindable2{'charlie'}, undef, 'charlie is not select bindable');
Test::More::is($bindable2{'delta'}, undef, 'delta is not select bindable');

$o->primary_column(['charlie', 'delta']);

my %bindable3 = map {$_, 1} $o->select_bindables();

Test::More::is($bindable3{'able'}, undef, 'able is not select bindable');
Test::More::is($bindable3{'baker'}, undef, 'baker is not select bindable');
Test::More::is($bindable3{'charlie'}, 1, 'charlie is select bindable');
Test::More::is($bindable3{'delta'}, 1, 'delta is select bindable');
};
{
#line 2541  insert_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

{
	my @insert = $o->insert_columns;

	Test::More::is($o->insert_query, "insert into mytable (" . join(', ', @insert)
		. ") values (?, ?, ?, ?)", "got default insert query");
}

{
	my @insert = $o->insert_columns(['able']);

	Test::More::is($o->insert_query, "insert into mytable (" . join(', ', @insert)
		. ") values (?)", "got able insert query");
	$o->insert_columns(undef);
}

{
	my @insert = $o->insert_columns(['able', 'baker']);

	Test::More::is($o->insert_query, "insert into mytable (" . join(', ', @insert)
		. ") values (?, ?)", "got able, baker insert query");
	$o->insert_columns(undef);
}

{

	Test::More::is(scalar($o->insert_query('foo')), undef, "Could not get insert query w/invalid column");
	Test::More::is($o->errcode, 'BDT-07', 'proper error code');
}

{
	Test::More::is($o->insert_query('able', 'baker'), "insert into mytable (able, baker) values (?, ?)", "got able, baker insert query");
}

{
	my $translator = 	{
			'able' => {
				'I' => {
					'val' => 'lc(?)',
					'binds' => 0
				},
			},
			'baker' => {
				'A' => {
					'val' => 'uc(?)',
					'binds' => 0,
				},
			},
		};

	Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

	my @insert = $o->insert_columns;

	my $q = "insert into mytable (" . join(', ', @insert)
		. ") values (" . join(', ', map{$_ eq 'able' ? 'lc(?)' : $_ eq 'baker' ? 'uc(?)' : '?'} @insert) . ")";

	Test::More::is($o->insert_query, $q, "got re-written default insert query");

}
};
{
#line 2670  replace_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

{
	my @replace = $o->replace_columns;

	Test::More::is($o->replace_query, "replace into mytable (" . join(', ', @replace)
		. ") values (?, ?, ?, ?)", "got default replace query");
}

{
	my @replace = $o->replace_columns(['able']);

	Test::More::is($o->replace_query, "replace into mytable (" . join(', ', @replace)
		. ") values (?)", "got able replace query");
	$o->replace_columns(undef);
}

{
	my @replace = $o->replace_columns(['able', 'baker']);

	Test::More::is($o->replace_query, "replace into mytable (" . join(', ', @replace)
		. ") values (?, ?)", "got able, baker replace query");
	$o->replace_columns(undef);
}

{

	Test::More::is(scalar($o->replace_query('foo')), undef, "Could not get replace query w/invalid column");
	Test::More::is($o->errcode, 'BDT-08', 'proper error code');
}

{
	Test::More::is($o->replace_query('able', 'baker'), "replace into mytable (able, baker) values (?, ?)", "got able, baker replace query");
}

{
	my $translator = 	{
			'able' => {
				'R' => {
					'val' => 'lc(?)',
					'binds' => 0
				},
			},
			'baker' => {
				'A' => {
					'val' => 'uc(?)',
					'binds' => 0,
				},
			},
		};

	Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

	my @replace = $o->replace_columns;

	my $q = "replace into mytable (" . join(', ', @replace)
		. ") values (" . join(', ', map{$_ eq 'able' ? 'lc(?)' : $_ eq 'baker' ? 'uc(?)' : '?'} @replace) . ")";

	Test::More::is($o->replace_query, $q, "got re-written default replace query");

}
};
{
#line 2801  update_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

{
	my @update = $o->update_columns;

	Test::More::is($o->update_query, "update mytable set " . join(', ', map {"$_ = ?"} @update), "got default update query");
}

{
	my @update = $o->update_columns(['able']);

	Test::More::is($o->update_query, "update mytable set " . join(', ', map {"$_ = ?"} @update), "got able update query");

	$o->update_columns(undef);
}

{
	my @update = $o->update_columns(['able', 'baker']);

	Test::More::is($o->update_query, "update mytable set " . join(', ', map {"$_ = ?"} @update), "got able, baker update query");
	$o->update_columns(undef);
}

{

	Test::More::is(scalar($o->update_query('foo')), undef, "Could not get update query w/invalid column");
	Test::More::is($o->errcode, 'BDT-06', 'proper error code');
}

{
	Test::More::is($o->update_query('able', 'baker'), "update mytable set able = ?, baker = ?", "got able, baker update query");
}

{
	my $translator = 	{
			'able' => {
				'U' => {
					'val' => 'lc(?)',
					'binds' => 0
				},
			},
			'baker' => {
				'A' => {
					'val' => 'uc(?)',
					'binds' => 0,
				},
			},
		};

	Test::More::is($o->db_write_translation($translator), $translator, "Set translator");

	my @update = $o->update_columns;

	my $q = "update mytable set " . join(', ', map{$_ . ' = ' . ($_ eq 'able' ? 'lc(?)' : $_ eq 'baker' ? 'uc(?)' : '?')} @update);

	Test::More::is($o->update_query, $q, "got re-written default update query");

}
};
{
#line 2920  delete_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

Test::More::is($o->delete_query, 'delete from mytable', 'proper delete query');
};
{
#line 2962  select_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', "set tablename");

Test::More::is(scalar($o->select_query('fake')), undef, 'Could not select unknown column');
Test::More::is($o->errcode, 'BDT-05', 'proper error code');

{
	my @select = $o->select_columns;

	Test::More::is($o->select_query, 'select ' . join(', ', map {"mytable.$_ as $_"} @select) . ' from mytable', "got default select query");	

}

{
	my @select = $o->select_columns(['able']);

	Test::More::is($o->select_query, 'select ' . join(', ', map {"mytable.$_ as $_"} @select) . ' from mytable', "got able select query");	

	$o->select_columns(undef);
}

{
	my @select = $o->select_columns(['able', 'baker']);

	Test::More::is($o->select_query, 'select ' . join(', ', map {"mytable.$_ as $_"} @select) . ' from mytable', "got able baker select query");	

	$o->select_columns(undef);
}

{
	Test::More::is($o->select_query('able', 'baker'), 'select mytable.able as able, mytable.baker as baker from mytable', 'got able baker passed select query');
}

{
	Test::More::is($o->select_query('NOW()', '"const1"', "'const2'", 2004), 'select NOW(), "const1", \'const2\', 2004 from mytable', 'got function, constant select query');
}

{
	my $translator = 	{
		'able' => 'lc(able)',
		'baker' => 'uc(baker)',
	};

	my @select = $o->select_columns();

	Test::More::is($o->db_read_translation($translator), $translator, "Set translator");

	Test::More::is($o->select_query, 'select ' . join(', ', map{($_ eq 'able' ? 'lc(able)' : $_ eq 'baker' ? 'uc(baker)' : "mytable.$_") . " as $_"} @select) . ' from mytable', "got translated select query");	

	$o->db_read_translation({});
}

{
	my $extra = {
		'current_time' => 'NOW()'
	};

	Test::More::is($o->extra_select($extra), $extra, "Set extra select");

	my @select = ((map {"mytable.$_ as $_"} $o->select_columns), (map {$extra->{$_} . ' as ' . $_} keys %$extra));

	Test::More::is($o->select_query, 'select ' . join(', ', @select) . ' from mytable', "got extra selecting select query");
};
};
{
#line 3248  multiselect_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Created object");

my $o3 = Basset::DB::Table->new();
Test::More::ok($o3, "Created object");

my $o4 = Basset::DB::Table->new();
Test::More::ok($o4, "Created object");

my $def1 = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $ref1 = {
	'able' => 'table2.aid',
	'baker' => 'table4.b',
	'charlie' => 'table4.c',
};

Test::More::is($o->definition($def1), $def1, "Set definition");
Test::More::is($o->references($ref1), $ref1, "Set references");
Test::More::is($o->name("table1"), "table1", "set table name");
Test::More::is($o->primary_column("able"), "able", "set table primary id");

my $def2 = {
	'aid' => 'SQL_INTEGER',
	'bid' => 'SQL_INTEGER',
	'cid' => 'SQL_INTEGER',
	'did' => 'SQL_INTEGER'
};

my $ref2 = {
	'aid' => 'table3.ace'
};

my $aliases2 = {
	'aid' => 'ALIASED_aid',
};

Test::More::is($o2->definition($def2), $def2, "Set definition");
Test::More::is($o2->references($ref2), $ref2, "Set references");
Test::More::is($o2->column_aliases($aliases2), $aliases2, "Set aliases");
Test::More::is($o2->name("table2"), "table2", "set table name");
Test::More::is($o2->primary_column("aid"), "aid", "set table primary id");

my $def3 = {
	'ace' => 'SQL_INTEGER',
	'bogey' => 'SQL_INTEGER',
};

Test::More::is($o3->definition($def3), $def3, "Set definition");
Test::More::is($o3->name("table3"), "table3", "set table name");
Test::More::is($o3->primary_column("ace"), "ace", "set table primary id");

my $def4 = {
	'a' => 'SQL_INTEGER',
	'b' => 'SQL_INTEGER',
	'c' => 'SQL_INTEGER',
	'd' => 'SQL_INTEGER'
};

Test::More::is($o4->definition($def4), $def4, "Set definition");
Test::More::is($o4->name("table4"), "table4", "set table name");
Test::More::ok($o4->primary_column([qw(b c)]), "set table primary id");

my @o1select = $o->select_columns();
my @o2select = $o2->select_columns();
my @o3select = $o3->select_columns();
my @o4select = $o4->select_columns();

Test::More::is(scalar(Basset::DB::Table->multiselect_query()), undef, "Could not multiselect w/o tables");
Test::More::is(Basset::DB::Table->errcode, 'BDT-47', 'proper error code');

Test::More::is(Basset::DB::Table->multiselect_query('tables' => $o),
"select " . (join(", ",map {"table1.$_ as $_"} @o1select)) . " from table1",
'multi selected single table');

Test::More::is(Basset::DB::Table->multiselect_query('tables' => [$o]),
"select " . (join(", ",map {"table1.$_ as $_"} @o1select)) . " from table1",
'multi selected single table in arrayref');


Test::More::is(Basset::DB::Table->multiselect_query('cols' => 'able', 'tables' => $o),
"select " . (join(", ",map {"table1.$_ as $_"} ('able'))) . " from table1",
'multi selected single table, different cols');

Test::More::is(Basset::DB::Table->multiselect_query('cols' => ['able'], 'tables' => $o),
"select " . (join(", ",map {"table1.$_ as $_"} ('able'))) . " from table1",
'multi selected single table, different cols in arrayref');

Test::More::is(Basset::DB::Table->multiselect_query('cols' => ['able'], 'tables' => [$o]),
"select " . (join(", ",map {"table1.$_ as $_"} ('able'))) . " from table1",
'multi selected single table in arrayref, different cols');

Test::More::is(Basset::DB::Table->multiselect_query('tables' => [$o, $o2]),
"select\n" . (join(",\n",map {"\ttable1.$_"} @o1select)) 
. ",\n" . (join(",\n",map {"\ttable2.$_"} @o2select)) . "\nfrom\n" .
"table1
	inner join
		table2
			on table1.able = table2.aid",
'multi selected multi table in arrayref');

Test::More::is(Basset::DB::Table->multiselect_query('cols' => ['able', 'baker'], 'tables' => [$o, $o2]),
"select\n" . (join(",\n",map {"\t$_"} ('able'))) 
. ",\n" . (join(",\n",map {"\t$_"} ('baker'))) . "\nfrom\n" .
"table1
	inner join
		table2
			on table1.able = table2.aid",
'multi selected multi table in arrayref with differing columns');

Test::More::is(Basset::DB::Table->multiselect_query('use_aliases' => 1, 'tables' => [$o, $o2]),
"select\n" . (join(",\n",map {"\ttable1.$_ as " . $o2->alias_column($_)} @o1select)) 
. ",\n" . (join(",\n",map {"\ttable2.$_ as " . $o2->alias_column($_)} @o2select)) . "\nfrom\n" .
"table1
	inner join
		table2
			on table1.able = table2.aid",
'multi selected multi table in arrayref with aliases');
};
{
#line 3439  count_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

Test::More::is($o->name('count_query_table'), 'count_query_table', 'Set table name');
Test::More::is($o->count_query, 'select count(1) as count from count_query_table', 'Got count query');
};
{
#line 3469  optimize_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is($o->name("test table"), "test table", "set table name");
Test::More::is($o->optimize_query, 'optimize table test table', "got optimize query");
};
{
#line 3498  describe_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");
Test::More::is($o->name("test table"), "test table", "set table name");
Test::More::is($o->describe_query, 'desc test table', "got desc query");
};
{
#line 3537  reference_query

my $def = {
	'user_id' => 'SQL_INTEGER',
	'user_name' => 'SQL_VARCHAR',
};

my $foreign = {
	'user_id' => 'user.id',
	'user_name' => 'user.name'
};

my $o = Basset::DB::Table->new(
	'definition' => $def,
	'references' => $foreign,
);
Test::More::ok($o, "Got object");
Test::More::is($o->definition, $def, "proper definition");
Test::More::is($o->references, $foreign, "proper foreign references");

my $f2 = {%$foreign};

Test::More::is($o->references($f2), $f2, "properly reset foreign reference");

Test::More::is($o->reference_query('user_id'), "select count(1) as count from user\n  where id = ?", "successful reference query");
Test::More::is($o->reference_query('user_name'), "select count(1) as count from user\n  where name = ?", "successful reference query");

Test::More::is(scalar($o->reference_query('foo')), undef, "got nothing for non-referenced column");
Test::More::is($o->errcode, "BDT-14", "Proper error code");
};
{
#line 3601  is_column

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::ok($o->is_column('able'), 'able is column');
Test::More::ok($o->is_column('baker'), 'baker is column');
Test::More::ok($o->is_column('charlie'), 'charlie is column');
Test::More::ok($o->is_column('delta'), 'delta is column');
Test::More::is($o->is_column('edgar'), 0, 'edgar is not column');
Test::More::is($o->is_column('foxtrot'), 0, 'foxtrot is not column');

Test::More::is(scalar($o->is_column), undef, "Cannot call w/o column");
Test::More::is($o->errcode, "BDT-04", "proper error code");
};
{
#line 3651  is_primary

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->primary_column('able'), 'able', 'Set primary column');;

Test::More::is(scalar($o->is_primary), undef, 'Cannot determine primary-ness w/o a column');
Test::More::is($o->errcode, 'BDT-01', 'proper error code');

Test::More::ok($o->is_primary('able'), 'able is primary');
Test::More::is($o->is_primary('baker'), 0, 'baker is not primary');
Test::More::is($o->is_primary('charlie'), 0, 'charlie is not primary');
Test::More::is($o->is_primary('delta'), 0, 'delta is not primary');
Test::More::is($o->is_primary('edgar'), 0, 'edgar is not primary');
Test::More::is($o->is_primary('foxtrot'), 0, 'foxtrot is not primary');

my $primaries = [qw(baker delta)];

Test::More::is($o->primary_column($primaries), $primaries, 'set primary column');

Test::More::is($o->is_primary('able'), 0, 'able is not primary');
Test::More::is($o->is_primary('baker'), 1, 'baker is primary');
Test::More::is($o->is_primary('charlie'), 0, 'charlie is not primary');
Test::More::is($o->is_primary('delta'), 1, 'delta is primary');
Test::More::is($o->is_primary('edgar'), 0, 'edgar is not primary');
Test::More::is($o->is_primary('foxtrot'), 0, 'foxtrot is not primary');

Test::More::is(scalar($o->is_primary), undef, "Cannot call w/o column");
Test::More::is($o->errcode, "BDT-01", "proper error code");
};
{
#line 3715  non_primary_cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");

{
	my %primary = map {$_, 1} $o->non_primary_cols;

	Test::More::is($primary{'able'}, 1, 'able is not primary column');
	Test::More::is($primary{'baker'}, 1, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, 1, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, 1, 'delta is not primary column');
}

{
	$o->primary_column('able');

	my %primary = map {$_, 1} $o->non_primary_cols;

	Test::More::is($primary{'able'}, undef, 'able is primary column');
	Test::More::is($primary{'baker'}, 1, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, 1, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, 1, 'delta is not primary column');
}

{
	$o->primary_column(['charlie', 'delta']);

	my %primary = map {$_, 1} $o->non_primary_cols;

	Test::More::is($primary{'able'}, 1, 'able is not primary column');
	Test::More::is($primary{'baker'}, 1, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, undef, 'charlie is primary column');
	Test::More::is($primary{'delta'}, undef, 'delta is primary column');
}
};
{
#line 3781  primary_cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");

{
	my %primary = map {$_, 1} grep {defined} $o->primary_cols;

	Test::More::is($primary{'able'}, undef, 'able is not primary column');
	Test::More::is($primary{'baker'}, undef, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, undef, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, undef, 'delta is not primary column');
}

{
	$o->primary_column('able');

	my %primary = map {$_, 1} $o->primary_cols;

	Test::More::is($primary{'able'}, 1, 'able is primary column');
	Test::More::is($primary{'baker'}, undef, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, undef, 'charlie is not primary column');
	Test::More::is($primary{'delta'}, undef, 'delta is not primary column');
}

{
	$o->primary_column(['charlie', 'delta']);

	my %primary = map {$_, 1} $o->primary_cols;

	Test::More::is($primary{'able'}, undef, 'able is not primary column');
	Test::More::is($primary{'baker'}, undef, 'baker is not primary column');
	Test::More::is($primary{'charlie'}, 1, 'charlie is primary column');
	Test::More::is($primary{'delta'}, 1, 'delta is primary column');
}
};
{
#line 3865  foreign_cols

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->name('tableone'), 'tableone', 'set object 1 name');
Test::More::ok($o->primary_column(['able', 'baker']), 'set object 1 primary columns');

my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Created object 2");
my $def2 = {
	'edgar' => 'SQL_VARCHAR',
	'foxtrot' => 'SQL_DATE',
	'goats' => 'SQL_TIMESTAMP',
	'henry' => 'SQL_FLOAT'
};

Test::More::is($o2->definition($def2), $def2, "set object 2 definition");
Test::More::is($o2->name('tabletoo'), 'tabletoo', "set object 2 name");
Test::More::ok($o2->primary_column(['edgar', 'foxtrot']), 'set object 2 primary columns');

my $ref1 = {
	'able' => 'tabletoo.edgar',
	'baker' => 'tabletoo.foxtrot',
	'charlie' => 'tablethree.col'
};

Test::More::is($o->references($ref1), $ref1, "Set reference 1");

my $o3 = Basset::DB::Table->new();
Test::More::ok($o3, "Created object 3");
my $def3 = {
	'col' => 'SQL_VARCHAR',
};

Test::More::is($o3->definition($def3), $def3, "set object 3 definition");
Test::More::is($o3->name('tablethree'), 'tablethree', "set object 3 name");

my $o4 = Basset::DB::Table->new();
Test::More::ok($o4, "Created object 4");
Test::More::is($o4->name('tablefour'), 'tablefour', "set object 4 name");


Test::More::is(scalar($o->foreign_cols), undef, "Cannot get foreign cols w/o table");
Test::More::is($o->errcode, 'BDT-45', "Proper error code");

{
	my $i = 1;
	my %f1 = map {$_, $i++} $o->foreign_cols($o2);
	Test::More::is($f1{'able'}, 1, 'able is foreign column');
	Test::More::is($f1{'baker'}, 2, 'baker is foreign column');
	Test::More::is(scalar (keys %f1), 2, 'only 2 foreign columns');
}

{
	my %f2 = map {$_, 1} $o->foreign_cols($o3);
	Test::More::is(scalar (keys %f2), 0, 'object 1 references no primary columns in object 3');
}

{
	my %f2 = map {$_, 1} $o->foreign_cols($o3, 'col');
	Test::More::is($f2{'charlie'}, 1, 'charlie is foreign column');
	Test::More::is(scalar (keys %f2), 1, 'only 1 foreign column');
}
};
{
#line 3977  referenced_column

my $def = {
	'user_id' => 'SQL_INTEGER',
	'user_name' => 'SQL_VARCHAR',
	'user_extra' => 'SQL_VARCHAR',
};

my $foreign = {
	'user_id' => 'user.id',
	'user_name' => 'user.name'
};

my $o = Basset::DB::Table->new(
	'definition' => $def,
	'references' => $foreign,
);
Test::More::ok($o, "Got object");
Test::More::is($o->definition, $def, "proper definition");
Test::More::is($o->references, $foreign, "proper foreign references");

my $f2 = {%$foreign};

Test::More::is($o->references($f2), $f2, "properly reset foreign reference");

Test::More::is(scalar($o->referenced_column), undef, "Cannot get referenced column w/o column");
Test::More::is($o->errcode, "BDT-15", "proper error code");

Test::More::is($o->referenced_column('user_id'), 'user.id', 'user_id properly referenced');
Test::More::is($o->referenced_column('user_name'), 'user.name', 'user_id properly referenced');
Test::More::is(scalar($o->referenced_column('user_extra')), undef, 'user_id properly referenced');
Test::More::is($o->errcode, "BDT-16", "proper error code");
};
{
#line 4094  attach_to_query

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");

Test::More::is($o->name('mytable'), 'mytable', 'set table name');

Test::More::is(scalar($o->attach_to_query), undef, "Cannot attach to query w/o query");
Test::More::is($o->errcode, "BDT-02", "proper error code");

Test::More::is($o->select_query, 'select mytable.able as able from mytable', 'proper select query');
my $query = $o->select_query;
Test::More::is(scalar($o->attach_to_query($query)), $query, "No clauses returns original query");
Test::More::is(scalar($o->attach_to_query($query, {})), $query, "Empty clauses returns original query");
Test::More::is(scalar($o->attach_to_query($query, {'having' => 'having clause'})), undef, "Cannot have having w/o group");
Test::More::is($o->errcode, "BDT-09", "proper error code");

Test::More::is($o->attach_to_query($query, {'where' => 'able = ?'}), $query . "\n  where able = ?", "attached where clause");
Test::More::is($o->attach_to_query($query, {'group by' => 'able'}), $query . "\n  group by able", "attached group by clause");
Test::More::is($o->attach_to_query($query, {'order by' => 'baker'}), $query . "\n  order by baker", "attached order by clause");
Test::More::is($o->attach_to_query($query, {'limit' => '5'}), $query . "\n  limit 5", "attached limit clause");

Test::More::is(
	$o->attach_to_query(
		$query, 
		{
			'where' => 'able = ?',
			'group by' => 'baker',
		}
	), $query . "\n  where able = ?\n  group by baker", "attached where and group by clause");

Test::More::is(
	$o->attach_to_query(
		$query, 
		{
			'where' => 'able = ?',
			'group by' => 'baker',
			'having' => 'count(*) > 1'
		}
	), $query . "\n  where able = ?\n  group by baker\n  having count(*) > 1", "attached where, group by, and having clause");
};
{
#line 4299  join_tables

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Created object");

my $o3 = Basset::DB::Table->new();
Test::More::ok($o3, "Created object");

my $o4 = Basset::DB::Table->new();
Test::More::ok($o4, "Created object");

my $def1 = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

my $ref1 = {
	'able' => 'table2.aid',
	'baker' => 'table4.b',
	'charlie' => 'table4.c',
};

Test::More::is($o->definition($def1), $def1, "Set definition");
Test::More::is($o->references($ref1), $ref1, "Set references");
Test::More::is($o->name("table1"), "table1", "set table name");
Test::More::is($o->primary_column("able"), "able", "set table primary id");

my $def2 = {
	'aid' => 'SQL_INTEGER',
	'bid' => 'SQL_INTEGER',
	'cid' => 'SQL_INTEGER',
	'did' => 'SQL_INTEGER'
};

my $ref2 = {
	'aid' => 'table3.ace'
};

Test::More::is($o2->definition($def2), $def2, "Set definition");
Test::More::is($o2->references($ref2), $ref2, "Set references");
Test::More::is($o2->name("table2"), "table2", "set table name");
Test::More::is($o2->primary_column("aid"), "aid", "set table primary id");

my $def3 = {
	'ace' => 'SQL_INTEGER',
	'bogey' => 'SQL_INTEGER',
};

Test::More::is($o3->definition($def3), $def3, "Set definition");
Test::More::is($o3->name("table3"), "table3", "set table name");
Test::More::is($o3->primary_column("ace"), "ace", "set table primary id");

my $def4 = {
	'a' => 'SQL_INTEGER',
	'b' => 'SQL_INTEGER',
	'c' => 'SQL_INTEGER',
	'd' => 'SQL_INTEGER'
};

Test::More::is($o4->definition($def4), $def4, "Set definition");
Test::More::is($o4->name("table4"), "table4", "set table name");
Test::More::ok($o4->primary_column([qw(b c)]), "set table primary id");


Test::More::is(scalar(Basset::DB::Table->join_tables), undef, "Could not join w/o tables");
Test::More::is(Basset::DB::Table->errcode, "BDT-28", "proper error code BDT-28");

Test::More::is(Basset::DB::Table->join_tables($o), "table1", "Join with one table is same table");

Test::More::is(Basset::DB::Table->join_tables($o, $o2),
"table1
	inner join
		table2
			on table1.able = table2.aid",
"Default joined two tables"
);

Test::More::is(Basset::DB::Table->join_tables($o2, $o),
"table2
	inner join
		table1
			on table1.able = table2.aid",
"Reverse  joined two tables"
);

Test::More::is(Basset::DB::Table->join_tables($o, $o2, $o3),
"table1
	inner join
		table2
			on table1.able = table2.aid
	inner join
		table3
			on table2.aid = table3.ace",
"Default joined three tables"
);
Test::More::is(Basset::DB::Table->join_tables($o, $o2, $o3, $o4),
"table1
	inner join
		table2
			on table1.able = table2.aid
	inner join
		table3
			on table2.aid = table3.ace
	inner join
		table4
			on table1.baker = table4.b
			and table1.charlie = table4.c",
"Default joined four tables"
);

Test::More::is(Basset::DB::Table->join_tables($o, [$o2]),
"table1
	inner join
		table2
			on table1.able = table2.aid",
"Default joined two tables w/arrayref table only"
);

Test::More::is(Basset::DB::Table->join_tables($o, ['inner',$o2]),
"table1
	inner join
		table2
			on table1.able = table2.aid",
"inner joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['outer',$o2]),
"table1
	outer join
		table2
			on table1.able = table2.aid",
"outer joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['natural',$o2]),
"table1
	natural join
		table2",
"natural joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['left',$o2]),
"table1
	left join
		table2
			on table1.able = table2.aid",
"left joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['right',$o2]),
"table1
	right join
		table2
			on table1.able = table2.aid",
"right joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['left outer',$o2]),
"table1
	left outer join
		table2
			on table1.able = table2.aid",
"left outer joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, ['right outer',$o2]),
"table1
	right outer join
		table2
			on table1.able = table2.aid",
"right outer joined 2 tables");

Test::More::is(Basset::DB::Table->join_tables($o, [$o4, 'table1.baker = table4.b']),
"table1
	inner join
		table4
			on table1.baker = table4.b",
"joined 2 tables with alternate clause");

Test::More::is(Basset::DB::Table->join_tables($o, ['outer', $o4, 'table1.baker = table4.b']),
"table1
	outer join
		table4
			on table1.baker = table4.b",
"outer joined 2 tables with 3 arg alternate clause");

Test::More::is(Basset::DB::Table->join_tables($o, [$o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	inner join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"joined 2 tables with 2 alternate clauses");

Test::More::is(Basset::DB::Table->join_tables($o, ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses");

Test::More::is(Basset::DB::Table->join_tables(['inner', $o], ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses w/ first table array");

Test::More::is(Basset::DB::Table->join_tables(['inner', $o, 'foo = bar'], ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses w/ first table array and columns");

Test::More::is(Basset::DB::Table->join_tables([$o, 'foo = bar'], ['outer', $o4, ['table1.baker = table4.b', 'table1.baker = table4.c']]),
"table1
	outer join
		table4
			on table1.baker = table4.b
			and table1.baker = table4.c",
"outer joined 2 tables with 2 alternate clauses w/ first table array and columns, non-inner");

Test::More::is(scalar(Basset::DB::Table->join_tables($o, $o3)), undef, "Cannot auto-join unreferenced tables");
Test::More::is(Basset::DB::Table->errcode, 'BDT-27', 'proper error code');
};
{
#line 4649  many_clause

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $def = {
	'able' => 'SQL_INTEGER',
	'baker' => 'SQL_INTEGER',
	'charlie' => 'SQL_INTEGER',
	'delta' => 'SQL_INTEGER'
};

Test::More::is($o->definition($def), $def, "Set definition");
Test::More::is($o->definition, $def, "Got definition");
Test::More::is($o->name('test'), 'test', 'set name');

Test::More::is(scalar($o->many_clause), undef, "Cannot build many clause w/o column");
Test::More::is($o->errcode, 'BDT-21', 'proper error code');

Test::More::is(scalar($o->many_clause('able')), undef, "Cannot build many clause w/o values");
Test::More::is($o->errcode, 'BDT-22', 'proper error code');

Test::More::is(scalar($o->many_clause('able', [])), undef, "Cannot build many clause w/o values");
Test::More::is($o->errcode, 'BDT-22', 'proper error code');

Test::More::is($o->many_clause('able', 1), 'test.able in (?)', 'built single many clause');
Test::More::is($o->many_clause('able', 1, 2), 'test.able in (?, ?)', 'built double many clause');
Test::More::is($o->many_clause('able', 1, 2, 3), 'test.able in (?, ?, ?)', 'built triple many clause');

Test::More::is($o->many_clause('able', [1]), 'test.able in (?)', 'built single many clause from arrayref');
Test::More::is($o->many_clause('able', [1, 2]), 'test.able in (?, ?)', 'built double many clause from arrayref');
Test::More::is($o->many_clause('able', [1, 2, 3]), 'test.able in (?, ?, ?)', 'built triple many clause from arrayref');

Test::More::is($o->many_clause('able', 'not', [1]), 'test.able not in (?)', 'built single not many clause');
Test::More::is($o->many_clause('able', 'not', [1, 2]), 'test.able not in (?, ?)', 'built double not many clause');
Test::More::is($o->many_clause('able', 'not', [1, 2, 3]), 'test.able not in (?, ?, ?)', 'built triple not many clause');
Test::More::is($o->many_clause('able', 1, [1, 2, 3]), 'test.able not in (?, ?, ?)', 'built triple not many clause w/arbitrary true value');
};
{
#line 4705  qualified_name

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

Test::More::is(scalar($o->qualified_name()), undef, 'could not get qualified name w/o column');

Test::More::is($o->errcode, 'BDT-23', 'Proper error code');
Test::More::is(scalar($o->qualified_name('foo')), undef, 'could not get qualified name w/o table name');
Test::More::is($o->errcode, 'BDT-24', 'Proper error code');
Test::More::is($o->name('test1'), 'test1', 'Set table name');
Test::More::is($o->qualified_name('foo'), 'test1.foo', 'column foo properly qualified');
Test::More::is($o->qualified_name('bar'), 'test1.bar', 'column bar properly qualified');
Test::More::is($o->name('test2'), 'test2', 'changed column name to test2');
Test::More::is($o->qualified_name('foo'), 'test2.foo', 'column foo properly qualified');
Test::More::is($o->qualified_name('bar'), 'test2.bar', 'column bar properly qualified');
Test::More::is($o->qualified_name('test2.foo'), 'test2.foo', 'previously column test2.foo properly qualified');
Test::More::is($o->qualified_name('test2.bar'), 'test2.bar', 'previously column test2.bar properly qualified');
};
{
#line 4764  nonqualified_name

Test::More::is(scalar(Basset::DB::Table->nonqualified_name()), undef, "Could not get nonqualified name w/o column");
Test::More::is(Basset::DB::Table->nonqualified_name('foo.bar'), 'bar', 'stripped table name');
Test::More::is(Basset::DB::Table->nonqualified_name('bar'), 'bar', 'returned column w/o table name');
};
{
#line 4973  construct_where_clause

Test::More::ok(! Basset::DB::Table->construct_where_clause, "Cannot construct_where_clause w/o tables");
Test::More::is(Basset::DB::Table->errcode, "BDT-48", 'proper error code');

my $t1 = Basset::DB::Table->new(
	'name'				=> 't1',
	'primary_column'	=> 'id',
	'definition'	=> {
		'id' => 'SQL_INTEGER',
		'name' => 'SQL_VARCHAR',
	}
);

Test::More::ok($t1, 'built first table');

my $t2 = Basset::DB::Table->new(
	'name'				=> 't2',
	'primary_column'	=> 'id',
	'definition'	=> {
		'id' => 'SQL_INTEGER',
		'size' => 'SQL_VARCHAR',
	}
);

Test::More::ok($t2, 'built second table');

my $one_table = [$t1];
my $two_tables = [$t1, $t2];

Test::More::ok(! Basset::DB::Table->construct_where_clause($one_table), "Cannot construct_where_clause w/o clauses");
Test::More::is(Basset::DB::Table->errcode, "BDT-49", 'proper error code');

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, 'name' => 'foo');
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t1.name = ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], 'foo', 'proper value');
}

{
	Test::More::ok(!Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, 'name' => 'foo', 'bar' => 'baz'),
		'could not construct_where_clause w/non-existent column');
	Test::More::is(Basset::DB::Table->errcode, 'BDT-50', 'proper error code');
}

{
	Test::More::ok(!Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, 'name' => 'foo', ['bar' => 'baz']),
		'could not construct_where_clause w/non-existent column');
	Test::More::is(Basset::DB::Table->errcode, 'BDT-50', 'proper error code');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => [qw(a b c)]);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id in (?, ?, ?)', 'proper clause');
	Test::More::is($return[1], 'a', 'proper value');
	Test::More::is($return[2], 'b', 'proper value');
	Test::More::is($return[3], 'c', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1});
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id > ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1, '<' => 10});
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], '(t1.id > ? OR t1.id < ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '10', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1, '<' => 10}, 'name' => 'you');
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], '(t1.id > ? OR t1.id < ?) AND t1.name = ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '10', 'proper value');
	Test::More::is($return[3], 'you', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => {'>' => 1}, 'id' => {'<' => 10});
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id > ? AND t1.id < ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '10', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, ['name' => 'me', 'id' => 3]);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], 'me', 'proper value');
	Test::More::is($return[3], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($one_table, 'id' => 1, ['name' => 'me', 'id' => 3], 'id' => 5);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t1.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '5', 'proper value');
	Test::More::is($return[3], 'me', 'proper value');
	Test::More::is($return[4], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => 1, ['name' => 'me', 'id' => 3], 'id' => 5);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t1.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '5', 'proper value');
	Test::More::is($return[3], 'me', 'proper value');
	Test::More::is($return[4], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => 1, ['name' => 'me', 'id' => 3], 't2.id' => 5);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t2.id = ? OR (t1.name = ? AND t1.id = ?)', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '5', 'proper value');
	Test::More::is($return[3], 'me', 'proper value');
	Test::More::is($return[4], '3', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => 1, 'size' => 7);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = ? AND t2.size = ?', 'proper clause');
	Test::More::is($return[1], '1', 'proper value');
	Test::More::is($return[2], '7', 'proper value');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => \1, 'size' => \7);
	Test::More::is(scalar(@return), 1, "got values from constructing where clause");
	Test::More::is($return[0], 't1.id = 1 AND t2.size = 7', 'proper clause');
}

{
	my @return = Basset::DB::Table->construct_where_clause($two_tables, 'id' => {'is' => \'NULL'}, 'size' => 7);
	Test::More::ok(scalar(@return), "got values from constructing where clause");
	Test::More::is($return[0], 't1.id is NULL AND t2.size = ?', 'proper clause');
	Test::More::is($return[1], '7', 'proper value');
}
};
{
#line 5150  arbitrary_sql

my $poclass = Basset::DB::Table->pkg->pkg_for_type('persistentobject');

Test::More::ok($poclass, "Got persistent object class");
Test::More::ok($poclass->can('arbitrary_sql'), 'persistent class can arbitrary_sql');
};
{		Test::More::ok(1, "uses strict");
		Test::More::ok(1, "uses warnings");
};
{#line 213 add_attr
sub test_accessor {
	my $self = shift;
	my $prop = shift;
	my $extra = shift;

	return $self->error("Not a class attribute", "BO-08") unless ref $self;

	return $extra;
};

Test::More::ok(\&Basset::DB::Table::test_accessor, "Added test accessor");

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Object created");

Test::More::ok(Basset::DB::Table->add_attr('test_attribute1'), "Added attribute for _accessor");
Test::More::ok($o->can('test_attribute1'), "Object sees attribute");
Test::More::ok(Basset::DB::Table->can('test_attribute1'), "Class sees attribute");

Test::More::is($o->test_attribute1('testval1'), 'testval1', "Method test_attribute1 mutates");
Test::More::is($o->test_attribute1(), 'testval1', "Method test_attribute1 accesses");
Test::More::is($o->test_attribute1(undef), undef, "Method test_attribute1 deletes");

Test::More::is(scalar Basset::DB::Table->test_attribute1('testval17'), undef, "Class fails to mutate");
Test::More::is(scalar Basset::DB::Table->test_attribute1(), undef, "Class fails to access");
Test::More::is(scalar Basset::DB::Table->test_attribute1(undef), undef, "Class fails to delete");

Test::More::ok(Basset::DB::Table->add_attr(['test_attribute2', 'test_accessor'], 'excess'), "Added attribute for test_accessor");
Test::More::ok($o->can('test_attribute2'), "Object sees attribute");
Test::More::ok(Basset::DB::Table->can('test_attribute2'), "Class sees attribute");

Test::More::is($o->test_attribute2('testval2'), 'excess', "Method test_attribute2 mutates");
Test::More::is($o->test_attribute2(), 'excess', "Method test_attribute2 accesses");
Test::More::is($o->test_attribute2(undef), 'excess', "Method test_attribute2 deletes");

Test::More::is(scalar Basset::DB::Table->test_attribute2('testval18'), undef, "Class fails to mutate");
Test::More::is(scalar Basset::DB::Table->test_attribute2(), undef, "Class fails to access");
Test::More::is(scalar Basset::DB::Table->test_attribute2(undef), undef, "Class fails to delete");

Test::More::ok(Basset::DB::Table->add_attr('test_attribute3', 'static'), "Added static attribute");
Test::More::ok($o->can('test_attribute3'), "Object sees attribute");
Test::More::ok(Basset::DB::Table->can('test_attribute3'), "Class sees attribute");

Test::More::is($o->test_attribute3('status'), 'static', "Method test_attribute3 mutates");
Test::More::is($o->test_attribute3(), 'static', "Method test_attribute3 accesses");
Test::More::is($o->test_attribute3(undef), 'static', "Method test_attribute3 deletes");

Test::More::is(scalar Basset::DB::Table->test_attribute3('testval19'), undef, "Class fails to mutate");
Test::More::is(scalar Basset::DB::Table->test_attribute3(), undef, "Class fails to access");
Test::More::is(scalar Basset::DB::Table->test_attribute3(undef), undef, "Class fails to delete");

Test::More::ok(Basset::DB::Table->add_attr(['test_attribute4', '_regex_accessor'], '^\d+$', 'Numbers only', 'test code'), "Added numeric only regex attribute");
Test::More::ok($o->can('test_attribute4'), "Object sees attribute");
Test::More::ok(Basset::DB::Table->can('test_attribute4'), "Class sees attribute");

Test::More::isnt(scalar $o->test_attribute4('foo'), 'foo', "Method test_attribute4 fails to set non-numeric");
Test::More::is($o->error, "Numbers only", "Proper object error message");
Test::More::is($o->errcode, "test code", "Proper object error code");
Test::More::isnt(scalar $o->test_attribute4('1234567890a'), '1234567890a', "Method test_attribute4 fails to set non-numeric");
Test::More::is($o->error, "Numbers only", "Proper object error message");
Test::More::is($o->errcode, "test code", "Proper object error code");
Test::More::isnt(scalar $o->test_attribute4('a1234567890'), 'a1234567890', "Method test_attribute4 fails to set non-numeric");
Test::More::is($o->error, "Numbers only", "Proper object error message");
Test::More::is($o->errcode, "test code", "Proper object error code");
Test::More::isnt(scalar $o->test_attribute4('123456a7890'), '123456a7890', "Method test_attribute4 fails to set non-numeric");
Test::More::is($o->error, "Numbers only", "Proper object error message");
Test::More::is($o->errcode, "test code", "Proper object error code");
Test::More::is(scalar $o->test_attribute4('12345'), '12345', "Method test_attribute4 mutates");
Test::More::is(scalar $o->test_attribute4(), '12345', "Method test_attribute4 accesses");
Test::More::is(scalar $o->test_attribute4(undef), undef, "Method test_attribute4 deletes");

Test::More::is(scalar Basset::DB::Table->test_attribute4('testval20'), undef, "Class fails to mutate");
Test::More::is(scalar Basset::DB::Table->test_attribute4(), undef, "Class fails to access");
Test::More::is(scalar Basset::DB::Table->test_attribute4(undef), undef, "Class fails to delete");

Test::More::ok(Basset::DB::Table->add_attr(['test_attribute5', '_regex_accessor'], 'abcD', 'Must contain abcD', 'test code2'), "Added abcD only regex attribute");
Test::More::ok($o->can('test_attribute5'), "Object sees attribute");
Test::More::ok(Basset::DB::Table->can('test_attribute5'), "Class sees attribute");

Test::More::isnt(scalar $o->test_attribute5('foo'), 'foo', "Method test_attribute4 fails to set non-abcD");
Test::More::is($o->error, "Must contain abcD", "Proper object error message");
Test::More::is($o->errcode, "test code2", "Proper object error code");
Test::More::isnt(scalar $o->test_attribute5('abc'), 'abc', "Method test_attribute4 fails to set non-abcD");
Test::More::is($o->error, "Must contain abcD", "Proper object error message");
Test::More::is($o->errcode, "test code2", "Proper object error code");
Test::More::isnt(scalar $o->test_attribute5('bcD'), 'bcD', "Method test_attribute4 fails to set non-abcD");
Test::More::is($o->error, "Must contain abcD", "Proper object error message");
Test::More::is($o->errcode, "test code2", "Proper object error code");
Test::More::isnt(scalar $o->test_attribute5('abD'), 'abD', "Method test_attribute4 fails to set non-abcD");
Test::More::is($o->error, "Must contain abcD", "Proper object error message");
Test::More::is($o->errcode, "test code2", "Proper object error code");
Test::More::is(scalar $o->test_attribute5('abcD'), 'abcD', "Method test_attribute5 mutates");
Test::More::is(scalar $o->test_attribute5('abcDE'), 'abcDE', "Method test_attribute5 mutates");
Test::More::is(scalar $o->test_attribute5('1abcD'), '1abcD', "Method test_attribute5 mutates");
Test::More::is(scalar $o->test_attribute5('zabcDz'), 'zabcDz', "Method test_attribute5 mutates");
Test::More::is(scalar $o->test_attribute5(), 'zabcDz', "Method test_attribute5 accesses");
Test::More::is(scalar $o->test_attribute5(undef), undef, "Method test_attribute5 deletes");

Test::More::is(scalar Basset::DB::Table->test_attribute5('testval20'), undef, "Class fails to mutate");
Test::More::is(scalar Basset::DB::Table->test_attribute5(), undef, "Class fails to access");
Test::More::is(scalar Basset::DB::Table->test_attribute5(undef), undef, "Class fails to delete");
};
{#line 375 add_class_attr
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Object created");

Test::More::ok(Basset::DB::Table->add_class_attr('test_class_attribute_1'), "Added test class attribute");
Test::More::ok($o->can("test_class_attribute_1"), "object can see class attribute");
Test::More::ok(Basset::DB::Table->can("test_class_attribute_1"), "class can see class attribute");

Test::More::is(Basset::DB::Table->test_class_attribute_1('test value 1'), 'test value 1', 'class method call mutates');
Test::More::is(Basset::DB::Table->test_class_attribute_1(), 'test value 1', 'class method call accesses');
Test::More::is(Basset::DB::Table->test_class_attribute_1(undef), undef, 'class method call deletes');

Test::More::is($o->test_class_attribute_1('test value 2'), 'test value 2', 'object method call mutates');
Test::More::is($o->test_class_attribute_1(), 'test value 2', 'object method call accesses');
Test::More::is($o->test_class_attribute_1(undef), undef, 'object method call deletes');

Test::More::ok(Basset::DB::Table->add_class_attr('test_class_attribute_2', 14), "Added test class attribute 2");
Test::More::ok($o->can("test_class_attribute_2"), "object can see class attribute");
Test::More::ok(Basset::DB::Table->can("test_class_attribute_2"), "class can see class attribute");

Test::More::is(Basset::DB::Table->test_class_attribute_2(), 14, "Class has default arg");
Test::More::is(Basset::DB::Table->test_class_attribute_2(), 14, "Object has default arg");

Test::More::is(Basset::DB::Table->test_class_attribute_2('test value 3'), 'test value 3', 'class method call mutates');
Test::More::is(Basset::DB::Table->test_class_attribute_2(), 'test value 3', 'class method call accesses');
Test::More::is(Basset::DB::Table->test_class_attribute_2(undef), undef, 'class method call deletes');

Test::More::is($o->test_class_attribute_1('test value 4'), 'test value 4', 'class method call mutates');
Test::More::is($o->test_class_attribute_1(), 'test value 4', 'object method call accesses');
Test::More::is($o->test_class_attribute_1(undef), undef, 'object method call deletes');

package Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

my $so = Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->new();
Test::More::ok($so, "Sub-Object created");

Test::More::is(scalar Basset::DB::Table->test_class_attribute_1("newer test val"), "newer test val", "trickle method class re-mutates");

Test::More::is(scalar $so->test_class_attribute_1(), "newer test val", "trickle method sub-object accesses super");

Test::More::is(scalar $so->test_class_attribute_1("testval3"), "testval3", "trickle method sub-object mutates");
Test::More::is(scalar $so->test_class_attribute_1(), "testval3", "trickle method sub-object accesses");
Test::More::is(scalar $so->test_class_attribute_1(undef), undef, "trickle method sub-object deletes");

Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->test_class_attribute_1("testval4"), "testval4", "trickle method class mutates");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->test_class_attribute_1(), "testval4", "trickle method subclass accesses");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->test_class_attribute_1(undef), undef, "trickle method subclass deletes");

Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->test_class_attribute_1("sub value"), "sub value", "Subclass re-mutates");
Test::More::is(scalar Basset::DB::Table->test_class_attribute_1(), "sub value", "Super class affected on access");

Test::More::is(scalar Basset::DB::Table->test_class_attribute_1("super value"), "super value", "Super class re-mutates");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->test_class_attribute_1(), "super value", "Sub class affected on access");

package Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass5;
our @ISA = qw(Basset::DB::Table);

sub conf {
	return undef;
};

package Basset::DB::Table;

{

	local $@ = undef;

	eval {
		Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass5->add_class_attr('test_class_attr');
	};

	Test::More::like($@, qr/^Conf file error :/, 'could not add class attr w/o conf file');
}

my $conf = Basset::DB::Table->conf();
$conf->{'Basset::DB::Table'}->{'_test_attribute'} = 'test value';

Test::More::ok(Basset::DB::Table->add_class_attr('_test_attribute'), 'added test attribute');
Test::More::is(Basset::DB::Table->_test_attribute, 'test value', 'populated with value from conf fiel');
};
{#line 605 add_trickle_class_attr
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Object created");

Test::More::ok(Basset::DB::Table->add_trickle_class_attr('trick_attr1'), "Added test trickle class attribute");
Test::More::ok($o->can("trick_attr1"), "object can see trickle class attribute");
Test::More::ok(Basset::DB::Table->can("trick_attr1"), "class can see trickle class attribute");

package Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

my $so = Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->new();
Test::More::ok($so, "Sub-Object created");

Test::More::is(scalar $o->trick_attr1("testval1"), "testval1", "trickle method object mutates");
Test::More::is(scalar $o->trick_attr1(), "testval1", "trickle method object accesses");
Test::More::is(scalar $o->trick_attr1(undef), undef, "trickle method object deletes");

Test::More::is(scalar Basset::DB::Table->trick_attr1("testval2"), "testval2", "trickle method class mutates");
Test::More::is(scalar Basset::DB::Table->trick_attr1(), "testval2", "trickle method class accesses");
Test::More::is(scalar Basset::DB::Table->trick_attr1(undef), undef, "trickle method class deletes");
Test::More::is(scalar Basset::DB::Table->trick_attr1("newer test val"), "newer test val", "trickle method class re-mutates");

Test::More::is(scalar $so->trick_attr1(), "newer test val", "trickle method sub-object accesses super");

Test::More::is(scalar $so->trick_attr1("testval3"), "testval3", "trickle method sub-object mutates");
Test::More::is(scalar $so->trick_attr1(), "testval3", "trickle method sub-object accesses");
Test::More::is(scalar $so->trick_attr1(undef), undef, "trickle method sub-object deletes");

Test::More::is(scalar Basset::DB::Table->trick_attr1("supertestval"), "supertestval", "super trickle method class mutates");
Test::More::is(Basset::DB::Table->trick_attr1(), "supertestval", "trickle method class accesses");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->trick_attr1("testval4"), "testval4", "trickle method class mutates");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->trick_attr1(), "testval4", "trickle method subclass accesses");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->trick_attr1(undef), undef, "trickle method subclass deletes");
Test::More::is(Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->trick_attr1(), undef, "subclass still sees undef as value");

Test::More::is(scalar Basset::DB::Table->trick_attr1("super value"), "super value", "Super class re-mutates");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->trick_attr1("sub value"), "sub value", "Subclass re-mutates");

Test::More::is(scalar Basset::DB::Table->trick_attr1(), "super value", "Super class unaffected on access");
Test::More::is(scalar Basset::DB::Table->trick_attr1("new super value"), "new super value", "Super class re-mutates");
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_class_attr::Subclass1->trick_attr1(), "sub value", "Sub class unaffected on access");

package Basset::Test::Testing::Basset::DB::Table::add_trickle_class_attr::Subclass5;
our @ISA = qw(Basset::DB::Table);

sub conf {
	return undef;
};

package Basset::DB::Table;

{
	local $@ = undef;
	eval {
		Basset::Test::Testing::Basset::DB::Table::add_trickle_class_attr::Subclass5->add_class_attr('test_trickle_attr');
	};
	Test::More::like($@, qr/^Conf file error :/, 'could not add trickle class attr w/o conf file');
}
};
{#line 739 add_default_attr
package Basset::Test::Testing::Basset::DB::Table::add_default_class_attr::subclass;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::add_default_class_attr::subclass->add_default_class_attr('some_test_attr'), "Added default class attribute");

package Basset::Test::Testing::Basset::DB::Table::add_default_class_attr::Subclass5;
our @ISA = qw(Basset::DB::Table);

sub conf {
	return undef;
};

package Basset::DB::Table;

{
	local $@ = undef;
	eval {
		Basset::Test::Testing::Basset::DB::Table::add_default_class_attr::Subclass5->add_class_attr('test_default_attr');
	};
	Test::More::like($@, qr/^Conf file error :/, 'could not add default class attr w/o conf file');
}
};
{#line 994 add_wrapper
my $subclass = "Basset::Test::Testing::Basset::DB::Table::add_wrapper";
my $subclass2 = "Basset::Test::Testing::Basset::DB::Table::add_wrapper2";

package Basset::Test::Testing::Basset::DB::Table::add_wrapper;
our @ISA = qw(Basset::DB::Table);

$subclass->add_attr('attr1');
$subclass->add_attr('attr2');
$subclass->add_attr('before_wrapper');
$subclass->add_attr('before_wrapper2');
$subclass->add_attr('after_wrapper');
$subclass->add_attr('after_wrapper2');
$subclass->add_attr('code_wrapper');

sub wrapper1 {shift->before_wrapper('set')};

sub wrapper2 {
	$_[0]->before_wrapper('B4SET');
	$_[0]->before_wrapper2('set2');
}

sub wrapper3 {
	$_[0]->before_wrapper('ASET1');
	$_[0]->before_wrapper2('ASET2');
	return $_[2];
}

sub wrapper5 {
	$_[0]->before_wrapper('5-BSET1');
	$_[0]->before_wrapper2('5-BSET2');
	$_[0]->after_wrapper('5-ASET1');
	$_[0]->after_wrapper2('5-ASET2');
}

package Basset::Test::Testing::Basset::DB::Table::add_wrapper2;
our @ISA = ($subclass);

sub wrapper4 {
	shift->after_wrapper('AWRAPPER');
}

package Basset::DB::Table;

Test::More::ok(! $subclass->add_wrapper, "Cannot add wrapper w/o type");
Test::More::is($subclass->errcode, "BO-31", "proper error code");

Test::More::ok(! $subclass->add_wrapper('before'), "Cannot add wrapper w/o attribute");
Test::More::is($subclass->errcode, "BO-32", "proper error code");

Test::More::ok(! $subclass->add_wrapper('before', 'bogus_wrapper'), "Cannot add wrapper w/o wrapper");
Test::More::is($subclass->errcode, "BO-33", "proper error code");

Test::More::ok(! $subclass->add_wrapper('before', 'bogus_attribute', 'bogus_wrapper'), "Cannot add wrapper: bogus attribute");
Test::More::is($subclass->errcode, "BO-34", "proper error code");

Test::More::ok(! $subclass->add_wrapper('before', 'attr2', 'bogus_wrapper'), "Cannot add wrapper: bogus wrapper");
Test::More::is($subclass->errcode, "BO-35", "proper error code");

Test::More::ok(! $subclass->add_wrapper('junk', 'attr2', 'wrapper1'), "Cannot add wrapper: bogus type");
Test::More::is($subclass->errcode, "BO-36", "proper error code");

Test::More::ok($subclass->add_wrapper('before', 'attr1', 'wrapper1'), "added wrapper to ref");

my $o = $subclass->new();
Test::More::ok($o, "got object");

Test::More::is($o->before_wrapper, undef, "before_wrapper is undef");
Test::More::is($o->attr1('foo'), 'foo', 'set attr1 to foo');
Test::More::is($o->before_wrapper, 'set', 'before_wrapper is set');

Test::More::is($o->before_wrapper(undef), undef, "before_wrapper is undef");

Test::More::ok($subclass->add_wrapper('before', 'attr1', 'wrapper2'), "added wrapper to ref");

Test::More::is($o->before_wrapper, undef, "before_wrapper is undef");
Test::More::is($o->attr1('bar'), 'bar', 'set attr1 to baz');
Test::More::is($o->before_wrapper, 'set', 'before_wrapper is set');
Test::More::is($o->before_wrapper2, 'set2', 'before_wrapper2 is set2');
Test::More::is($o->after_wrapper, undef, 'after_wrapper is undef');
Test::More::is($o->after_wrapper2, undef, 'after_wrapper2 is undef');

Test::More::is($o->before_wrapper(undef), undef, "before_wrapper is undef");
Test::More::is($o->before_wrapper2(undef), undef, "before_wrapper2 is undef");

Test::More::ok($subclass->add_wrapper('after', 'attr1', 'wrapper3'), "added after wrapper to ref");

Test::More::is($o->before_wrapper, undef, "before_wrapper is undef");
Test::More::is($o->attr1('baz'), 'baz', 'set attr1 to baz');
Test::More::is($o->before_wrapper, 'ASET1', 'before_wrapper is ASET1');
Test::More::is($o->before_wrapper2, 'ASET2', 'before_wrapper2 is ASET2');

my $o2 = $subclass2->new();
Test::More::ok($o2, "got sub object");

Test::More::ok($subclass2->add_wrapper('before', 'attr1', 'wrapper4'), "added after wrapper to ref");

Test::More::is($o2->before_wrapper, undef, "before_wrapper is undef");
Test::More::is($o2->attr1('baz'), 'baz', 'set attr1 to baz');
Test::More::is($o2->before_wrapper, 'ASET1', 'before_wrapper is ASET1');
Test::More::is($o2->before_wrapper2, 'ASET2', 'before_wrapper2 is ASET2');
Test::More::is($o2->after_wrapper, 'AWRAPPER', 'after_wrapper is AWRAPPER');

Test::More::is($o->before_wrapper(undef), undef, "before_wrapper is undef");
Test::More::is($o->before_wrapper2(undef), undef, "before_wrapper2 is undef");
Test::More::is($o->after_wrapper(undef), undef, "after_wrapper2 is undef");
Test::More::is($o->after_wrapper2(undef), undef, "after_wrapper2 is undef");

Test::More::ok($subclass->add_wrapper('before', 'attr1', 'wrapper5'), "added before wrapper to ref");

Test::More::is($o->before_wrapper, undef, "before_wrapper is undef");
Test::More::is($o->attr1('bar'), 'bar', 'set attr1 to baz');
Test::More::is($o->before_wrapper, 'ASET1', 'before_wrapper is set ASET1');
Test::More::is($o->before_wrapper2, 'ASET2', 'before_wrapper2 is ASET2');
Test::More::is($o->after_wrapper, '5-ASET1', 'after_wrapper is 5-ASET1');
Test::More::is($o->after_wrapper2, '5-ASET2', 'after_wrapper2 is 5-ASET2');


Test::More::is($o2->before_wrapper(undef), undef, "before_wrapper is undef");
Test::More::is($o2->before_wrapper2(undef), undef, "before_wrapper2 is undef");
Test::More::is($o2->after_wrapper(undef), undef, "after_wrapper2 is undef");
Test::More::is($o2->after_wrapper2(undef), undef, "after_wrapper2 is undef");

Test::More::is($o2->before_wrapper, undef, "before_wrapper is undef");
Test::More::is($o2->attr1('bar'), 'bar', 'set attr1 to baz');
Test::More::is($o2->before_wrapper, 'ASET1', 'before_wrapper is set ASET1');
Test::More::is($o2->before_wrapper2, 'ASET2', 'before_wrapper2 is ASET2');
Test::More::is($o2->after_wrapper, '5-ASET1', 'after_wrapper is 5-ASET1');
Test::More::is($o2->after_wrapper2, '5-ASET2', 'after_wrapper2 is 5-ASET2');


Test::More::is($o->before_wrapper(undef), undef, "before_wrapper is undef");
Test::More::is($o->before_wrapper2(undef), undef, "before_wrapper2 is undef");
Test::More::is($o->after_wrapper(undef), undef, "after_wrapper2 is undef");
Test::More::is($o->after_wrapper2(undef), undef, "after_wrapper2 is undef");

Test::More::is($o->before_wrapper, undef, "before_wrapper is undef");
Test::More::is($o->attr1('bar'), 'bar', 'set attr1 to baz');
Test::More::is($o->before_wrapper, 'ASET1', 'before_wrapper is set ASET1');
Test::More::is($o->before_wrapper2, 'ASET2', 'before_wrapper2 is ASET2');
Test::More::is($o->after_wrapper, '5-ASET1', 'after_wrapper is 5-ASET1');
Test::More::is($o->after_wrapper2, '5-ASET2', 'after_wrapper2 is 5-ASET2');

Test::More::ok($subclass->add_wrapper('before', 'attr1', sub {$_[0]->code_wrapper('SET CODE WRAP'); return 1}), 'added coderef wrapper');
Test::More::is($o->attr1('code'), 'code', 'set attr1 to code');
Test::More::is($o->code_wrapper, 'SET CODE WRAP', 'properly used coderef wrapper');
};
{#line 1236 error
my $notes = 0;

sub notifier {
	my $self = shift;
	my $note = shift;
	$notes++;
};

my $center = Basset::DB::Table->pkg_for_type('notificationcenter');
Test::More::ok($center, "Got notification center class");


Test::More::ok(
	$center->addObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'error',
		'object' => 'all',
		'method' => 'notifier'
	), "Added observer for error notifications"
);

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Object created");

Test::More::is(scalar Basset::DB::Table->error("classerr"), undef, "Class error set and returns undef");
Test::More::is($notes, 1, "Posted a notification");
Test::More::is(scalar Basset::DB::Table->error(), 'classerr', "Class error accesses");
Test::More::is($notes, 1, "No notification");

Test::More::is(scalar Basset::DB::Table->error("classerr2", "classcode2"), undef, "Class error and errcode set and returns undef");
Test::More::is($notes, 2, "Posted a notification");
Test::More::is(scalar Basset::DB::Table->error(), 'classerr2', "Class error accesses");
Test::More::is($notes, 2, "No notification");
Test::More::is(scalar Basset::DB::Table->errcode(), 'classcode2', "Class Class errcode accesses");
Test::More::is($notes, 2, "No notification");

Test::More::is(scalar $o->error("objerr"), undef, "Object error set and returns undef");
Test::More::is($notes, 3, "Posted a notification");
Test::More::is(scalar $o->error(), 'objerr', "Object error accesses");
Test::More::is($notes, 3, "No notification");
Test::More::is(scalar Basset::DB::Table->error(), 'classerr2', "Class error unaffected");
Test::More::is($notes, 3, "No notification");

Test::More::is(scalar $o->error("objerr2", "objcode2"), undef, "Object error and errcode set and returns undef");
Test::More::is($notes, 4, "Posted a notification");
Test::More::is(scalar $o->error(), 'objerr2', "Object error accesses");
Test::More::is($notes, 4, "No notification");
Test::More::is(scalar $o->errcode(), 'objcode2', "Object errcode accesses");
Test::More::is($notes, 4, "No notification");
Test::More::is(scalar Basset::DB::Table->error(), 'classerr2', "Class error unaffected");
Test::More::is($notes, 4, "No notification");
Test::More::is(scalar Basset::DB::Table->errcode(), 'classcode2', "Class errcode unaffected");
Test::More::is($notes, 4, "No notification");

Test::More::is(scalar Basset::DB::Table->error("classerr3", "clscode3"), undef, "Re-set class error");
Test::More::is($notes, 5, "Posted notification");
Test::More::is(scalar $o->error(), 'objerr2', "Object error unchanged");
Test::More::is($notes, 5, "No notification");
Test::More::is(scalar $o->errcode(), 'objcode2', "Object errcode unchanged");
Test::More::is($notes, 5, "No notification");

Test::More::is(scalar $o->error("objerr3", "objcode3", "silently"), undef, "Silently set error");
Test::More::is($notes, 5, "No notification");
Test::More::is(scalar $o->error(), 'objerr3', "Object error accesses");
Test::More::is($notes, 5, "No notification");
Test::More::is(scalar $o->errcode(), 'objcode3', "Object errcode accesses");
Test::More::is($notes, 5, "No notification");
Test::More::is(scalar Basset::DB::Table->error(), 'classerr3', "Class error unaffected");
Test::More::is($notes, 5, "No notification");
Test::More::is(scalar Basset::DB::Table->errcode(), 'clscode3', "Class errcode unaffected");
Test::More::is($notes, 5, "No notification");

Test::More::is(scalar $o->error(["formatted error %d %.2f %s", 13, 3.14, "data"], "ec", "silently"), undef, "Object set formatted error");
Test::More::is(scalar $o->error, "formatted error 13 3.14 data", "Formatted error accesses");
Test::More::is(scalar $o->errcode, "ec", "Formatted errcode accesses");
Test::More::is(scalar Basset::DB::Table->error(), 'classerr3', "Class error unaffected");
Test::More::is($notes, 5, "No notification");
Test::More::is(scalar Basset::DB::Table->errcode(), 'clscode3', "Class errcode unaffected");
Test::More::is($notes, 5, "No notification");

my $confClass = Basset::DB::Table->pkg_for_type('conf');
Test::More::ok($confClass, "Got conf");

my $cfg = $confClass->conf;
Test::More::ok($cfg, "Got configuration");

Test::More::ok($cfg->{"Basset::Object"}->{'exceptions'} = 1, "enables exceptions");

eval {
	$o->error("exception error", "excpcode");
};
Test::More::ok($@ =~ /^excpcode /, "Caught object exception code");
Test::More::is($o->last_exception, "exception error", "Caught object exception");
Test::More::is(Basset::DB::Table->last_exception, "exception error", "Caught class exception");
Test::More::is($notes, 6, "Posted a notification");

eval {
	Basset::DB::Table->error("exception error 2", "excpcode2");
};

Test::More::ok($@ =~ /^excpcode2 /, "Caught object exception code2");
Test::More::is($o->last_exception, "exception error 2", "Caught object exception");
Test::More::is(Basset::DB::Table->last_exception, "exception error 2", "Caught class exception");
Test::More::is($notes, 7, "Posted a notification");

eval {
	Basset::DB::Table->error("exception error 3", "excpcode3", "silently");
};
Test::More::ok($@ =~ /^excpcode3/, "Caught object exception code3");
Test::More::is($o->last_exception, "exception error 3", "Caught object exception");
Test::More::is(Basset::DB::Table->last_exception, "exception error 3", "Caught class exception");
Test::More::is($notes, 7, "No notification");

Test::More::is($cfg->{"Basset::Object"}->{'exceptions'} = 0, 0,"shut off exceptions");

Test::More::ok(
	$center->removeObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'error',
	), "Removed observer for error notifications"
);

package Basset::Test::Testing::Basset::DB::Table::error::Subclass1;
our @ISA = qw(Basset::DB::Table);

sub can {
	my $self = shift;
	my $method = shift;
	return 0 if $method =~ /_..._error/;
	return $self->SUPER::can($method);
};

package Basset::DB::Table;
{
	local $@ = undef;

	eval {
		Basset::Test::Testing::Basset::DB::Table::error::Subclass1->error("some error");
	};
	Test::More::like($@, qr/^System start up failure/, 'Could not start system when cannot error');
}

package Basset::Test::Testing::Basset::DB::Table::error::Subclass2;
our @ISA = qw(Basset::DB::Table);

sub can {
	my $self = shift;
	my $method = shift;
	return 0 if $method =~ /_..._errcode/;
	return $self->SUPER::can($method);
};

package Basset::DB::Table;

{
	local $@ = undef;

	eval {
		Basset::Test::Testing::Basset::DB::Table::error::Subclass2->error("some error");
	};

	Test::More::like($@, qr/^System start up failure/, 'Could not start system when cannot errcode');

	Test::More::is(scalar(Basset::Test::Testing::Basset::DB::Table::error::Subclass2->error), undef, 'accessing error merely returns');

}
};
{#line 1492 rawerror
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Object created");

Test::More::is(scalar Basset::DB::Table->error("raw class error", "roe"), undef, "Set class error");
Test::More::is(scalar Basset::DB::Table->rawerror(), "raw class error", "Class raw error accesses");
Test::More::is(scalar Basset::DB::Table->error(["raw class error %d"], "roe"), undef, "Set formatted class error");
Test::More::is(ref Basset::DB::Table->rawerror(), 'ARRAY', "Class formatted raw error accesses");
Test::More::is(Basset::DB::Table->rawerror()->[0], "raw class error %d", "Class formatted raw error accesses");

Test::More::is(scalar $o->error("raw object error", "roe"), undef, "Set object error");
Test::More::is(scalar $o->rawerror(), "raw object error", "Object raw error accesses");
Test::More::is(scalar $o->error(["raw object error %d"], "roe"), undef, "Set formatted object error");
Test::More::is(ref $o->rawerror(), 'ARRAY', "Object formatted raw error accesses");
Test::More::is($o->rawerror()->[0], 'raw object error %d', "Object formatted raw error accesses");
Test::More::ok(ref $o->rawerror() eq 'ARRAY', "Class formatted raw error unaffected");
Test::More::is(Basset::DB::Table->rawerror()->[0], "raw class error %d", "Class formatted raw error unaffected");
};
{#line 1545 errcode
Test::More::is(scalar Basset::DB::Table->error("test error", "test code", "silently"), undef, "Class sets errcode");
Test::More::is(scalar Basset::DB::Table->errcode(), "test code", "Class accesses");
};
{#line 1572 errstring
Test::More::is(scalar Basset::DB::Table->error("test error", "test code"), undef, "Class sets error & errcode");
Test::More::is(Basset::DB::Table->errstring(), "test error...with code (test code)", "Class accesses errstring");

Test::More::is(scalar Basset::DB::Table->error("test error2", "test code2", "silently"), undef, "Class silently sets error & errcode");
Test::More::is(Basset::DB::Table->errstring(), "test error2...with code (test code2)", "Class accesses errstring");

Test::More::is(scalar Basset::DB::Table->error("test error3"), undef, "Class sets error & no errcode");
Test::More::is(Basset::DB::Table->errstring(), "test error3...with code (code undefined)", "Class accesses errstring");

Test::More::is(scalar Basset::DB::Table->error("test error4", undef, "silently"), undef, "Class silently sets error & no errcode");
Test::More::is(Basset::DB::Table->errstring(), "test error4...with code (code undefined)", "Class accesses errstring");

Basset::DB::Table->wipe_errors();

Test::More::is(scalar(Basset::DB::Table->errstring), undef, 'errcode returns nothing w/o error and errcode');
Basset::DB::Table->errcode('test code');
Test::More::is(Basset::DB::Table->errstring, 'error undefined...with code (test code)', 'errcode returns undefined w/o error');
};
{#line 1625 errvals
my $notes = 0;

sub notifier2 {
	my $self = shift;
	my $note = shift;
	$notes++;
};

my $center = Basset::DB::Table->pkg_for_type('notificationcenter');
Test::More::ok($center, "Got notification center class");


Test::More::ok(
	$center->addObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'error',
		'object' => 'all',
		'method' => 'notifier2'
	), "Added observer for error notifications"
);

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Object created");

Test::More::is(scalar $o->error("test error", "test code"), undef, "Object set error");
Test::More::is($notes, 1, "Posted notification");

my @errvals = $o->errvals;
Test::More::is($notes, 1, "No notification");
Test::More::is($errvals[0], "test error", "Object accesses error");
Test::More::is($notes, 1, "No notification");
Test::More::is($errvals[1], "test code", "Object accesses error");
Test::More::is($notes, 1, "No notification");
Test::More::is($errvals[2], "silently", "errvals always silent");
Test::More::is($notes, 1, "No notification");

Test::More::ok(
	$center->removeObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'error',
	), "Removed observer for error notifications"
);
};
{#line 1699 usererror
my $translator = Basset::DB::Table->errortranslator();
Test::More::ok(Basset::DB::Table->errortranslator(
	{
		'test code' => "friendly test message",
		'formatted test error %d' => "friendlier test message",
		'formatted test error 7' => 'friendliest test message',
		'extra error' => 'friendliest test message 2'
	}),
	'Class set error translator'
);

my $uses_real = Basset::DB::Table->use_real_errors();
Test::More::is(Basset::DB::Table->use_real_errors(0), 0, "Uses real errors");

Test::More::is(scalar Basset::DB::Table->error("extra error", "test code"), undef, "Class sets error");
Test::More::is(Basset::DB::Table->usererror(), "friendliest test message 2", "Class gets user error for literal");

Test::More::is(scalar Basset::DB::Table->error(["formatted test error %d", 7], "test code"), undef, "Class sets formatted error");
Test::More::is(Basset::DB::Table->usererror(), "friendliest test message", "Class gets user error for formatted string");

Test::More::is(scalar Basset::DB::Table->error(["formatted test error %d", 9], "test code"), undef, "Class sets formatted error");
Test::More::is(Basset::DB::Table->usererror(), "friendlier test message", "Class gets user error for string format");

Test::More::is(scalar Basset::DB::Table->error("Some test error", "test code"), undef, "Class sets standard error");
Test::More::is(Basset::DB::Table->usererror(), "friendly test message", "Class gets user error for error code");

Test::More::is(scalar Basset::DB::Table->error("Some unknown error", "unknown code"), undef, "Class sets standard error w/o translation");
Test::More::is(Basset::DB::Table->usererror(), "Some unknown error", "Class gets no user error");

Test::More::ok(Basset::DB::Table->errortranslator(
	{
		'test code' => "friendly test message",
		'formatted test error %d' => "friendlier test message",
		'formatted test error 7' => 'friendliest test message',
		'extra error' => 'friendliest test message 2',
		'*' => 'star error',
	}),
	'Class changed error translator'
);

Test::More::is(scalar Basset::DB::Table->error("Some unknown error", "unknown code"), undef, "Class sets standard error w/o translation");
Test::More::is(Basset::DB::Table->usererror(), "star error", "Class gets star error");

Test::More::is(Basset::DB::Table->errortranslator($translator), $translator, 'Class reset error translator');
Test::More::is(Basset::DB::Table->use_real_errors($uses_real), $uses_real, "resets uses real errors");
};
{#line 1800 wipe_errors
Test::More::is(scalar Basset::DB::Table->error("test error", "error code"), undef, "Class set error and errcode");
Test::More::is(Basset::DB::Table->error(), "test error", "Class accesses error");
Test::More::is(Basset::DB::Table->errcode(), "error code", "Class accesses errcode");
Test::More::ok(Basset::DB::Table->wipe_errors(), "Class wiped errors");
Test::More::is(Basset::DB::Table->error(), undef, "Class error wiped out");
Test::More::is(Basset::DB::Table->errcode(), undef, "Class errcode wiped out");

my $confClass = Basset::DB::Table->pkg_for_type('conf');
Test::More::ok($confClass, "Got conf");

my $cfg = $confClass->conf;
Test::More::ok($cfg, "Got configuration");

Test::More::ok($cfg->{"Basset::Object"}->{'exceptions'} = 1, "enables exceptions");

eval {
	Basset::DB::Table->error("test exception", "test exception code");
};
Test::More::ok($@, "Caught exception");
Test::More::like($@, qr/test exception code/, "Exception matches");
Test::More::like(Basset::DB::Table->last_exception, qr/test exception/, "Exception is present");
Test::More::ok(Basset::DB::Table->wipe_errors(), "Class wiped errors");
Test::More::is(Basset::DB::Table->last_exception, undef, "last exception wiped out");
Test::More::is($cfg->{"Basset::Object"}->{'exceptions'} = 0, 0,"disables exceptions");
};
{#line 1873 notify
my $test1notes = undef;
my $test2notes = undef;

sub test1notifier {
	my $self = shift;
	my $note = shift;
	$test1notes = $note->{'args'}->[0];
};

sub test2notifier {
	my $self = shift;
	my $note = shift;
	$test2notes = $note->{'args'}->[0];
};

my $center = Basset::DB::Table->pkg_for_type('notificationcenter');
Test::More::ok($center, "Got notification center class");

Test::More::ok(
	$center->addObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'test1',
		'object' => 'all',
		'method' => 'test1notifier'
	), "Added observer for test1 notifications"
);

Test::More::ok(
	$center->addObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'test2',
		'object' => 'all',
		'method' => 'test2notifier'
	), "Added observer for test2 notifications"
);


my $o = Basset::DB::Table->new();
Test::More::ok($o, "Object created");

Test::More::ok(Basset::DB::Table->notify('test1', "Test 1 note 1"), "Class posted notification");
Test::More::is($test1notes, "Test 1 note 1", "Received note");
Test::More::is($test2notes, undef, "No note for test 2");

Test::More::ok(Basset::DB::Table->notify('test2', "Test 2 note 2"), "Class posted notification");
Test::More::is($test2notes, "Test 2 note 2", "Received note");
Test::More::is($test1notes, "Test 1 note 1", "Test 1 note unchanged");

Test::More::ok(
	$center->removeObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'test1',
	), "Removed observer for test1 notifications"
);

Test::More::ok(
	$center->addObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'test1',
		'object' => $o,
		'method' => 'test1notifier'
	), "Added specific observer for test1 notifications"
);

Test::More::ok(Basset::DB::Table->notify('test1', 'Test 1 note 2'), "Class posted notification");
Test::More::is($test1notes, "Test 1 note 1", "Test 1 note unchanged");
Test::More::is($test2notes, "Test 2 note 2", "Test 2 note unchanged");

Test::More::ok($o->notify('test1', 'Test 1 note 3'), "Object posted notification");
Test::More::is($test1notes, "Test 1 note 3", "Recieved note");

Test::More::is($test2notes, "Test 2 note 2", "Test 2 note unchanged");



Test::More::ok(
	$center->removeObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'test1',
	), "Removed observer for test1 notifications"
);


Test::More::ok(
	$center->removeObserver(
		'observer' => 'Basset::DB::Table',
		'notification'	=> 'test2',
	), "Removed observer for test2 notifications"
);
};
{#line 2027 add_restrictions
package Basset::Test::Testing::Basset::DB::Table::add_restrictions::Subclass1;
our @ISA = qw(Basset::DB::Table);

my %restrictions = (
	'specialerror' => [
		'error' => 'error2',
		'errcode' => 'errcode2'
	],
	'invalidrestriction' => [
		'junkymethod' => 'otherjunkymethod'
	]
);

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::add_restrictions::Subclass1->add_restrictions(%restrictions), "Added restrictions to subclass");
};
{#line 2099 add_restricted_method
package Basset::Test::Testing::Basset::DB::Table::add_restricted_method::Subclass1;
our @ISA = qw(Basset::DB::Table);

my %restrictions = (
	'specialerror' => [
		'error' => 'error2',
		'errcode' => 'errcode2'
	],
	'invalidrestriction' => [
		'junkymethod' => 'otherjunkymethod'
	]
);

Basset::DB::Table->add_class_attr('e2');
Basset::DB::Table->add_class_attr('c2');

Test::More::is(Basset::DB::Table->e2(0), 0, "set e2 to 0");
Test::More::is(Basset::DB::Table->c2(0), 0, "set c2 to 0");

sub error2 {
	my $self = shift;
	$self->e2($self->e2 + 1);
	return $self->SUPER::error(@_);
}

sub errcode2 {
	my $self = shift;
	$self->c2($self->c2 + 1);
	return $self->SUPER::errcode(@_);
}

Test::More::ok(scalar Basset::Test::Testing::Basset::DB::Table::add_restricted_method::Subclass1->add_restrictions(%restrictions), "Added restrictions to subclass");

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::add_restricted_method::Subclass1->isa('Basset::DB::Table'), 'Proper subclass');

my $subclass = Basset::Test::Testing::Basset::DB::Table::add_restricted_method::Subclass1->inline_class();
Test::More::ok(scalar $subclass, "Got restricted class");
Test::More::ok($subclass->restricted, "Subclass is restricted");
Test::More::ok(scalar $subclass->isa('Basset::Test::Testing::Basset::DB::Table::add_restricted_method::Subclass1'), "Is subclass");
Test::More::ok(scalar $subclass->isa('Basset::DB::Table'), "Is subclass");

Test::More::ok(scalar $subclass->add_restricted_method('specialerror', 'error'), "Restricted error");
Test::More::ok(scalar $subclass->add_restricted_method('specialerror', 'errcode'), "Restricted errcode");
Test::More::ok(! scalar $subclass->add_restricted_method('invalidrestriction', 'junkymethod'), "Could not add invalid restriction");

Test::More::ok(! scalar $subclass->add_restricted_method('specialerror', 'error2'), "Could not add invalid restricted method");
Test::More::ok(! scalar $subclass->add_restricted_method('specialerror', 'errcode2'), "Could not add invalid restricted method");
Test::More::ok(! scalar $subclass->add_restricted_method('specialerror', 'junkymethod2'), "Could not add invalid restricted method");

my $e2 = $subclass->e2;
my $c2 = $subclass->c2;

#we post silently or else error and errcode would be called when it posts the error notification.
Test::More::is(scalar $subclass->error("test error", "test code", "silently"), undef, "Set error for subclass");

Test::More::is($subclass->e2, $e2 + 1, "Subclass restricted error incremented");
Test::More::is($subclass->c2, $c2, "Subclass restricted errcode unchanged");
Test::More::is($subclass->error(), "test error", "Subclass accesses error method");
Test::More::is($subclass->e2, $e2 + 2, "Subclass restricted error incremented");
Test::More::is($subclass->c2, $c2, "Subclass restricted errcode unchanged");
Test::More::is($subclass->errcode(), "test code", "Subclass accesses errcode method");
Test::More::is($subclass->e2, $e2 + 2, "Subclass restricted error unchanged");
Test::More::is($subclass->c2, $c2 + 1, "Subclass restricted errcode incremented");

Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::add_restricted_method::Subclass1->error("super test error", "super test code", "silently"), undef, "Superclass sets error");
Test::More::is($subclass->e2, $e2 + 2, "Subclass restricted error unchanged");
Test::More::is($subclass->c2, $c2 + 1, "Subclass restricted errcode unchanged");
};
{#line 2236 failed_restricted_method
package Basset::Test::Testing::Basset::DB::Table::failed_restricted_method::Subclass2;
our @ISA = qw(Basset::DB::Table);

sub successful {
	return 1;
};

my %restrictions = (
	'failure' => [
		'successful' => 'failed_restricted_method',
	],
);

package Basset::DB::Table;

my $subclass = Basset::Test::Testing::Basset::DB::Table::failed_restricted_method::Subclass2->inline_class;
Test::More::ok($subclass, "Got restricted subclass");
Test::More::ok(scalar $subclass->restricted, "Subclass is restricted");
Test::More::ok(scalar $subclass->add_restrictions(%restrictions), "Subclass added restrictions");

Test::More::ok(! scalar Basset::DB::Table->failed_restricted_method, "Failed restricted method always fails");
Test::More::ok(! scalar Basset::Test::Testing::Basset::DB::Table::failed_restricted_method::Subclass2->failed_restricted_method, "Failed restricted method always fails");
Test::More::ok(! scalar $subclass->failed_restricted_method, "Failed restricted method always fails");

Test::More::ok(scalar Basset::Test::Testing::Basset::DB::Table::failed_restricted_method::Subclass2->successful, "Super Success is successful");
Test::More::ok(scalar $subclass->successful, "Subclass success is successful");
Test::More::ok(scalar $subclass->add_restricted_method('failure', 'successful'), "Restricted subclass to fail upon success");
Test::More::ok(scalar Basset::Test::Testing::Basset::DB::Table::failed_restricted_method::Subclass2->successful, "Super Success is successful");
Test::More::ok(! scalar $subclass->successful, "Subclass success fails");
};
{#line 2290 inline_class
my $class = Basset::DB::Table->inline_class();
Test::More::ok($class, "Got restricted class");
Test::More::ok($class->restricted(), "Class is restricted");
Test::More::ok(! Basset::DB::Table->restricted(), "Superclass is not restricted");
};
{#line 2351 restrict
package Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1;
our @ISA = qw(Basset::DB::Table);

sub successful {
	return 1;
};

my %restrictions = (
	'failure' => [
		'successful' => 'failed_restricted_method',
	],
);

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->add_restrictions(%restrictions), "Subclass added restrictions");

package Basset::DB::Table;

Test::More::ok(scalar Basset::DB::Table->can('failed_restricted_method'), "Basset::DB::Table has failed_restricted_method");
Test::More::ok(scalar Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->can('failed_restricted_method'), "Subclass has failed_restricted_method");

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->isa('Basset::DB::Table'), 'Proper subclass');
Test::More::ok(! scalar Basset::DB::Table->failed_restricted_method, "Method properly fails");
Test::More::ok(! scalar Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->failed_restricted_method, "Method properly fails");

my $subclass = Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->restrict('failure');

Test::More::ok($subclass, "Got restricted subclass");

Test::More::ok($subclass->restricted, "Subclass is restricted");
Test::More::ok(! Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->restricted, "Superclass unaffected");
Test::More::ok(! Basset::DB::Table->restricted, "Superclass unaffected");

Test::More::ok(! scalar $subclass->successful, "Subclass restricted");
Test::More::ok(scalar Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->successful, "Superclass unaffected");

Test::More::ok(scalar Basset::Test::Testing::Basset::DB::Table::restrict::Subclass1->restrict('worthless restriction'), "Added unknown restriction");
};
{#line 2448 nonrestricted_parent
package Basset::Test::Testing::Basset::DB::Table::nonrestricted_parent::Subclass1;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

Test::More::is(Basset::DB::Table->nonrestricted_parent, "Basset::DB::Table", "Basset::DB::Table own nonrestricted parent");
Test::More::is(Basset::Test::Testing::Basset::DB::Table::nonrestricted_parent::Subclass1->nonrestricted_parent, "Basset::Test::Testing::Basset::DB::Table::nonrestricted_parent::Subclass1", "Subclass own nonrestricted parent");

my $subclass = Basset::Test::Testing::Basset::DB::Table::nonrestricted_parent::Subclass1->inline_class;
Test::More::ok($subclass, "Got restricted class");
Test::More::is($subclass->nonrestricted_parent, "Basset::Test::Testing::Basset::DB::Table::nonrestricted_parent::Subclass1", "Restricted class has proper non restricted parent");

my $subclass2 = $subclass->inline_class;
Test::More::ok($subclass2, "Got restricted class of restricted class");
Test::More::is($subclass2->nonrestricted_parent, "Basset::Test::Testing::Basset::DB::Table::nonrestricted_parent::Subclass1", "Restricted class has proper non restricted parent");

my $subclass3 = Basset::DB::Table->inline_class;
Test::More::ok($subclass3, "Got restricted class");
Test::More::is($subclass3->nonrestricted_parent, "Basset::DB::Table", "Restricted class has proper non restricted parent");
};
{#line 2506 dump
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");
my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Created object");

Test::More::ok($o->dump, "Dumped object");
Test::More::ok($o->dump(['a']), "Dumped array");
Test::More::ok($o->dump({'k' => 'v'}), "Dumped hash");
Test::More::ok($o2->dump, "Dumped other object");
Test::More::is($o->dump($o2), $o2->dump, "Dumps equal");
Test::More::is($o->dump, $o2->dump($o), "Dumps equal");
};
{#line 2581 new
my $o = Basset::DB::Table->new();

Test::More::ok($o, "created a new object");

package Basset::Test::Testing::Basset::DB::Table::new::Subclass1;
our @ISA = qw(Basset::DB::Table);

Basset::Test::Testing::Basset::DB::Table::new::Subclass1->add_attr('attr1');
Basset::Test::Testing::Basset::DB::Table::new::Subclass1->add_attr('attr2');
Basset::Test::Testing::Basset::DB::Table::new::Subclass1->add_attr('attr3');
Basset::Test::Testing::Basset::DB::Table::new::Subclass1->add_class_attr('class_attr');

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::new::Subclass1->isa('Basset::DB::Table'), "Subclass is subclass");
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::new::Subclass1->can('attr1'), 'class can attr1');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::new::Subclass1->can('attr2'), 'class can attr2');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::new::Subclass1->can('attr3'), 'class can attr3');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::new::Subclass1->can('class_attr'), 'class can class_attr');

my $o2 = Basset::Test::Testing::Basset::DB::Table::new::Subclass1->new();
Test::More::ok($o2, "created a subclass object");

my $o3 = Basset::Test::Testing::Basset::DB::Table::new::Subclass1->new(
	'attr1' => 'attr1val',
);

Test::More::ok($o3, "Created a subclass object");
Test::More::is(scalar $o3->attr1, 'attr1val', 'subclass object has attribute from constructor');

my $o4 = Basset::Test::Testing::Basset::DB::Table::new::Subclass1->new(
	'attr1' => 'attr1val',
	'attr2' => 'attr2val',
);

Test::More::ok($o4, "Created a subclass object");
Test::More::is(scalar $o4->attr1, 'attr1val', 'subclass object has attribute from constructor');
Test::More::is(scalar $o4->attr2, 'attr2val', 'subclass object has attribute from constructor');

my $o5 = Basset::Test::Testing::Basset::DB::Table::new::Subclass1->new(
	'attr1' => 'attr1val',
	'attr2' => 'attr2val',
	'attr7' => 'attr7val',
	'attr8' => 'attr8val',
);

Test::More::ok($o5, "Created a subclass object w/junk values");
Test::More::is(scalar $o5->attr1, 'attr1val', 'subclass object has attribute from constructor');
Test::More::is(scalar $o5->attr2, 'attr2val', 'subclass object has attribute from constructor');

#these tests would now pass.
#my $o6 = Basset::Test::Testing::Basset::DB::Table::new::Subclass1->new(
#	'attr1' => undef,
#);
#
#Test::More::ok(! $o6, "Failed to create object w/undef value");

my $o7 = Basset::Test::Testing::Basset::DB::Table::new::Subclass1->new(
	'attr1' => 7,
	'attr2' => 0,
);

Test::More::ok($o7, "Created object w/0 value");
Test::More::is($o7->attr1, 7, 'attr1 value set');
Test::More::is($o7->attr2, 0, 'attr2 value set');
};
{#line 2697 init
package Basset::Test::Testing::Basset::DB::Table::init::Subclass2;
our @ISA = qw(Basset::DB::Table);

sub conf {
	return undef;
};

package Basset::DB::Table;

{
	my $o = undef;
	local $@ = undef;
	$o = Basset::Test::Testing::Basset::DB::Table::init::Subclass2->new();
	Test::More::is($o, undef, 'could not create object w/o conf file');
}

{
	my $o = Basset::DB::Table->new('__j_known_junk_method' => 'a');
	Test::More::ok($o, 'created object');
}
};
{#line 2778 pkg
package main::Basset::Test::Testing::Basset::DB::Table::MainSubClass;
our @ISA = qw(Basset::DB::Table);

package Basset::Test::Testing::Basset::DB::Table::MainSubClass2;
our @ISA = qw(Basset::DB::Table);


package ::Basset::Test::Testing::Basset::DB::Table::MainSubClass3;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

Test::More::ok(main::Basset::Test::Testing::Basset::DB::Table::MainSubClass->isa('Basset::DB::Table'), "Created subclass");
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::MainSubClass2->isa('Basset::DB::Table'), "Created subclass");
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::MainSubClass3->isa('Basset::DB::Table'), "Created subclass");

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created object");

my $so1 = main::Basset::Test::Testing::Basset::DB::Table::MainSubClass->new();
Test::More::ok($so1, "Created sub-object");

my $so2 = Basset::Test::Testing::Basset::DB::Table::MainSubClass2->new();
Test::More::ok($so2, "Created sub-object");

my $so3 = Basset::Test::Testing::Basset::DB::Table::MainSubClass3->new();
Test::More::ok($so3, "Created sub-object");

Test::More::is($o->pkg, "Basset::DB::Table", "Superclass works");
Test::More::is($so1->pkg, "Basset::Test::Testing::Basset::DB::Table::MainSubClass", "Subclass works");
Test::More::is($so2->pkg, "Basset::Test::Testing::Basset::DB::Table::MainSubClass2", "Subclass works");
Test::More::is($so3->pkg, "Basset::Test::Testing::Basset::DB::Table::MainSubClass3", "Subclass works");
};
{#line 2853 factory
package Basset::Test::Testing::Basset::DB::Table::factory::Subclass;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

my $oldtypes = Basset::DB::Table->types();
Test::More::ok($oldtypes, "Saved old types");
my $newtypes = {%$oldtypes, 'factory_test_type' => 'Basset::DB::Table'};
Test::More::is(Basset::DB::Table->types($newtypes), $newtypes, "Set new types");
Test::More::is(Basset::DB::Table->pkg_for_type('factory_test_type'), 'Basset::DB::Table', 'can get class for type');
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Created new object");
my $o2 = Basset::DB::Table->factory('type' => 'factory_test_type');
Test::More::ok($o2, "Factoried new object");
Test::More::ok($o2->isa('Basset::DB::Table'), "Factory object isa class object");
Test::More::is(Basset::DB::Table->types($oldtypes), $oldtypes, "reset old types");
};
{#line 2909 copy
package Basset::Test::Testing::Basset::DB::Table::copy::subclass;
our @ISA = qw(Basset::DB::Table);

Basset::Test::Testing::Basset::DB::Table::copy::subclass->add_attr('attr1');
Basset::Test::Testing::Basset::DB::Table::copy::subclass->add_attr('attr2');
Basset::Test::Testing::Basset::DB::Table::copy::subclass->add_attr('attr3');

package Basset::DB::Table;

my $o = Basset::DB::Table->new();
Test::More::ok($o, "Instantiated object");
my $o2 = $o->copy;
Test::More::ok($o2, "Copied object");
Test::More::is(length $o->dump, length $o2->dump, "dumps are same size");

my $o3 = Basset::Test::Testing::Basset::DB::Table::copy::subclass->new(
	'attr1' => 'first attribute',
	'attr2' => 'second attribute',
	'attr3' => 'third attribute'
);

Test::More::ok($o3, "Instantiated sub-object");

Test::More::is($o3->attr1, 'first attribute', 'Subobject attr1 matches');
Test::More::is($o3->attr2, 'second attribute', 'Subobject attr2 matches');
Test::More::is($o3->attr3, 'third attribute', 'Subobject attr3 matches');

my $o4 = $o3->copy;

Test::More::ok($o4, "Copied sub-object");

Test::More::is($o4->attr1, 'first attribute', 'Copied subobject attr1 matches');
Test::More::is($o4->attr2, 'second attribute', 'Copied subobject attr2 matches');
Test::More::is($o4->attr3, 'third attribute', 'Copied subobject attr3 matches');

Test::More::is(length $o3->dump, length $o4->dump, "Sub object dumps are same size");

my $array = ['a', 2, {'foo' => 'bar'}];

Test::More::ok($array, "Got array");

my $array2 = Basset::DB::Table->copy($array);

Test::More::ok($array2, "Copied array");
Test::More::is($array->[0], $array2->[0], "First element matches");
Test::More::is($array->[1], $array2->[1], "Second element matches");
Test::More::is($array->[2]->{'foo'}, $array2->[2]->{'foo'}, "Third element matches");
};
{#line 2988 pkg_for_type
Test::More::ok(Basset::DB::Table->types, "Got types out of the conf file");
my $typesbkp = Basset::DB::Table->types();
my $newtypes = {%$typesbkp, 'testtype1' => 'Basset::DB::Table', 'testtype2' => 'boguspkg'};
Test::More::ok($typesbkp, "Backed up the types");
Test::More::is(Basset::DB::Table->types($newtypes), $newtypes, "Set new types");
Test::More::is(Basset::DB::Table->pkg_for_type('testtype1'), 'Basset::DB::Table', "Got class for new type");
Test::More::ok(! scalar Basset::DB::Table->pkg_for_type('testtype2'), "Could not access invalid type");
Test::More::is(Basset::DB::Table->errcode, 'BO-29', 'proper error code');

Basset::DB::Table->wipe_errors;
Test::More::is(scalar(Basset::DB::Table->pkg_for_type('testtype2', 'errorless')), undef, "Could not access invalid type w/ second arg");
Test::More::is(scalar(Basset::DB::Table->errcode), undef, 'no error code set w/second arg');
Test::More::is(scalar(Basset::DB::Table->errstring), undef, 'no error string set w/second arg');

my $h = {};

Test::More::is(Basset::DB::Table->types($h), $h, 'wiped out types');
Test::More::is(scalar(Basset::DB::Table->pkg_for_type('testtype3')), undef, 'could not get type w/o types');
Test::More::is(Basset::DB::Table->errcode, 'BO-09', 'proper error code for no types');

Test::More::is(Basset::DB::Table->types($typesbkp), $typesbkp, "Re-set original types");
};
{#line 3155 inherits
package Basset::Test::Testing::Basset::DB::Table::inherits::Subclass1;
Basset::DB::Table->inherits('Basset::Test::Testing::Basset::DB::Table::inherits::Subclass1', 'object');

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::inherits::Subclass1->isa('Basset::Object'), 'subclass inherits from root');
};
{#line 3197 isa_path
Test::More::ok(Basset::DB::Table->isa_path, "Can get an isa_path for root");
my $path = Basset::DB::Table->isa_path;
Test::More::is($path->[-1], 'Basset::DB::Table', 'Class has self at end of path');

package Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1;
our @ISA = qw(Basset::DB::Table);

package Basset::Test::Testing::Basset::DB::Table::isa_path::subclass2;
our @ISA = qw(Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1);

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1->isa('Basset::DB::Table'), 'Subclass of Basset::DB::Table');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::isa_path::subclass2->isa('Basset::DB::Table'), 'Sub-subclass of Basset::DB::Table');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1->isa('Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1'), 'Sub-subclass of subclass');

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1->isa_path, "We have a path");
my $subpath = Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1->isa_path;
Test::More::is($subpath->[-2], 'Basset::DB::Table', 'Next to last entry is parent');
Test::More::is($subpath->[-1], 'Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1', 'Last entry is self');

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::isa_path::subclass2->isa_path, "We have a sub path");
my $subsubpath = Basset::Test::Testing::Basset::DB::Table::isa_path::subclass2->isa_path;

Test::More::is($subsubpath->[-3], 'Basset::DB::Table', 'Third to last entry is grandparent');
Test::More::is($subsubpath->[-2], 'Basset::Test::Testing::Basset::DB::Table::isa_path::subclass1', 'Second to last entry is parent');
Test::More::is($subsubpath->[-1], 'Basset::Test::Testing::Basset::DB::Table::isa_path::subclass2', 'Last entry is self');

package Basset::Test::Testing::Basset::DB::Table::isa_path::Subclass3;

our @ISA = qw(Basset::DB::Table Basset::DB::Table);

package Basset::DB::Table;

my $isa = Basset::Test::Testing::Basset::DB::Table::isa_path::Subclass3->isa_path;
Test::More::ok($isa, "Got isa path");

#Test::More::is(scalar(@$isa), 2, 'two entries in isa_path');
Test::More::is($isa->[-2], 'Basset::DB::Table', 'Second to last entry is parent');
Test::More::is($isa->[-1], 'Basset::Test::Testing::Basset::DB::Table::isa_path::Subclass3', 'Last entry is self');
};
{#line 3291 module_for_class
Test::More::is(scalar(Basset::DB::Table->module_for_class), undef, "Could not get module_for_class w/o package");
Test::More::is(Basset::DB::Table->errcode, "BO-20", 'proper error code');
Test::More::is(Basset::DB::Table->module_for_class('Basset::Object'), 'Basset/Object.pm', 'proper pkg -> file name');
Test::More::is(Basset::DB::Table->module_for_class('Basset::Object::Persistent'), 'Basset/Object/Persistent.pm', 'proper pkg -> file name');
Test::More::is(Basset::DB::Table->module_for_class('Basset::DB::Table'), 'Basset/DB/Table.pm', 'proper pkg -> file name');
};
{#line 3324 conf
Test::More::ok(scalar Basset::DB::Table->conf, "Class accessed conf file");
my $o = Basset::DB::Table->new();
Test::More::ok(scalar $o, "Got object");
Test::More::ok(scalar $o->conf, "Object accessed conf file");
};
{#line 3351 escape_for_html
Test::More::is(Basset::DB::Table->escape_for_html('&'), '&#38;', 'escapes &');
Test::More::is(Basset::DB::Table->escape_for_html('a&'), 'a&#38;', 'escapes &');
Test::More::is(Basset::DB::Table->escape_for_html('&b'), '&#38;b', 'escapes &');
Test::More::is(Basset::DB::Table->escape_for_html('a&b'), 'a&#38;b', 'escapes &');

Test::More::is(Basset::DB::Table->escape_for_html('"'), '&#34;', 'escapes "');
Test::More::is(Basset::DB::Table->escape_for_html('a"'), 'a&#34;', 'escapes "');
Test::More::is(Basset::DB::Table->escape_for_html('"b'), '&#34;b', 'escapes "');
Test::More::is(Basset::DB::Table->escape_for_html('a"b'), 'a&#34;b', 'escapes "');

Test::More::is(Basset::DB::Table->escape_for_html("'"), '&#39;', "escapes '");
Test::More::is(Basset::DB::Table->escape_for_html("a'"), 'a&#39;', "escapes '");
Test::More::is(Basset::DB::Table->escape_for_html("'b"), '&#39;b', "escapes '");
Test::More::is(Basset::DB::Table->escape_for_html("a'b"), 'a&#39;b', "escapes '");

Test::More::is(Basset::DB::Table->escape_for_html('<'), '&#60;', 'escapes <');
Test::More::is(Basset::DB::Table->escape_for_html('a<'), 'a&#60;', 'escapes <');
Test::More::is(Basset::DB::Table->escape_for_html('<b'), '&#60;b', 'escapes <');
Test::More::is(Basset::DB::Table->escape_for_html('a<b'), 'a&#60;b', 'escapes <');

Test::More::is(Basset::DB::Table->escape_for_html('>'), '&#62;', 'escapes >');
Test::More::is(Basset::DB::Table->escape_for_html('a>'), 'a&#62;', 'escapes >');
Test::More::is(Basset::DB::Table->escape_for_html('>b'), '&#62;b', 'escapes >');
Test::More::is(Basset::DB::Table->escape_for_html('a>b'), 'a&#62;b', 'escapes >');

Test::More::is(Basset::DB::Table->escape_for_html('&>'), '&#38;&#62;', 'escapes &>');
Test::More::is(Basset::DB::Table->escape_for_html('<">'), '&#60;&#34;&#62;', 'escapes <">');
Test::More::is(Basset::DB::Table->escape_for_html("&&'"), '&#38;&#38;&#39;', "escapes &&'");
Test::More::is(Basset::DB::Table->escape_for_html('<&'), '&#60;&#38;', 'escapes <&');
Test::More::is(Basset::DB::Table->escape_for_html(q('"'')), '&#39;&#34;&#39;&#39;', q(escapes '"''));

Test::More::is(Basset::DB::Table->escape_for_html(), undef, 'escaped nothing returns undef');
Test::More::is(Basset::DB::Table->escape_for_html(undef), undef, 'escaped undef returns nothing');
};
{#line 3415 today
Test::More::like(Basset::DB::Table->today, qr/^\d\d\d\d-\d\d-\d\d$/, 'matches date regex');
Test::More::like(Basset::DB::Table->today('abc'), qr/^\d\d\d\d-\d\d-\d\d$/, 'matches date regex despite input');
};
{#line 3438 now
Test::More::like(Basset::DB::Table->now, qr/^\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d$/, 'matches timestamp regex');
Test::More::like(Basset::DB::Table->now('def'), qr/^\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d$/, 'matches timestamp regex despite input');
};
{#line 3467 gen_handle
Test::More::ok(Basset::DB::Table->gen_handle, "Generated handle");
my $h = Basset::DB::Table->gen_handle;
Test::More::ok($h, "Generated second handle");
Test::More::is(ref $h, "GLOB", "And it's a globref");
};
{#line 3542 perform
package Basset::Test::Testing::Basset::DB::Table::perform::Subclass;
our @ISA = qw(Basset::DB::Table);

Basset::Test::Testing::Basset::DB::Table::perform::Subclass->add_attr('attr1');
Basset::Test::Testing::Basset::DB::Table::perform::Subclass->add_attr('attr2');
Basset::Test::Testing::Basset::DB::Table::perform::Subclass->add_attr('attr3');

sub method1 {
	return 77;
}

sub method2 {
	my $self = shift;
	return scalar @_;
};

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::perform::Subclass->isa('Basset::DB::Table'), 'we have a subclass');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::perform::Subclass->can('attr1'), 'subclass has attr1');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::perform::Subclass->can('attr2'), 'subclass has attr2');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::perform::Subclass->can('attr2'), 'subclass has attr3');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::perform::Subclass->can('method1'), 'subclass has method1');
Test::More::ok(Basset::Test::Testing::Basset::DB::Table::perform::Subclass->can('method2'), 'subclass has method2');
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->method1, 77, 'method1 returns 77');
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->method2, 0, 'method2 behaves as expected');
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->method2('a'), 1, 'method2 behaves as expected');
Test::More::is(scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->method2(0,0), 2, 'method2 behaves as expected');

my $o = Basset::Test::Testing::Basset::DB::Table::perform::Subclass->new();

Test::More::ok($o, "Instantiated object");

my $class = 'Basset::Test::Testing::Basset::DB::Table::perform::Subclass';

Test::More::is(scalar($class->perform), undef, "Cannot perform w/o method");
Test::More::is($class->errcode, 'BO-04', 'proper error code');
Test::More::is(scalar($class->perform('methods' => 'able')), undef, "Cannot perform w/o values");
Test::More::is($class->errcode, 'BO-05', 'proper error code');
Test::More::is(scalar($class->perform('methods' => 'able', 'values' => 'baker')), undef, "methods must be arrayref");
Test::More::is($class->errcode, 'BO-11', 'proper error code');
Test::More::is(scalar($class->perform('methods' => ['able'], 'values' => 'baker')), undef, "values must be arrayref");
Test::More::is($class->errcode, 'BO-12', 'proper error code');


Test::More::ok(
	scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->perform(
		'methods' => ['method1'],
		'values' => ['a'],
	),
	"Class performs method1");

Test::More::ok(
	scalar $o->perform(
		'methods' => ['method1'],
		'values' => ['a'],
	),
	"Object performs method1");

Test::More::ok(! 
	scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->perform(
		'methods' => ['method2'],
		'values' => [],
	),
	"Class cannot perform method2 w/o args");

Test::More::ok(
	scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->perform(
		'methods' => ['method2'],
		'values' => ['a']
	),
	"Class performs method2 w/1 arg");

Test::More::ok(
	scalar Basset::Test::Testing::Basset::DB::Table::perform::Subclass->perform(
		'methods' => ['method2'],
		'values' => ['b'],
	),
	"Class performs method2 w/1 arg in arrayref");

Test::More::ok(! 
	scalar $o->perform(
		'methods' => ['attr1'],
		'values' => []
	),
	"object cannot access attribute w/o args"
);

Test::More::is(scalar $o->attr1, undef, 'attr1 is undefined');
Test::More::is(scalar $o->attr2, undef, 'attr2 is undefined');
Test::More::is(scalar $o->attr3, undef, 'attr3 is undefined');

Test::More::ok(
	scalar $o->perform(
		'methods' => ['attr1'],
		'values' => ['attr1_val']
	),
	"object performed attr1"
);

Test::More::is(scalar $o->attr1(), 'attr1_val', 'attr1 set via perform');

Test::More::ok(
	scalar $o->perform(
		'methods' => ['attr2', 'attr3'],
		'values' => ['attr2_val', 'attr3_val']
	),
	"object performed attr2, attr3"
);

Test::More::is(scalar $o->attr2(), 'attr2_val', 'attr2 set via perform');
Test::More::is(scalar $o->attr3(), 'attr3_val', 'attr3 set via perform');

Test::More::ok(! 
	scalar $o->perform(
		'methods' => ['attr4'],
		'values' => ['attr4_val']
	),
	"object cannot perform unknown method"
);

Test::More::ok(! 
	scalar $o->perform(
		'methods' => ['attr4', 'attr2'],
		'values' => ['attr4_val', 'attr2_val_2'],
	),
	'object cannot perform unknown method w/known method'
);

Test::More::is(scalar $o->attr2, 'attr2_val', 'attr2 unchanged');

Test::More::ok(! 
	scalar $o->perform(
		'methods' => ['attr1'],
		'values' => [undef]
	),
	"object failed trying to perform attr1"
);


Test::More::ok(! 
	scalar $o->perform(
		'methods' => ['attr1', 'attr2'],
		'values' => [undef, 'attr2_val_2'],
	),
	'object failed trying to perform attr1'
);

Test::More::is(scalar $o->attr2, 'attr2_val', 'attr2 unchanged');

Test::More::ok(! 
	scalar $o->perform(
		'methods' => ['attr1', 'attr2'],
		'values' => [undef, 'attr2_val_2'],
		'continue' => 1,
	),
	'object failed trying to perform attr1'
);

Test::More::is(scalar $o->attr2, 'attr2_val_2', 'attr2 changed due to continue');

my $arr = ['a', 'b'];
Test::More::ok($arr, "Have an arrayref");

Test::More::ok(
	scalar $o->perform(
		'methods' => ['attr3'],
		'values' => [$arr],
	),
	"Performed attr3"
);

Test::More::is($o->attr3, $arr, "attr3 contains arrayref");

Test::More::ok(
	scalar $o->perform(
		'methods' => ['attr3'],
		'values' => [$arr],
		'dereference' => ['attr3'],
	),
	"Performed attr3 with de-reference"
);

Test::More::is($o->attr3, 'a', "attr3 contains first element of arrayref");

Test::More::ok(
	scalar $o->perform(
		'methods' => ['attr2', 'attr3'],
		'values' => [$arr, $arr],
		'dereference' => ['attr2'],
	),
	"Performed attr3 with de-reference"
);

Test::More::is($o->attr2, 'a', "attr2 contains first element of arrayref");
Test::More::is($o->attr3, $arr, "attr3 contains arrayref");
};
{#line 3813 stack_trace
sub tracer {
	return Basset::DB::Table->stack_trace;
};

Test::More::ok(tracer(), "Got a stack trace");
my $trace = tracer();
Test::More::ok($trace, "Has a stack trace");
Test::More::like($trace, qr/Package:/, "Contains word: 'Package:'");
Test::More::like($trace, qr/Filename:/, "Contains word: 'Filename:'");
Test::More::like($trace, qr/Line number:/, "Contains word: 'Line number:'");
Test::More::like($trace, qr/Subroutine:/, "Contains word: 'Subroutine:'");
Test::More::like($trace, qr/Has Args\? :/, "Contains word: 'Has Args:'");
Test::More::like($trace, qr/Want array\? :/, "Contains word: 'Want array:'");
Test::More::like($trace, qr/Evaltext:/, "Contains word: 'Evaltext:'");
Test::More::like($trace, qr/Is require\? :/, "Contains word: 'Is require:'");
};
{#line 3865 no_op
Test::More::ok(Basset::DB::Table->no_op, "No op");
Test::More::is(Basset::DB::Table->no_op, 1, "No op is 1");
my $obj = Basset::DB::Table->new();
Test::More::ok($obj, "Got object");
Test::More::ok($obj->no_op, "Object no ops");
Test::More::is($obj->no_op, 1, "Object no op is 1");
};
{#line 3889 system_prefix
Test::More::is(Basset::DB::Table->system_prefix(), '__b_', 'expected system prefix');
};
{#line 3921 privatize
Test::More::ok(! Basset::DB::Table->privatize, 'Cannot privatize w/o method');
Test::More::is(Basset::DB::Table->errcode, "BO-24", "proper error code");

Test::More::is(Basset::DB::Table->privatize('foo'), '__b_foo', "privatized foo");
Test::More::is(Basset::DB::Table->privatize('__b_foo'), '__b_foo', "__b_foo remains __b_foo");
};
{#line 3959 deprivatize
Test::More::ok(! Basset::DB::Table->deprivatize, 'Cannot deprivatize w/o method');
Test::More::is(Basset::DB::Table->errcode, "BO-25", "proper error code");

Test::More::is(Basset::DB::Table->deprivatize('foo'), 'foo', "deprivatized foo");
Test::More::is(Basset::DB::Table->deprivatize('__b_foo'), 'foo', "deprivatized __b_foo");
};
{#line 3992 deprivatize
Test::More::ok(! Basset::DB::Table->is_private, 'Cannot is_private w/o method');
Test::More::is(Basset::DB::Table->errcode, "BO-26", "proper error code");

Test::More::ok(! Basset::DB::Table->is_private('foo'), 'foo is not private');
Test::More::ok(Basset::DB::Table->is_private('__b_foo'), '__b_foo is private');
};
{#line 4047 cast
package Basset::Test::Testing::Basset::DB::Table::cast::Subclass1;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

#pretend it was loaded normally
$INC{Basset::DB::Table->module_for_class("Basset::Test::Testing::Basset::DB::Table::cast::Subclass1")}++;

my $subclass = "Basset::Test::Testing::Basset::DB::Table::cast::Subclass1";

Test::More::ok(! Basset::DB::Table->cast, "Cannot cast classes");
Test::More::is(Basset::DB::Table->errcode, "BO-21", "proper error code");

my $o = Basset::DB::Table->new();
Test::More::ok($o, "got object");

Test::More::ok(! $o->cast, "Cannot cast w/o class");
Test::More::is($o->errcode, "BO-22", "proper error code");
my $c = $o->cast($subclass, 'copy');
Test::More::ok($c, "casted object");
Test::More::is($o->pkg, "Basset::DB::Table", "original part of super package");
Test::More::is($c->pkg, $subclass, "casted object part of sub package");
Test::More::is($c->errcode, $o->errcode, "error codes match, rest is assumed");

my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "got object");

Test::More::ok(! $o2->cast, "Cannot cast w/o class");
Test::More::is($o2->errcode, "BO-22", "proper error code");
my $c2 = $o2->cast($subclass, 'copy');
Test::More::ok($c2, "casted object");
Test::More::is($o2->pkg, "Basset::DB::Table", "original part of super package");
Test::More::is($c2->pkg, $subclass, "casted object part of sub package");
Test::More::is($c2->errcode, $o->errcode, "error codes match, rest is assumed");
};
{#line 4150 errortranslator
my $uses_real = Basset::DB::Table->use_real_errors();
Test::More::is(Basset::DB::Table->use_real_errors(0), 0, "Uses real errors");

my $translator = {
	'test error' => 'test message'
};

Test::More::ok($translator, "Created translator");
Test::More::is(Basset::DB::Table->errortranslator($translator), $translator, "Set translator");
Test::More::is(scalar Basset::DB::Table->error('test error', 'test code'), undef, "Set error");
Test::More::is(Basset::DB::Table->usererror(), 'test message', 'Re-wrote error message');

Test::More::is(Basset::DB::Table->errortranslator($uses_real), $uses_real, 'Class reset uses real error');
};
{#line 4182 use_real_errors
my $translator = Basset::DB::Table->errortranslator();
Test::More::ok(Basset::DB::Table->errortranslator(
	{
		'test code' => "friendly test message",
		'formatted test error %d' => "friendlier test message",
		'formatted test error 7' => 'friendliest test message',
		'extra error' => 'friendliest test message 2'
	}),
	'Class set error translator'
);

my $uses_real = Basset::DB::Table->use_real_errors();

my $confClass = Basset::DB::Table->pkg_for_type('conf');
Test::More::ok($confClass, "Got conf");

my $cfg = $confClass->conf;
Test::More::ok($cfg, "Got configuration");

Test::More::ok($cfg->{"Basset::Object"}->{'use_real_errors'} = 1, "enables real errors");

Test::More::is(scalar Basset::DB::Table->error("extra error", "test code"), undef, "Class sets error");
Test::More::is(Basset::DB::Table->usererror(), "extra error...with code (test code)", "Class gets literal error for literal");

Test::More::is(scalar Basset::DB::Table->error(["formatted test error %d", 7], "test code"), undef, "Class sets formatted error");
Test::More::is(Basset::DB::Table->usererror(), "formatted test error 7...with code (test code)", "Class gets literal error for formatted string");

Test::More::is(scalar Basset::DB::Table->error(["formatted test error %d", 9], "test code"), undef, "Class sets formatted error");
Test::More::is(Basset::DB::Table->usererror(), "formatted test error 9...with code (test code)", "Class gets literal error for string format");

Test::More::is(scalar Basset::DB::Table->error("Some test error", "test code"), undef, "Class sets standard error");
Test::More::is(Basset::DB::Table->usererror(), "Some test error...with code (test code)", "Class gets literal error for error code");

Test::More::is(scalar Basset::DB::Table->error("Some unknown error", "unknown code"), undef, "Class sets standard error w/o translation");
Test::More::is(Basset::DB::Table->usererror(), "Some unknown error...with code (unknown code)", "Class gets no user error");

Test::More::ok(Basset::DB::Table->errortranslator(
	{
		'test code' => "friendly test message",
		'formatted test error %d' => "friendlier test message",
		'formatted test error 7' => 'friendliest test message',
		'extra error' => 'friendliest test message 2',
		'*' => 'star error',
	}),
	'Class changed error translator'
);

Test::More::is(scalar Basset::DB::Table->error("Some unknown error", "unknown code"), undef, "Class sets standard error w/o translation");
Test::More::is(Basset::DB::Table->usererror(), "Some unknown error...with code (unknown code)", "Class gets literal star error");

Test::More::is(Basset::DB::Table->errortranslator($translator), $translator, 'Class reset error translator');
#Test::More::is(Basset::DB::Table->errortranslator($uses_real), $uses_real, 'Class reset uses real error');
#Test::More::ok('foo', 'bar');
Test::More::is($cfg->{"Basset::DB::Table"}->{'use_real_errors'} = $uses_real, $uses_real, "enables reset uses real errors");
};
{#line 4264 delegate
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Set up object");
my $o2 = Basset::DB::Table->new();
Test::More::ok($o2, "Set up second object");
Test::More::ok(! scalar Basset::DB::Table->delegate($o), "Class cannot set delegate");
Test::More::is(scalar $o->delegate($o2), $o2, "Object set delegate");
Test::More::is(scalar $o->delegate(), $o2, "Object accessed delegate");
Test::More::is(scalar $o->delegate(undef), undef, "Object deleted delegate");
};
{#line 4297 types
Test::More::ok(Basset::DB::Table->types, "Got types out of the conf file");
my $typesbkp = Basset::DB::Table->types();
my $newtypes = {%$typesbkp, 'testtype1' => 'Basset::DB::Table', 'testtype2' => 'boguspkg'};
Test::More::ok($typesbkp, "Backed up the types");
Test::More::is(Basset::DB::Table->types($newtypes), $newtypes, "Set new types");
Test::More::is(Basset::DB::Table->pkg_for_type('testtype1'), 'Basset::DB::Table', "Got class for new type");
Test::More::ok(! scalar Basset::DB::Table->pkg_for_type('testtype2'), "Could not access invalid type");
Test::More::is(Basset::DB::Table->types($typesbkp), $typesbkp, "Re-set original types");
};
{#line 4326 restrictions
package Basset::Test::Testing::Basset::DB::Table::restrictions::subclass1;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::restrictions::subclass1->isa('Basset::DB::Table'), 'proper subclass');
my $restrictions = {
	'foo' => [
		'a' => 'b'
	]
};
Test::More::ok($restrictions, 'made restrictions');
Test::More::is(Basset::Test::Testing::Basset::DB::Table::restrictions::subclass1->restrictions($restrictions), $restrictions, 'added restrictions');
Test::More::is(Basset::Test::Testing::Basset::DB::Table::restrictions::subclass1->restrictions, $restrictions, 'accessed restrictions');
};
{#line 4350 applied_restrictions
package Basset::Test::Testing::Basset::DB::Table::applied_restrictions::Subclass;
our @ISA = qw(Basset::DB::Table);

my %restrictions = (
	'specialerror' => [
		'error' => 'error3',
		'errcode' => 'errcode3'
	],
	'invalidrestriction' => [
		'junkymethod' => 'otherjunkymethod'
	]
);

Basset::DB::Table->add_class_attr('e3');
Basset::DB::Table->add_class_attr('c3');

Test::More::is(Basset::DB::Table->e3(0), 0, "set e3 to 0");
Test::More::is(Basset::DB::Table->c3(0), 0, "set c3 to 0");

sub error3 {
	my $self = shift;
	$self->e3($self->e3 + 1);
	return $self->SUPER::error(@_);
}

sub errcode3 {
	my $self = shift;
	$self->c3($self->c3 + 1);
	return $self->SUPER::errcode(@_);
}

Test::More::ok(scalar Basset::Test::Testing::Basset::DB::Table::applied_restrictions::Subclass->add_restrictions(%restrictions), "Added restrictions to subclass");

package Basset::DB::Table;

Test::More::ok(Basset::Test::Testing::Basset::DB::Table::applied_restrictions::Subclass->isa('Basset::DB::Table'), 'Proper subclass');
my $subclass = Basset::Test::Testing::Basset::DB::Table::applied_restrictions::Subclass->restrict('specialerror');
Test::More::ok($subclass, "Restricted error");
Test::More::ok(! scalar $subclass->add_restricted_method('invalidrestriction', 'junkymethod'), "Could not add invalid restriction");
Test::More::ok($subclass->restricted, "Subclass is restricted");

Test::More::ok($subclass->applied_restrictions, "Subclass has applied restrictions");
my $restrictions = $subclass->applied_restrictions;

Test::More::ok(ref $restrictions eq 'ARRAY', 'applied restrictions are an array');
Test::More::is(scalar @$restrictions, 1, "Subclass has 1 restriction");
Test::More::is($restrictions->[0], 'specialerror', 'Correct restriction in place');
};
{#line 4416 restricted
package Basset::Test::Testing::Basset::DB::Table::restricted::Subclass1;
our @ISA = qw(Basset::DB::Table);

package Basset::DB::Table;

Test::More::ok(! Basset::DB::Table->restricted, "Basset::DB::Table is not restricted");
Test::More::ok(! Basset::Test::Testing::Basset::DB::Table::restricted::Subclass1->restricted, "Subclass is not restricted");
my $subclass = Basset::DB::Table->inline_class;
Test::More::ok($subclass, "Subclassed Basset::DB::Table");
my $subclass2 = Basset::Test::Testing::Basset::DB::Table::restricted::Subclass1->inline_class();
Test::More::ok($subclass2, "Restricted Basset::Test::Testing::Basset::DB::Table::restricted::Subclass1");
Test::More::ok($subclass->restricted, "Subclass is restricted");
Test::More::ok($subclass2->restricted, "Subclass is restricted");
};
{#line 4480 exceptions
my $confClass = Basset::DB::Table->pkg_for_type('conf');
Test::More::ok($confClass, "Got conf");

my $cfg = $confClass->conf;
Test::More::ok($cfg, "Got configuration");

my $exceptions = $cfg->{"Basset::Object"}->{'exceptions'};

Test::More::is($cfg->{"Basset::Object"}->{'exceptions'} = 0, 0, "disables exceptions");
Test::More::is($cfg->{"Basset::Object"}->{'exceptions'} = 0, 0, "enables exceptions");
Test::More::is($cfg->{"Basset::Object"}->{'exceptions'} = $exceptions, $exceptions, "reset exceptions");
};
{#line 4509 last_exception
my $o = Basset::DB::Table->new();
Test::More::ok($o, "Got object");

my $confClass = Basset::DB::Table->pkg_for_type('conf');
Test::More::ok($confClass, "Got conf");

my $cfg = $confClass->conf;
Test::More::ok($cfg, "Got configuration");

Test::More::ok($cfg->{"Basset::Object"}->{'exceptions'} = 1, "enables exceptions");

Test::More::ok(scalar Basset::DB::Table->wipe_errors, "Wiped out errors");
Test::More::ok(! Basset::DB::Table->last_exception, "Last exception is empty");
eval {
	Basset::DB::Table->error('test exception', 'test code');
};
Test::More::like($@, "/test code/", "Thrown exception matches");
Test::More::like(Basset::DB::Table->last_exception, qr/test exception/, "Last exception matches");
Test::More::like($o->last_exception, qr/test exception/, "Object last exception matches");
Test::More::is($cfg->{"Basset::Object"}->{'exceptions'} = 0, 0,"disables exceptions");
};
