#ifdef __cplusplus
extern "C" {
#endif

/*
**  It seems that perfection is attained
**  not when there is nothing more to add,
**  but when there is nothing more to remove.
**                -- Antoine de Saint Exupery
*/

#include "uulib/UUID.h"
#include "XSUB.h"
#include "uulib/clear.h"
#include "uulib/clock.h"
#include "uulib/compare.h"
#include "uulib/gen.h"
#include "uulib/isnull.h"
#include "uulib/pack.h"
#include "uulib/parse.h"
#include "uulib/unpack.h"
#include "uulib/unparse.h"
#include "uulib/util.h"

#ifdef __cplusplus
}
#endif

/* 2 hex digits per byte + 4 separators */
#define UUID_BUFFSZ 36

#ifndef MUTEX_LOCK
#  define MUTEX_LOCK(m)           NOOP
#endif

#ifndef MUTEX_UNLOCK
#  define MUTEX_UNLOCK(m)         NOOP
#endif

#ifndef MUTEX_INIT
#  define MUTEX_INIT(m)           NOOP
#endif

#ifndef MUTEX_DESTROY
#  define MUTEX_DESTROY(m)        NOOP
#endif

#ifdef USE_ITHREADS
STATIC perl_mutex UUID_LOCK;
#else
#define UUID_LOCK dNOOP;
#endif

#ifndef SVf_THINKFIRST
#define SVf_THINKFIRST  (SVf_READONLY|SVf_PROTECT|SVf_ROK|SVf_FAKE \
                        |SVs_RMG|SVf_IsCOW)
#endif

#ifndef SvTHINKFIRST
#define SvTHINKFIRST(sv)  (SvFLAGS(sv) & SVf_THINKFIRST
#endif

#ifndef SV_CHECK_THINKFIRST_COW_DROP
#define SV_CHECK_THINKFIRST_COW_DROP(sv) \
    if (SvTHINKFIRST(sv)) \
        sv_force_normal_flags(sv, SV_COW_DROP_PV)
#endif

#ifndef CVf_AUTOLOAD
#define CvAUTOLOAD_off(cv) NOOP
#endif

#define UU_ALIAS_GENERATE_V0(out, su, dptr) \
    SV_CHECK_THINKFIRST_COW_DROP(out);      \
    if (isGV_with_GP(out))                  \
        croak("%s", PL_no_modify);          \
    SvUPGRADE(out, SVt_PV);                 \
    dptr = SvGROW(out, sizeof(uu_t)+1);     \
    MUTEX_LOCK(&UUID_LOCK);                 \
    uu_v0gen(aUCXT, &su);                   \
    MUTEX_UNLOCK(&UUID_LOCK);               \
    uu_pack(aUCXT, &su, (U8*)dptr);         \
    dptr[sizeof(uu_t)] = '\0';              \
    SvCUR_set(out, sizeof(uu_t));           \
    (void)SvPOK_only(out);                  \
    if (SvTYPE(out) == SVt_PVCV)            \
        CvAUTOLOAD_off(out);

#define UU_ALIAS_GENERATE_V1(out, su, dptr) \
    SV_CHECK_THINKFIRST_COW_DROP(out);      \
    if (isGV_with_GP(out))                  \
        croak("%s", PL_no_modify);          \
    SvUPGRADE(out, SVt_PV);                 \
    dptr = SvGROW(out, sizeof(uu_t)+1);     \
    MUTEX_LOCK(&UUID_LOCK);                 \
    uu_v1gen(aUCXT, &su);                   \
    MUTEX_UNLOCK(&UUID_LOCK);               \
    uu_pack(aUCXT, &su, (U8*)dptr);         \
    dptr[sizeof(uu_t)] = '\0';              \
    SvCUR_set(out, sizeof(uu_t));           \
    (void)SvPOK_only(out);                  \
    if (SvTYPE(out) == SVt_PVCV)            \
        CvAUTOLOAD_off(out);

#define UU_ALIAS_GENERATE_V4(out, su, dptr) \
    SV_CHECK_THINKFIRST_COW_DROP(out);      \
    if (isGV_with_GP(out))                  \
        croak("%s", PL_no_modify);          \
    SvUPGRADE(out, SVt_PV);                 \
    dptr = SvGROW(out, sizeof(uu_t)+1);     \
    MUTEX_LOCK(&UUID_LOCK);                 \
    uu_v4gen(aUCXT, &su);                   \
    MUTEX_UNLOCK(&UUID_LOCK);               \
    uu_pack4(aUCXT, &su, (U8*)dptr);        \
    dptr[sizeof(uu_t)] = '\0';              \
    SvCUR_set(out, sizeof(uu_t));           \
    (void)SvPOK_only(out);                  \
    if (SvTYPE(out) == SVt_PVCV)            \
        CvAUTOLOAD_off(out);

#define UU_ALIAS_GENERATE_V6(out, su, dptr) \
    SV_CHECK_THINKFIRST_COW_DROP(out);      \
    if (isGV_with_GP(out))                  \
        croak("%s", PL_no_modify);          \
    SvUPGRADE(out, SVt_PV);                 \
    dptr = SvGROW(out, sizeof(uu_t)+1);     \
    MUTEX_LOCK(&UUID_LOCK);                 \
    uu_v6gen(aUCXT, &su);                   \
    MUTEX_UNLOCK(&UUID_LOCK);               \
    uu_pack6(aUCXT, &su, (U8*)dptr);        \
    dptr[sizeof(uu_t)] = '\0';              \
    SvCUR_set(out, sizeof(uu_t));           \
    (void)SvPOK_only(out);                  \
    if (SvTYPE(out) == SVt_PVCV)            \
        CvAUTOLOAD_off(out);

#define UU_ALIAS_GENERATE_V7(out, su, dptr) \
    SV_CHECK_THINKFIRST_COW_DROP(out);      \
    if (isGV_with_GP(out))                  \
        croak("%s", PL_no_modify);          \
    SvUPGRADE(out, SVt_PV);                 \
    dptr = SvGROW(out, sizeof(uu_t)+1);     \
    MUTEX_LOCK(&UUID_LOCK);                 \
    uu_v7gen(aUCXT, &su);                   \
    MUTEX_UNLOCK(&UUID_LOCK);               \
    uu_pack7(aUCXT, &su, (U8*)dptr);        \
    dptr[sizeof(uu_t)] = '\0';              \
    SvCUR_set(out, sizeof(uu_t));           \
    (void)SvPOK_only(out);                  \
    if (SvTYPE(out) == SVt_PVCV)            \
        CvAUTOLOAD_off(out);

#define UU_ALIAS_UNPARSE_LOWER(in, out, us, dptr)    \
    if (SvPOK(in)) {                                 \
        dptr = SvGROW(in, sizeof(uu_t));             \
        uu_unpack(aUCXT, (unsigned char*)dptr, &us); \
        SV_CHECK_THINKFIRST_COW_DROP(out);           \
        if (isGV_with_GP(out))                       \
            croak("%s", PL_no_modify);               \
        SvUPGRADE(out, SVt_PV);                      \
        SvPOK_only(out);                             \
        dptr = SvGROW(out, UUID_BUFFSZ+1);           \
        uu_unparse_lower(aUCXT, &us, dptr);          \
        dptr[UUID_BUFFSZ] = '\0';                    \
        SvCUR_set(out, UUID_BUFFSZ);                 \
        (void)SvPOK_only(out);                       \
        if (SvTYPE(out) == SVt_PVCV)                 \
            CvAUTOLOAD_off(out);                     \
    }

#define UU_ALIAS_UNPARSE_UPPER(in, out, us, dptr)    \
    if (SvPOK(in)) {                                 \
        dptr = SvGROW(in, sizeof(uu_t));             \
        uu_unpack(aUCXT, (unsigned char*)dptr, &us); \
        SV_CHECK_THINKFIRST_COW_DROP(out);           \
        if (isGV_with_GP(out))                       \
            croak("%s", PL_no_modify);               \
        SvUPGRADE(out, SVt_PV);                      \
        SvPOK_only(out);                             \
        dptr = SvGROW(out, UUID_BUFFSZ+1);           \
        uu_unparse_upper(aUCXT, &us, dptr);          \
        dptr[UUID_BUFFSZ] = '\0';                    \
        SvCUR_set(out, UUID_BUFFSZ);                 \
        (void)SvPOK_only(out);                       \
        if (SvTYPE(out) == SVt_PVCV)                 \
            CvAUTOLOAD_off(out);                     \
    }

#define UU_ALIAS_UUID4(su, dptr)    \
    MUTEX_LOCK(&UUID_LOCK);         \
    uu_v4gen(aUCXT, &su);           \
    MUTEX_UNLOCK(&UUID_LOCK);       \
    RETVAL = newSV(UUID_BUFFSZ+1);  \
    dptr = SvPVX(RETVAL);           \
    uu_unparse4(aUCXT, &su, dptr);  \
    dptr[UUID_BUFFSZ] = '\0';       \
    SvCUR_set(RETVAL, UUID_BUFFSZ); \
    SvPOK_only(RETVAL);

#define UU_ALIAS_VERSION(in, su, str, len)              \
    RETVAL = -1;                                        \
    if (SvPOK(in)) {                                    \
        str = SvPV(in, len);                            \
        if (len == sizeof(uu_t)) {                      \
            uu_unpack(aUCXT, (unsigned char*)str, &su); \
            RETVAL = uu_type(aUCXT, &su);               \
        }                                               \
    }


#ifdef PERL_IMPLICIT_CONTEXT
# define dUCXT     dMY_CXT
# define UCXT_INIT MY_CXT_INIT
#else
# define dUCXT     my_cxt_t *my_cxtp = &my_cxt;
# define UCXT_INIT my_cxt_t *my_cxtp = &my_cxt;
#endif


#define MY_CXT_KEY "UUID::_guts" XS_VERSION
/* my_cxt_t global typedef lives in TYPE.h */
START_MY_CXT


MODULE = UUID		PACKAGE = UUID


BOOT:
    MUTEX_INIT(&UUID_LOCK);
    MUTEX_LOCK(&UUID_LOCK);
    {
        UCXT_INIT;
        SV **svp;

        UCXT.thread_id = 0;

        svp = hv_fetchs(PL_modglobal, "Time::NVtime", 0);
        if (!svp)         croak("Time::HiRes is required");
        if (!SvIOK(*svp)) croak("Time::NVtime isn't a function pointer");
        UCXT.myNVtime = INT2PTR(NV(*)(), SvIV(*svp));
        /* test
        {
            (*UCXT.myNVtime)(aTHX);
            printf("The current time is: %" NVff "\n", (*MY_CXT.myNVtime)());
        }
        */

        svp = hv_fetchs(PL_modglobal, "Time::U2time", 0);
        if (!svp)         croak("Time::HiRes is required");
        if (!SvIOK(*svp)) croak("Time::U2time isn't a function pointer");
        UCXT.myU2time = INT2PTR(void(*)(pTHX_ UV ret[2]), SvIV(*svp));
        /* test
        {
            UV  xx[2];
            (*UCXT.myU2time)(aTHX_ (UV*)&xx);
            printf("The current seconds are: %u.%06u\n", xx[0], xx[1]);
        }
        */

        uu_gen_init(aUCXT);
        uu_clock_init(aUCXT);
        UCXT.uu_statepath = NULL;
        UCXT.uu_statepath_len = 0;
    }
    MUTEX_UNLOCK(&UUID_LOCK);



void
_hide_always();
    PROTOTYPE:
    PREINIT:
        dUCXT;
    PPCODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_gen_setuniq(aUCXT);
        MUTEX_UNLOCK(&UUID_LOCK);

void
_hide_mac()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    PPCODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_gen_setrand(aUCXT);
        MUTEX_UNLOCK(&UUID_LOCK);

int
_persist(str)
    SV * str
    PREINIT:
        dUCXT;
    INIT:
    /* do not prototype. breaks t/5persist/boot.t */
        char    *ptr;
        STRLEN  len;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        if (SvTRUE(str)) {
            ptr = SvPVbyte(str, len);
            if (UCXT.uu_statepath)
                Safefree(UCXT.uu_statepath);
            Newxz(UCXT.uu_statepath, len+1, char);
            Copy(ptr, UCXT.uu_statepath, len, char);
            uu_init_statepath(aUCXT, UCXT.uu_statepath);
            UCXT.uu_statepath_len = len;
        }
        else {
            UCXT.uu_statepath     = NULL;
            UCXT.uu_statepath_len = 0;
            uu_init_statepath(aUCXT, UCXT.uu_statepath);
        }
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = 1;
    OUTPUT:
        RETVAL

SV *
_realnode()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    INIT:
        int         rv;
        char        *dptr;
        struct uu   su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        rv = uu_realnode(aUCXT, &su);
        MUTEX_UNLOCK(&UUID_LOCK);
        if (rv) {
            RETVAL = newSV(UUID_BUFFSZ+1);
            dptr = SvPVX(RETVAL);
            uu_unparse(aUCXT, &su, dptr);
            dptr[UUID_BUFFSZ] = '\0';
            SvCUR_set(RETVAL, UUID_BUFFSZ);
            SvPOK_only(RETVAL);
        }
        else
            RETVAL = &PL_sv_no;
    OUTPUT:
        RETVAL

SV *
_statepath()
    PREINIT:
        dUCXT;
    CODE:
    /* do not PROTOTYPE. breaks t/5persist/boot.t */
        MUTEX_LOCK(&UUID_LOCK);
        RETVAL = newSVpvn(UCXT.uu_statepath, UCXT.uu_statepath_len);
        MUTEX_UNLOCK(&UUID_LOCK);
    OUTPUT:
        RETVAL

void
clear(io)
    SV * io
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        struct uu   su;
        char        *dptr;
    CODE:
        UU_ALIAS_GENERATE_V0(io, su, dptr);

IV
compare(in1, in2)
    SV * in1
    SV * in2
    PROTOTYPE: $$
    PREINIT:
        dUCXT;
    INIT:
        STRLEN  len1, len2;
    CODE:
        if (SvPOK(in1) && SvPOK(in2)
            && SvCUR(in1) == sizeof(uu_t)
            && SvCUR(in2) == sizeof(uu_t))
            RETVAL = uu_cmp_binary(aUCXT,
                (U8*)SvPV_force(in1, len1),
                (U8*)SvPV_force(in2, len2)
            );
        else if (!SvOK(in1))
            RETVAL = SvOK(in2) ? -1 : 0;
        else if (!SvOK(in2))
            RETVAL = 1;
        else
            RETVAL = sv_cmp(in1, in2);
    OUTPUT:
        RETVAL

void
copy(out, in)
    SV * out
    SV * in
    PROTOTYPE: $$
    PREINIT:
        dUCXT;
    INIT:
        struct uu   su;
        STRLEN      len;
        char        *dptr;
    CODE:
        if (!SvPOK(in) || SvCUR(in) != sizeof(uu_t))
            uu_clear(aUCXT, &su);
        else
            uu_unpack(aUCXT, (U8*)SvPV_force(in, len), &su);
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, sizeof(uu_t)+1);
        uu_pack(aUCXT, &su, (U8*)dptr);
        dptr[sizeof(uu_t)] = '\0';
        SvCUR_set(out, sizeof(uu_t));
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        UU_ALIAS_GENERATE_V4(out, su, dptr);

void
generate_random(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        UU_ALIAS_GENERATE_V4(out, su, dptr);

void
generate_time(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        UU_ALIAS_GENERATE_V1(out, su, dptr);

void
generate_v0(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        UU_ALIAS_GENERATE_V0(out, su, dptr);

void
generate_v1(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        UU_ALIAS_GENERATE_V1(out, su, dptr);

void
generate_v4(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        UU_ALIAS_GENERATE_V4(out, su, dptr);

void
generate_v6(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu6  su;
    CODE:
        UU_ALIAS_GENERATE_V6(out, su, dptr);

void
generate_v7(out)
    SV * out
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu7  su;
    CODE:
        UU_ALIAS_GENERATE_V7(out, su, dptr);

IV
is_null(in)
    SV * in
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        STRLEN  len;
    CODE:
        if (!SvPOK(in))
            RETVAL = 0;
        else if (SvCUR(in) != sizeof(uu_t))
            RETVAL = 0;
        else
            RETVAL = uu_isnull_binary(aUCXT, (U8*)SvPV(in, len));
    OUTPUT:
        RETVAL

IV
parse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        /* XXX might see uninitialized data */
        RETVAL = -1;
        if (SvPOK(in) && !uu_parse(aUCXT, SvGROW(in, UUID_BUFFSZ+1), &su)) {
            SV_CHECK_THINKFIRST_COW_DROP(out);
            if (isGV_with_GP(out))
                croak("%s", PL_no_modify);
            SvUPGRADE(out, SVt_PV);
            dptr = SvGROW(out, sizeof(uu_t)+1);
            uu_pack(aUCXT, &su, (U8*)dptr);
            dptr[sizeof(uu_t)] = '\0';
            SvCUR_set(out, sizeof(uu_t));
            (void)SvPOK_only(out);
            if (SvTYPE(out) == SVt_PVCV)
                CvAUTOLOAD_off(out);
            RETVAL = 0;
        }
    OUTPUT:
    RETVAL

NV
time(in)
    SV * in
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
    CODE:
        RETVAL = 0;
        if (SvPOK(in)) {
            str = SvPV(in, len);
            if (len == sizeof(uu_t)) {
                uu_unpack(aUCXT, (U8*)str, &su);
                RETVAL = uu_time(aUCXT, &su);
            }
        }
    OUTPUT:
        RETVAL

IV
type(in)
    SV * in
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
    CODE:
        UU_ALIAS_VERSION(in, su, str, len);
    OUTPUT:
        RETVAL

void
unparse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    PREINIT:
        dUCXT;
    INIT:
        struct uu   us;
        char        *dptr;
    CODE:
        UU_ALIAS_UNPARSE_LOWER(in, out, us, dptr);

void
unparse_lower(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    PREINIT:
        dUCXT;
    INIT:
        struct uu   us;
        char        *dptr;
    CODE:
        UU_ALIAS_UNPARSE_LOWER(in, out, us, dptr);

void
unparse_upper(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    PREINIT:
        dUCXT;
    INIT:
        struct uu   us;
        char        *dptr;
    CODE:
        UU_ALIAS_UNPARSE_UPPER(in, out, us, dptr);

SV *
uuid()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        UU_ALIAS_UUID4(su, dptr);
    OUTPUT:
        RETVAL

SV *
uuid0()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v0gen(aUCXT, &su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUFFSZ+1);
        dptr = SvPVX(RETVAL);
        uu_unparse(aUCXT, &su, dptr);
        dptr[UUID_BUFFSZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUFFSZ);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid1()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v1gen(aUCXT, &su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUFFSZ+1);
        dptr = SvPVX(RETVAL);
        uu_unparse(aUCXT, &su, dptr);
        dptr[UUID_BUFFSZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUFFSZ);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid4()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        UU_ALIAS_UUID4(su, dptr);
    OUTPUT:
        RETVAL

SV *
uuid6()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu6  su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v6gen(aUCXT, &su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUFFSZ+1);
        dptr = SvPVX(RETVAL);
        uu_unparse6(aUCXT, &su, (char*)dptr);
        dptr[UUID_BUFFSZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUFFSZ);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid7()
    PROTOTYPE:
    PREINIT:
        dUCXT;
    INIT:
        char        *dptr;
        struct uu7  su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v7gen(aUCXT, &su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUFFSZ+1);
        dptr = SvPVX(RETVAL);
        uu_unparse7(aUCXT, &su, (char*)dptr);
        dptr[UUID_BUFFSZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUFFSZ);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

UV
variant(in)
    SV * in
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
    CODE:
        RETVAL = 0;
        if (SvPOK(in)) {
            str = SvPV(in, len);
            if (len == sizeof(uu_t)) {
                uu_unpack(aUCXT, (unsigned char*)str, &su);
                RETVAL = uu_variant(aUCXT, &su);
            }
        }
    OUTPUT:
        RETVAL

IV
version(in)
    SV * in
    PROTOTYPE: $
    PREINIT:
        dUCXT;
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
    CODE:
        UU_ALIAS_VERSION(in, su, str, len);
    OUTPUT:
        RETVAL

#if defined(USE_ITHREADS) && defined(MY_CXT_KEY) && defined(NOTYET)

void
CLONE(...)
    CODE:
        MY_CXT_CLONE;
        ++UCXT.thread_id;

#endif

