package Syntax::SourceHighlight;

use 5.010;
use strict;
use warnings;
use parent 'DynaLoader';

use Syntax::SourceHighlight::SourceHighlight;
use Syntax::SourceHighlight::LangMap;
use Syntax::SourceHighlight::HighlightEvent;

bootstrap Syntax::SourceHighlight;

sub highlightFile {
    my $self = shift;
    $self->highlight(@_);
}

sub highlightString {
    my $self      = shift;
    my $string    = shift;
    my $lang      = shift;
    my $file_name = shift // '';

    die __PACKAGE__
      . '->highlightString() accepts three arguments: '
      . 'string, language, and optional output file name'
      if @_
      or not defined $string
      or not defined $lang;
    return $self->highlights( $string, $lang, $file_name );
}

1;
