#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 133;
use_ok('HTML::Fraction');

# these are adapted forms of leon's tests

my $f = HTML::Fraction->new;
isa_ok($f, 'HTML::Fraction');

is($f->tweak("Hi there"), "Hi there");

my $test;
while (<DATA>) {
  chomp;
  unless ($test) {
    $test = $_;
    next;
  }
  unless ($_) {
    undef $test;
    next;
  }
  ((s/^!//) ? \&isnt : \&is )->($f->tweak("foo $_ foo $_ foo"),"foo $test foo $test foo", "convert $_");
}

__DATA__
&frac12;
1/2
0.5
.5
0.50
0.5000

&#8585;
0/3
!0
!0.0

&#8531;
1/3
0.33
0.333
0.3333
.33
.333
.3333
!.3
!.33334

&#8532;
2/3
0.67
0.667
0.6667
.67
.667
.6667
!.6

&frac14;
1/4
0.25
.25
0.250
.250
0.25000
.25000

&frac34;
3/4
0.75
.75
0.750
.750
0.75000
.75000

&#8533;
1/5
0.2
.2
0.20
.20
0.200
.200

&#8534;
2/5
0.4
.4
0.40
.40
0.400
.400

&#8535;
3/5
0.6
.6
0.60
.60
0.600
.600

&#8536;
4/5
0.8
.8
0.80
.80
0.800
.800

&#8537;
1/6
0.17
0.167
0.166667
.17
.167
.166667

&#8538;
5/6
0.83
0.833
0.83333
.83
.833
.83333

&#8528;
1/7
0.14
0.143
!0.142
0.1429
!0.1428
0.14286
!0.14285
0.142857
0.1428571
0.14285714
0.142857143
0.142857142857143
.14
.143
!.142
.1429
!.1428
.14286
!.14285
.142857
.1428571
.14285714
.142857143
.142857142857143

&#8539;
1/8
0.13
.13
0.125
.125
0.1250
.1250
0.12500
.12500

&#8529;
1/9
0.11
0.111
0.1111
.11
.111
.1111
!0.1

&#8530;
1/10
0.1
.1
0.10
.10
0.10000
.100000