
BEGIN {

    # For historical reasons, alias *Types::Bool with JSON::PP::Boolean
    *Types::Bool:: = *JSON::PP::Boolean::;
}

package Types::Bool;
$Types::Bool::VERSION = '0.1.0'; # TRIAL
# ABSTRACT: Booleans as objects for Perl

use 5.005;

BEGIN {
    require overload;
    overload->import(
        '0+' => sub { ${ $_[0] } },
        '++' => sub { $_[0] = ${ $_[0] } + 1 },
        '--' => sub { $_[0] = ${ $_[0] } - 1 },
        fallback => 1,
    ) unless overload::Method( Types::Bool, '0+' );

    require constant;
    constant->import( true => bless \( my $dummy = 1 ), 'Types::Bool' )
      unless Types::Bool->can('true');
    constant->import( false => bless \( my $dummy = 0 ), 'Types::Bool' )
      unless Types::Bool->can('false');

    unless ( Types::Bool->can('is_bool') ) {
        require Scalar::Util;
        *is_bool = sub ($) { Scalar::Util::blessed( $_[0] ) and $_[0]->isa('Types::Bool') };
    }
}

sub to_bool ($) { $_[0] ? true : false }

@Types::Bool::EXPORT_OK = qw(true false is_bool to_bool);

sub import {    # Load Exporter only if needed
    return unless @_ > 1;

    require Exporter;
    my $EXPORTER_VERSION = Exporter->VERSION;
    $EXPORTER_VERSION =~ tr/_//d;
    push @ISA, qw(Exporter) if $EXPORTER_VERSION < 5.57;

    no warnings 'redefine';
    *import = sub {
        return unless @_ > 1;
        goto &Exporter::import;
    };
    goto &Exporter::import;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Types::Bool - Booleans as objects for Perl

=head1 VERSION

version 0.1.0

=head1 AUTHOR

Adriano Ferreira <ferreira@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Adriano Ferreira.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
