# Generated by default/object.tt
package Paws::LookoutMetrics::ItemizedMetricStats;
  use Moose;
  has MetricName => (is => 'ro', isa => 'Str');
  has OccurrenceCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::ItemizedMetricStats

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::ItemizedMetricStats object:

  $service_obj->Method(Att1 => { MetricName => $value, ..., OccurrenceCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::ItemizedMetricStats object:

  $result = $service_obj->Method(...);
  $result->Att1->MetricName

=head1 DESCRIPTION

Aggregated statistics about a measure affected by an anomaly.

=head1 ATTRIBUTES


=head2 MetricName => Str

The name of the measure.


=head2 OccurrenceCount => Int

The number of times that the measure appears.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

