# Generated by default/object.tt
package Paws::Macie2::SearchResourcesCriteriaBlock;
  use Moose;
  has And => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::SearchResourcesCriteria]', request_name => 'and', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SearchResourcesCriteriaBlock

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SearchResourcesCriteriaBlock object:

  $service_obj->Method(Att1 => { And => $value, ..., And => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SearchResourcesCriteriaBlock object:

  $result = $service_obj->Method(...);
  $result->Att1->And

=head1 DESCRIPTION

Specifies property- and tag-based conditions that define filter
criteria for including or excluding Amazon Web Services resources from
the query results.

=head1 ATTRIBUTES


=head2 And => ArrayRef[L<Paws::Macie2::SearchResourcesCriteria>]

An array of objects, one for each property- or tag-based condition that
includes or excludes resources from the query results. If you specify
more than one condition, Amazon Macie uses AND logic to join the
conditions.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

