# NAME

Pluto - Functional Programming

# ABSTRACT

Functional Scripting for Perl 5

# SYNOPSIS

    package Cosmos;

    use Pluto;

    call(string('hello world'), 'titlecase');

    # Hello World

# DESCRIPTION

This package enables functional programming for Perl 5 via indirect routine
dispatching and dependency injection, operating in a way that plays nicely with
third-party libraries without having to switch over to object-oriented
programming.

# WHY

Perl is a multi-paradigm programming language that supports functional
programming, but, Perl has an intentionally limited standard library with an
emphasis on providing library support via the CPAN which is overwhelmingly
object-oriented. This makes developing in a functional style difficult as
you'll eventually need to rely on a CPAN library that requires you to switch
over to object-oriented programming.

# LIBRARIES

This package uses type constraints from:

[Types::Standard](https://metacpan.org/pod/Types::Standard)

# SCENARIOS

This package supports the following scenarios:

## array

    # given: synopsis

    array;

This package supports making the `array` function available in the calling
package if it doesn't exist already. This function creates a
[Data::Object::Array](https://metacpan.org/pod/Data::Object::Array) object.

## bool

    # given: synopsis

    bool;

This package supports making the `bool` function available in the calling
package if it doesn't exist already. This function creates a
[Data::Object::Boolean](https://metacpan.org/pod/Data::Object::Boolean) object.

## call

    # given: synopsis

    call('Test', 'ok');

This package supports making the `call` function available in the calling
package. This function dispatches function and method calls to a package.

## code

    # given: synopsis

    code;

This package supports making the `code` function available in the calling
package if it doesn't exist already. This function creates a
[Data::Object::Code](https://metacpan.org/pod/Data::Object::Code) object.

## false

    # given: synopsis

    false;

This package supports making the `false` function available in the calling
package if it doesn't exist already. This function creates a
[Data::Object::Boolean](https://metacpan.org/pod/Data::Object::Boolean) object.

## float

    # given: synopsis

    float;

This package supports making the `float` function available in the)calling
package if it doesn't exist already. This function creates a
[Data::Object::Float](https://metacpan.org/pod/Data::Object::Float) object.

## hash

    # given: synopsis

    hash;

This package supports making the `hash` function available in the)calling
package if it doesn't exist already. This function creates a
[Data::Object::Hash](https://metacpan.org/pod/Data::Object::Hash) object.

## number

    # given: synopsis

    number;

This package supports making the `number` function available in the)calling
package if it doesn't exist already. This function creates a
[Data::Object::Number](https://metacpan.org/pod/Data::Object::Number) object.

## regexp

    # given: synopsis

    regexp;

This package supports making the `regexp` function available in the)calling
package if it doesn't exist already. This function creates a
[Data::Object::Regexp](https://metacpan.org/pod/Data::Object::Regexp) object.

## space

    # given: synopsis

    space;

This package supports making the `space` function available in the)calling
package if it doesn't exist already. This function creates a
[Data::Object::Space](https://metacpan.org/pod/Data::Object::Space) object.

## string

    # given: synopsis

    string;

This package supports making the `string` function available in the)calling
package if it doesn't exist already. This function creates a
[Data::Object::String](https://metacpan.org/pod/Data::Object::String) object.

## true

    # given: synopsis

    true;

This package supports making the `true` function available in the)calling
package if it doesn't exist already. This function creates a
[Data::Object::Boolean](https://metacpan.org/pod/Data::Object::Boolean) object.

# AUTHOR

Al Newkirk, `awncorp@cpan.org`

# LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the ["license
file"](https://github.com/iamalnewkirk/pluto/blob/master/LICENSE).

# PROJECT

[Wiki](https://github.com/iamalnewkirk/pluto/wiki)

[Project](https://github.com/iamalnewkirk/pluto)

[Initiatives](https://github.com/iamalnewkirk/pluto/projects)

[Milestones](https://github.com/iamalnewkirk/pluto/milestones)

[Contributing](https://github.com/iamalnewkirk/pluto/blob/master/CONTRIBUTE.md)

[Issues](https://github.com/iamalnewkirk/pluto/issues)
