package AWS::Lambda::AL2023;
use 5.026000;
use strict;
use warnings;

our $VERSION = "0.4.1";

# This list is auto generated by authors/update-aws-lambda-al2023.pl; DO NOT EDIT
our $LAYERS = {
    '5.38' => {
        'x86_64' => {
            'af-south-1' => {
                runtime_arn     => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-east-1' => {
                runtime_arn     => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-northeast-1' => {
                runtime_arn     => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-northeast-2' => {
                runtime_arn     => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-northeast-3' => {
                runtime_arn     => "arn:aws:lambda:ap-northeast-3:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-northeast-3:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-south-1' => {
                runtime_arn     => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-south-2' => {
                runtime_arn     => "arn:aws:lambda:ap-south-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-south-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-southeast-1' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-southeast-2' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-southeast-3' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-3:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-3:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ap-southeast-4' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-4:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-4:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'ca-central-1' => {
                runtime_arn     => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-central-1' => {
                runtime_arn     => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-central-2' => {
                runtime_arn     => "arn:aws:lambda:eu-central-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-central-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-north-1' => {
                runtime_arn     => "arn:aws:lambda:eu-north-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-north-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-south-1' => {
                runtime_arn     => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-south-2' => {
                runtime_arn     => "arn:aws:lambda:eu-south-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-south-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-west-1' => {
                runtime_arn     => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-west-2' => {
                runtime_arn     => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'eu-west-3' => {
                runtime_arn     => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'il-central-1' => {
                runtime_arn     => "arn:aws:lambda:il-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:il-central-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'me-central-1' => {
                runtime_arn     => "arn:aws:lambda:me-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:me-central-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'me-south-1' => {
                runtime_arn     => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'sa-east-1' => {
                runtime_arn     => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'us-east-1' => {
                runtime_arn     => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'us-east-2' => {
                runtime_arn     => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'us-west-1' => {
                runtime_arn     => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
            'us-west-2' => {
                runtime_arn     => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-38-paws-al2023-x86_64:3",
                paws_version    => 3,
            },
        },
        'arm64' => {
            'af-south-1' => {
                runtime_arn     => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-east-1' => {
                runtime_arn     => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-northeast-1' => {
                runtime_arn     => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-northeast-2' => {
                runtime_arn     => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-northeast-3' => {
                runtime_arn     => "arn:aws:lambda:ap-northeast-3:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-northeast-3:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-south-1' => {
                runtime_arn     => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-south-2' => {
                runtime_arn     => "arn:aws:lambda:ap-south-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-south-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-southeast-1' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-southeast-2' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-southeast-3' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-3:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-3:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ap-southeast-4' => {
                runtime_arn     => "arn:aws:lambda:ap-southeast-4:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ap-southeast-4:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'ca-central-1' => {
                runtime_arn     => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-central-1' => {
                runtime_arn     => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-central-2' => {
                runtime_arn     => "arn:aws:lambda:eu-central-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-central-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-north-1' => {
                runtime_arn     => "arn:aws:lambda:eu-north-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-north-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-south-1' => {
                runtime_arn     => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-south-2' => {
                runtime_arn     => "arn:aws:lambda:eu-south-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-south-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-west-1' => {
                runtime_arn     => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-west-2' => {
                runtime_arn     => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'eu-west-3' => {
                runtime_arn     => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'il-central-1' => {
                runtime_arn     => "arn:aws:lambda:il-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:il-central-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'me-central-1' => {
                runtime_arn     => "arn:aws:lambda:me-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:me-central-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'me-south-1' => {
                runtime_arn     => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'sa-east-1' => {
                runtime_arn     => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'us-east-1' => {
                runtime_arn     => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'us-east-2' => {
                runtime_arn     => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'us-west-1' => {
                runtime_arn     => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
            'us-west-2' => {
                runtime_arn     => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2",
                runtime_version => 2,
                paws_arn        => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-38-paws-al2023-arm64:1",
                paws_version    => 1,
            },
        },
    },
};


sub get_layer_info {
    my ($version, $region, $arch) = @_;
    $arch //= 'x86_64';
    return $LAYERS->{$version}{$arch}{$region};
}

sub print_runtime_arn {
    my ($version, $region, $arch) = @_;
    $arch //= 'x86_64';
    print $LAYERS->{$version}{$arch}{$region}{runtime_arn};
}

sub print_paws_arn {
    my ($version, $region, $arch) = @_;
    $arch //= 'x86_64';
    print $LAYERS->{$version}{$arch}{$region}{paws_arn};
}

1;
__END__

=encoding utf-8

=head1 NAME

AWS::Lambda::AL2023 - AWS Lambda Custom Runtimes based on Amazon Linux 2023

=head1 SYNOPSIS

You can get the layer ARN in your script by using C<get_layer_info>.

    use AWS::Lambda::AL2023;
    my $info = AWS::Lambda::get_layer_info(
        "5.38",      # Perl Version
        "us-east-1", # Region
        "x86_64",    # Architecture ("x86_64" or "arm64", optional, the default is "x86_64")
    );
    say $info->{runtime_arn};     # arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2
    say $info->{runtime_version}; # 2
    say $info->{paws_arn}         # arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-paws-al2023-x86_64:3
    say $info->{paws_version}     # 3,

Or, you can use following one-liner.

    perl -MAWS::Lambda -e 'AWS::Lambda::print_runtime_arn("5.38", "us-east-1")'
    perl -MAWS::Lambda -e 'AWS::Lambda::print_paws_arn("5.38", "us-east-1")'

The list of all available layer ARN is here:

=over

=item Perl 5.38

=over

=item x86_64 architecture

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-northeast-3:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-south-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-southeast-3:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ap-southeast-4:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-central-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-north-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-south-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:il-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:me-central-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-38-runtime-al2023-x86_64:2>

=back

=item arm64 architecture

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-northeast-3:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-south-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-southeast-3:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ap-southeast-4:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-central-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-north-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-south-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:il-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:me-central-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-38-runtime-al2023-arm64:2>

=back

=back

=back

=head2 Use Pre-built Zip Archives

URLs for Zip archives are:

C<https://shogo82148-lambda-perl-runtime-$REGION.s3.amazonaws.com/perl-$VERSION-runtime-al2023-$ARCHITECTURE.zip>

And Paws:

C<https://shogo82148-lambda-perl-runtime-$REGION.s3.amazonaws.com/perl-$VERSION-paws-al2023-$ARCHITECTURE.zip>

=head2 Pre-installed modules

The following modules are pre-installed for convenience.

=over

=item L<AWS::Lambda>

=item L<AWS::XRay>

=item L<JSON>

=item L<Cpanel::JSON::XS>

=item L<JSON::MaybeXS>

=item L<YAML>

=item L<YAML::Tiny>

=item L<YAML::XS>

=item L<Net::SSLeay>

=item L<IO::Socket::SSL>

=item L<Mozilla::CA>

=back

L<Paws> is optional

=head1 SEE ALSO

=over

=item L<AWS::Lambda>

=item L<AWS::Lambda::Bootstrap>

=item L<AWS::Lambda::Context>

=item L<AWS::Lambda::PSGI>

=item L<Paws>

=item L<AWS::XRay>

=back

=head1 LICENSE

The MIT License (MIT)

Copyright (C) ICHINOSE Shogo

=head1 AUTHOR

ICHINOSE Shogo

=cut
