# Generated by default/object.tt
package Paws::AccessAnalyzer::PathElement;
  use Moose;
  has Index => (is => 'ro', isa => 'Int', request_name => 'index', traits => ['NameInRequest']);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Substring => (is => 'ro', isa => 'Paws::AccessAnalyzer::Substring', request_name => 'substring', traits => ['NameInRequest']);
  has Value => (is => 'ro', isa => 'Str', request_name => 'value', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::PathElement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::PathElement object:

  $service_obj->Method(Att1 => { Index => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::PathElement object:

  $result = $service_obj->Method(...);
  $result->Att1->Index

=head1 DESCRIPTION

A single element in a path through the JSON representation of a policy.

=head1 ATTRIBUTES


=head2 Index => Int

Refers to an index in a JSON array.


=head2 Key => Str

Refers to a key in a JSON object.


=head2 Substring => L<Paws::AccessAnalyzer::Substring>

Refers to a substring of a literal string in a JSON object.


=head2 Value => Str

Refers to the value associated with a given key in a JSON object.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

