# Generated by default/object.tt
package Paws::SecurityHub::AwsEc2EipDetails;
  use Moose;
  has AllocationId => (is => 'ro', isa => 'Str');
  has AssociationId => (is => 'ro', isa => 'Str');
  has Domain => (is => 'ro', isa => 'Str');
  has InstanceId => (is => 'ro', isa => 'Str');
  has NetworkBorderGroup => (is => 'ro', isa => 'Str');
  has NetworkInterfaceId => (is => 'ro', isa => 'Str');
  has NetworkInterfaceOwnerId => (is => 'ro', isa => 'Str');
  has PrivateIpAddress => (is => 'ro', isa => 'Str');
  has PublicIp => (is => 'ro', isa => 'Str');
  has PublicIpv4Pool => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEc2EipDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEc2EipDetails object:

  $service_obj->Method(Att1 => { AllocationId => $value, ..., PublicIpv4Pool => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEc2EipDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AllocationId

=head1 DESCRIPTION

Information about an Elastic IP address.

=head1 ATTRIBUTES


=head2 AllocationId => Str

The identifier that AWS assigns to represent the allocation of the
Elastic IP address for use with Amazon VPC.


=head2 AssociationId => Str

The identifier that represents the association of the Elastic IP
address with an EC2 instance.


=head2 Domain => Str

The domain in which to allocate the address.

If the address is for use with EC2 instances in a VPC, then C<Domain>
is C<vpc>. Otherwise, C<Domain> is C<standard>.


=head2 InstanceId => Str

The identifier of the EC2 instance.


=head2 NetworkBorderGroup => Str

The name of the location from which the Elastic IP address is
advertised.


=head2 NetworkInterfaceId => Str

The identifier of the network interface.


=head2 NetworkInterfaceOwnerId => Str

The AWS account ID of the owner of the network interface.


=head2 PrivateIpAddress => Str

The private IP address that is associated with the Elastic IP address.


=head2 PublicIp => Str

A public IP address that is associated with the EC2 instance.


=head2 PublicIpv4Pool => Str

The identifier of an IP address pool. This parameter allows Amazon EC2
to select an IP address from the address pool.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

