
package Paws::QLDB::DescribeJournalKinesisStream;
  use Moose;
  has LedgerName => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'name', required => 1);
  has StreamId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'streamId', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeJournalKinesisStream');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/ledgers/{name}/journal-kinesis-streams/{streamId}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::QLDB::DescribeJournalKinesisStreamResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::QLDB::DescribeJournalKinesisStream - Arguments for method DescribeJournalKinesisStream on L<Paws::QLDB>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeJournalKinesisStream on the
L<Amazon QLDB|Paws::QLDB> service. Use the attributes of this class
as arguments to method DescribeJournalKinesisStream.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeJournalKinesisStream.

=head1 SYNOPSIS

    my $qldb = Paws->service('QLDB');
    my $DescribeJournalKinesisStreamResponse =
      $qldb->DescribeJournalKinesisStream(
      LedgerName => 'MyLedgerName',
      StreamId   => 'MyUniqueId',

      );

    # Results:
    my $Stream = $DescribeJournalKinesisStreamResponse->Stream;

    # Returns a L<Paws::QLDB::DescribeJournalKinesisStreamResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/qldb/DescribeJournalKinesisStream>

=head1 ATTRIBUTES


=head2 B<REQUIRED> LedgerName => Str

The name of the ledger.



=head2 B<REQUIRED> StreamId => Str

The UUID (represented in Base62-encoded text) of the QLDB journal
stream to describe.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeJournalKinesisStream in L<Paws::QLDB>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

