#!/usr/bin/perl

package eBay::API::XML::DataType::CartItemArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CartItemArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CartItemArrayType

=head1 DESCRIPTION

A collection of CartItems.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CartItemArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::CartItemType;


my @gaProperties = ( [ 'CartItem', 'ns:CartItemType', '1'
	     ,'eBay::API::XML::DataType::CartItemType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCartItem()

Details about a cart item and what to do with it (for example, add it
to the cart, remove it from the cart, or change the quantity for an item).
As a return type, this and its children are only returned if there are
items in the cart after the last SetCart operation.
This is only required if the parent container is submitted.

  Calls: SetCart
  RequiredInput: Conditionally

#    Argument: reference to an array  
                      of 'ns:CartItemType'

=cut

sub setCartItem {
  my $self = shift;
  $self->{'CartItem'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCartItem()

  Calls: GetCart
         SetCart
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:CartItemType'

=cut

sub getCartItem {
  my $self = shift;
  return $self->_getDataTypeArray('CartItem');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
