#!/usr/bin/perl

package eBay::API::XML::Call::GetStoreOptions::GetStoreOptionsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetStoreOptionsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetStoreOptions::GetStoreOptionsResponseType

=head1 DESCRIPTION

Contains the current list of options for Store configurations.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetStoreOptions::GetStoreOptionsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::StoreLogoArrayType;
use eBay::API::XML::DataType::StoreSubscriptionArrayType;
use eBay::API::XML::DataType::StoreThemeArrayType;


my @gaProperties = ( [ 'AdvancedThemeArray', 'ns:StoreThemeArrayType', ''
	     ,'eBay::API::XML::DataType::StoreThemeArrayType', '1' ]
	, [ 'BasicThemeArray', 'ns:StoreThemeArrayType', ''
	     ,'eBay::API::XML::DataType::StoreThemeArrayType', '1' ]
	, [ 'LogoArray', 'ns:StoreLogoArrayType', ''
	     ,'eBay::API::XML::DataType::StoreLogoArrayType', '1' ]
	, [ 'MaxCategories', 'xs:int', '', '', '' ]
	, [ 'MaxCategoryLevels', 'xs:int', '', '', '' ]
	, [ 'SubscriptionArray', 'ns:StoreSubscriptionArrayType', ''
	     ,'eBay::API::XML::DataType::StoreSubscriptionArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdvancedThemeArray()

The current set of advances themes. Unlike basic themes, you
can use any color	scheme with an advanced theme. These themes 
are suitable for more advanced customization.

#    Argument: 'ns:StoreThemeArrayType'

=cut

sub setAdvancedThemeArray {
  my $self = shift;
  $self->{'AdvancedThemeArray'} = shift
}

=head2 getAdvancedThemeArray()

  Returned: Always
#    Returns: 'ns:StoreThemeArrayType'

=cut

sub getAdvancedThemeArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AdvancedThemeArray'
		,'eBay::API::XML::DataType::StoreThemeArrayType');
}


=head2 setBasicThemeArray()

The current set of basic themes. Each basic theme definition
specifies a valid color scheme for the theme.

#    Argument: 'ns:StoreThemeArrayType'

=cut

sub setBasicThemeArray {
  my $self = shift;
  $self->{'BasicThemeArray'} = shift
}

=head2 getBasicThemeArray()

  Returned: Always
#    Returns: 'ns:StoreThemeArrayType'

=cut

sub getBasicThemeArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BasicThemeArray'
		,'eBay::API::XML::DataType::StoreThemeArrayType');
}


=head2 setLogoArray()

The current set of Store logos. These logos are used in the Store header.

#    Argument: 'ns:StoreLogoArrayType'

=cut

sub setLogoArray {
  my $self = shift;
  $self->{'LogoArray'} = shift
}

=head2 getLogoArray()

  Returned: Always
#    Returns: 'ns:StoreLogoArrayType'

=cut

sub getLogoArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LogoArray'
		,'eBay::API::XML::DataType::StoreLogoArrayType');
}


=head2 setMaxCategories()

The maximum number of categories in this store.

#    Argument: 'xs:int'

=cut

sub setMaxCategories {
  my $self = shift;
  $self->{'MaxCategories'} = shift
}

=head2 getMaxCategories()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getMaxCategories {
  my $self = shift;
  return $self->{'MaxCategories'};
}


=head2 setMaxCategoryLevels()

The maximum number of category levels in this store.

#    Argument: 'xs:int'

=cut

sub setMaxCategoryLevels {
  my $self = shift;
  $self->{'MaxCategoryLevels'} = shift
}

=head2 getMaxCategoryLevels()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getMaxCategoryLevels {
  my $self = shift;
  return $self->{'MaxCategoryLevels'};
}


=head2 setSubscriptionArray()

The current set of eBay Store subscription tiers and corresponding 
subscription prices.

#    Argument: 'ns:StoreSubscriptionArrayType'

=cut

sub setSubscriptionArray {
  my $self = shift;
  $self->{'SubscriptionArray'} = shift
}

=head2 getSubscriptionArray()

  Returned: Always
#    Returns: 'ns:StoreSubscriptionArrayType'

=cut

sub getSubscriptionArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SubscriptionArray'
		,'eBay::API::XML::DataType::StoreSubscriptionArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
