# Generated by default/object.tt
package Paws::ComputeOptimizer::LambdaFunctionRecommendation;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has CurrentMemorySize => (is => 'ro', isa => 'Int', request_name => 'currentMemorySize', traits => ['NameInRequest']);
  has Finding => (is => 'ro', isa => 'Str', request_name => 'finding', traits => ['NameInRequest']);
  has FindingReasonCodes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'findingReasonCodes', traits => ['NameInRequest']);
  has FunctionArn => (is => 'ro', isa => 'Str', request_name => 'functionArn', traits => ['NameInRequest']);
  has FunctionVersion => (is => 'ro', isa => 'Str', request_name => 'functionVersion', traits => ['NameInRequest']);
  has LastRefreshTimestamp => (is => 'ro', isa => 'Str', request_name => 'lastRefreshTimestamp', traits => ['NameInRequest']);
  has LookbackPeriodInDays => (is => 'ro', isa => 'Num', request_name => 'lookbackPeriodInDays', traits => ['NameInRequest']);
  has MemorySizeRecommendationOptions => (is => 'ro', isa => 'ArrayRef[Paws::ComputeOptimizer::LambdaFunctionMemoryRecommendationOption]', request_name => 'memorySizeRecommendationOptions', traits => ['NameInRequest']);
  has NumberOfInvocations => (is => 'ro', isa => 'Int', request_name => 'numberOfInvocations', traits => ['NameInRequest']);
  has UtilizationMetrics => (is => 'ro', isa => 'ArrayRef[Paws::ComputeOptimizer::LambdaFunctionUtilizationMetric]', request_name => 'utilizationMetrics', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::LambdaFunctionRecommendation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::LambdaFunctionRecommendation object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., UtilizationMetrics => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::LambdaFunctionRecommendation object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Describes an AWS Lambda function recommendation.

=head1 ATTRIBUTES


=head2 AccountId => Str

The AWS account ID of the function.


=head2 CurrentMemorySize => Int

The amount of memory, in MB, that's allocated to the current function.


=head2 Finding => Str

The finding classification of the function.

Findings for functions include:

=over

=item *

B<C<Optimized> > E<mdash> The function is correctly provisioned to run
your workload based on its current configuration and its utilization
history. This finding classification does not include finding reason
codes.

=item *

B<C<NotOptimized> > E<mdash> The function is performing at a higher
level (over-provisioned) or at a lower level (under-provisioned) than
required for your workload because its current configuration is not
optimal. Over-provisioned resources might lead to unnecessary
infrastructure cost, and under-provisioned resources might lead to poor
application performance. This finding classification can include the
C<MemoryUnderprovisioned> and C<MemoryUnderprovisioned> finding reason
codes.

=item *

B<C<Unavailable> > E<mdash> Compute Optimizer was unable to generate a
recommendation for the function. This could be because the function has
not accumulated sufficient metric data, or the function does not
qualify for a recommendation. This finding classification can include
the C<InsufficientData> and C<Inconclusive> finding reason codes.

Functions with a finding of unavailable are not returned unless you
specify the C<filter> parameter with a value of C<Unavailable> in your
C<GetLambdaFunctionRecommendations> request.

=back



=head2 FindingReasonCodes => ArrayRef[Str|Undef]

The reason for the finding classification of the function.

Functions that have a finding classification of C<Optimized> don't have
a finding reason code.

Finding reason codes for functions include:

=over

=item *

B<C<MemoryOverprovisioned> > E<mdash> The function is over-provisioned
when its memory configuration can be sized down while still meeting the
performance requirements of your workload. An over-provisioned function
might lead to unnecessary infrastructure cost. This finding reason code
is part of the C<NotOptimized> finding classification.

=item *

B<C<MemoryUnderprovisioned> > E<mdash> The function is
under-provisioned when its memory configuration doesn't meet the
performance requirements of the workload. An under-provisioned function
might lead to poor application performance. This finding reason code is
part of the C<NotOptimized> finding classification.

=item *

B<C<InsufficientData> > E<mdash> The function does not have sufficient
metric data for Compute Optimizer to generate a recommendation. For
more information, see the Supported resources and requirements
(https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html)
in the I<AWS Compute Optimizer User Guide>. This finding reason code is
part of the C<Unavailable> finding classification.

=item *

B<C<Inconclusive> > E<mdash> The function does not qualify for a
recommendation because Compute Optimizer cannot generate a
recommendation with a high degree of confidence. This finding reason
code is part of the C<Unavailable> finding classification.

=back



=head2 FunctionArn => Str

The Amazon Resource Name (ARN) of the current function.


=head2 FunctionVersion => Str

The version number of the current function.


=head2 LastRefreshTimestamp => Str

The time stamp of when the function recommendation was last refreshed.


=head2 LookbackPeriodInDays => Num

The number of days for which utilization metrics were analyzed for the
function.


=head2 MemorySizeRecommendationOptions => ArrayRef[L<Paws::ComputeOptimizer::LambdaFunctionMemoryRecommendationOption>]

An array of objects that describe the memory configuration
recommendation options for the function.


=head2 NumberOfInvocations => Int

The number of times your function code was executed during the
look-back period.


=head2 UtilizationMetrics => ArrayRef[L<Paws::ComputeOptimizer::LambdaFunctionUtilizationMetric>]

An array of objects that describe the utilization metrics of the
function.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

