package RapidApp::Template::Store::Dummy;
use strict;
use warnings;
use autodie;

use RapidApp::Util qw(:all);

use Moo;
extends 'RapidApp::Template::Store';
use Types::Standard ':all';


=pod

=head1 DESCRIPTION

Reference implementation for L<RapidApp::Template::Store>.

=cut

has 'dummy_template_name',    is => 'ro', isa => Str, default => sub { 'site/dummy/template.md' };

my $dummy_mtime   = time;
my $dummy_deleted = 0;
my $dummy_content = "Default dummy template content.\n\nGenerated by the RapidApp::Template::Store::Dummy reference implementation";

sub dummy_template_mtime   { $dummy_mtime   = $_[1] if (scalar(@_) > 1); $dummy_mtime   }
sub dummy_template_content { $dummy_content = $_[1] if (scalar(@_) > 1); $dummy_content }
sub dummy_template_deleted { $dummy_deleted = $_[1] if (scalar(@_) > 1); $dummy_deleted }


sub owns_tpl {
  my ($self, $name) = @_;
  
  # Report ownership of only our single our dummy template name
  return $name eq $self->dummy_template_name
}

sub template_mtime {
  my ($self, $name) = @_;
  $name eq $self->dummy_template_name or die "this should never happen";
  return undef if ($self->dummy_template_deleted);
  return $self->dummy_template_mtime;
}

sub template_content {
  my ($self, $name) = @_;
  $name eq $self->dummy_template_name or die "this should never happen";
  return $self->dummy_template_content
}

sub template_exists {
  my ($self, $name) = @_;
  $name eq $self->dummy_template_name or die "this should never happen";
  return $self->dummy_template_deleted ? 0 : 1;
}

sub create_template {
  my ($self, $name, $content) = @_;
  $name eq $self->dummy_template_name or die "this should never happen";
  die "Dummy template '$name' already exists\n" unless $self->dummy_template_deleted;
  $self->dummy_template_content($content);
  $self->dummy_template_mtime(time);
  $self->dummy_template_deleted(0);
  return 1;
}

sub update_template {
  my ($self, $name, $content) = @_;
  $name eq $self->dummy_template_name or die "this should never happen";
  die "Dummy template '$name' does not exist\n" if $self->dummy_template_deleted;
  $self->dummy_template_content($content);
  $self->dummy_template_mtime(time);
  return 1;
}

sub delete_template {
  my ($self, $name) = @_;
  $name eq $self->dummy_template_name or die "this should never happen";
  die "Dummy template '$name' does not exist\n" if $self->dummy_template_deleted;
  $self->dummy_template_deleted(1);
  return 1;
}


# The returned list should be filtered according to supplied regexes, however,
# the Provider will also filter it. But the regex filter list is still passed
# in, purely for the benefit of the Store so it can limit the list
sub list_templates {
  my ($self, @regexes) = @_;

  my @list = grep {
    my ($name,$incl) = ($_, 1);
    !($name =~ $_) and $incl = 0 for (@regexes);
    $incl
  } ( $self->dummy_template_name );
  
  \@list
}




## For debug:

#my @meths = qw/
#owns_tpl
#template_exists  
#template_mtime
#template_content 
#create_template  
#update_template  
#delete_template  
#list_templates   
#/;
#
#for my $meth (@meths) {
#
#  around $meth => sub {
#    my ($orig, $self, @args) = @_;
#    
#    #scream_color(MAGENTA.BOLD,$meth);
#    
#    my (@ret,$ret);
#    wantarray ? @ret = $self->$orig(@args) : $ret = $self->$orig(@args);
#    
#    my $returns = $ret ? $ret : \@ret;
#    my $arg = scalar(@args) > 1 ? \@args : $args[0];
#    
#    scream_color(MAGENTA,{
#      _method => $meth,
#      args => $arg,
#      returns => $returns,
#      wantarray => wantarray
#    });
#    
#    return $ret ? $ret : @ret;
#
#  };
#}
#
#


1;