#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "INLINE.h"

AV* ckeys (AV* hashes) {
    int num_keys, num_to_merge, i, r;
	HE *hash_entry;
    SV *sv_key, *hash_ref, *merge_ref;
    HV *merger, *hash;
    AV* hkeys = newAV();
    
    merge_ref = av_shift(hashes);
    if (! SvROK(merge_ref)) croak("merge_ref is not a reference");
    
    merger = hv_copy_hints_hv((HV*)SvRV(merge_ref));
    num_to_merge = av_top_index(hashes) + 1;

    for (r = 0; r < num_to_merge; r++) {
        hash_ref = av_shift(hashes);
        if (! SvROK(hash_ref)) croak("hash_ref is not a reference");
        hash = (HV*)SvRV(hash_ref);
        num_keys = hv_iterinit(hash);
	    for (i = 0; i < num_keys; i++) {
		    hash_entry = hv_iternext(hash);
		    sv_key = hv_iterkeysv(hash_entry);
            hv_store_ent(merger, sv_key, newSViv(1), 0);
        }   
    }
    
    num_keys = hv_iterinit(merger);
	for (i = 0; i < num_keys; i++) {
		hash_entry = hv_iternext(merger);
		sv_key = hv_iterkeysv(hash_entry);
        av_push(hkeys, newSVpvf("%s", SvPV(sv_key, PL_na)));
    }

    sortsv(AvARRAY(hkeys), av_tindex(hkeys)+1, Perl_sv_cmp_locale);
    return hkeys;
}

MODULE = Combine::Keys  PACKAGE = Combine::Keys 

PROTOTYPES: DISABLE


AV *
ckeys (hashes)
	AV *	hashes

