use strict;
use warnings;

package App::Embra::Plugin::TransformMarkdown;
$App::Embra::Plugin::TransformMarkdown::VERSION = '0.001'; # TRIAL
# ABSTRACT: turn markdown files into html

use File::Basename;
use Method::Signatures;
use Moo;



has 'extension' => (
    is => 'ro',
    default => sub { 'md' },
);


has 'converter' => (
    is => 'ro',
    default => sub {
        require Text::Markdown;
        Text::Markdown->new;
    },
);

method transform_files {
    for my $file ( @{ $self->embra->files } ) {
        next if $file->ext ne $self->extension;
        $file->content( $self->converter->markdown( $file->content ) );
        $file->notes->{transformed_by} = __PACKAGE__;
        $file->ext( 'html' );
    }
}

with 'App::Embra::Role::FileTransformer';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::TransformMarkdown - turn markdown files into html

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will transform the content of Markdown files into HTML and change the file's extension to C<.html>.

=head1 ATTRIBUTES

=head2 extension

Files ending with this extension will be treated as Markdown files. Defualts to C<.md>.

=head2 converter

The object to use to convert the file content from Markdown to HTML. Defaults to an instance of L<Text::Markdown>.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
