use File::Which;
use Devel::CheckLib;

my $llvmc = $ENV{LLVM_CONFIG} || 'llvm-config';
unless (which($llvmc)) { print "Can't find \"$llvmc\"\n"; exit }

my $vers = `$llvmc --version`; chomp $vers;
unless ($vers eq '3.1') { print "Wrong LLVM version $vers: needed 3.1\n"; exit }

# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;

my %WriteMakefileArgs = (
  'ABSTRACT' => 'Perl bindings to the Low Level Virtual Machine',
  'AUTHOR' => 'Alessandro Ghedini <alexbio@cpan.org>',
  'BUILD_REQUIRES' => {
    'Capture::Tiny' => '0',
    'File::Find' => '0',
    'File::Slurp' => '0',
    'File::Temp' => '0',
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'Devel::CheckLib' => '0',
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'LLVM',
  'EXE_FILES' => [],
  'INC' => '-I.',
  'LIBS' => '-lLLVM-3.1',
  'LICENSE' => 'perl',
  'NAME' => 'LLVM',
  'OBJECT' => '$(O_FILES)',
  'PREREQ_PM' => {
    'XSLoader' => '0',
    'strict' => '0',
    'warnings' => '0'
  },
  'VERSION' => '0.10',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


my $ccflags = `$llvmc --cflags`; chomp $ccflags;
$WriteMakefileArgs{CCFLAGS} = $ccflags;

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

