use Test::More tests => 400;

use Geo::Lookup::ByTime qw(hav_distance);

# First 20 capital cities from
#  http://www.mapsofworld.com/utilities/world-latitude-longitude.htm
my @cities = (
    ['Afghanistan',         'Kabul',            34.28,  69.11],
    ['Albania',             'Tirane',           41.18,  19.49],
    ['Algeria',             'Algiers',          36.42,  3.8],
    ['American Samoa',      'Pago Pago',        -14.16, -170.43],
    ['Andorra',             'Andorra la Vella', 42.31,  1.32],
    ['Angola',              'Luanda',           -8.50,  13.15],
    ['Antigua and Barbuda', 'W. Indies',        17.20,  -61.48],
    ['Argentina',           'Buenos Aires',     -36.30, -60.0],
    ['Armenia',             'Yerevan',          40.10,  44.31],
    ['Aruba',               'Oranjestad',       12.32,  -70.2],
    ['Australia',           'Canberra',         -35.15, 149.8],
    ['Austria',             'Vienna',           48.12,  16.22],
    ['Azerbaijan',          'Baku',             40.29,  49.56],
    ['Bahamas',             'Nassau',           25.5,   -77.20],
    ['Bahrain',             'Manama',           26.10,  50.30],
    ['Bangladesh',          'Dhaka',            23.43,  90.26],
    ['Barbados',            'Bridgetown',       13.5,   -59.30],
    ['Belarus',             'Minsk',            53.52,  27.30],
    ['Belgium',             'Brussels',         50.51,  4.21],
    ['Belize',              'Belmopan',         17.18,  -88.30]
);

# Distance matrix computed using Haversine implementation from
#  http://www.movable-type.co.uk/scripts/LatLong.html
# Before using the above code I ammended the Earth's radius
# to 6378.137km
# http://en.wikipedia.org/wiki/Earth_radius
my @dist = (
    0,                  4375709.493276576,
    5817131.171309863,  13686962.039197056,
    5833348.312517209,  7572494.500405209,
    12279145.43399378,  15461886.007929847,
    2284163.543321863,  13299058.218958562,
    11400633.97083994,  4588742.886343013,
    1851356.7740529927, 12491590.96837694,
    2021435.310124735,  2382291.878469269,
    12420307.217111759, 3897315.595318361,
    5441810.579945718,  13829046.801084405,
    4375709.493276576,  0,
    1458055.323811548,  16879908.67812824,
    1511492.0204415855, 5568340.307663361,
    8024852.584611547,  11823206.729454298,
    2092906.1759653708, 9094082.654318497,
    15696433.706787389, 814601.8541953361,
    2525713.552818771,  8706329.247670986,
    3286268.795756607,  6757977.501047658,
    8102228.281252973,  1492507.1263880092,
    1570160.1180097351, 10179577.657244176,
    5817131.171309863,  1458055.323811548,
    0,                  17493803.61377989,
    689446.8487298529,  5095274.36929969,
    6701095.931359717,  10434602.675004888,
    3533900.7125161774, 7783183.360537633,
    16979798.719986375, 1651823.0970780978,
    3973413.630682188,  7606788.675051016,
    4525970.606476236,  8197639.530560298,
    6733496.649635065,  2631117.499648655,
    1568834.8519678838, 9076514.94795069,
    13686962.039197056, 16879908.67812824,
    17493803.61377989,  0,
    16804974.88349488,  17484206.07304993,
    12457652.640596438, 10837064.292844681,
    15594670.413108284, 11436364.266788406,
    4607742.877448281,  16207659.023976805,
    15190210.538854398, 11008956.073886748,
    15598840.438081546, 11572475.89903577,
    12622481.964401197, 15387407.573814193,
    15962120.178223379, 9670435.83684369,
    5833348.312517209,  1511492.0204415855,
    689446.8487298529,  16804974.88349488,
    0,                  5782962.3116996195,
    6516171.261707735,  10737691.143532503,
    3570515.9310700195, 7583265.899985017,
    17204845.678247496, 1332269.7901841353,
    3986149.5356317544, 7235617.173218377,
    4780620.927262402,  8207262.808999449,
    6605846.556159207,  2285345.9314472615,
    939188.8953596879,  8711577.957368093,
    7572494.500405209,  5568340.307663361,
    5095274.36929969,   17484206.07304993,
    5782962.3116996195, 0,
    8690767.015471874,  7950957.9338723365,
    6287802.769028752,  9505678.544860385,
    13380046.286646115, 6310144.323665575,
    6593743.418780477,  10459749.099317202,
    5565121.973201272,  9099258.997955253,
    8370997.167998133,  7032211.898132613,
    6625661.560119461,  11507048.514031224,
    12279145.43399378,  8024852.584611547,
    6701095.931359717,  12457652.640596438,
    6516171.261707735,  8690767.015471874,
    0,                  5957630.3350482695,
    10072097.820993727, 1084187.795483656,
    16353642.159675498, 7697070.6355263665,
    10468048.717014771, 1871119.0071495688,
    11226401.112834046, 14569329.328302115,
    473696.2886613765,  8408041.473209083,
    6837853.567269729,  2849902.9276332646,
    15461886.007929847, 11823206.729454298,
    10434602.675004888, 10837064.292844681,
    10737691.143532503, 7950957.9338723365,
    5957630.3350482695, 0,
    13609466.483421417, 5517373.528482406,
    11505493.525420807, 12046735.860570801,
    14033018.678082284, 7112745.656451253,
    13443683.533518279, 16847050.11548732,
    5544199.00784995,   13020478.292373195,
    11524493.241387727, 6656502.081559715,
    2284163.543321863,  2092906.1759653708,
    3533900.7125161774, 15594670.413108284,
    3570515.9310700195, 6287802.769028752,
    10072097.820993727, 13609466.483421417,
    0,                  11125056.980453767,
    13640948.854505608, 2399400.261787521,
    446851.3077246925,  10552185.794419007,
    1654459.5729238752, 4666221.763244491,
    10176016.959038023, 1967445.448123122,
    3299034.671944808,  11992178.852317512,
    13299058.218958562, 9094082.654318497,
    7783183.360537633,  11436364.266788406,
    7583265.899985017,  9505678.544860385,
    1084187.795483656,  5517373.528482406,
    11125056.980453767, 0,
    15282826.817419503, 8737139.398882959,
    11511583.152959816, 1640964.840076633,
    12309041.296464276, 15524570.845170291,
    1189870.1563020998, 9407122.246805098,
    7862670.4635063475, 2021005.682569363,
    11400633.97083994,  15696433.706787389,
    16979798.719986375, 4607742.877448281,
    17204845.678247496, 13380046.286646115,
    16353642.159675498, 11505493.525420807,
    13640948.854505608, 15282826.817419503,
    0,                  15985888.255416125,
    13235042.126248276, 15439064.76838067,
    12466849.307982212, 9049397.243259393,
    16253320.541589143, 15183410.831614336,
    16791821.36732065,  13987436.898732482,
    4588742.886343013,  814601.8541953361,
    1651823.0970780978, 16207659.023976805,
    1332269.7901841353, 6310144.323665575,
    7697070.6355263665, 12046735.860570801,
    2399400.261787521,  8737139.398882959,
    15985888.255416125, 0,
    2774452.1308865254, 8178158.076258022,
    3840899.2694641342, 6937834.7991368575,
    7832368.162615236,  982305.7313242337,
    910074.704856708,   9635740.087009823,
    1851356.7740529927, 2525713.552818771,
    3973413.630682188,  15190210.538854398,
    3986149.5356317544, 6593743.418780477,
    10468048.717014771, 14033018.678082284,
    446851.3077246925,  11511583.152959816,
    13235042.126248276, 2774452.1308865254,
    0,                  10873653.947264252,
    1581109.3549328467, 4232969.653555708,
    10585895.001195066, 2226971.376991209,
    3658489.383175164,  12295072.461970065,
    12491590.96837694,  8706329.247670986,
    7606788.675051016,  11008956.073886748,
    7235617.173218377,  10459749.099317202,
    1871119.0071495688, 7112745.656451253,
    10552185.794419007, 1640964.840076633,
    15439064.76838067,  8178158.076258022,
    10873653.947264252, 0,
    11989093.59120451,  14425354.533093706,
    2300330.463459737,  8657565.08555903,
    7268412.333293822,  1475970.9326108212,
    2021435.310124735,  3286268.795756607,
    4525970.606476236,  15598840.438081546,
    4780620.927262402,  5565121.973201272,
    11226401.112834046, 13443683.533518279,
    1654459.5729238752, 12309041.296464276,
    12466849.307982212, 3840899.2694641342,
    1581109.3549328467, 11989093.59120451,
    0,                  4034638.8447640864,
    11239439.082282476, 3596226.021277241,
    4747017.385553343,  13459094.430406384,
    2382291.878469269,  6757977.501047658,
    8197639.530560298,  11572475.89903577,
    8207262.808999449,  9099258.997955253,
    14569329.328302115, 16847050.11548732,
    4666221.763244491,  15524570.845170291,
    9049397.243259393,  6937834.7991368575,
    4232969.653555708,  14425354.533093706,
    4034638.8447640864, 0,
    14756756.809340151, 6168065.917661271,
    7758126.7295454815, 15514111.762055364,
    12420307.217111759, 8102228.281252973,
    6733496.649635065,  12622481.964401197,
    6605846.556159207,  8370997.167998133,
    473696.2886613765,  5544199.00784995,
    10176016.959038023, 1189870.1563020998,
    16253320.541589143, 7832368.162615236,
    10585895.001195066, 2300330.463459737,
    11239439.082282476, 14756756.809340151,
    0,                  8590970.17544368,
    6998893.296538088,  3137072.180262087,
    3897315.595318361,  1492507.1263880092,
    2631117.499648655,  15387407.573814193,
    2285345.9314472615, 7032211.898132613,
    8408041.473209083,  13020478.292373195,
    1967445.448123122,  9407122.246805098,
    15183410.831614336, 982305.7313242337,
    2226971.376991209,  8657565.08555903,
    3596226.021277241,  6168065.917661271,
    8590970.17544368,   0,
    1609451.0213285824, 10069338.516460521,
    5441810.579945718,  1570160.1180097351,
    1568834.8519678838, 15962120.178223379,
    939188.8953596879,  6625661.560119461,
    6837853.567269729,  11524493.241387727,
    3299034.671944808,  7862670.4635063475,
    16791821.36732065,  910074.704856708,
    3658489.383175164,  7268412.333293822,
    4747017.385553343,  7758126.7295454815,
    6998893.296538088,  1609451.0213285824,
    0,                  8725719.732627375,
    13829046.801084405, 10179577.657244176,
    9076514.94795069,   9670435.83684369,
    8711577.957368093,  11507048.514031224,
    2849902.9276332646, 6656502.081559715,
    11992178.852317512, 2021005.682569363,
    13987436.898732482, 9635740.087009823,
    12295072.461970065, 1475970.9326108212,
    13459094.430406384, 15514111.762055364,
    3137072.180262087,  10069338.516460521,
    8725719.732627375,  0,
);

for my $c1 (@cities) {
    my $p1 = {
        name => join(', ', @$c1[0, 1]),
        lat  => $c1->[2],
        lon  => $c1->[3]
    };
    for my $c2 (@cities) {
        my $ref_dist = shift @dist;
        my $p2       = {
            name => join(', ', @$c2[0, 1]),
            lat  => $c2->[2],
            lon  => $c2->[3]
        };
        my $calc_dist = hav_distance($p1, $p2);

        my $rd = sprintf("%.2f", $ref_dist);
        my $cd = sprintf("%.2f", $calc_dist);

        is($cd, $rd, "$p1->{name} to $p2->{name}");
    }
}
