#!/usr/bin/perl
###########################################################################

use Test::More tests => 347;
use Text::Scan;

$ref = new Text::Scan;

@termlist = ( 
	"aboard",
	"additives",
	"alternative treatments",
	"anti crime",
	"asbestos",
	"automobile recalls",
	"banning",
	"bitumenization",
	"boarding",
	"carbon dioxide",
	"cementation",
	"chunnel",
	"co2",
	"confirmed",
	"consumer market",
	"continent",
	"cyanide",
	"desertification",
	"devaluation",
	"disasters",
	"dismantling",
	"disorders",
	"drug legalization",
	"earth summit",
	"ec",
	"economic development",
	"economic zones",
	"emissions",
	"encryption equipment",
	"eu",
	"euro",
	"european community",
	"european union",
	"experiments",
	"exploration",
	"explosion",
	"famine",
	"fishing",
	"generic",
	"geography",
	"greenhouse gas",
	"holistic",
	"horsepower",
	"human",
	"human smuggling",
	"hydrides",
	"hydrogen",
	"illness",
	"illnesses",
	"impairments",
	"implantation",
	"impurities",
	"incineration",
	"international maritime organisation",
	"killed",
	"label",
	"legalization",
	"life styles",
	"local authorities",
	"mainstreaming",
	"malnutrition",
	"market reform",
	"market reforms",
	"medical treatment",
	"medical treatments",
	"medications",
	"mental",
	"methods",
	"microorganisms",
	"native american",
	"nato",
	"natural gas",
	"nobel",
	"nobel prize",
	"non traditional medicine",
	"ocean remote sensing",
	"offshore",
	"oil production",
	"orphan diseases",
	"pariah",
	"petroleum exploration",
	"piracy",
	"poisonous substances",
	"pollution controls",
	"popularity",
	"power cuts",
	"predictors",
	"preservatives",
	"preserve",
	"preventative",
	"private sector",
	"prospecting",
	"public sector",
	"r d",
	"rain forest",
	"regulations",
	"research",
	"research and development",
	"resurgence",
	"rural areas",
	"schedule",
	"seabed",
	"seminar",
	"sick building syndrome",
	"single market",
	"smoking",
	"smuggling",
	"soil enhancement",
	"spaceborne",
	"spoilage",
	"starvation",
	"survey ship",
	"sustained development",
	"sweatshop",
	"sweatshops",
	"symptoms",
	"synthetic aperture radar",
	"technology transfer",
	"territorial waters",
	"toll",
	"tourist industry",
	"treatment",
	"treatments",
	"tribal",
	"tribunals",
	"un",
	"united nations",
	"vessels",
	"vitrification",
	"vomiting",
	"warsaw pact",
	"wellness",
	"wiring",
	"withdrawal",
);
 
for my $term (@termlist) {
	$ref->insert($term, '~');
}

$line =
     "doc      fbis3 20900         jpest005___94017         jprs est 94 005   document type jprs   document title science  amp  technology       europe international economic competitiveness      3 march 1994    west europe    science  amp  technology policy       policies proposed for improving eastern german industrial research     94ws0087b karlsruhe fraunhofer institut fuer systemtechnik   und innovationsforschung in german mar 93 pp 1 19    94ws0087b     karlsruhe fraunhofer institut fuer systemtechnik   und innovationsforschung     language   german   article type cso     followup document to workshop on industrial research in   eastern germany  produced by fraunhofer institute for systems   technology and innovation research  fhg isi        text  this paper was generated in connection with the   study  industrial research establishments in the frg with   special consideration for structural adjustments in the new   laender   which was jointly carried out in 1991 93 by the   fraunhofer institute for systems technology and innovation   research  isi   karlsruhe  and the institute for economic   research halle  iwh   berlin  at the request of the federal   ministry for economics  the project leaders at isi were stefan   kuhlmann  rainer bierhals  doris holland  guido reger  project   leaders at iwh were herbert berteit  eberhard adam  hans juergen   rauch  susanne roehnert      the double challenge  upheaval in germany s industrial   research infrastructure  requirements for political action     1  upheaval in germany s industrial research infrastructure     industrial research is an important element for a   competitive  modern industry  it combines knowledge of basic   research with the requirements of industrial production    industrial research is therefore an essential part of the   technological innovation capability in the economy      the industrial research infrastructure in the united germany   today faces a double challenge      challenge 1  industrial research needs a technical and   functional adjustment to the altered tasks  this is a result of   the progressive technological development and altered dynamic of   the world market  which further reinforce the pressure for   innovation in industry  first  new subject concentrations are   emerging in research and technology  to which the industrial   research establishments and government r amp d funding measures   must   react  second  it is becoming clear that industrial research   institutions today  more than before  must be understood as   active intermediaries in networks of various industrial partners   and research establishments  and that in so doing basic research   and application development must cooperate more closely than   before  in local as well as globalized industrial connections      challenge 2  simultaneously  an internal german adjustment   of   capacity and structure is necessary  as a result of the change   in systems  industrial research in the new laender has lost its   customers almost completely and is in total upheaval  and   largely in dissolution as well  the sharp economic decline of   the global economy  which now has also reached western german   industry  further led to reduced utilization of western german   industrial research as well  despite the already completed   downsizing in eastern germany  the declining demand is today   faced with a relatively large overall german supply potential   for industrial research that lacks industrial contracts  to this   is added a structural problem  both research systems contributed   similar strengths and weaknesses  today a heated  cutthroat   competition is under way  in which eastern german suppliers are   clearly finding poorer starting conditions      in order to assure an overall german industrial landscape   that is aimed at the future  is innovation oriented and benefits   industrial competitiveness  two urgent tasks must be mastered at   the same time           in the short term  the creation of improved competitive   conditions for the remaining industrial research establishments   in eastern germany  assuming that an approximately equal   distribution between old and new laender is politically intended         in the medium term  a stocktaking  specific adjustment and   further development of the entire german industrial research   landscape        the following part of the research report called  industrial   research establishments in the frg with special consideration of   structural adjustments in the new laender  is meant as a   contribution to the discussion of requirements for political   action in this field  in the following the outlined discussions   will be shown as having several steps      the argumentation rests on results of the studies  carried   out jointly by the fraunhofer institute for systems technology   and innovation research  isi  and the institute for economic   research halle  iwh  in 1991 92 on this subject  which are   documented in the other sections of the research report  and on   assessments of newer results of innovation research      2  restructuring of industrial research  elements of new   political efforts     a debate on the future of industrial research in germany   must   take the following aspects into account           support for research and technology is a long term   investment and does not help overcome the current economic   crisis         new technological concentrations and the increasing   interlinking of technologies will mark industrial research   services in the future         new functions of technical research and industrial innovation   are developing         regions need a mix of industrial research at the  middle    level   of technology and a  wide range          industrial research in eastern germany needs preferential   treatment in order to have a chance to adjust to the double   structural change         a stocktaking and specific restructuring of the   entire german industrial research landscape is   necessary        these aspects can only be briefly commented on in the   following  a systematic analysis and the design of future   structures for industrial research in germany will require   significantly greater efforts than were possible within the   framework of this underlying study      support for research and technology is a long term   investment and does not serve to overcome the current crisis     the discussions outlined here for the support of research   and   technology are not suitable for helping to overcome the double   crisis of the german economy in the early 1990s  which consists   of the basic adjustment crisis of eastern german industry and   the current economic slump in the western german economy      strengthening the technological innovation capability of   industry is a permanent task  whose results become effective   only in the medium and long term  planning horizons for   stabilization  reorganization and expansion of the industrial   research infrastructure must therefore have a perspective of at   least five to ten years  the buildup of the existing   infrastructure in the old laender took place over three decades   before it reached its present size  and the establishments were   able to assume their present functions in the scientific and   industrial innovation system      for the infrastructure plans for industrial research in the   area of the new laender today this means  after an urgent    initial guarantee of a minimum potential in the upheaval phase   of 1989 72  as was shown by the fate of many  research   companies   that the foreseeable requirements must be the   determining ones at the end of our decade and in transition to   the next millennium  these requirements cannot be exactly   specified in advance  however  partly because the positions of   the german economy in the world market in five years and later   are uncertain  and partly because technological developments   cannot be adequately assessed  however  we can indicate a few   elements in the foreseeable shifts in concentration and altered   function of industrial research in the coming years      new technological concentrations and their increasing   interlinking     in the last few years the question of the potential   development of science and technology is again being discussed   and studied in leading industrial nations  above all in the   united states and in japan  as well as in europe and in other   oecd nations  a whole series of studies on evaluating the   so called critical technology fields for the medium term future   have now been published  they contain more or less extensive   lists of technologies  for example the commerce department of   the united states   emerging technology  an appraisal of the   technical and economic possibilities   1990   report of the   national committee for critical technology  of the united   states  1991  ministry of economics of the netherlands     experiment in technology forecasting   1991  economic planning   agency  japan   technology and products in the year 2010   1992    science and technology agency  japan   future technology in   japan   1992   such studies were produced with the general   objective of being able to concentrate research activities and   government followup measures to those areas of technology  where   a decisive influence on the future problem solving capability of   the national economies in question is addressed  such studies   are also under way in germany at this time  one with medium term   and one with long term perspectives   which have not yet been   concluded  however      what information regarding the innovation process from   medium   and long term perspectives  and thus for the tasks of industrial   research  can be obtained from such studies  and what   bottlenecks can be perceived  this is  of course a prognostic   and synthetic question  to which there is no ultimate answer    founded on data      in general terms  the innovation cycle can be sketched as   that of  intelligent  technology  the universally cheap resource   of petroleum in the postwar era is replaced by the universally   cheap resource of the  chip       in the discussion of bottlenecks  greater attention must be   paid to the demand factors  technology monitoring  and sometimes   also technology policy  is tempted to limit itself to the   description and consideration of the potential supply of natural   science technology solutions and the institutions which offer   them  which technology and which research infrastructure will be   important in the future depends to a great extent on the   anticipated social  ecological and economic problem pressure    from which important demands on the science and technology of   the future are formulated      for the purpose of clear arrangement and description  it is   possible to distinguish those fields of technology  which in all   corresponding foreign studies are regarded as essential for the   future innovation capability  a new assessment by the isi and   the project sponsor  the federal ministry for research and   technology  bmft   undertaken at the request of the bmft  will   soon appear            advanced materials         manufacturing and production technologies         information technology and electronics         biotechnology         and  above all  technologies in their respective overlapping   areas  such as microsystem technology  nanotechnology  molecular   electronics        technology at the beginning of the 21st century cannot be   divided according to conventional aspects  however  this applies   particularly to application areas  applications such as future   telecommunications result from progress in both microelectronics   and photonics and are not conceivable without contributions from   software development  this cooperation by technologies is not   basically new  but is spreading more and more and now requires   consequences for the research  technology and innovation   policies  it must be studied whether the research infrastructure    including the industrial one  and the existing research   administration in germany must be adapted to the objectively   existing interlinking      new functions of technological research and industrial   innovation develop     the oecd recently stressed  as a result of its    technology economy program   the altered role of industrial   research in the industrialized nations  as an  intermediary   body   it will in the future not only provide the transfer of   knowledge from research to industrial application  but must also   feed back the requirements of industry to basic and   long term oriented research  beyond that  it will have to meet   the  seemingly paradoxical  double challenge of being   increasingly active  on the spot  in local technology oriented   networks as well as cooperate in  globalized  technology   development contexts   techno globalism    since the production   of knowledge and innovations more and more frequently takes   place in international connections      this is the result of a structural change for technological   innovations  which now no longer takes place in  new  technology   fields  such as modern biotechnology   but on a broad front  and   to which the industrial and industrially applied research in the   new laender must also submit  see also box 1   michael gibbons   of the science policy research unit  spru  spectacularly called   this supplementation  observed by many innovation researchers    of the innovation process by a second mode the  transition from   mode 1 to mode 2 of the knowledge production   mode 1 describes   a more traditional   linear   discipline bound  primarily   internal  within a company or research institute  manner of   producing technological innovation through  applied  research   and development  which in certain fields will continue to be of   importance   mode 2 describes a new form of science based   innovation processes  which overcomes the conventional   separation of pure and applied research  elements of the new   form of science production are           research in connection with application and application   development with feedback to the research base         production of  transdisciplinary  knowledge         heterogeneous form of activities and participating actors         variety of organizational and institutional forms         immediate industrial utilization of the possibilities of new   technical facilities and equipment in research         greater demands for quality and efficiency control        to begin with  these are very general conclusions  which   need   more precise analysis and specification for individual fields of   technology  research institutions and various industries  it is   certain  however  that a view  organization and promotion of   industrial research that is largely oriented toward traditional   divisions of industrial branches  such as dominates traditional    joint industrial research   will no longer do justice to the   interconnected character and  transdisciplinary quality  of   increasingly science linked innovation processes      box 1  market opportunities for eastern german industrial   research  modern technological strategies necessary      in a market for industrial research in germany  which is   overcrowded in some fields and which furthermore is marked by a   decrease in research contracts from the economy and restrained   government support for industrial research  it is particularly   difficult for these establishments and enterprises in the new   laender to become permanently established  in view of the   extremely unfavorable starting conditions  interrupted relations   with former industrial partners  the lack of capital  uncertain   property conditions  obsolete facilities  the danger of losing   qualified personnel  they regard themselves as exposed to a   fierce  cutthroat competition  although in part they are highly   efficient and willing to achieve      a future oriented market strategy includes market analyses   and operating systems  sufficient investments and long term   business strategies  particularly innovation and technology   strategies  it is precisely in these areas that eastern german   enterprises have major shortcomings  short term survival   strategies  such as low price policies  do not create any   prospects  what is decisive is the correct positioning of one s   own work with respect to the demands of technological   innovations in industry  right now these are undergoing a   radical process of change  world market capable products from a   high price economy such as the german  and other western   european ones  will be even more technology intensive in the   future than in the past  the  technological intensity  of the   products today increasingly also includes intelligent   interconnection of technologies of very different origin  at the   same time  more and more often knowledge from basic scientific   research flows directly into the development process for new   products  or methods       the growing  interlinking of technology  and    science basing    creates new challenges for industrial research and development    small and medium sized enterprises  above all  thus end up under   pressure to adjust and are looking for support  industrial   research establishments can provide help here and thus find a   market  if they meet the following demands           technological interconnection  intelligent   products require the combination of the most varied   technologies  industrial research must visibly be able to   practice interface management         interdisciplinary cooperation  more than before    representatives of various disciplines in the engineering   sciences  the natural sciences and technology management must be   ready for and capable of cooperating         network orientation  one enterprise is increasingly   less able to offer all the know how about technology intensive   products  formal and informal cooperation between various   partners  companies  research facilities  engineering bureaus    etc   in technology networks becomes more important         simultaneous regional and global orientation    industry related research needs strong roots in the regional   research and industrial environment  but in the respective field   of expertise it must maintain active connections with leading   worldwide developments  for instance through international   research cooperations        regions need a  mix  of industrial research at the  middle    level of technology and a  wide range       the conclusions in the preceding step do not make regional   potentials in industrial research at the  middle  technological   level  which are frequently based more on the traditional     linear   model  superfluous  practical experience proves  and   many innovation and regional research studies confirm  that they   continue to form a stabilizing element in modern industrial   structures  whose backbone are active  company internal r amp d   potentials      in the old laender such capacities have been built up over   decades with massive use of public funding from the federal   government and the laender  many of these research   establishments today form the foundation for continued   development toward  science based  technological innovations      which  mix  of industrial research establishments from   various fields of technology and with varying technological    range  is regionally or nationally necessary  it would take a   great deal of expense systematically to compare  quantitatively   and qualitatively  the existing infrastructure of industrial   research in the old laender with the establishments in existence   right now in eastern germany  in order to draw conclusions for   planning decisions  this expense could not be justified in the   framework of the analyses undertaken for this report      but just a glance at the industrial research infrastructure    mix  of an old land  which is very active in this respect    makes it clear how large the gap is that yawns between the   situation there and the conditions in the new laender  see box   2   the desire to build such an infrastructure from scratch in   each of the eastern german laender would take an extraordinary   effort      box 2  industrial research in the old laender  example    baden wuerttemberg     the beginnings of government support for industrial research   in the region of the land of baden wuerttemberg go back far into   the 19th century  today  the land  9 6 million inhabitants    counts the following among its industrial research   establishments           13 fraunhofer society institutes         10 joint industrial research institutes         eight contract research facilities at universities         two large research establishments         about 100 transfer establishments of the steinbeis foundation    usually  at technical colleges        these facilities are financed by research income  contract   research  research funding  and by institutional funding from   the federal government and the land  in proportions varying   according to the institution       the fraunhofer society institutes in baden wuerttemberg    1 500 employees  work in the following fields of work  among   others  information technology  production automation  biomethod   technology  energy technology  construction technology  sensor   technology  materials  the budget of the baden wuerttemberg   institutes was dm 300 million in 1989  approximately one third   of which was financed on the basis of industrial cooperations      divided by industry  the joint industrial research   establishments operate in the following fields  textile and   process technology  clothing industry  textile chemistry    chemical fibers  tanning  pigments paints  industrial glass    precision mechanics watch technology  microtechnology  fine   metals metal chemistry  synthetics  the budget volume for these   establishments was dm 46 million in 1989  dm 14 million of which   were based on industrial cooperations      the contract research institutes at the universities   an   institutes    which have only been around for a few years in   this form  are active in the following sectors    microelectronics  information science  natural sciences medical   research  laser technology in medicine  application oriented   knowledge processing  solar energy and hydrogen research    manufacturing technology  in 1989 the budget for these   institutes was dm 49 million  dm 18 million of which came from   cooperations with the business sector      the large research establishments  stuttgart research center   of the aerospace research institute  dlr  in the fields of   materials  construction methods  energetics  and karlsruhe   nuclear research center  kfk  in the fields of environmental   technology  materials research  handling technology  microsystem   technology  nuclear technology   earned about dm 30 million in   income in 1989 through industrial cooperations  with a total   budget of dm 780 million   in connection with the shrinking   institutional support for these establishments from the federal   government  they will make efforts over the next few years to   expand their share of the contract research market      the technical advisory services and transfer centers of the   steinbeis foundation  founded in 1971   in the which professors   and graduates from technical colleges in the region offer   technological advice and development projects in the fields of   flexible automation and production technology  process   technology  electronics microelectronics  software engineering   and cad cam  in 1989 earned more than 90 percent of their dm 65   million budget from industrial cooperations      industrial research in eastern germany needs preferential   treatment in order to have a chance to adjust with the double   structural change     the collapse of industrial research in the new laender has   already taken on dramatic proportions  of the approximately   75 000 researchers active in industry at the beginning of 1990    at the present time  as reported by representative surveys at   the beginning of october 1992  no more than 15 000 are left in   the new laender  the number of industrial researchers in the new   laender  compared to the old laender  has thus reached a ratio   of 1 15  while in the old laender there are seven researchers   for every 100 industry employees  in the new laender there is   only one  in addition  it must be taken into account that of the   remaining r amp d employees one in three works in a job creation   position      so far  it has not been possible to halt the decline of   r amp d   potentials  an extensive inquiry among privatized research   establishments and privatized enterprises gave the result that    from the end of 1991 until april 1992  a 25 percent decrease in   r amp d potential took place  and these companies feared an   additional decrease by mid 1993 by up to 60 percent  in trust   agency enterprises  as well  a more rapid drop in r amp d   employees   than in general employees is taking place  as confirmed by   reports from the trust agency itself      about half of all industrial r amp d employees in the new   laender   are still working in trust agency enterprises  although the   trust agency is trying to enforce preservation of the r amp d   potential when selling the companies  increasingly more buyers   of industrial enterprises are refusing to take over r amp d   employees  the number of enterprises which function as  extended   workbenches  for their mother companies  is growing      the present development in industrial research runs counter   to the desirable industrial buildup in the new laender  where   there is a lack of creative research there is also a lack of   innovation  and where no innovations are being brought out there   will also be little investment  successful innovations presume   immaterial investments and result in material replacement    rationalization  and expansion investments  for that reason   r amp d   must not be regarded as a labor policy task  but as a necessary   investment for the future      although basically an original task for the economy  the   federal government and the laender agree that in view of the   extent and the special problems of structural change in the   economy in the new laender  the process of restructuring and   reorganization and expansion of efficient r amp d potentials   must be   accompanied by subsidies over a longer period through government   measures  in this sense many attempts at economic and technology   policy are being made to promote the innovation capability of   eastern german enterprises  the bmwi  federal ministry for   economics  and the bmft are making a large amount of funding   available  but it is still not clear whether these subsidies   will also be available in the medium term  three to five years    as a prerequisite for self supporting reconstruction in the new   laender      in the future it will primarily be the laender which must   bear special responsibility in this process  a glance at the   abundance of existing subsidy measures being offered by the   governments in the old laender  see box 3  makes it clear how   much eastern germany still needs to catch up  although the   governments in the new laender are apparently becoming active in   this field  as was documented at another place in this study      a research landscape is soon destroyed  rebuilding it is   many   times more expensive than keeping it  for this reason it is   proposed          that research potentials be supported on site for a   longer  but defined period of time  the research establishments   need fundamental or basic financing  decreasing   since only a   minor part of the overall costs can be financed from project   support         that a gradually decreasing financial subsidy be assumed for   the next three to five years for the enterprises still under   trust agency management  limiting the subsidy to enterprises   with fewer than 1 000 employees is here counterproductive for   maintaining the r amp d potentials         that the subsidy rate in certain cases be increased to 80   percent for enterprises  which due to their limited financial   opportunities cannot generate the required 50 percent of their   own funding and for that reason cannot claim any subsidies         that equal starting conditions be created for eastern german   industrial  independent  research establishments by conveying   ownership of the movable goods as well as property needed for   the business  in addition  cancellation of old debts and   liquidation loans is indispensable         that the support of contract research from west to east  awo    be expanded  utilization of eastern german industrial research   by companies in the processing industries in the old laender has   been less than satisfactory until now  with exactly dm 50   million  as of august 1992   one can only speak of a beginning   of support in awarding contracts to researchers in the new   laender  measured by the annual amounts given away by   enterprises in the old laender to external research   establishments  the above amount  at not quite one percent  is   very low         that the equality of eastern german r amp d facilities in   competing   for the granting of contracts be assured  to that end  more   eastern german scientists should also sit on expert panels        box 3  research and technology support activities by the old   laender  according to the bdi  federal association of german   industry  handbook of research and innovation support in 1992      baden wuerttemberg          economic support program  focus on technology support        the law on subsidizing medium sized enterprises        technology consulting       bavaria          technology consulting program        innovation support program        support for economic research        introduction to technology program        medium sized enterprise credit program        program to support rational energy use        environmental technology support program        new materials research program       berlin          industrial technology development        innovation fund        science related technology research        support of r amp d in small and medium sized enterprises        technology consulting        innovation assistant       bremen          joint r amp d program        r amp d project program        innovation assistant        technical consulting service        medium sized industry support program        work experience in innovation        acquisition cost subsidy program        researchers in industry program        support for information and communications technologies       hamburg          projects in the field of industrial research        innovation promotion program        media and communications technology support program        management assistant        support of r amp d projects in the field of artificial   intelligence       hesse          technology and innovation consulting        rational and nonpolluting energy use        environmental technology program       lower saxony          support of r amp d projects in the field of product and   process innovation        inventor support        technology consulting        innovation assistant       north rhine westphalia          technology program economy        technology consulting        technology program energy        technology program metallic materials        future technologies program        innovation assistant        euro assistant        work experience in innovation       rhineland palatinate          support for economic research        innovation support program        technology consulting        technology introduction program        personnel transfer program  innovation assistant       saarland          research and technology program        technology consulting        innovation support        innovation assistant       schleswig holstein          support for product innovations        support for special consulting        support for inventions        support for innovation cooperations        support for market analyses and technology studies        introduction of new environmental technologies        support for economic research  development and technology   transfer       stocktaking and specific restructuring of the entire german   industrial research landscape     in the old frg a relatively differentiated system of   industrial research had developed since the 1960s  important   elements are the institutes for joint industrial research  the   fraunhofer society institutes  the universities  the technical   colleges and increasingly the major research establishments  in   the former gdr industrial research was organized completely   differently  but it also had  something which is crucial   here  comparatively high quality research resources  above all   in human capital      today  more than two years after the german unification  the   all german industrial research is facing a challenge with   respect to volume  the uncontrolled decline of industrial   production in the new laender is accompanied by a continued   cutback in industrial research in eastern germany  the sharp   economic slump in the global economy  which has now reached the   western german industry as well  also causes a shrinking demand   for the services of western germany industrial research      to this is added a structural problem  a comparison of   technological specialization models in eastern and western   germany for the year immediately before the unification shows   that both research systems demonstrate similar strengths and   weaknesses  so that there were scarcely any positive   complementary effects  on the contrary  a violent cutthroat   competition began  in which eastern german workers clearly had   the inferior starting conditions      what could have happened even at the time of the german   unification must take place now  the entire german industrial   research infrastructure should be subjected to a thorough   stocktaking          on the demand side  meaning with a view to the   foreseeable  as well as desirable with respect to industrial   policy  industrial demand for research work         on the supply side  meaning with a view to existing and   development capable potentials         institutionally  meaning with a view to proven or obsolete   financing  organization and cooperation models    respectively        since this has already in part been done as regards the   eastern german infrastructure  this challenge applies   particularly to the western german system  it should be   connected with the attempt to describe the entire german market   for research and development services in terms of quantity as   well  see box 4       several reasons argue in favor of such a revision           until now there has been no sufficiently detailed  in   terms of quantity and quality  and at the same time clear   picture of the entire german infrastructure of industrial   research  but such an overview represents an indispensable   foundation for planning and decisions in research and innovation   policy         there are accumulating indications that the spending for   research and technology development in germany is stagnating or   even declining  the public research budgets have grown   disproportionately with the german unification  that is to say    in relative terms they have shrunk  research spending by the   economic sector hardly grew in real terms in the last three   years  after high growth rates in the 1980s  and the number of   employed research personnel in the old laender from 1989 to 1991   dropped by 2 9 percent a year  according to the expert report on   economic statistics 1992   under these conditions there is also   a stagnation of external r amp d spending by enterprises  and   hence   the field of action for industrial research         the system of government actors is fragmented  there is a   lack   of coordination between department politics and of a clear   division of duties between regional  national and european   r amp d   policies         there are scarcely any long term and strategically designed   guidelines  either in industry or in research and technology   policy         the mobility between the subsystems of the research system    for   example between industrial research  economic research  academic   operation  and in international connections is insufficient         the politically offered incentive systems are now no longer   sufficiently capable of adjustment or creative  it is felt that   their concepts are no longer specific enough        in the event the proposed extensive stocktaking of the   business oriented research system should finally lead to a   reorganization  several factors are unavoidable           a restructuring of industrial research must take place   with a view to the position and opportunities of german industry   in the world market  in so doing  one must balance which   weaknesses in the technological performance profile can   realistically be overcome by the industry and by government   support for industrial research  and which market sectors will   remain unconquerable         the existing industrial structures and industrial   concentrations in eastern and western germany  insofar as they   are competitive or harbor strong potential for future success    must be treated as constants in the decision about research   infrastructures         the restructuring must treat german industrial research as a   part of the larger infrastructure of the european community and   also with a view to central and eastern europe        it is of basic importance here that the state cannot    execute  this restructuring process but should primarily   moderate and  during recognizable bottlenecks  provide support   through institutional funding for necessary research facilities   and time limited subsidy programs      box 4  development of the market for research and   development in the old laender     an exact description of the market for r amp d services   creates   difficulties in several respects  which are mentioned elsewhere    see prognos isi   r amp d cooperations by small and medium sized   enterprises  basel karlsruhe  1991   including the new laender   makes little sense  since the corresponding data are still   incomplete and the dynamic of negative change continues to be   strong  see expert report on economic statistics   research and   development in the economy  results and assessments 1991 92        the data available for the old laender show stagnation    after   impressive growth in research spending in the economy in the   1980s and an absolutely and relatively significant growth in   external research tasks since the beginning of the 1990s  this   is undoubtedly a reflection of the slowdown in economic growth    experience in innovation research   interlocking technologies      science linking   allows for the assumption  however  that the   proportion of external r amp d spending  about 10 percent    reached   today will no longer decrease but perhaps might even grow      more precise analyses here show that the predominant part of   external company spending flows not to government supported   research infrastructures but to other companies  a clear   indication of the interconnection of industrial technology  as   is well known  the entry into the r amp d market is made easier   for   government supported institutions through programs which offer   financial support for cooperation between industry and science      under these framework conditions it cannot be anticipated   that eastern german establishments should rapidly be able to   capture  on their own  an appreciable share of the all german   r amp d market ";

@result = $ref->multiscan( $line );

print "results contain ", scalar @result, " items\n";
#print join("\n", @result), "\n";

ok( 173 == scalar @result, 'correct number of results' );

# Just getting through without a segfault is good enough here!

my @answers = (
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"treatment",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"methods",
	"~",
	"research",
	"~",
	"research and development",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"hydrogen",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"methods",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"treatment",
	"~",
	"research",
	"~",
	"research",
	"~",
	"confirmed",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"euro",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"human",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research and development",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"european community",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~",
	"research",
	"~"
	);

for my $i (0..$#result){
	ok($result[$i]->[0] eq $answers[$i*2], 
        $result[$i]->[0] . " is $answers[$i*2]");
	ok($result[$i]->[2] eq $answers[$i*2+1],
        $result[$i]->[2] . " is $answers[$i*2+1]"); 
}


