/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;

public class BuilderArrayPayload
extends BuilderInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    protected final int elementWidth;
    @Nonnull
    protected final List<Number> arrayElements;

    public BuilderArrayPayload(int elementWidth, @Nullable List<Number> arrayElements) {
        super(OPCODE);
        this.elementWidth = elementWidth;
        this.arrayElements = arrayElements == null ? ImmutableList.of() : arrayElements;
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @Nonnull
    public List<Number> getArrayElements() {
        return this.arrayElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.arrayElements.size() + 1) / 2;
    }

    @Override
    public Format getFormat() {
        return BuilderArrayPayload.OPCODE.format;
    }
}

