\name{WienerDeconvolutionImageFilter}
\alias{WienerDeconvolutionImageFilter}
\title{WienerDeconvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
The Wiener deconvolution image filter is designed to restore an image
convolved with a blurring kernel while keeping noise enhancement to a
minimum.
WienerDeconvolutionImageFilter}
\details{
The Wiener filter aims to minimize noise enhancement induced by
frequencies with low signal-to-noise ratio. The Wiener filter kernel
is defined in the frequency domain as \eqn{W(\omega) = H^*(\omega) / (|H(\omega)|^2 + (1 / SNR(\omega)))} where \eqn{H(\omega)} is the Fourier transform of the blurring kernel with which the
original image was convolved and the signal-to-noise ratio \eqn{SNR(\omega)} . \eqn{SNR(\omega)} is defined by \eqn{P_f(\omega) / P_n(\omega)} where \eqn{P_f(\omega)} is the power spectral density of the uncorrupted signal and \eqn{P_n(\omega)} is the power spectral density of the noise. When applied to the input
blurred image, this filter produces an estimate \eqn{\hat{f}(x)} of the true underlying signal \eqn{f(x)} that minimizes the expected error between \eqn{\hat{f}(x)} and \eqn{f(x)} .
This filter requires two inputs, the image to be deconvolved and the
blurring kernel. These two inputs can be set using the methods
SetInput() and SetKernelImage(), respectively.
The power spectral densities of the signal and noise are typically
unavailable for a given problem. In particular, \eqn{P_f(\omega)} cannot be computed from \eqn{f(x)} because this unknown signal is precisely the signal that this filter
aims to recover. Nevertheless, it is common for the noise to have a
power spectral density that is flat or decreasing significantly more
slowly than the power spectral density of a typical image as the
frequency \eqn{\omega} increases. Hence, \eqn{P_n(\omega)} can typically be approximated with a constant, and this filter makes
this assumption (see the NoiseVariance member variable). \eqn{P_f(\omega)} , on the other hand, will vary with input. This filter computes the
power spectral density of the input blurred image, subtracts the power
spectral density of the noise, and uses the result as the estimate of \eqn{P_f(\omega)} .
For further information on the Wiener deconvolution filter, please see
"Digital Signal Processing" by Kenneth R. Castleman, Prentice Hall,
1995
Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
Chris Mullins, The University of North Carolina at Chapel Hill
Cory Quammen, The University of North Carolina at Chapel Hill
See:
WienerDeconvolution for the procedural interface
itk::WienerDeconvolutionImageFilter for the Doxygen on the original ITK class.
WienerDeconvolutionImageFilter}
%C++ includes: sitkWienerDeconvolutionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetNoiseVariance() const:}{
Set/get the variance of the zero-mean Gaussian white noise assumed to
be added to the input.
}
\item{bool GetNormalize() const:}{}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetNoiseVariance(double NoiseVariance):}{
Set/get the variance of the zero-mean Gaussian white noise assumed to
be added to the input.
}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ WienerDeconvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~WienerDeconvolutionImageFilter():}{
Destructor
}
}
}
