/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MousePositionCache {
    @Nonnull
    private final Component component;
    @Nonnull
    private final Supplier<Point> mousePositionSupplier;
    private boolean stale = true;
    private Point cachedPosition = null;

    private MousePositionCache(@Nonnull Component component, @Nonnull Supplier<Point> mousePositionSupplier) {
        this.component = (Component)Preconditions.checkNotNull((Object)component);
        this.mousePositionSupplier = (Supplier)Preconditions.checkNotNull(mousePositionSupplier);
    }

    public static MousePositionCache createAndInstall(@Nonnull Component component, @Nonnull Supplier<Point> mousePositionSupplier) {
        MousePositionCache cache = new MousePositionCache(component, mousePositionSupplier);
        cache.attachListeners();
        return cache;
    }

    private void attachListeners() {
        this.component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MousePositionCache.this.markAsStale();
            }
        });
    }

    private void markAsStale() {
        this.stale = true;
    }

    @Nullable
    public Point getMousePosition() {
        if (this.stale) {
            this.cachedPosition = this.mousePositionSupplier.get();
            this.stale = false;
        }
        return this.cachedPosition;
    }
}

