/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.ldap.util;

import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.ldaptive.Connection;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.SearchScope;
import org.ldaptive.referral.ReferralHandler;
import org.ldaptive.referral.SearchReferralHandler;
import org.opensearch.secure_sm.AccessController;

public class LdapHelper {
    private static SearchFilter ALL = new SearchFilter("(objectClass=*)");

    public static List<LdapEntry> search(Connection conn, String unescapedDn, SearchFilter filter, SearchScope searchScope, String[] returnAttributes, boolean shouldFollowReferrals) throws LdapException {
        try {
            String baseDn = LdapHelper.escapeDn(unescapedDn);
            return (List)AccessController.doPrivilegedChecked(() -> {
                ArrayList entries = new ArrayList();
                SearchRequest request = new SearchRequest(baseDn, filter);
                request.setSearchScope(searchScope);
                request.setDerefAliases(DerefAliases.ALWAYS);
                request.setReturnAttributes(returnAttributes);
                SearchOperation search = new SearchOperation(conn);
                if (shouldFollowReferrals) {
                    request.setReferralHandler((ReferralHandler)new SearchReferralHandler());
                }
                Response r = search.execute((Request)request);
                SearchResult result = (SearchResult)r.getResult();
                entries.addAll(result.getEntries());
                return entries;
            });
        }
        catch (InvalidNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static LdapEntry lookup(Connection conn, String unescapedDn, String[] returnAttributes, boolean shouldFollowReferrals) throws LdapException {
        List<LdapEntry> entries = LdapHelper.search(conn, unescapedDn, ALL, SearchScope.OBJECT, returnAttributes, shouldFollowReferrals);
        if (entries.size() == 1) {
            return entries.get(0);
        }
        return null;
    }

    private static String escapeDn(String dn) throws InvalidNameException {
        LdapName dnName = new LdapName(dn);
        ArrayList<Rdn> escaped = new ArrayList<Rdn>(dnName.size());
        for (Rdn rdn : dnName.getRdns()) {
            escaped.add(new Rdn(rdn.getType(), LdapHelper.escapeForwardSlash(rdn.getValue())));
        }
        return new LdapName(escaped).toString();
    }

    private static Object escapeForwardSlash(Object input) {
        if (input != null && input instanceof String) {
            return ((String)input).replace("/", "\\2f");
        }
        return input;
    }
}

