/*
 * Decompiled with CFR 0.152.
 */
package StandardLibraryInternal;

public class InternalResult<T, E> {
    private final boolean isSuccess;
    private final T value;
    private final E error;

    private InternalResult(boolean isSuccess, T value, E error) {
        this.isSuccess = isSuccess;
        this.value = value;
        this.error = error;
    }

    public static <T, E> InternalResult success(T t) {
        return new InternalResult<T, Object>(true, t, null);
    }

    public static <T, E> InternalResult failure(E e) {
        return new InternalResult<Object, E>(false, null, e);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isFailure() {
        return !this.isSuccess;
    }

    public T value() {
        if (!this.isSuccess) {
            throw new IllegalStateException("Tried to extract a value from a failure: " + this);
        }
        return this.value;
    }

    public E error() {
        if (this.isSuccess) {
            throw new IllegalStateException("Tried to extract an error from a success: " + this);
        }
        return this.error;
    }
}

