/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.services;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.protobufs.SearchRequest;
import org.opensearch.protobufs.SearchResponse;
import org.opensearch.protobufs.services.SearchServiceGrpc;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.grpc.listeners.SearchRequestActionListener;
import org.opensearch.transport.grpc.proto.request.search.SearchRequestProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.AbstractQueryBuilderProtoUtils;
import org.opensearch.transport.grpc.util.CircuitBreakerStreamObserver;
import org.opensearch.transport.grpc.util.GrpcErrorHandler;

public class SearchServiceImpl
extends SearchServiceGrpc.SearchServiceImplBase {
    private static final Logger logger = LogManager.getLogger(SearchServiceImpl.class);
    private final Client client;
    private final AbstractQueryBuilderProtoUtils queryUtils;
    private final CircuitBreakerService circuitBreakerService;

    public SearchServiceImpl(Client client, AbstractQueryBuilderProtoUtils queryUtils, CircuitBreakerService circuitBreakerService) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null");
        }
        if (queryUtils == null) {
            throw new IllegalArgumentException("Query utils cannot be null");
        }
        if (circuitBreakerService == null) {
            throw new IllegalArgumentException("Circuit breaker service cannot be null");
        }
        this.client = client;
        this.queryUtils = queryUtils;
        this.circuitBreakerService = circuitBreakerService;
    }

    public void search(SearchRequest request, StreamObserver<SearchResponse> responseObserver) {
        int requestSize = request.getSerializedSize();
        CircuitBreaker breaker = this.circuitBreakerService.getBreaker("in_flight_requests");
        try {
            breaker.addEstimateBytesAndMaybeBreak((long)requestSize, "<grpc_request>");
            CircuitBreakerStreamObserver<SearchResponse> wrappedObserver = new CircuitBreakerStreamObserver<SearchResponse>(responseObserver, this.circuitBreakerService, requestSize);
            org.opensearch.action.search.SearchRequest searchRequest = SearchRequestProtoUtils.prepareRequest(request, this.client, this.queryUtils);
            SearchRequestActionListener listener = new SearchRequestActionListener(wrappedObserver);
            this.client.search(searchRequest, (ActionListener)listener);
        }
        catch (CircuitBreakingException e) {
            logger.debug("Circuit breaker tripped for gRPC search request: {}", (Object)e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError((Exception)((Object)e));
            responseObserver.onError((Throwable)grpcError);
        }
        catch (IOException | RuntimeException e) {
            breaker.addWithoutBreaking((long)(-requestSize));
            logger.debug("SearchServiceImpl failed to process search request, request=" + String.valueOf(request) + ", error=" + e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
            responseObserver.onError((Throwable)grpcError);
        }
    }
}

