/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.internal.hppc.AbstractIterator;
import org.apache.lucene.internal.hppc.BitMixer;
import org.apache.lucene.internal.hppc.BufferAllocationException;
import org.apache.lucene.internal.hppc.CharCursor;
import org.apache.lucene.internal.hppc.HashContainers;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class CharHashSet
implements Iterable<CharCursor>,
Accountable,
Cloneable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CharHashSet.class);
    private static final char EMPTY_KEY = '\u0000';
    public char[] keys;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public CharHashSet() {
        this(4);
    }

    public CharHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharHashSet(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public CharHashSet(CharHashSet set) {
        this(set.size());
        this.addAll(set);
    }

    public boolean add(char key) {
        char existing;
        if (key == '\u0000') {
            assert (this.keys[this.mask + 1] == '\u0000');
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(char ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (char e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(CharHashSet set) {
        this.ensureCapacity(set.size());
        return this.addAll((Iterable<? extends CharCursor>)set);
    }

    public int addAll(Iterable<? extends CharCursor> iterable) {
        int count = 0;
        for (CharCursor charCursor : iterable) {
            if (!this.add(charCursor.value)) continue;
            ++count;
        }
        return count;
    }

    public char[] toArray() {
        char[] cloned = new char[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = '\u0000';
        }
        char[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            char existing = keys[slot];
            if (existing != '\u0000') {
                cloned[j++] = existing;
            }
            slot = slot + inc & mask;
        }
        return cloned;
    }

    public boolean remove(char key) {
        char existing;
        if (key == '\u0000') {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int removeAll(CharHashSet other) {
        int before = this.size();
        if (other.size() >= this.size()) {
            if (this.hasEmptyKey && other.contains('\u0000')) {
                this.hasEmptyKey = false;
            }
            char[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                char existing = keys[slot];
                if (existing != '\u0000' && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    public boolean contains(char key) {
        char existing;
        if (key == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            char[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        char[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            char existing = keys[slot];
            if (existing == '\u0000') continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.sameKeys((CharHashSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(CharHashSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (CharCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public CharHashSet clone() {
        try {
            CharHashSet cloned = (CharHashSet)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<CharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys);
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    public static CharHashSet from(char ... elements) {
        CharHashSet set = new CharHashSet(elements.length);
        set.addAll(elements);
        return set;
    }

    protected int hashKey(char key) {
        assert (key != '\u0000');
        return BitMixer.mixPhi(key);
    }

    public int indexOf(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public char indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index];
    }

    public char indexReplace(int index, char equivalentKey) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        assert (this.keys[index] == equivalentKey);
        char previousValue = this.keys[index];
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index, char key) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == '\u0000') {
            assert (index == this.mask + 1);
            assert (this.keys[index] == '\u0000');
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == '\u0000');
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key);
            } else {
                this.keys[index] = key;
            }
            ++this.assigned;
        }
    }

    public void indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        if (index > this.mask) {
            this.hasEmptyKey = false;
        } else {
            this.shiftConflictingKeys(index);
        }
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(char[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        char[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            char existing = fromKeys[i];
            if (existing == '\u0000') continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        char[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new char[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, char pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == '\u0000' && pendingKey != '\u0000');
        char[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        char[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = CharHashSet.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharHashSet.this.mask;
        }

        @Override
        protected CharCursor fetch() {
            int mask = CharHashSet.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharHashSet.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && CharHashSet.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = '\u0000';
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

