/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.gui.messages.UpdateStatusBarLeftDisplayEvent;
import mediathek.gui.tabs.tab_film.FilmDescriptionPanel;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import org.jetbrains.annotations.NotNull;

public abstract class AGuiTabPanel
extends JPanel {
    protected final JTabbedPane descriptionTab = new JTabbedPane();
    protected Daten daten;
    protected MediathekGui mediathekGui;
    protected FilmDescriptionPanel descriptionPanel;

    protected void makeDescriptionTabVisible(boolean visible) {
        if (visible) {
            if (this.descriptionTab.indexOfComponent(this.descriptionPanel) == -1) {
                this.descriptionTab.add((Component)this.descriptionPanel, 0);
                this.descriptionTab.setTitleAt(0, "Beschreibung");
            }
        } else if (this.descriptionTab.indexOfComponent(this.descriptionPanel) != -1) {
            this.descriptionTab.remove(this.descriptionPanel);
        }
    }

    protected void setupDescriptionTab(@NotNull JTable table, @NotNull JCheckBoxMenuItem cbmi, @NotNull String configKey, @NotNull Supplier<Optional<DatenFilm>> datenFilmSupplier) {
        this.descriptionPanel.install(this.descriptionTab, table, datenFilmSupplier);
        this.descriptionTab.putClientProperty("JTabbedPane.tabClosable", true);
        this.descriptionTab.putClientProperty("JTabbedPane.tabCloseCallback", tabIndex -> cbmi.doClick());
        this.setupShowFilmDescriptionMenuItem();
        this.initDescriptionTabVisibility(configKey);
    }

    protected void updateSelectedListItemsCount(@NotNull JTable table) {
        int sel = table.getSelectedRowCount();
        this.mediathekGui.selectedListItemsProperty.setSelectedItems(sel);
    }

    protected abstract void setupShowFilmDescriptionMenuItem();

    protected void initDescriptionTabVisibility(@NotNull String configKey) {
        boolean visible = ApplicationConfiguration.getConfiguration().getBoolean(configKey, true);
        this.makeDescriptionTabVisible(visible);
    }

    public abstract void tabelleSpeichern();

    protected abstract List<DatenFilm> getSelFilme();

    public abstract Optional<DatenFilm> getCurrentlySelectedFilm();

    protected void updateStartInfoProperty() {
        MessageBus.getMessageBus().publishAsync((Object)new UpdateStatusBarLeftDisplayEvent());
    }

    public abstract void installMenuEntries(JMenu var1);

    public class MarkFilmAsUnseenAction
    extends AbstractAction {
        public MarkFilmAsUnseenAction() {
            super("Filme als ungesehen markieren");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 128));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> listFilms = AGuiTabPanel.this.getSelFilme();
            try (SeenHistoryController controller = new SeenHistoryController();){
                controller.markUnseen(listFilms);
            }
        }
    }

    public class MarkFilmAsSeenAction
    extends AbstractAction {
        public MarkFilmAsSeenAction() {
            super("Filme als gesehen markieren");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, 128));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> listFilms = AGuiTabPanel.this.getSelFilme();
            try (SeenHistoryController controller = new SeenHistoryController();){
                controller.markSeen(listFilms);
            }
        }
    }
}

