/**
 * Represents an HTTP error from the Appservice.
 * @category Error handling
 */
export declare class AppserviceHttpError extends Error {
    readonly body: {
        errcode: string;
        error: string;
    };
    readonly status: number;
    /**
     * The Matrix error code
     */
    readonly errcode: string;
    /**
     * Optional human-readable error message.
     */
    readonly error: string;
    /**
     * Creates a new Appservice HTTP error
     * @param body The error body.
     * @param status The HTTP status code.
     */
    constructor(body: {
        errcode: string;
        error: string;
    }, status: number);
    /**
     * Developer-friendly error message.
     */
    get message(): string;
}
