/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import org.havi.ui.HBackgroundConfigTemplate;
import org.havi.ui.HBackgroundConfiguration;
import org.havi.ui.HBackgroundDevice;
import org.havi.ui.HConfigurationException;
import org.havi.ui.HGraphicsConfigTemplate;
import org.havi.ui.HGraphicsConfiguration;
import org.havi.ui.HGraphicsDevice;
import org.havi.ui.HPermissionDeniedException;
import org.havi.ui.HScreenConfigTemplate;
import org.havi.ui.HScreenConfiguration;
import org.havi.ui.HVideoConfigTemplate;
import org.havi.ui.HVideoConfiguration;
import org.havi.ui.HVideoDevice;

public class HScreen {
    private static final HScreen DEFAULT_HSCREEN = new HScreen();
    private HVideoDevice hVideoDevice = new HVideoDevice();
    private HGraphicsDevice hGraphicsDevice = new HGraphicsDevice();
    private HBackgroundDevice hBackgroundDevice = new HBackgroundDevice();

    private HScreen() {
    }

    public static HScreen[] getHScreens() {
        HScreen[] screens = new HScreen[]{DEFAULT_HSCREEN};
        return screens;
    }

    public static HScreen getDefaultHScreen() {
        return DEFAULT_HSCREEN;
    }

    public HVideoDevice[] getHVideoDevices() {
        HVideoDevice[] devices = new HVideoDevice[]{this.hVideoDevice};
        return devices;
    }

    public HVideoDevice getDefaultHVideoDevice() {
        return this.hVideoDevice;
    }

    public HVideoConfiguration getBestConfiguration(HVideoConfigTemplate[] hvcta) {
        return this.hVideoDevice.getBestConfiguration(hvcta);
    }

    public HGraphicsDevice[] getHGraphicsDevices() {
        HGraphicsDevice[] devices = new HGraphicsDevice[]{this.hGraphicsDevice};
        return devices;
    }

    public HGraphicsDevice getDefaultHGraphicsDevice() {
        return this.hGraphicsDevice;
    }

    public HGraphicsConfiguration getBestConfiguration(HGraphicsConfigTemplate[] hgcta) {
        return this.hGraphicsDevice.getBestConfiguration(hgcta);
    }

    public HBackgroundDevice[] getHBackgroundDevices() {
        HBackgroundDevice[] devices = new HBackgroundDevice[]{this.hBackgroundDevice};
        return devices;
    }

    public HBackgroundDevice getDefaultHBackgroundDevice() {
        return this.hBackgroundDevice;
    }

    public HBackgroundConfiguration getBestConfiguration(HBackgroundConfigTemplate[] hbcta) {
        return this.hBackgroundDevice.getBestConfiguration(hbcta);
    }

    public HScreenConfiguration[] getCoherentScreenConfigurations(HScreenConfigTemplate[] hscta) {
        if (hscta == null || hscta.length == 0) {
            throw new IllegalArgumentException("HScreenConfigTemplate[] hscta cannot be null");
        }
        HScreenConfiguration[] hsc = new HScreenConfiguration[hscta.length];
        for (int i = 0; i < hscta.length; ++i) {
            if (hscta[i] instanceof HVideoConfigTemplate) {
                hsc[i] = this.hVideoDevice.getBestConfiguration((HVideoConfigTemplate)hscta[i]);
                continue;
            }
            if (hscta[i] instanceof HGraphicsConfigTemplate) {
                hsc[i] = this.hGraphicsDevice.getBestConfiguration((HGraphicsConfigTemplate)hscta[i]);
                continue;
            }
            if (hscta[i] instanceof HBackgroundConfigTemplate) {
                hsc[i] = this.hBackgroundDevice.getBestConfiguration((HBackgroundConfigTemplate)hscta[i]);
                continue;
            }
            return null;
        }
        return hsc;
    }

    public boolean setCoherentScreenConfigurations(HScreenConfiguration[] hsca) throws SecurityException, HPermissionDeniedException, HConfigurationException {
        if (hsca == null || hsca.length == 0) {
            throw new IllegalArgumentException("HScreenConfiguration[] hsca cannot be null");
        }
        for (int i = 0; i < hsca.length; ++i) {
            if (!(hsca[i] instanceof HVideoConfiguration ? !((HVideoConfiguration)hsca[i]).getDevice().setVideoConfiguration((HVideoConfiguration)hsca[i]) : (hsca[i] instanceof HGraphicsConfiguration ? !((HGraphicsConfiguration)hsca[i]).getDevice().setGraphicsConfiguration((HGraphicsConfiguration)hsca[i]) : hsca[i] instanceof HBackgroundConfiguration && !((HBackgroundConfiguration)hsca[i]).getDevice().setBackgroundConfiguration((HBackgroundConfiguration)hsca[i])))) continue;
            return false;
        }
        return true;
    }
}

