/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashMap;
import java.util.List;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.CachedUserConsent;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedUserConsents
extends AbstractRevisioned
implements InRealm {
    private HashMap<String, CachedUserConsent> consents = new HashMap();
    private final String realmId;
    private boolean allConsents;

    public CachedUserConsents(Long revision, String id, RealmModel realm, List<CachedUserConsent> consents) {
        this(revision, id, realm, consents, true);
    }

    public CachedUserConsents(Long revision, String id, RealmModel realm, List<CachedUserConsent> consents, boolean allConsents) {
        super(revision, id);
        this.realmId = realm.getId();
        this.allConsents = allConsents;
        if (consents != null) {
            for (CachedUserConsent consent : consents) {
                this.consents.put(consent.getClientDbId(), consent);
            }
        }
    }

    @Override
    public String getRealm() {
        return this.realmId;
    }

    public HashMap<String, CachedUserConsent> getConsents() {
        return this.consents;
    }

    public boolean isAllConsents() {
        return this.allConsents;
    }
}

