/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl;

import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.api.ManagedExecutorConfig;
import io.smallrye.context.impl.DefaultValues;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class DefaultValuesFromConfig
implements DefaultValues {
    private final String EXEC_ASYNC = "mp.context.ManagedExecutor.maxAsync";
    private final String EXEC_QUEUE = "mp.context.ManagedExecutor.maxQueued";
    private final String EXEC_PROPAGATED = "mp.context.ManagedExecutor.propagated";
    private final String EXEC_CLEARED = "mp.context.ManagedExecutor.cleared";
    private final String THREAD_CLEARED = "mp.context.ThreadContext.cleared";
    private final String THREAD_PROPAGATED = "mp.context.ThreadContext.propagated";
    private final String THREAD_UNCHANGED = "mp.context.ThreadContext.unchanged";
    private String[] executorPropagated;
    private String[] executorCleared;
    private int executorAsync;
    private int executorQueue;
    private String[] threadPropagated;
    private String[] threadCleared;
    private String[] threadUnchanged;

    public DefaultValuesFromConfig() {
        Config config = ConfigProvider.getConfig();
        HashSet<String> allkeys = new HashSet<String>();
        config.getPropertyNames().forEach(item -> allkeys.add((String)item));
        this.executorAsync = config.getOptionalValue("mp.context.ManagedExecutor.maxAsync", Integer.class).orElse(ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxAsync());
        this.executorQueue = config.getOptionalValue("mp.context.ManagedExecutor.maxQueued", Integer.class).orElse(ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxQueued());
        this.executorPropagated = this.resolveConfiguration(config, "mp.context.ManagedExecutor.propagated", SmallRyeContextManager.ALL_REMAINING_ARRAY, allkeys);
        this.executorCleared = this.resolveConfiguration(config, "mp.context.ManagedExecutor.cleared", SmallRyeContextManager.NO_STRING, allkeys);
        this.threadCleared = this.resolveConfiguration(config, "mp.context.ThreadContext.cleared", SmallRyeContextManager.NO_STRING, allkeys);
        this.threadPropagated = this.resolveConfiguration(config, "mp.context.ThreadContext.propagated", SmallRyeContextManager.ALL_REMAINING_ARRAY, allkeys);
        this.threadUnchanged = this.resolveConfiguration(config, "mp.context.ThreadContext.unchanged", SmallRyeContextManager.NO_STRING, allkeys);
    }

    private String[] resolveConfiguration(Config mpConfig, String key, String[] originalValue, Set<String> allKeys) {
        try {
            return (String[])mpConfig.getValue(key, String[].class);
        }
        catch (NoSuchElementException e) {
            if (allKeys.contains(key)) {
                return new String[0];
            }
            return originalValue;
        }
    }

    @Override
    public String[] getExecutorPropagated() {
        return this.executorPropagated;
    }

    @Override
    public String[] getExecutorCleared() {
        return this.executorCleared;
    }

    @Override
    public int getExecutorAsync() {
        return this.executorAsync;
    }

    @Override
    public int getExecutorQueue() {
        return this.executorQueue;
    }

    @Override
    public String[] getThreadPropagated() {
        return this.threadPropagated;
    }

    @Override
    public String[] getThreadCleared() {
        return this.threadCleared;
    }

    @Override
    public String[] getThreadUnchanged() {
        return this.threadUnchanged;
    }
}

