/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.InformationDialog;
import org.jsampler.CC;
import org.jsampler.view.LostFilesTable;
import org.jsampler.view.std.JSReplaceLostFilesDlg;
import org.jsampler.view.std.StdI18n;

public class JSLostFilesDlg
extends InformationDialog {
    private final LostFilesTable lostFilesTable = new LostFilesTable();
    private final JButton btnReplace = new JButton(StdI18n.i18n.getButtonLabel("JSLostFilesDlg.btnReplace"));
    private final JButton btnRename = new JButton(StdI18n.i18n.getButtonLabel("rename"));
    private final JButton btnUpdate = new JButton(StdI18n.i18n.getButtonLabel("update"));
    private final EventHandler eventHandler = new EventHandler();

    public JSLostFilesDlg(Frame frame) {
        super(frame, StdI18n.i18n.getLabel("JSLostFilesDlg.title"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JScrollPane jScrollPane = new JScrollPane(this.lostFilesTable);
        jScrollPane.setPreferredSize(new Dimension(500, 250));
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.btnRename.setEnabled(false);
        jPanel2.add(this.btnRename);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.btnReplace);
        jPanel2.add(Box.createGlue());
        jPanel2.add(this.btnUpdate);
        jPanel.add(jPanel2);
        CC.getLostFilesModel().addChangeListener(this.getHandler());
        CC.getLostFilesModel().update();
        this.setMainPane(jPanel);
        this.lostFilesTable.getSelectionModel().addListSelectionListener(this.getHandler());
        this.btnRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSLostFilesDlg.this.lostFilesTable.editSelectedFile();
            }
        });
        this.btnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new JSReplaceLostFilesDlg(JSLostFilesDlg.this).setVisible(true);
            }
        });
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getLostFilesModel().update();
            }
        });
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements ListSelectionListener,
    ChangeListener {
        private EventHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            JSLostFilesDlg.this.btnRename.setEnabled(!listSelectionModel.isSelectionEmpty());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = CC.getLostFilesModel().getLostFileCount() != 0;
            JSLostFilesDlg.this.btnReplace.setEnabled(bl);
        }
    }
}

