/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class Tension
implements Named {
    public static final int TENSION_MIN = 0;
    public static final int TENSION_MAX = Level.HATEFUL.limit + 100;
    public static final int DELTA = 10;
    public static final int TENSION_ADD_MINOR = 100;
    public static final int TENSION_ADD_NORMAL = 200;
    public static final int TENSION_ADD_MAJOR = 300;
    public static final int TENSION_ADD_LAND_TAKEN = 200;
    public static final int TENSION_ADD_UNIT_DESTROYED = 400;
    public static final int TENSION_ADD_SETTLEMENT_ATTACKED = 500;
    public static final int TENSION_ADD_CAPITAL_ATTACKED = 600;
    public static final int TENSION_ADD_WAR_INCITER = 250;
    public static final int CONTACT_MODIFIER = 0;
    public static final int ALLIANCE_MODIFIER = -500;
    public static final int DROP_ALLIANCE_MODIFIER = 200;
    public static final int PEACE_TREATY_MODIFIER = -250;
    public static final int CEASE_FIRE_MODIFIER = -250;
    public static final int WAR_MODIFIER = Level.HATEFUL.limit;
    public static final int RESUME_WAR_MODIFIER = 750;
    public static final int SURRENDERED = (Level.CONTENT.limit + Level.HAPPY.limit) / 2;
    private int value;

    public Tension() {
        this.setValue(Level.HAPPY.getLimit());
    }

    public Tension(int newTension) {
        this.setValue(newTension);
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int newValue) {
        this.value = newValue < 0 ? 0 : (newValue > TENSION_MAX ? TENSION_MAX : newValue);
    }

    public final Level getLevel() {
        return CollectionUtils.find(Level.values(), level -> this.value <= level.getLimit(), Level.HATEFUL);
    }

    public final void modify(int newTension) {
        this.setValue(this.value + newTension);
    }

    public String getKey() {
        return "tension." + this.getLevel().getKey();
    }

    @Override
    public String getNameKey() {
        return Messages.nameKey("model." + this.getKey());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tension) {
            Tension other = (Tension)o;
            return this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.value;
        return hash;
    }

    public String toString() {
        return this.getLevel().toString();
    }

    public static enum Level {
        HAPPY(100),
        CONTENT(600),
        DISPLEASED(700),
        ANGRY(800),
        HATEFUL(1000);

        private final int limit;

        private Level(int limit) {
            this.limit = limit;
        }

        public int getLimit() {
            return this.limit;
        }

        public String getKey() {
            return StringUtils.getEnumKey(this);
        }
    }
}

