/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class MetadataSet {
    private final ListMultimap<Property, Metadata> all;
    private final ListMultimap<Property, Metadata> primary;
    private final ListMultimap<String, Metadata> refiners;
    private final Map<Metadata, Metadata> refines;
    private final Supplier<List<Metadata>> allList = Suppliers.memoize((Supplier)new Supplier<List<Metadata>>(){

        public List<Metadata> get() {
            return ImmutableList.copyOf((Collection)MetadataSet.this.all.values());
        }
    });
    private final Supplier<List<Metadata>> primaryList = Suppliers.memoize((Supplier)new Supplier<List<Metadata>>(){

        public List<Metadata> get() {
            return ImmutableList.copyOf((Collection)MetadataSet.this.primary.values());
        }
    });

    private MetadataSet(Multimap<Property, Metadata> all, Multimap<Property, Metadata> primary, Map<Metadata, Metadata> refines, Multimap<String, Metadata> refiners) {
        this.all = ImmutableListMultimap.copyOf(all);
        this.primary = ImmutableListMultimap.copyOf(primary);
        this.refines = ImmutableMap.copyOf(refines);
        this.refiners = ImmutableListMultimap.copyOf(refiners);
    }

    public List<Metadata> getPrimary() {
        return (List)this.primaryList.get();
    }

    public List<Metadata> getAll() {
        return (List)this.allList.get();
    }

    public boolean containsPrimary(Property property) {
        return this.primary.containsKey((Object)property);
    }

    public boolean containsPrimary(Property property, String value) {
        for (Metadata meta : this.primary.get((Object)property)) {
            if (!meta.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Property property) {
        return this.all.containsKey((Object)property);
    }

    public List<Metadata> getPrimary(Property property) {
        return this.primary.get((Object)property);
    }

    public List<Metadata> getAny(Property property) {
        return this.all.get((Object)property);
    }

    public Optional<Metadata> getRefinedBy(Metadata meta) {
        return Optional.fromNullable((Object)this.refines.get(meta));
    }

    public List<Metadata> getRefining(String id) {
        return this.refiners.get((Object)id);
    }

    public static Optional<Metadata> tryFindInRefines(List<Metadata> metas, final Property property, final Optional<String> value) {
        Preconditions.checkNotNull(metas);
        Preconditions.checkNotNull((Object)property);
        Preconditions.checkNotNull(value);
        return Iterables.tryFind(metas, (Predicate)new Predicate<Metadata>(){

            public boolean apply(Metadata meta) {
                return MetadataSet.tryFind(meta.getRefiners(), property, (Optional<String>)value).isPresent();
            }
        });
    }

    public static Optional<Metadata> tryFind(List<Metadata> metas, final Property property, final Optional<String> value) {
        Preconditions.checkNotNull(metas);
        Preconditions.checkNotNull((Object)property);
        Preconditions.checkNotNull(value);
        return Iterables.tryFind(metas, (Predicate)new Predicate<Metadata>(){

            public boolean apply(Metadata meta) {
                return property.equals(meta.getProperty()) && (!value.isPresent() || ((String)value.get()).equals(meta.getValue()));
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Metadata {
        private final Optional<String> id;
        private final Property property;
        private final String value;
        private final Optional<String> refines;
        private final List<Metadata> refiners;

        private Metadata(String id, Property property, String value, String refines, List<Metadata> refiners) {
            Preconditions.checkNotNull((Object)property);
            this.id = Optional.fromNullable((Object)id);
            this.property = property;
            String string = this.value = value == null ? "" : value.trim();
            this.refines = refines == null ? Optional.absent() : (refines.startsWith("#") ? Optional.fromNullable((Object)Strings.emptyToNull((String)refines.substring(1))) : Optional.of((Object)refines));
            this.refiners = refiners == null ? ImmutableList.of() : refiners;
        }

        public Optional<String> getId() {
            return this.id;
        }

        public Property getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public Optional<String> getRefines() {
            return this.refines;
        }

        public List<Metadata> getRefiners() {
            return this.refiners;
        }

        public boolean isPrimary() {
            return !this.refines.isPresent();
        }

        public String toString() {
            return "Metadata [id=" + this.id + ", property=" + this.property + ", value=" + this.value + ", refines=" + this.refines + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            result = 31 * result + (this.refines == null ? 0 : this.refines.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Metadata other = (Metadata)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
                return false;
            }
            if (this.refines == null ? other.refines != null : !this.refines.equals(other.refines)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static final class Builder {
        private final Multimap<Property, Metadata> primary = LinkedListMultimap.create();
        private final Multimap<Property, Metadata> all = LinkedListMultimap.create();
        private final LinkedList<Metadata> tempMetas = Lists.newLinkedList();
        private final Multimap<String, Metadata> refinersMap = LinkedListMultimap.create();
        private final Map<Metadata, Metadata> refines = Maps.newHashMap();
        private final Map<Metadata, Visit> visits = Maps.newHashMap();

        public MetadataSet build() {
            for (Metadata metadata : this.tempMetas) {
                this.build(metadata);
            }
            return new MetadataSet(this.all, this.primary, this.refines, this.refinersMap);
        }

        private Metadata build(Metadata meta) {
            Preconditions.checkArgument((boolean)meta.getId().isPresent());
            switch (Visit.safe(this.visits.get(meta)).ordinal()) {
                case 1: {
                    return meta;
                }
                case 2: {
                    throw new IllegalStateException("Not a DAG");
                }
            }
            this.visits.put(meta, Visit.VISITING);
            LinkedList<Metadata> refiners = new LinkedList<Metadata>();
            for (Metadata refiner : this.refinersMap.get((Object)((String)meta.getId().get()))) {
                refiners.add(refiner.getId().isPresent() ? this.build(refiner) : refiner);
            }
            Metadata result = new Metadata((String)meta.getId().get(), meta.getProperty(), meta.getValue(), (String)meta.getRefines().orNull(), refiners);
            for (Metadata refiner : refiners) {
                this.refines.put(refiner, result);
            }
            if (result.getRefines().isPresent()) {
                this.refinersMap.remove(result.getRefines().get(), (Object)meta);
                this.refinersMap.put((Object)((String)result.getRefines().get()), (Object)result);
            } else {
                this.primary.put((Object)result.getProperty(), (Object)result);
            }
            this.all.put((Object)result.getProperty(), (Object)result);
            this.visits.put(meta, Visit.VISITED);
            return result;
        }

        public Builder meta(String id, Property property, String value, String refines) {
            Metadata meta = new Metadata(id, property, value, refines, null);
            if (id == null) {
                if (!meta.refines.isPresent()) {
                    this.primary.put((Object)property, (Object)meta);
                }
                this.all.put((Object)property, (Object)meta);
            } else {
                this.tempMetas.add(meta);
            }
            if (meta.refines.isPresent()) {
                this.refinersMap.put((Object)((String)meta.refines.get()), (Object)meta);
            }
            return this;
        }

        private static enum Visit {
            UNVISITED,
            VISITED,
            VISITING;


            public static Visit safe(Visit visit) {
                return visit != null ? visit : UNVISITED;
            }
        }
    }
}

