/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.data.OracleCLOBValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleContentXML;
import org.jkiss.dbeaver.ext.oracle.data.OracleXMLWrapper;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentXML;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class OracleXMLValueHandler
extends OracleCLOBValueHandler {
    public static final OracleXMLValueHandler INSTANCE = new OracleXMLValueHandler();

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/xml";
    }

    protected DBDContent fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object object;
        try {
            object = resultSet.getObject(index);
        }
        catch (SQLException sQLException) {
            try {
                object = resultSet.getSQLXML(index);
            }
            catch (SQLException sQLException2) {
                object = null;
            }
        }
        if (object == null) {
            return new OracleContentXML(session.getExecutionContext(), null);
        }
        if (object.getClass().getName().equals("oracle.xdb.XMLType")) {
            return new OracleContentXML(session.getExecutionContext(), new OracleXMLWrapper(object));
        }
        if (object instanceof SQLXML) {
            return new OracleContentXML(session.getExecutionContext(), (SQLXML)object);
        }
        throw new DBCException("Unsupported object type: " + object.getClass().getName());
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value instanceof OracleContentXML) {
            super.bindParameter(session, statement, paramType, paramIndex, value);
        } else if (value instanceof JDBCContentXML) {
            if (((JDBCContentXML)value).isNull()) {
                statement.setNull(paramIndex, 2009, paramType.getTypeName());
            } else {
                SQLXML xmlValue = ((JDBCContentXML)value).getRawValue();
                Object xmlObject = OracleContentXML.createXmlObject(session, xmlValue.getBinaryStream());
                statement.setObject(paramIndex, xmlObject);
            }
        } else if (DBUtils.isNullValue((Object)value)) {
            statement.setNull(paramIndex, 2009, paramType.getTypeName());
        } else {
            String strValue = CommonUtils.toString((Object)value);
            Object xmlObject = OracleContentXML.createXmlObject(session, new ByteArrayInputStream(strValue.getBytes(StandardCharsets.UTF_8)));
            statement.setObject(paramIndex, xmlObject);
        }
    }

    public DBDContent getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new OracleContentXML(session.getExecutionContext(), null);
        }
        if (object instanceof OracleContentXML) {
            return copy ? (OracleContentXML)((OracleContentXML)((Object)object)).cloneValue(session.getProgressMonitor()) : (OracleContentXML)((Object)object);
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }
}

