"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsolatedCircuitError = void 0;
const BrokenCircuitError_1 = require("./BrokenCircuitError");
class IsolatedCircuitError extends BrokenCircuitError_1.BrokenCircuitError {
    /**
     * Exception thrown from {@link CircuitBreakerPolicy.execute} when the
     * circuit breaker is open.
     */
    constructor() {
        super(`Execution prevented because the circuit breaker is open`);
        this.isIsolatedCircuitError = true;
    }
}
exports.IsolatedCircuitError = IsolatedCircuitError;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c3a26841a84f20dfe0850d0a5a9bd01da4f003ea/node_modules/cockatiel/dist/errors/IsolatedCircuitError.js.map