/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGrayscaleConnectedOpeningImageFilter_h
#define sitkGrayscaleConnectedOpeningImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class GrayscaleConnectedOpeningImageFilter
\brief Enhance pixels associated with a bright object (identified by a seed pixel) where the bright object is surrounded by a darker object.

GrayscaleConnectedOpeningImageFilter is useful for enhancing bright objects that are surrounded by dark borders. This filter makes it easier to threshold the image and extract just the object of interest.

Geodesic morphology and the connected opening algorithm is described in Chapter 6 of Pierre Soille's book "Morphological Image
Analysis: Principles and Applications", Second Edition, Springer, 2003.

\see GrayscaleGeodesicDilateImageFilter 


\see MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
\sa itk::simple::GrayscaleConnectedOpening for the procedural interface
\sa itk::GrayscaleConnectedOpeningImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GrayscaleConnectedOpeningImageFilter : public ImageFilter {
    public:
      using Self = GrayscaleConnectedOpeningImageFilter;

      /** Destructor */
      virtual ~GrayscaleConnectedOpeningImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GrayscaleConnectedOpeningImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set/Get the seed pixel for the segmentation
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSeed ( std::vector<unsigned int> Seed ) { this->m_Seed = std::move(Seed); return *this; }

      /**
       * Set/Get the seed pixel for the segmentation
       */
      std::vector<unsigned int> GetSeed() const { return this->m_Seed; }\

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      bool GetFullyConnected() const { return this->m_FullyConnected; }

      /** Name of this class */
      std::string GetName() const { return std::string ("GrayscaleConnectedOpeningImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<unsigned int>  m_Seed{std::vector<unsigned int>(3, 0)};

      bool  m_FullyConnected{false};


    };

    /**\
     * \brief Enhance pixels associated with a bright object (identified by a seed pixel) where the bright object is surrounded by a darker object.
     *
     * This function directly calls the execute method of GrayscaleConnectedOpeningImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::GrayscaleConnectedOpeningImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image GrayscaleConnectedOpening ( const Image& image1, std::vector<unsigned int> seed = std::vector<unsigned int>(3, 0), bool fullyConnected = false );

     /** @} */
}
#endif
