/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ExtendedStats;
import org.opensearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.request.AggregateFilterAnalyzer;
import org.opensearch.sql.opensearch.request.CaseRangeAnalyzer;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.ArgMaxMinParser;
import org.opensearch.sql.opensearch.response.agg.BucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.CountAsTotalHitsParser;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.NoBucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.response.agg.SinglePercentileParser;
import org.opensearch.sql.opensearch.response.agg.SingleValueParser;
import org.opensearch.sql.opensearch.response.agg.StatsParser;
import org.opensearch.sql.opensearch.response.agg.TopHitsParser;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.CompositeAggregationBuilder;
import org.opensearch.sql.utils.Utils;

public class AggregateAnalyzer {
    private static final String METADATA_FIELD = "_index";

    private AggregateAnalyzer() {
    }

    public static Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> analyze(Aggregate aggregate, @Nullable Project project, List<String> outputFields, AggregateBuilderHelper helper) throws ExpressionNotAnalyzableException {
        Objects.requireNonNull(aggregate, "aggregate");
        try {
            List<String> nestedPathFromBuckets;
            boolean validNestedAgg;
            List groupList = aggregate.getGroupSet().asList();
            List<String> aggFieldNames = outputFields.subList(groupList.size(), outputFields.size());
            Pair<AggregatorFactories.Builder, List<MetricParser>> builderAndParser = AggregateAnalyzer.processAggregateCalls(aggFieldNames, aggregate.getAggCallList(), project, helper);
            AggregatorFactories.Builder metricBuilder = (AggregatorFactories.Builder)builderAndParser.getLeft();
            List metricParsers = (List)builderAndParser.getRight();
            boolean countAllOnly = !groupList.isEmpty();
            Pair<List<String>, AggregatorFactories.Builder> countAggNameAndBuilderPair = AggregateAnalyzer.removeCountAggregationBuilders(metricBuilder, countAllOnly);
            AggregatorFactories.Builder newMetricBuilder = (AggregatorFactories.Builder)countAggNameAndBuilderPair.getRight();
            List countAggNames = (List)countAggNameAndBuilderPair.getLeft();
            if (aggregate.getGroupSet().isEmpty()) {
                if (newMetricBuilder == null) {
                    return Pair.of(List.of(), (Object)new CountAsTotalHitsParser(countAggNames));
                }
                return Pair.of((Object)ImmutableList.copyOf((Collection)newMetricBuilder.getAggregatorFactories()), (Object)new NoBucketAggregationParser(metricParsers));
            }
            AggregatorFactories.Builder subBuilder = newMetricBuilder;
            List<Pair<String, Integer>> groupNameAndIndexList = IntStream.range(0, groupList.size()).mapToObj(i -> Pair.of((Object)((String)outputFields.get(i)), (Object)((Integer)groupList.get(i)))).toList();
            Pair<Set<Integer>, AggregationBuilder> aggPushedAndAggBuilder = AggregateAnalyzer.createStructuredAggregation(groupNameAndIndexList, project, subBuilder, helper);
            Set aggPushed = (Set)aggPushedAndAggBuilder.getLeft();
            AggregationBuilder pushedAggBuilder = (AggregationBuilder)aggPushedAndAggBuilder.getRight();
            groupNameAndIndexList = groupNameAndIndexList.stream().filter(pair -> !aggPushed.contains(pair.getRight())).toList();
            if (pushedAggBuilder != null) {
                subBuilder = new AggregatorFactories.Builder().addAggregator(pushedAggBuilder);
            }
            if (groupNameAndIndexList.isEmpty()) {
                return Pair.of((Object)ImmutableList.copyOf((Collection)subBuilder.getAggregatorFactories()), (Object)new BucketAggregationParser(metricParsers, countAggNames));
            }
            List<CompositeValuesSourceBuilder<?>> buckets = AggregateAnalyzer.createCompositeBuckets(groupNameAndIndexList, project, helper);
            if (buckets.size() != groupNameAndIndexList.size()) {
                throw new UnsupportedOperationException("Not all the left aggregations can be converted to value sources of composite aggregation");
            }
            org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder compositeBuilder = AggregationBuilders.composite((String)"composite_buckets", buckets).size(helper.queryBucketSize);
            if (subBuilder != null) {
                compositeBuilder.subAggregations(subBuilder);
            }
            boolean bl = validNestedAgg = (nestedPathFromBuckets = groupNameAndIndexList.stream().map(b -> Utils.resolveNestedPath((String)((String)b.getLeft()), helper.fieldTypes)).toList()).stream().noneMatch(Objects::isNull) && nestedPathFromBuckets.stream().distinct().count() == 1L;
            if (validNestedAgg) {
                String nestedPath = nestedPathFromBuckets.getFirst();
                AbstractAggregationBuilder nestedAggBuilder = AggregationBuilders.nested((String)String.format("nested_%s", compositeBuilder.getName()), (String)nestedPath).subAggregation((AggregationBuilder)compositeBuilder);
                return Pair.of(Collections.singletonList(nestedAggBuilder), (Object)new BucketAggregationParser(metricParsers, countAggNames));
            }
            return Pair.of(Collections.singletonList(compositeBuilder), (Object)new BucketAggregationParser(metricParsers, countAggNames));
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf((Throwable)e, UnsupportedOperationException.class);
            throw new ExpressionNotAnalyzableException("Can't convert " + String.valueOf(aggregate), e);
        }
    }

    private static Pair<List<String>, AggregatorFactories.Builder> removeCountAggregationBuilders(AggregatorFactories.Builder metricBuilder, boolean countAllOnly) {
        List<ValueCountAggregationBuilder> countAggregatorFactories = metricBuilder.getAggregatorFactories().stream().filter(ValueCountAggregationBuilder.class::isInstance).map(ValueCountAggregationBuilder.class::cast).filter(vc -> vc.script() == null).filter(vc -> !countAllOnly || vc.fieldName().equals(METADATA_FIELD)).toList();
        ArrayList copy = new ArrayList(metricBuilder.getAggregatorFactories());
        copy.removeAll(countAggregatorFactories);
        AggregatorFactories.Builder newMetricBuilder = new AggregatorFactories.Builder();
        copy.forEach(arg_0 -> ((AggregatorFactories.Builder)newMetricBuilder).addAggregator(arg_0));
        if (countAllOnly || AggregateAnalyzer.supportCountFiled(countAggregatorFactories, metricBuilder)) {
            List<String> countAggNameList = countAggregatorFactories.stream().map(AggregationBuilder::getName).toList();
            if (newMetricBuilder.getAggregatorFactories().isEmpty()) {
                newMetricBuilder = null;
            }
            return Pair.of(countAggNameList, (Object)newMetricBuilder);
        }
        return Pair.of(List.of(), (Object)metricBuilder);
    }

    private static boolean supportCountFiled(List<ValueCountAggregationBuilder> countAggBuilderList, AggregatorFactories.Builder metricBuilder) {
        return countAggBuilderList.size() == metricBuilder.getAggregatorFactories().size() && countAggBuilderList.stream().map(ValuesSourceAggregationBuilder::fieldName).distinct().count() == 1L;
    }

    private static Pair<AggregatorFactories.Builder, List<MetricParser>> processAggregateCalls(List<String> aggNames, List<AggregateCall> aggCalls, Project project, AggregateBuilderHelper helper) throws PredicateAnalyzer.ExpressionNotAnalyzableException {
        AggregatorFactories.Builder metricBuilder = new AggregatorFactories.Builder();
        ArrayList<MetricParser> metricParserList = new ArrayList<MetricParser>();
        AggregateFilterAnalyzer aggFilterAnalyzer = new AggregateFilterAnalyzer(helper, project);
        for (int i = 0; i < aggCalls.size(); ++i) {
            String nestedPath;
            AggregateCall aggCall = aggCalls.get(i);
            List<Pair<RexNode, String>> args = AggregateAnalyzer.convertAggArgThroughProject(aggCall, project, helper);
            String aggName = aggNames.get(i);
            Pair<AggregationBuilder, MetricParser> builderAndParser = AggregateAnalyzer.createAggregationBuilderAndParser(aggCall, args, aggName, helper);
            builderAndParser = aggFilterAnalyzer.analyze(builderAndParser, aggCall, aggName);
            String string = nestedPath = args.isEmpty() ? null : Utils.resolveNestedPath((String)((String)args.getFirst().getRight()), helper.fieldTypes);
            if (nestedPath != null) {
                metricBuilder.addAggregator((AggregationBuilder)AggregationBuilders.nested((String)String.format("nested_%s", aggCall.getName()), (String)nestedPath).subAggregation((AggregationBuilder)builderAndParser.getLeft()));
            } else {
                metricBuilder.addAggregator((AggregationBuilder)builderAndParser.getLeft());
            }
            metricParserList.add((MetricParser)builderAndParser.getRight());
        }
        return Pair.of((Object)metricBuilder, metricParserList);
    }

    private static List<Pair<RexNode, String>> convertAggArgThroughProject(AggregateCall aggCall, Project project, AggregateBuilderHelper helper) {
        return project == null ? aggCall.getArgList().stream().map(i -> Pair.of((Object)RexInputRef.of((int)i, (RelDataType)helper.rowType), (Object)((String)helper.rowType.getFieldNames().get((int)i)))).toList() : (PlanUtils.getObjectFromLiteralAgg((AggregateCall)aggCall) != null ? project.getNamedProjects().stream().filter(rex -> !((RexNode)rex.getKey()).isA(SqlKind.ROW_NUMBER)).map(p -> Pair.of((Object)((RexNode)p.getKey()), (Object)((String)p.getValue()))).toList() : aggCall.getArgList().stream().map(project.getNamedProjects()::get).map(p -> Pair.of((Object)((RexNode)p.getKey()), (Object)((String)p.getValue()))).toList());
    }

    private static Pair<AggregationBuilder, MetricParser> createAggregationBuilderAndParser(AggregateCall aggCall, List<Pair<RexNode, String>> args, String aggName, AggregateBuilderHelper helper) {
        if (aggCall.isDistinct()) {
            return AggregateAnalyzer.createDistinctAggregation(aggCall, args, aggName, helper);
        }
        return AggregateAnalyzer.createRegularAggregation(aggCall, args, aggName, helper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<AggregationBuilder, MetricParser> createDistinctAggregation(AggregateCall aggCall, List<Pair<RexNode, String>> args, String aggName, AggregateBuilderHelper helper) {
        switch (aggCall.getAggregation().kind) {
            case COUNT: {
                return Pair.of((Object)helper.build(!args.isEmpty() ? (RexNode)args.getFirst().getKey() : null, AggregationBuilders.cardinality((String)aggName)), (Object)new SingleValueParser(aggName));
            }
            default: {
                throw new AggregateAnalyzerException(String.format("unsupported distinct aggregator %s", aggCall.getAggregation()));
            }
        }
    }

    private static Pair<AggregationBuilder, MetricParser> createRegularAggregation(AggregateCall aggCall, List<Pair<RexNode, String>> args, String aggName, AggregateBuilderHelper helper) {
        return switch (aggCall.getAggregation().kind) {
            case SqlKind.AVG -> Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.avg((String)aggName)), (Object)new SingleValueParser(aggName));
            case SqlKind.SUM -> Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.sum((String)aggName)), (Object)new SingleValueParser(aggName));
            case SqlKind.COUNT -> Pair.of((Object)helper.build(!args.isEmpty() ? (RexNode)args.getFirst().getKey() : null, AggregationBuilders.count((String)aggName)), (Object)new SingleValueParser(aggName));
            case SqlKind.MIN -> {
                ExprType fieldType = OpenSearchTypeFactory.convertRelDataTypeToExprType((RelDataType)((RexNode)args.getFirst().getKey()).getType());
                if (AggregateAnalyzer.supportsMaxMinAggregation(fieldType)) {
                    yield Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.min((String)aggName)), (Object)new SingleValueParser(aggName));
                }
                yield Pair.of((Object)AggregationBuilders.topHits((String)aggName).fetchField(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery(), SortOrder.ASC), (Object)new TopHitsParser(aggName, true, false));
            }
            case SqlKind.MAX -> {
                ExprType fieldType = OpenSearchTypeFactory.convertRelDataTypeToExprType((RelDataType)((RexNode)args.getFirst().getKey()).getType());
                if (AggregateAnalyzer.supportsMaxMinAggregation(fieldType)) {
                    yield Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.max((String)aggName)), (Object)new SingleValueParser(aggName));
                }
                yield Pair.of((Object)AggregationBuilders.topHits((String)aggName).fetchField(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery(), SortOrder.DESC), (Object)new TopHitsParser(aggName, true, false));
            }
            case SqlKind.VAR_SAMP -> Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.extendedStats((String)aggName)), (Object)new StatsParser(ExtendedStats::getVarianceSampling, aggName));
            case SqlKind.VAR_POP -> Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.extendedStats((String)aggName)), (Object)new StatsParser(ExtendedStats::getVariancePopulation, aggName));
            case SqlKind.STDDEV_SAMP -> Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.extendedStats((String)aggName)), (Object)new StatsParser(ExtendedStats::getStdDeviationSampling, aggName));
            case SqlKind.STDDEV_POP -> Pair.of((Object)helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.extendedStats((String)aggName)), (Object)new StatsParser(ExtendedStats::getStdDeviationPopulation, aggName));
            case SqlKind.ARG_MAX -> Pair.of((Object)AggregationBuilders.topHits((String)aggName).fetchField(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField((RexNode)args.get(1).getKey()).getReferenceForTermQuery(), SortOrder.DESC), (Object)new ArgMaxMinParser(aggName));
            case SqlKind.ARG_MIN -> Pair.of((Object)AggregationBuilders.topHits((String)aggName).fetchField(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField((RexNode)args.get(1).getKey()).getReferenceForTermQuery(), SortOrder.ASC), (Object)new ArgMaxMinParser(aggName));
            case SqlKind.OTHER_FUNCTION -> {
                BuiltinFunctionName functionName = (BuiltinFunctionName)BuiltinFunctionName.ofAggregation((String)aggCall.getAggregation().getName()).get();
                switch (functionName) {
                    case TAKE: {
                        yield Pair.of((Object)AggregationBuilders.topHits((String)aggName).fetchField(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery()).size(helper.inferValue((RexNode)args.getLast().getKey(), Integer.class).intValue()).from(0), (Object)new TopHitsParser(aggName, false, true));
                    }
                    case FIRST: {
                        TopHitsAggregationBuilder firstBuilder = AggregationBuilders.topHits((String)aggName).size(1).from(0);
                        if (!args.isEmpty()) {
                            firstBuilder.fetchField(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery());
                        }
                        yield Pair.of((Object)firstBuilder, (Object)new TopHitsParser(aggName, true, false));
                    }
                    case LAST: {
                        TopHitsAggregationBuilder lastBuilder = AggregationBuilders.topHits((String)aggName).size(1).from(0).sort("_doc", SortOrder.DESC);
                        if (!args.isEmpty()) {
                            lastBuilder.fetchField(helper.inferNamedField((RexNode)args.getFirst().getKey()).getReferenceForTermQuery());
                        }
                        yield Pair.of((Object)lastBuilder, (Object)new TopHitsParser(aggName, true, false));
                    }
                    case PERCENTILE_APPROX: {
                        PercentilesAggregationBuilder aggBuilder = helper.build((RexNode)args.getFirst().getKey(), AggregationBuilders.percentiles((String)aggName)).percentiles(new double[]{helper.inferValue((RexNode)args.get(1).getKey(), Double.class)});
                        if (args.size() > 3) {
                            aggBuilder.compression(helper.inferValue((RexNode)args.getLast().getKey(), Double.class).doubleValue());
                        }
                        yield Pair.of((Object)aggBuilder, (Object)new SinglePercentileParser(aggName));
                    }
                    case DISTINCT_COUNT_APPROX: {
                        yield Pair.of((Object)helper.build(!args.isEmpty() ? (RexNode)args.getFirst().getKey() : null, AggregationBuilders.cardinality((String)aggName)), (Object)new SingleValueParser(aggName));
                    }
                }
                throw new AggregateAnalyzerException(String.format("Unsupported push-down aggregator %s", aggCall.getAggregation()));
            }
            case SqlKind.LITERAL_AGG -> {
                RexLiteral literal = PlanUtils.getObjectFromLiteralAgg((AggregateCall)aggCall);
                if (literal == null || !(literal.getValue() instanceof Number)) {
                    throw new AggregateAnalyzerException(String.format("Unsupported push-down aggregator %s", aggCall.getAggregation()));
                }
                Integer dedupNumber = (Integer)literal.getValueAs(Integer.class);
                TopHitsAggregationBuilder topHitsAggregationBuilder = AggregationBuilders.topHits((String)aggName).from(0).size(dedupNumber.intValue());
                ArrayList sources = new ArrayList();
                ArrayList scripts = new ArrayList();
                args.forEach(rex -> {
                    if (rex.getKey() instanceof RexInputRef) {
                        sources.add(helper.inferNamedField((RexNode)rex.getKey()).getReference());
                    } else if (rex.getKey() instanceof RexCall || rex.getKey() instanceof RexLiteral) {
                        scripts.add(new SearchSourceBuilder.ScriptField((String)rex.getValue(), helper.inferScript((RexNode)rex.getKey()).getScript(), false));
                    } else {
                        throw new AggregateAnalyzerException(String.format("Unsupported push-down aggregator %s due to rex type is %s", aggCall.getAggregation(), ((RexNode)rex.getKey()).getKind()));
                    }
                });
                topHitsAggregationBuilder.fetchSource((String[])sources.stream().distinct().toArray(String[]::new), new String[0]);
                topHitsAggregationBuilder.scriptFields(scripts);
                yield Pair.of((Object)topHitsAggregationBuilder, (Object)new TopHitsParser(aggName, false, false));
            }
            default -> throw new AggregateAnalyzerException(String.format("unsupported aggregator %s", aggCall.getAggregation()));
        };
    }

    private static boolean supportsMaxMinAggregation(ExprType fieldType) {
        ExprType coreType = fieldType instanceof OpenSearchDataType ? ((OpenSearchDataType)fieldType).getExprType() : fieldType;
        return ExprCoreType.numberTypes().contains(coreType) || coreType == ExprCoreType.DATE || coreType == ExprCoreType.TIME || coreType == ExprCoreType.TIMESTAMP;
    }

    private static List<CompositeValuesSourceBuilder<?>> createCompositeBuckets(List<Pair<String, Integer>> groupNameAndIndexList, @Nullable Project project, AggregateBuilderHelper helper) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        groupNameAndIndexList.forEach(nameAndIndex -> resultBuilder.add(AggregateAnalyzer.createCompositeBucket((String)nameAndIndex.getLeft(), (Integer)nameAndIndex.getRight(), project, helper)));
        return resultBuilder.build();
    }

    private static Pair<Set<Integer>, AggregationBuilder> createStructuredAggregation(List<Pair<String, Integer>> groupNameAndIndexList, @Nullable Project project, AggregatorFactories.Builder metricBuilder, AggregateBuilderHelper helper) {
        ValuesSourceAggregationBuilder<?> rootAggBuilder = null;
        ValuesSourceAggregationBuilder<?> tailAggBuilder = null;
        HashSet<Integer> aggPushed = new HashSet<Integer>();
        for (Pair<String, Integer> nameAndIndex : groupNameAndIndexList) {
            String name;
            RexNode agg = helper.inferRexNodeFromIndex((Integer)nameAndIndex.getRight(), project);
            ValuesSourceAggregationBuilder<?> aggBuilder = AggregateAnalyzer.createCompositeIncompatibleAggregation(agg, name = (String)nameAndIndex.getLeft(), helper);
            if (aggBuilder == null) continue;
            aggPushed.add((Integer)nameAndIndex.getRight());
            if (rootAggBuilder == null) {
                rootAggBuilder = aggBuilder;
            } else {
                tailAggBuilder.subAggregation(aggBuilder);
            }
            tailAggBuilder = aggBuilder;
        }
        if (tailAggBuilder != null && metricBuilder != null) {
            tailAggBuilder.subAggregations(metricBuilder);
        }
        return Pair.of(aggPushed, rootAggBuilder);
    }

    private static ValuesSourceAggregationBuilder<?> createCompositeIncompatibleAggregation(RexNode agg, String name, AggregateBuilderHelper helper) {
        Optional<RangeAggregationBuilder> rangeAggBuilder;
        AutoDateHistogramAggregationBuilder aggBuilder = null;
        if (AggregateAnalyzer.isAutoDateSpan(agg)) {
            aggBuilder = AggregateAnalyzer.analyzeAutoDateSpan(agg, name, helper);
        } else if (AggregateAnalyzer.isCase(agg) && (rangeAggBuilder = CaseRangeAnalyzer.create(name, helper.rowType).analyze((RexCall)agg)).isPresent()) {
            aggBuilder = (ValuesSourceAggregationBuilder)rangeAggBuilder.get();
        }
        return aggBuilder;
    }

    private static AutoDateHistogramAggregationBuilder analyzeAutoDateSpan(RexNode spanAgg, String name, AggregateBuilderHelper helper) {
        RexCall rexCall = (RexCall)spanAgg;
        RexInputRef rexInputRef = (RexInputRef)rexCall.getOperands().getFirst();
        RexLiteral valueLiteral = (RexLiteral)rexCall.getOperands().get(1);
        return ((AutoDateHistogramAggregationBuilder)new AutoDateHistogramAggregationBuilder(name).field(helper.inferNamedField((RexNode)rexInputRef).getRootName())).setNumBuckets(Objects.requireNonNull((Integer)valueLiteral.getValueAs(Integer.class)).intValue());
    }

    private static boolean isAutoDateSpan(RexNode rex) {
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().equals((Object)PPLBuiltinOperators.WIDTH_BUCKET);
    }

    private static boolean isCase(RexNode rex) {
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.CASE;
    }

    private static CompositeValuesSourceBuilder<?> createCompositeBucket(String bucketName, Integer groupIndex, @Nullable Project project, AggregateBuilderHelper helper) {
        Object e;
        RexCall rexCall;
        RexNode rex = helper.inferRexNodeFromIndex(groupIndex, project);
        if (rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().getName().equalsIgnoreCase(BuiltinFunctionName.SPAN.name()) && rexCall.getOperands().size() == 3 && (e = rexCall.getOperands().getFirst()) instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)e;
            e = rexCall.getOperands().get(1);
            if (e instanceof RexLiteral) {
                RexLiteral valueLiteral = (RexLiteral)e;
                e = rexCall.getOperands().get(2);
                if (e instanceof RexLiteral) {
                    RexLiteral unitLiteral = (RexLiteral)e;
                    return CompositeAggregationBuilder.buildHistogram(bucketName, helper.inferNamedField((RexNode)rexInputRef).getRootName(), (Double)valueLiteral.getValueAs(Double.class), SpanUnit.of((String)((String)unitLiteral.getValueAs(String.class))), MissingOrder.FIRST, helper.bucketNullable);
                }
            }
        }
        return AggregateAnalyzer.createTermsSourceBuilder(bucketName, rex, helper);
    }

    private static CompositeValuesSourceBuilder<?> createTermsSourceBuilder(String bucketName, RexNode group, AggregateBuilderHelper helper) {
        TermsValuesSourceBuilder termsBuilder = (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(bucketName).order(SortOrder.ASC);
        if (helper.bucketNullable) {
            ((TermsValuesSourceBuilder)termsBuilder.missingBucket(true)).missingOrder(MissingOrder.FIRST);
        }
        TermsValuesSourceBuilder sourceBuilder = helper.build(group, termsBuilder);
        return AggregateAnalyzer.withValueTypeHint(sourceBuilder, arg_0 -> ((CompositeValuesSourceBuilder)sourceBuilder).userValuetypeHint(arg_0), group.getType(), group instanceof RexInputRef);
    }

    private static ValuesSourceAggregationBuilder<?> createTermsAggregationBuilder(String bucketName, RexNode group, AggregateBuilderHelper helper) {
        TermsAggregationBuilder sourceBuilder = helper.build(group, new TermsAggregationBuilder(bucketName).size(helper.queryBucketSize).order(BucketOrder.key((boolean)true)));
        return (ValuesSourceAggregationBuilder)AggregateAnalyzer.withValueTypeHint(sourceBuilder, arg_0 -> ((TermsAggregationBuilder)sourceBuilder).userValueTypeHint(arg_0), group.getType(), group instanceof RexInputRef);
    }

    private static <T> T withValueTypeHint(T sourceBuilder, Function<ValueType, T> withValueTypeHint, RelDataType groupType, boolean isSourceField) {
        ExprType exprType = OpenSearchTypeFactory.convertRelDataTypeToExprType((RelDataType)groupType);
        if (List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(exprType)) {
            return withValueTypeHint.apply(ValueType.LONG);
        }
        if (isSourceField) {
            return sourceBuilder;
        }
        ValueType valueType = ValueType.lenientParse((String)exprType.typeName().toLowerCase());
        return valueType == null || valueType == ValueType.STRING ? sourceBuilder : withValueTypeHint.apply(valueType);
    }

    public static class AggregateBuilderHelper {
        final RelDataType rowType;
        final Map<String, ExprType> fieldTypes;
        final RelOptCluster cluster;
        final boolean bucketNullable;
        final int queryBucketSize;

        <T extends ValuesSourceAggregationBuilder<T>> T build(RexNode node, T aggBuilder) {
            return (T)this.build(node, arg_0 -> aggBuilder.field(arg_0), arg_0 -> aggBuilder.script(arg_0));
        }

        <T extends CompositeValuesSourceBuilder<T>> T build(RexNode node, T sourceBuilder) {
            return (T)this.build(node, arg_0 -> sourceBuilder.field(arg_0), arg_0 -> sourceBuilder.script(arg_0));
        }

        <T> T build(RexNode node, Function<String, T> fieldBuilder, Function<Script, T> scriptBuilder) {
            if (node == null) {
                return fieldBuilder.apply(AggregateAnalyzer.METADATA_FIELD);
            }
            if (node instanceof RexInputRef) {
                RexInputRef ref = (RexInputRef)node;
                return fieldBuilder.apply(this.inferNamedField(node).getReferenceForTermQuery());
            }
            if (node instanceof RexCall || node instanceof RexLiteral) {
                return scriptBuilder.apply(this.inferScript(node).getScript());
            }
            throw new IllegalStateException(String.format("Metric aggregation doesn't support RexNode %s", node));
        }

        PredicateAnalyzer.NamedFieldExpression inferNamedField(RexNode node) {
            if (node instanceof RexInputRef) {
                RexInputRef ref = (RexInputRef)node;
                return new PredicateAnalyzer.NamedFieldExpression(ref.getIndex(), (List<String>)this.rowType.getFieldNames(), this.fieldTypes);
            }
            throw new IllegalStateException(String.format("Cannot infer field name from RexNode %s", node));
        }

        PredicateAnalyzer.ScriptQueryExpression inferScript(RexNode node) {
            if (node instanceof RexCall || node instanceof RexLiteral) {
                return new PredicateAnalyzer.ScriptQueryExpression(node, this.rowType, this.fieldTypes, this.cluster, Collections.emptyMap());
            }
            throw new IllegalStateException(String.format("Metric aggregation doesn't support RexNode %s", node));
        }

        <T> T inferValue(RexNode node, Class<T> clazz) {
            if (node instanceof RexLiteral) {
                RexLiteral literal = (RexLiteral)node;
                return (T)literal.getValueAs(clazz);
            }
            throw new IllegalStateException(String.format("Cannot infer value from RexNode %s", node));
        }

        RexNode inferRexNodeFromIndex(int index, Project project) {
            return project == null ? RexInputRef.of((int)index, (RelDataType)this.rowType) : (RexNode)project.getProjects().get(index);
        }

        String inferFieldNameFromIndex(int index, Project project) {
            return project == null ? (String)this.rowType.getFieldNames().get(index) : (String)project.getRowType().getFieldNames().get(index);
        }

        @Generated
        public AggregateBuilderHelper(RelDataType rowType, Map<String, ExprType> fieldTypes, RelOptCluster cluster, boolean bucketNullable, int queryBucketSize) {
            this.rowType = rowType;
            this.fieldTypes = fieldTypes;
            this.cluster = cluster;
            this.bucketNullable = bucketNullable;
            this.queryBucketSize = queryBucketSize;
        }
    }

    public static class ExpressionNotAnalyzableException
    extends Exception {
        ExpressionNotAnalyzableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class AggregateAnalyzerException
    extends RuntimeException {
        AggregateAnalyzerException(String message) {
            super(message);
        }

        AggregateAnalyzerException(Throwable cause) {
            super(cause);
        }
    }
}

