/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableIntersectReorderRule;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class IntersectReorderRule
extends RelRule<Config>
implements SubstitutionRule {
    protected IntersectReorderRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        List<RelNode> inputs = intersect.getInputs();
        List sortedInputs = inputs.stream().sorted(Comparator.comparingDouble(mq::getRowCount)).collect(Collectors.toList());
        if (inputs.equals(sortedInputs)) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.pushAll(sortedInputs);
        relBuilder.intersect(intersect.all, sortedInputs.size());
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIntersectReorderRule.Config.of().withOperandSupplier(b0 -> b0.operand(LogicalIntersect.class).predicate(intersect -> intersect.getInputs().size() > 1).anyInputs()).withDescription("IntersectReorderRule");

        @Override
        default public IntersectReorderRule toRule() {
            return new IntersectReorderRule(this);
        }
    }
}

