use strict;
use warnings;

use UV ();

use Test::More;

# are all of the constants exportable as we expect?
can_ok('UV', (
    qw(UV_VERSION_MAJOR UV_VERSION_MINOR UV_VERSION_PATCH),
    qw(UV_VERSION_IS_RELEASE UV_VERSION_SUFFIX UV_VERSION_HEX),
    qw(UV_E2BIG UV_EACCES UV_EADDRINUSE UV_EADDRNOTAVAIL UV_EAFNOSUPPORT),
    qw(UV_EAGAIN UV_EAI_ADDRFAMILY UV_EAI_AGAIN UV_EAI_BADFLAGS UV_EAI_BADHINTS),
    qw(UV_EAI_CANCELED UV_EAI_FAIL UV_EAI_FAMILY UV_EAI_MEMORY UV_EAI_NODATA),
    qw(UV_EAI_NONAME UV_EAI_OVERFLOW UV_EAI_PROTOCOL UV_EAI_SERVICE ),
    qw(UV_EAI_SOCKTYPE UV_EALREADY UV_EBADF UV_EBUSY UV_ECANCELED UV_ECHARSET),
    qw(UV_ECONNABORTED UV_ECONNREFUSED UV_ECONNRESET UV_EDESTADDRREQ UV_EEXIST),
    qw(UV_EFAULT UV_EFBIG UV_EHOSTUNREACH UV_EINTR UV_EINVAL UV_EIO UV_EISCONN),
    qw(UV_EISDIR UV_ELOOP UV_EMFILE UV_EMSGSIZE UV_ENAMETOOLONG UV_ENETDOWN),
    qw(UV_ENETUNREACH UV_ENFILE UV_ENOBUFS UV_ENODEV UV_ENOENT UV_ENOMEM),
    qw(UV_ENONET UV_ENOPROTOOPT UV_ENOSPC UV_ENOSYS UV_ENOTCONN UV_ENOTDIR),
    qw(UV_ENOTEMPTY UV_ENOTSOCK UV_ENOTSUP UV_EPERM UV_EPIPE UV_EPROTO),
    qw(UV_EPROTONOSUPPORT UV_EPROTOTYPE UV_ERANGE UV_EROFS UV_ESHUTDOWN UV_ESPIPE),
    qw(UV_ESRCH UV_ETIMEDOUT UV_ETXTBSY UV_EXDEV UV_UNKNOWN UV_EOF UV_ENXIO UV_EMLINK),
));

# are all of the functions exportable as we expect?
can_ok('UV', (
    qw(default_loop check idle loop poll prepare timer),
    qw(err_name hrtime strerror version version_string),
));

done_testing;
