#!/usr/bin/perl

## a stripped version of redhat's /usr/lib/rpm/cpanflute
## vang@auctionwatch.ro
## custommized for mtop
#
# $Id: cpan2spec.pl,v 1.2 2002/07/06 19:40:22 mdprewitt Exp $
#

my $name="Marc Prewitt";
my $email='mprewitt@chelsea.net';

use File::Basename;

my $InputFile = $ARGV[0];

my $tarball = basename($InputFile);
$tarball =~ /(\S+)\-(\S+)\.tar\.gz/;
my $clm_name=$1;
my $clm_version=$2;

my $class = dirname($InputFile);
$class =~ s/^\.\/[0-9][0-9]_//;
if ($class ne '.') {
  $class = "($class)";
} else {
  $class = "";
}

# Change ::'s to -'s
$clm_name =~ s/::/-/g;

my $clm_changelog = get_changelog();

# complain if either parameter is missing
($clm_name eq "") && die "Module name not specified\n";
($clm_version eq "") && die "Module version not specified\n";

# Create and Open file to create SPEC files.
my $filename = $clm_name . '.spec'; 
open (FILE, "> $filename");

# Print the spec file. Lots of substitutions here.
print FILE "Summary: $clm_name for mysql $class
Name: perl-$clm_name
Version: $clm_version
Release: 1
Copyright: GPL
Group: Applications/CPAN
Source0: $clm_name-$clm_version.tar.gz
Url: http://mtop.sourceforge.net/
BuildRoot: /var/tmp/perl-$clm_name-buildroot/
#BuildRequires: perl >= 5.00503
#Requires: perl >= 5.00503

%description
mtop (MySQL top) monitors a MySQL database showing the queries which are taking the most amount of time to complete. Features include 'zooming' in on a
process to show the complete query, 'explaining' the query optimizer information for a query and 'killing' queries. In addition, server performance statistics,
configuration information, and tuning tips are provided. 

# Provide perl-specific find-{provides,requires}.
#%define __find_provides /usr/lib/rpm/find-provides.perl
#%define __find_requires /usr/lib/rpm/find-requires.perl

%prep
%setup -q -n $clm_name-%{version} $create

%build
CFLAGS=\"\$RPM_OPT_FLAGS\" perl Makefile.PL
make
make test

%clean 
rm -rf \$RPM_BUILD_ROOT

%install
rm -rf \$RPM_BUILD_ROOT
eval `perl '-V:installarchlib'`
mkdir -p \$RPM_BUILD_ROOT/\$installarchlib
make PREFIX=\$RPM_BUILD_ROOT/usr install

[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress

find \$RPM_BUILD_ROOT/usr -type f -print | \
	sed \"s\@^\$RPM_BUILD_ROOT\@\@g\" | \
	grep -v perllocal.pod | \
	grep -v \"\\.packlist\" > $clm_name-$clm_version-filelist
if [ \"\$(cat $clm_name-$clm_version-filelist)X\" = \"X\" ] ; then
    echo \"ERROR: EMPTY FILE LIST\"
    exit -1
fi

%files -f $clm_name-$clm_version-filelist
%defattr(-,root,root)

%changelog
* $clm_changelog
- Spec file was autogenerated. 
";
close(FILE);


sub get_changelog {
  return ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat")[(localtime)[6]] . " " .
    ("Jan", "Feb", "Mar", "Apr", "May", "Jun",
     "Jul", "Aug", "Sep", "Oct", "Nov", "Dec")[(localtime)[4]] . " " .
    (localtime)[3] . " " . (1900+(localtime)[5]) . " " .
		$name . " <" . $email . ">";
}
