/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBType;
import adql.db.region.Region;
import adql.parser.feature.FeatureSet;
import adql.parser.grammar.ParseException;
import adql.query.IdentifierField;
import adql.query.operand.StringConstant;
import adql.query.operand.function.InUnitFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.translator.JDBCTranslator;
import adql.translator.TranslationException;

public class PostgreSQLTranslator
extends JDBCTranslator {
    protected byte caseSensitivity = 0;
    protected final FeatureSet supportedFeatures = new FeatureSet();

    public PostgreSQLTranslator() {
        this.caseSensitivity = (byte)15;
        this.initSupportedFeatures();
    }

    public PostgreSQLTranslator(boolean allCaseSensitive) {
        this.caseSensitivity = (byte)(allCaseSensitive ? 15 : 0);
        this.initSupportedFeatures();
    }

    public PostgreSQLTranslator(boolean catalog, boolean schema, boolean table, boolean column) {
        this.caseSensitivity = IdentifierField.CATALOG.setCaseSensitive(this.caseSensitivity, catalog);
        this.caseSensitivity = IdentifierField.SCHEMA.setCaseSensitive(this.caseSensitivity, schema);
        this.caseSensitivity = IdentifierField.TABLE.setCaseSensitive(this.caseSensitivity, table);
        this.caseSensitivity = IdentifierField.COLUMN.setCaseSensitive(this.caseSensitivity, column);
        this.initSupportedFeatures();
    }

    protected void initSupportedFeatures() {
        this.supportedFeatures.supportAll();
        this.supportedFeatures.unsupportAll("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo");
        this.supportedFeatures.unsupport(InUnitFunction.FEATURE);
    }

    @Override
    public final FeatureSet getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean isCaseSensitive(IdentifierField field) {
        return field == null ? false : field.isCaseSensitive(this.caseSensitivity);
    }

    @Override
    public String translate(StringConstant strConst) throws TranslationException {
        if (strConst.getValue() != null && strConst.getValue().contains("\\")) {
            return "E'" + strConst.getValue() + "'";
        }
        return super.translate(strConst);
    }

    @Override
    public String translate(MathFunction fct) throws TranslationException {
        switch (fct.getType()) {
            case LOG: {
                return "ln(" + (fct.getNbParameters() >= 1 ? "CAST(" + this.translate(fct.getParameter(0)) + " AS numeric)" : "") + ")";
            }
            case LOG10: {
                return "log(10, " + (fct.getNbParameters() >= 1 ? "CAST(" + this.translate(fct.getParameter(0)) + " AS numeric)" : "") + ")";
            }
            case RAND: {
                return "random()";
            }
            case TRUNCATE: {
                if (fct.getNbParameters() >= 2) {
                    return "trunc(CAST(" + this.translate(fct.getParameter(0)) + " AS numeric), " + this.translate(fct.getParameter(1)) + ")";
                }
                return "trunc(CAST(" + this.translate(fct.getParameter(0)) + " AS numeric))";
            }
            case ROUND: {
                if (fct.getNbParameters() >= 2) {
                    return "round(CAST(" + this.translate(fct.getParameter(0)) + " AS numeric), " + this.translate(fct.getParameter(1)) + ")";
                }
                return "round(CAST(" + this.translate(fct.getParameter(0)) + " AS numeric))";
            }
            case PI: {
                return this.getDefaultADQLFunction(fct);
            }
        }
        String sql = fct.getName() + "(";
        for (int i = 0; i < fct.getNbParameters(); ++i) {
            sql = sql + (i == 0 ? "" : ", ") + "CAST(" + this.translate(fct.getParameter(i)) + " AS numeric)";
        }
        return sql + ")";
    }

    @Override
    public String translate(InUnitFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(ExtractCoord extractCoord) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoord);
    }

    @Override
    public String translate(ExtractCoordSys extractCoordSys) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoordSys);
    }

    @Override
    public String translate(AreaFunction areaFunction) throws TranslationException {
        return this.getDefaultADQLFunction(areaFunction);
    }

    @Override
    public String translate(CentroidFunction centroidFunction) throws TranslationException {
        return this.getDefaultADQLFunction(centroidFunction);
    }

    @Override
    public String translate(DistanceFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(ContainsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(IntersectsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(BoxFunction box) throws TranslationException {
        return this.getDefaultADQLFunction(box);
    }

    @Override
    public String translate(CircleFunction circle) throws TranslationException {
        return this.getDefaultADQLFunction(circle);
    }

    @Override
    public String translate(PointFunction point) throws TranslationException {
        return this.getDefaultADQLFunction(point);
    }

    @Override
    public String translate(PolygonFunction polygon) throws TranslationException {
        return this.getDefaultADQLFunction(polygon);
    }

    @Override
    public DBType convertTypeFromDB(int dbmsType, String rawDbmsTypeName, String dbmsTypeName, String[] params) {
        if (dbmsTypeName == null || dbmsTypeName.trim().length() == 0) {
            return null;
        }
        dbmsTypeName = dbmsTypeName.toLowerCase();
        int lengthParam = -1;
        if (params != null && params.length > 0) {
            try {
                lengthParam = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (dbmsTypeName.equals("smallint") || dbmsTypeName.equals("int2") || dbmsTypeName.equals("smallserial") || dbmsTypeName.equals("serial2") || dbmsTypeName.equals("boolean") || dbmsTypeName.equals("bool")) {
            return new DBType(DBType.DBDatatype.SMALLINT);
        }
        if (dbmsTypeName.equals("integer") || dbmsTypeName.equals("int") || dbmsTypeName.equals("int4") || dbmsTypeName.equals("serial") || dbmsTypeName.equals("serial4")) {
            return new DBType(DBType.DBDatatype.INTEGER);
        }
        if (dbmsTypeName.equals("bigint") || dbmsTypeName.equals("int8") || dbmsTypeName.equals("bigserial") || dbmsTypeName.equals("bigserial8")) {
            return new DBType(DBType.DBDatatype.BIGINT);
        }
        if (dbmsTypeName.equals("real") || dbmsTypeName.equals("float4")) {
            return new DBType(DBType.DBDatatype.REAL);
        }
        if (dbmsTypeName.equals("double precision") || dbmsTypeName.equals("float8") || dbmsTypeName.equals("numeric")) {
            return new DBType(DBType.DBDatatype.DOUBLE);
        }
        if (dbmsTypeName.equals("bit")) {
            return new DBType(DBType.DBDatatype.BINARY, lengthParam);
        }
        if (dbmsTypeName.equals("bit varying") || dbmsTypeName.equals("varbit")) {
            return new DBType(DBType.DBDatatype.VARBINARY, lengthParam);
        }
        if (dbmsTypeName.equals("char") || dbmsTypeName.equals("character")) {
            return new DBType(DBType.DBDatatype.CHAR, lengthParam);
        }
        if (dbmsTypeName.equals("varchar") || dbmsTypeName.equals("character varying")) {
            return new DBType(DBType.DBDatatype.VARCHAR, lengthParam);
        }
        if (dbmsTypeName.equals("bytea")) {
            return new DBType(DBType.DBDatatype.BLOB);
        }
        if (dbmsTypeName.equals("text")) {
            return new DBType(DBType.DBDatatype.CLOB);
        }
        if (dbmsTypeName.equals("timestamp") || dbmsTypeName.equals("timestamptz") || dbmsTypeName.equals("time") || dbmsTypeName.equals("timetz") || dbmsTypeName.equals("date")) {
            return new DBType(DBType.DBDatatype.TIMESTAMP);
        }
        return null;
    }

    @Override
    public String convertTypeToDB(DBType type) {
        if (type == null) {
            return "VARCHAR";
        }
        switch (type.type) {
            case SMALLINT: 
            case INTEGER: 
            case REAL: 
            case BIGINT: 
            case CHAR: 
            case VARCHAR: 
            case TIMESTAMP: {
                return type.type.toString();
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case BINARY: 
            case VARBINARY: {
                return "bytea";
            }
            case BLOB: {
                return "bytea";
            }
            case CLOB: {
                return "TEXT";
            }
        }
        return "VARCHAR";
    }

    @Override
    public Region translateGeometryFromDB(Object jdbcColValue) throws ParseException {
        throw new ParseException("Unsupported geometrical value! The value \"" + jdbcColValue + "\" can not be parsed as a region.");
    }

    @Override
    public Object translateGeometryToDB(Region region) throws ParseException {
        throw new ParseException("Geometries can not be uploaded in the database in this implementation!");
    }
}

