# This file contains the weighted network of coappearances of characters in
# Victor Hugo's novel "Les Miserables". Nodes represent characters as indicated
# by the labels, and edges connect any pair of characters that appear in the
# same chapter of the book. The values on the edges are the number of such
# coappearances. The data on coappearances were taken from D. E. Knuth, The
# Stanford GraphBase: A Platform for Combinatorial Computing, Addison-Wesley,
# Reading, MA (1993).
#
# The group labels were transcribed from "Finding and evaluating community
# structure in networks" by M. E. J. Newman and M. Girvan.

$miserables = OpenStruct.new({
  :nodes=>[
    OpenStruct.new({:node_value=>"Myriel", :group=>1}),
    OpenStruct.new({:node_value=>"Napoleon", :group=>1}),
    OpenStruct.new({:node_value=>"Mlle. Baptistine", :group=>1}),
    OpenStruct.new({:node_value=>"Mme. Magloire", :group=>1}),
    OpenStruct.new({:node_value=>"Countess de Lo", :group=>1}),
    OpenStruct.new({:node_value=>"Geborand", :group=>1}),
    OpenStruct.new({:node_value=>"Champtercier", :group=>1}),
    OpenStruct.new({:node_value=>"Cravatte", :group=>1}),
    OpenStruct.new({:node_value=>"Count", :group=>1}),
    OpenStruct.new({:node_value=>"Old Man", :group=>1}),
    OpenStruct.new({:node_value=>"Labarre", :group=>2}),
    OpenStruct.new({:node_value=>"Valjean", :group=>2}),
    OpenStruct.new({:node_value=>"Marguerite", :group=>3}),
    OpenStruct.new({:node_value=>"Mme. de R", :group=>2}),
    OpenStruct.new({:node_value=>"Isabeau", :group=>2}),
    OpenStruct.new({:node_value=>"Gervais", :group=>2}),
    OpenStruct.new({:node_value=>"Tholomyes", :group=>3}),
    OpenStruct.new({:node_value=>"Listolier", :group=>3}),
    OpenStruct.new({:node_value=>"Fameuil", :group=>3}),
    OpenStruct.new({:node_value=>"Blacheville", :group=>3}),
    OpenStruct.new({:node_value=>"Favourite", :group=>3}),
    OpenStruct.new({:node_value=>"Dahlia", :group=>3}),
    OpenStruct.new({:node_value=>"Zephine", :group=>3}),
    OpenStruct.new({:node_value=>"Fantine", :group=>3}),
    OpenStruct.new({:node_value=>"Mme. Thenardier", :group=>4}),
    OpenStruct.new({:node_value=>"Thenardier", :group=>4}),
    OpenStruct.new({:node_value=>"Cosette", :group=>5}),
    OpenStruct.new({:node_value=>"Javert", :group=>4}),
    OpenStruct.new({:node_value=>"Fauchelevent", :group=>0}),
    OpenStruct.new({:node_value=>"Bamatabois", :group=>2}),
    OpenStruct.new({:node_value=>"Perpetue", :group=>3}),
    OpenStruct.new({:node_value=>"Simplice", :group=>2}),
    OpenStruct.new({:node_value=>"Scaufflaire", :group=>2}),
    OpenStruct.new({:node_value=>"Woman 1", :group=>2}),
    OpenStruct.new({:node_value=>"Judge", :group=>2}),
    OpenStruct.new({:node_value=>"Champmathieu", :group=>2}),
    OpenStruct.new({:node_value=>"Brevet", :group=>2}),
    OpenStruct.new({:node_value=>"Chenildieu", :group=>2}),
    OpenStruct.new({:node_value=>"Cochepaille", :group=>2}),
    OpenStruct.new({:node_value=>"Pontmercy", :group=>4}),
    OpenStruct.new({:node_value=>"Boulatruelle", :group=>6}),
    OpenStruct.new({:node_value=>"Eponine", :group=>4}),
    OpenStruct.new({:node_value=>"Anzelma", :group=>4}),
    OpenStruct.new({:node_value=>"Woman 2", :group=>5}),
    OpenStruct.new({:node_value=>"Mother Innocent", :group=>0}),
    OpenStruct.new({:node_value=>"Gribier", :group=>0}),
    OpenStruct.new({:node_value=>"Jondrette", :group=>7}),
    OpenStruct.new({:node_value=>"Mme. Burgon", :group=>7}),
    OpenStruct.new({:node_value=>"Gavroche", :group=>8}),
    OpenStruct.new({:node_value=>"Gillenormand", :group=>5}),
    OpenStruct.new({:node_value=>"Magnon", :group=>5}),
    OpenStruct.new({:node_value=>"Mlle. Gillenormand", :group=>5}),
    OpenStruct.new({:node_value=>"Mme. Pontmercy", :group=>5}),
    OpenStruct.new({:node_value=>"Mlle. Vaubois", :group=>5}),
    OpenStruct.new({:node_value=>"Lt. Gillenormand", :group=>5}),
    OpenStruct.new({:node_value=>"Marius", :group=>8}),
    OpenStruct.new({:node_value=>"Baroness T", :group=>5}),
    OpenStruct.new({:node_value=>"Mabeuf", :group=>8}),
    OpenStruct.new({:node_value=>"Enjolras", :group=>8}),
    OpenStruct.new({:node_value=>"Combeferre", :group=>8}),
    OpenStruct.new({:node_value=>"Prouvaire", :group=>8}),
    OpenStruct.new({:node_value=>"Feuilly", :group=>8}),
    OpenStruct.new({:node_value=>"Courfeyrac", :group=>8}),
    OpenStruct.new({:node_value=>"Bahorel", :group=>8}),
    OpenStruct.new({:node_value=>"Bossuet", :group=>8}),
    OpenStruct.new({:node_value=>"Joly", :group=>8}),
    OpenStruct.new({:node_value=>"Grantaire", :group=>8}),
    OpenStruct.new({:node_value=>"Mother Plutarch", :group=>9}),
    OpenStruct.new({:node_value=>"Gueulemer", :group=>4}),
    OpenStruct.new({:node_value=>"Babet", :group=>4}),
    OpenStruct.new({:node_value=>"Claquesous", :group=>4}),
    OpenStruct.new({:node_value=>"Montparnasse", :group=>4}),
    OpenStruct.new({:node_value=>"Toussaint", :group=>5}),
    OpenStruct.new({:node_value=>"Child 1", :group=>10}),
    OpenStruct.new({:node_value=>"Child 2", :group=>10}),
    OpenStruct.new({:node_value=>"Brujon", :group=>4}),
    OpenStruct.new({:node_value=>"Mme. Hucheloup", :group=>8})
  ],
  :links=>[
    OpenStruct.new({:source=>1, :target=>0, :value=>1}),
    OpenStruct.new({:source=>2, :target=>0, :value=>8}),
    OpenStruct.new({:source=>3, :target=>0, :value=>10}),
    OpenStruct.new({:source=>3, :target=>2, :value=>6}),
    OpenStruct.new({:source=>4, :target=>0, :value=>1}),
    OpenStruct.new({:source=>5, :target=>0, :value=>1}),
    OpenStruct.new({:source=>6, :target=>0, :value=>1}),
    OpenStruct.new({:source=>7, :target=>0, :value=>1}),
    OpenStruct.new({:source=>8, :target=>0, :value=>2}),
    OpenStruct.new({:source=>9, :target=>0, :value=>1}),
    OpenStruct.new({:source=>11, :target=>10, :value=>1}),
    OpenStruct.new({:source=>11, :target=>3, :value=>3}),
    OpenStruct.new({:source=>11, :target=>2, :value=>3}),
    OpenStruct.new({:source=>11, :target=>0, :value=>5}),
    OpenStruct.new({:source=>12, :target=>11, :value=>1}),
    OpenStruct.new({:source=>13, :target=>11, :value=>1}),
    OpenStruct.new({:source=>14, :target=>11, :value=>1}),
    OpenStruct.new({:source=>15, :target=>11, :value=>1}),
    OpenStruct.new({:source=>17, :target=>16, :value=>4}),
    OpenStruct.new({:source=>18, :target=>16, :value=>4}),
    OpenStruct.new({:source=>18, :target=>17, :value=>4}),
    OpenStruct.new({:source=>19, :target=>16, :value=>4}),
    OpenStruct.new({:source=>19, :target=>17, :value=>4}),
    OpenStruct.new({:source=>19, :target=>18, :value=>4}),
    OpenStruct.new({:source=>20, :target=>16, :value=>3}),
    OpenStruct.new({:source=>20, :target=>17, :value=>3}),
    OpenStruct.new({:source=>20, :target=>18, :value=>3}),
    OpenStruct.new({:source=>20, :target=>19, :value=>4}),
    OpenStruct.new({:source=>21, :target=>16, :value=>3}),
    OpenStruct.new({:source=>21, :target=>17, :value=>3}),
    OpenStruct.new({:source=>21, :target=>18, :value=>3}),
    OpenStruct.new({:source=>21, :target=>19, :value=>3}),
    OpenStruct.new({:source=>21, :target=>20, :value=>5}),
    OpenStruct.new({:source=>22, :target=>16, :value=>3}),
    OpenStruct.new({:source=>22, :target=>17, :value=>3}),
    OpenStruct.new({:source=>22, :target=>18, :value=>3}),
    OpenStruct.new({:source=>22, :target=>19, :value=>3}),
    OpenStruct.new({:source=>22, :target=>20, :value=>4}),
    OpenStruct.new({:source=>22, :target=>21, :value=>4}),
    OpenStruct.new({:source=>23, :target=>16, :value=>3}),
    OpenStruct.new({:source=>23, :target=>17, :value=>3}),
    OpenStruct.new({:source=>23, :target=>18, :value=>3}),
    OpenStruct.new({:source=>23, :target=>19, :value=>3}),
    OpenStruct.new({:source=>23, :target=>20, :value=>4}),
    OpenStruct.new({:source=>23, :target=>21, :value=>4}),
    OpenStruct.new({:source=>23, :target=>22, :value=>4}),
    OpenStruct.new({:source=>23, :target=>12, :value=>2}),
    OpenStruct.new({:source=>23, :target=>11, :value=>9}),
    OpenStruct.new({:source=>24, :target=>23, :value=>2}),
    OpenStruct.new({:source=>24, :target=>11, :value=>7}),
    OpenStruct.new({:source=>25, :target=>24, :value=>13}),
    OpenStruct.new({:source=>25, :target=>23, :value=>1}),
    OpenStruct.new({:source=>25, :target=>11, :value=>12}),
    OpenStruct.new({:source=>26, :target=>24, :value=>4}),
    OpenStruct.new({:source=>26, :target=>11, :value=>31}),
    OpenStruct.new({:source=>26, :target=>16, :value=>1}),
    OpenStruct.new({:source=>26, :target=>25, :value=>1}),
    OpenStruct.new({:source=>27, :target=>11, :value=>17}),
    OpenStruct.new({:source=>27, :target=>23, :value=>5}),
    OpenStruct.new({:source=>27, :target=>25, :value=>5}),
    OpenStruct.new({:source=>27, :target=>24, :value=>1}),
    OpenStruct.new({:source=>27, :target=>26, :value=>1}),
    OpenStruct.new({:source=>28, :target=>11, :value=>8}),
    OpenStruct.new({:source=>28, :target=>27, :value=>1}),
    OpenStruct.new({:source=>29, :target=>23, :value=>1}),
    OpenStruct.new({:source=>29, :target=>27, :value=>1}),
    OpenStruct.new({:source=>29, :target=>11, :value=>2}),
    OpenStruct.new({:source=>30, :target=>23, :value=>1}),
    OpenStruct.new({:source=>31, :target=>30, :value=>2}),
    OpenStruct.new({:source=>31, :target=>11, :value=>3}),
    OpenStruct.new({:source=>31, :target=>23, :value=>2}),
    OpenStruct.new({:source=>31, :target=>27, :value=>1}),
    OpenStruct.new({:source=>32, :target=>11, :value=>1}),
    OpenStruct.new({:source=>33, :target=>11, :value=>2}),
    OpenStruct.new({:source=>33, :target=>27, :value=>1}),
    OpenStruct.new({:source=>34, :target=>11, :value=>3}),
    OpenStruct.new({:source=>34, :target=>29, :value=>2}),
    OpenStruct.new({:source=>35, :target=>11, :value=>3}),
    OpenStruct.new({:source=>35, :target=>34, :value=>3}),
    OpenStruct.new({:source=>35, :target=>29, :value=>2}),
    OpenStruct.new({:source=>36, :target=>34, :value=>2}),
    OpenStruct.new({:source=>36, :target=>35, :value=>2}),
    OpenStruct.new({:source=>36, :target=>11, :value=>2}),
    OpenStruct.new({:source=>36, :target=>29, :value=>1}),
    OpenStruct.new({:source=>37, :target=>34, :value=>2}),
    OpenStruct.new({:source=>37, :target=>35, :value=>2}),
    OpenStruct.new({:source=>37, :target=>36, :value=>2}),
    OpenStruct.new({:source=>37, :target=>11, :value=>2}),
    OpenStruct.new({:source=>37, :target=>29, :value=>1}),
    OpenStruct.new({:source=>38, :target=>34, :value=>2}),
    OpenStruct.new({:source=>38, :target=>35, :value=>2}),
    OpenStruct.new({:source=>38, :target=>36, :value=>2}),
    OpenStruct.new({:source=>38, :target=>37, :value=>2}),
    OpenStruct.new({:source=>38, :target=>11, :value=>2}),
    OpenStruct.new({:source=>38, :target=>29, :value=>1}),
    OpenStruct.new({:source=>39, :target=>25, :value=>1}),
    OpenStruct.new({:source=>40, :target=>25, :value=>1}),
    OpenStruct.new({:source=>41, :target=>24, :value=>2}),
    OpenStruct.new({:source=>41, :target=>25, :value=>3}),
    OpenStruct.new({:source=>42, :target=>41, :value=>2}),
    OpenStruct.new({:source=>42, :target=>25, :value=>2}),
    OpenStruct.new({:source=>42, :target=>24, :value=>1}),
    OpenStruct.new({:source=>43, :target=>11, :value=>3}),
    OpenStruct.new({:source=>43, :target=>26, :value=>1}),
    OpenStruct.new({:source=>43, :target=>27, :value=>1}),
    OpenStruct.new({:source=>44, :target=>28, :value=>3}),
    OpenStruct.new({:source=>44, :target=>11, :value=>1}),
    OpenStruct.new({:source=>45, :target=>28, :value=>2}),
    OpenStruct.new({:source=>47, :target=>46, :value=>1}),
    OpenStruct.new({:source=>48, :target=>47, :value=>2}),
    OpenStruct.new({:source=>48, :target=>25, :value=>1}),
    OpenStruct.new({:source=>48, :target=>27, :value=>1}),
    OpenStruct.new({:source=>48, :target=>11, :value=>1}),
    OpenStruct.new({:source=>49, :target=>26, :value=>3}),
    OpenStruct.new({:source=>49, :target=>11, :value=>2}),
    OpenStruct.new({:source=>50, :target=>49, :value=>1}),
    OpenStruct.new({:source=>50, :target=>24, :value=>1}),
    OpenStruct.new({:source=>51, :target=>49, :value=>9}),
    OpenStruct.new({:source=>51, :target=>26, :value=>2}),
    OpenStruct.new({:source=>51, :target=>11, :value=>2}),
    OpenStruct.new({:source=>52, :target=>51, :value=>1}),
    OpenStruct.new({:source=>52, :target=>39, :value=>1}),
    OpenStruct.new({:source=>53, :target=>51, :value=>1}),
    OpenStruct.new({:source=>54, :target=>51, :value=>2}),
    OpenStruct.new({:source=>54, :target=>49, :value=>1}),
    OpenStruct.new({:source=>54, :target=>26, :value=>1}),
    OpenStruct.new({:source=>55, :target=>51, :value=>6}),
    OpenStruct.new({:source=>55, :target=>49, :value=>12}),
    OpenStruct.new({:source=>55, :target=>39, :value=>1}),
    OpenStruct.new({:source=>55, :target=>54, :value=>1}),
    OpenStruct.new({:source=>55, :target=>26, :value=>21}),
    OpenStruct.new({:source=>55, :target=>11, :value=>19}),
    OpenStruct.new({:source=>55, :target=>16, :value=>1}),
    OpenStruct.new({:source=>55, :target=>25, :value=>2}),
    OpenStruct.new({:source=>55, :target=>41, :value=>5}),
    OpenStruct.new({:source=>55, :target=>48, :value=>4}),
    OpenStruct.new({:source=>56, :target=>49, :value=>1}),
    OpenStruct.new({:source=>56, :target=>55, :value=>1}),
    OpenStruct.new({:source=>57, :target=>55, :value=>1}),
    OpenStruct.new({:source=>57, :target=>41, :value=>1}),
    OpenStruct.new({:source=>57, :target=>48, :value=>1}),
    OpenStruct.new({:source=>58, :target=>55, :value=>7}),
    OpenStruct.new({:source=>58, :target=>48, :value=>7}),
    OpenStruct.new({:source=>58, :target=>27, :value=>6}),
    OpenStruct.new({:source=>58, :target=>57, :value=>1}),
    OpenStruct.new({:source=>58, :target=>11, :value=>4}),
    OpenStruct.new({:source=>59, :target=>58, :value=>15}),
    OpenStruct.new({:source=>59, :target=>55, :value=>5}),
    OpenStruct.new({:source=>59, :target=>48, :value=>6}),
    OpenStruct.new({:source=>59, :target=>57, :value=>2}),
    OpenStruct.new({:source=>60, :target=>48, :value=>1}),
    OpenStruct.new({:source=>60, :target=>58, :value=>4}),
    OpenStruct.new({:source=>60, :target=>59, :value=>2}),
    OpenStruct.new({:source=>61, :target=>48, :value=>2}),
    OpenStruct.new({:source=>61, :target=>58, :value=>6}),
    OpenStruct.new({:source=>61, :target=>60, :value=>2}),
    OpenStruct.new({:source=>61, :target=>59, :value=>5}),
    OpenStruct.new({:source=>61, :target=>57, :value=>1}),
    OpenStruct.new({:source=>61, :target=>55, :value=>1}),
    OpenStruct.new({:source=>62, :target=>55, :value=>9}),
    OpenStruct.new({:source=>62, :target=>58, :value=>17}),
    OpenStruct.new({:source=>62, :target=>59, :value=>13}),
    OpenStruct.new({:source=>62, :target=>48, :value=>7}),
    OpenStruct.new({:source=>62, :target=>57, :value=>2}),
    OpenStruct.new({:source=>62, :target=>41, :value=>1}),
    OpenStruct.new({:source=>62, :target=>61, :value=>6}),
    OpenStruct.new({:source=>62, :target=>60, :value=>3}),
    OpenStruct.new({:source=>63, :target=>59, :value=>5}),
    OpenStruct.new({:source=>63, :target=>48, :value=>5}),
    OpenStruct.new({:source=>63, :target=>62, :value=>6}),
    OpenStruct.new({:source=>63, :target=>57, :value=>2}),
    OpenStruct.new({:source=>63, :target=>58, :value=>4}),
    OpenStruct.new({:source=>63, :target=>61, :value=>3}),
    OpenStruct.new({:source=>63, :target=>60, :value=>2}),
    OpenStruct.new({:source=>63, :target=>55, :value=>1}),
    OpenStruct.new({:source=>64, :target=>55, :value=>5}),
    OpenStruct.new({:source=>64, :target=>62, :value=>12}),
    OpenStruct.new({:source=>64, :target=>48, :value=>5}),
    OpenStruct.new({:source=>64, :target=>63, :value=>4}),
    OpenStruct.new({:source=>64, :target=>58, :value=>10}),
    OpenStruct.new({:source=>64, :target=>61, :value=>6}),
    OpenStruct.new({:source=>64, :target=>60, :value=>2}),
    OpenStruct.new({:source=>64, :target=>59, :value=>9}),
    OpenStruct.new({:source=>64, :target=>57, :value=>1}),
    OpenStruct.new({:source=>64, :target=>11, :value=>1}),
    OpenStruct.new({:source=>65, :target=>63, :value=>5}),
    OpenStruct.new({:source=>65, :target=>64, :value=>7}),
    OpenStruct.new({:source=>65, :target=>48, :value=>3}),
    OpenStruct.new({:source=>65, :target=>62, :value=>5}),
    OpenStruct.new({:source=>65, :target=>58, :value=>5}),
    OpenStruct.new({:source=>65, :target=>61, :value=>5}),
    OpenStruct.new({:source=>65, :target=>60, :value=>2}),
    OpenStruct.new({:source=>65, :target=>59, :value=>5}),
    OpenStruct.new({:source=>65, :target=>57, :value=>1}),
    OpenStruct.new({:source=>65, :target=>55, :value=>2}),
    OpenStruct.new({:source=>66, :target=>64, :value=>3}),
    OpenStruct.new({:source=>66, :target=>58, :value=>3}),
    OpenStruct.new({:source=>66, :target=>59, :value=>1}),
    OpenStruct.new({:source=>66, :target=>62, :value=>2}),
    OpenStruct.new({:source=>66, :target=>65, :value=>2}),
    OpenStruct.new({:source=>66, :target=>48, :value=>1}),
    OpenStruct.new({:source=>66, :target=>63, :value=>1}),
    OpenStruct.new({:source=>66, :target=>61, :value=>1}),
    OpenStruct.new({:source=>66, :target=>60, :value=>1}),
    OpenStruct.new({:source=>67, :target=>57, :value=>3}),
    OpenStruct.new({:source=>68, :target=>25, :value=>5}),
    OpenStruct.new({:source=>68, :target=>11, :value=>1}),
    OpenStruct.new({:source=>68, :target=>24, :value=>1}),
    OpenStruct.new({:source=>68, :target=>27, :value=>1}),
    OpenStruct.new({:source=>68, :target=>48, :value=>1}),
    OpenStruct.new({:source=>68, :target=>41, :value=>1}),
    OpenStruct.new({:source=>69, :target=>25, :value=>6}),
    OpenStruct.new({:source=>69, :target=>68, :value=>6}),
    OpenStruct.new({:source=>69, :target=>11, :value=>1}),
    OpenStruct.new({:source=>69, :target=>24, :value=>1}),
    OpenStruct.new({:source=>69, :target=>27, :value=>2}),
    OpenStruct.new({:source=>69, :target=>48, :value=>1}),
    OpenStruct.new({:source=>69, :target=>41, :value=>1}),
    OpenStruct.new({:source=>70, :target=>25, :value=>4}),
    OpenStruct.new({:source=>70, :target=>69, :value=>4}),
    OpenStruct.new({:source=>70, :target=>68, :value=>4}),
    OpenStruct.new({:source=>70, :target=>11, :value=>1}),
    OpenStruct.new({:source=>70, :target=>24, :value=>1}),
    OpenStruct.new({:source=>70, :target=>27, :value=>1}),
    OpenStruct.new({:source=>70, :target=>41, :value=>1}),
    OpenStruct.new({:source=>70, :target=>58, :value=>1}),
    OpenStruct.new({:source=>71, :target=>27, :value=>1}),
    OpenStruct.new({:source=>71, :target=>69, :value=>2}),
    OpenStruct.new({:source=>71, :target=>68, :value=>2}),
    OpenStruct.new({:source=>71, :target=>70, :value=>2}),
    OpenStruct.new({:source=>71, :target=>11, :value=>1}),
    OpenStruct.new({:source=>71, :target=>48, :value=>1}),
    OpenStruct.new({:source=>71, :target=>41, :value=>1}),
    OpenStruct.new({:source=>71, :target=>25, :value=>1}),
    OpenStruct.new({:source=>72, :target=>26, :value=>2}),
    OpenStruct.new({:source=>72, :target=>27, :value=>1}),
    OpenStruct.new({:source=>72, :target=>11, :value=>1}),
    OpenStruct.new({:source=>73, :target=>48, :value=>2}),
    OpenStruct.new({:source=>74, :target=>48, :value=>2}),
    OpenStruct.new({:source=>74, :target=>73, :value=>3}),
    OpenStruct.new({:source=>75, :target=>69, :value=>3}),
    OpenStruct.new({:source=>75, :target=>68, :value=>3}),
    OpenStruct.new({:source=>75, :target=>25, :value=>3}),
    OpenStruct.new({:source=>75, :target=>48, :value=>1}),
    OpenStruct.new({:source=>75, :target=>41, :value=>1}),
    OpenStruct.new({:source=>75, :target=>70, :value=>1}),
    OpenStruct.new({:source=>75, :target=>71, :value=>1}),
    OpenStruct.new({:source=>76, :target=>64, :value=>1}),
    OpenStruct.new({:source=>76, :target=>65, :value=>1}),
    OpenStruct.new({:source=>76, :target=>66, :value=>1}),
    OpenStruct.new({:source=>76, :target=>63, :value=>1}),
    OpenStruct.new({:source=>76, :target=>62, :value=>1}),
    OpenStruct.new({:source=>76, :target=>48, :value=>1}),
    OpenStruct.new({:source=>76, :target=>58, :value=>1})
  ]
})
